package my.control;


import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Enumeration;
import java.util.Vector;

import my.entity.Literal;

public class IO {
	
	private DataOutputStream out;
	private RandomAccessFile rf;
	Vector<Literal> liste = new Vector<Literal>();
	
	public IO(File fileToSave, Enumeration liste) {
		File temp=null;
		
		if(!fileToSave.getName().endsWith("lit")) {
			temp = new File(fileToSave.getAbsolutePath()+".lit");
			fileToSave = temp;
		}	
		
		try {
			out = new DataOutputStream(new
			        BufferedOutputStream(new FileOutputStream(fileToSave)));	
		} 
		catch (FileNotFoundException e) {
			e.printStackTrace();
		}
		
		try {
			String tmp = schreibeDatei(liste);
			for(int i=0; i<tmp.length(); i++) {
				out.write((byte)tmp.charAt(i));
			}
			out.close();
		} 
		catch (IOException e) {
			e.printStackTrace();
		}	
	}
	
	public IO(File fileToLoad) {
		
		String tmp ="";
		Literal lit;
		try {
			rf = new RandomAccessFile(fileToLoad, "r");
		} 
		catch (FileNotFoundException e) {
			e.printStackTrace();
		}
		try {
			while(rf.getFilePointer() != rf.length()) {
				tmp = rf.readLine();
				lit = new Literal(tmp);
				liste.add(lit);	
			}
		}
		catch (IOException e) {
			e.printStackTrace();
		}
	}
	

	

	public String schreibeDatei(Enumeration liste) {
  
		String output = "";
		while(liste.hasMoreElements())
			output += ((Literal)liste.nextElement()).getLiteral() +"\n";
		return output;         
	}

	public Vector<Literal> getListe() {
		return liste;
	}
}
