package my.control;

import java.io.File;
import java.util.Enumeration;
import java.util.Vector;

import javax.swing.SwingUtilities;


import my.entity.Literal;
import my.gui.GUI_Eingabe;
import my.operatoren.Antiunifikator;
import my.operatoren.Unifikator;

/**
 * @author  chris
 */
public class Controller {
	
	private GUI_Eingabe hauptfenster = null;
	private Literal literal;
	private SyntaxChecker sc;
	
	private Literal LiteralDasInDerTextBoxSteht = null;
	
	/**
	 * Konstruktor fuer Controller.
	 * Erzeugt einen neuen Thread in dem die GUI erzeugt wird
	 */
	public Controller() {
		SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				GUI_Eingabe hauptfenster = new GUI_Eingabe(Controller.this);
				Controller.this.hauptfenster = hauptfenster;
			}
		});
		
	}

	/**
	 * verarbeitet ein eingegebenes Literal.
	 * Ruft hierfuer die parseLiteral-Methode aus Literal auf
	 * @param literal_string
	 */
	public Literal processLiteral(String literal_string) {
		literal_string = literal_string.replace(" ", "");
		literal = null;
		sc = new SyntaxChecker();
		boolean syntaxkorrekt = false;
		syntaxkorrekt = sc.checksyntax(literal_string,this);
		if(syntaxkorrekt) {
			literal = new Literal(literal_string);
			syntaxkorrekt = false;
		}
		return literal;	
	}
	
	public void unifizieren(Vector<Literal> lit_liste) {
		String uni = Unifikator.unifikation(lit_liste);
		if (Unifikator.isUnifiziert()) {
			setInfo(Unifikator.getUni_lit()+"\n"+uni);
			GUI_Eingabe.setAusgabeIsLiteral(true);
			setLiteralDasInDerTextBoxSteht(Unifikator.getUni_lit());
		}
		else {
			setInfo(uni);
			GUI_Eingabe.setAusgabeIsLiteral(false);
			setLiteralDasInDerTextBoxSteht(null);
		}
	}
	
	/** 
	 * schreibt eine Fehlermeldung in die Textarea des Hauptfensters.
	 * Die Schriftfarbe ist rot.
	 * @param fehlermeldung
	 */
	public void setFehlerMeldung(String fehlermeldung) {
		hauptfenster.setFehlerMeldung(fehlermeldung);
	}
	
	/** 
	 * schreibt eine Info in die Textarea des Hauptfensters.
	 * Die Schriftfarbe ist blau.
	 * @param info
	 */
	public void setInfo(String info) {
		hauptfenster.setInfo(info);
	}

	public void speichereLiteralListe(File fileToSave, Enumeration en) {
		new IO(fileToSave, en);		
	}	
	
	public void ladeLiteralListe(File fileToLoad) {
		hauptfenster.getListmodel().removeAllElements();
		IO io = new IO(fileToLoad);
		hauptfenster.setListModel(io.getListe());	
	}

	/**
	 * @return String
	 */
	public String antiunifizieren() {
		Literal tmp = Antiunifikator.antiunifizieren(new Literal((Literal)hauptfenster.getListmodel().get(0)), new Literal((Literal)hauptfenster.getListmodel().get(1)));
		if(tmp != null) {
			setLiteralDasInDerTextBoxSteht(tmp);
			GUI_Eingabe.setAusgabeIsLiteral(true);
			return tmp.toString();
		}	
		GUI_Eingabe.setAusgabeIsLiteral(false);
		setLiteralDasInDerTextBoxSteht(null);
		return "";
	}

	public Literal getLiteralDasInDerTextBoxSteht() {
		return LiteralDasInDerTextBoxSteht;
	}

	public void setLiteralDasInDerTextBoxSteht(Literal literalDasInDerTextBoxSteht) {
		LiteralDasInDerTextBoxSteht = literalDasInDerTextBoxSteht;
	}
}
