package edu.udo.cs.yale.operator.exercise.fpGrowth;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;

import edu.udo.cs.yale.operator.ResultObjectAdapter;

public class FrequentItemSets extends ResultObjectAdapter {
	LinkedHashMap<Collection<Item>, Integer> frequentSets;
	public FrequentItemSets() {
		frequentSets = new LinkedHashMap<Collection<Item>,Integer>();
	}
	/**
	 * Adds a frequent item set to this container. ConditionalItems and frequentItems 
	 * are merged.
	 * @param conditionalItems conditional items for this frequent set 
	 * @param frequentItems the frequent set
	 * @param frequency the frequency of the set
	 */
	@SuppressWarnings("unchecked")
	public void addFrequentSet(Collection<Item> conditionalItems, Collection<Item> frequentItems, int frequency) {
		LinkedList<Item> set = new LinkedList<Item>();
		set.addAll(conditionalItems);
		set.addAll(frequentItems);
		Collections.sort(set);
		frequentSets.put(set, new Integer(frequency));
	}
	/**
	 * this method generates the output
	 */
	public String toString() {
		StringBuffer output = new StringBuffer();
		Iterator<Collection<Item>> keyIterator = frequentSets.keySet().iterator();
		while (keyIterator.hasNext()) {
			Collection<Item> currentKey = keyIterator.next();
			output.append(currentKey.toString());
			output.append(": ");
			output.append(frequentSets.get(currentKey).toString());
			output.append("\n");
		}
		return output.toString();
	}
}
