@echo off
SETLOCAL ENABLEDELAYEDEXPANSION

rem ##############################################################
rem ###                                                        ###
rem ###            Windows Start Script for YALE               ###
rem ###                                                        ###
rem ###  This script tries to determine the location of YALE,  ###
rem ###  searches for a proper Java executable and start the   ### 
rem ###  program.                                              ###
rem ###                                                        ###
rem ###  Please adapt the line containing MAX_JAVA_MEMORY in   ###
rem ###  order to allow for more memory usage.                 ###
rem ###  Alternatively, you can define an environment variable ###
rem ###  MAX_JAVA_MEMORY!                                      ###
rem ###                                                        ###
rem ###  You might also want to add a JDBC driver library in   ###
rem ###  the line with YALE_JDBC_DRIVERS!                      ###
rem ###                                                        ###
rem ##############################################################


rem ##########################################
rem ###                                    ###
rem ###  Setting Maximal Amount of Memory  ###
rem ###                                    ###
rem ##########################################

if "%MAX_JAVA_MEMORY%"=="" set MAX_JAVA_MEMORY=350


rem ###########################################
rem ###                                     ###
rem ###  Setting Additional Operators Path  ###
rem ###                                     ###
rem ###########################################

if "%YALE_OPERATORS_ADDITIONAL%"=="" set YALE_OPERATORS_ADDITIONAL=


rem ##########################################
rem ###                                    ###
rem ###  Setting JDBC Driver Libraries     ###
rem ###                                    ###
rem ##########################################

if "%YALE_JDBC_DRIVERS%"=="" set YALE_JDBC_DRIVERS=


rem #######################################
rem ###                                 ###
rem ###  Setting or Guessing YALE_HOME  ###
rem ###                                 ###
rem #######################################

rem ###  set YALE_HOME to the correct directory if you changed the location of this start script  ###

if "%YALE_HOME%"=="" goto guessyalehome
goto javahome

:guessyalehome
set YALE_BATCHDIR=%~dp0
set YALE_HOME=%YALE_BATCHDIR%..
echo YALE_HOME is not set. Trying the directory '%YALE_HOME%'...
goto javahome


rem ############################
rem ###                      ###
rem ###  Searching for Java  ###
rem ###                      ###
rem ############################

:javahome
set LOCAL_JRE_JAVA=%YALE_HOME%\jre\bin\java.exe
if exist "%LOCAL_JRE_JAVA%" goto localjre
goto checkjavahome

:localjre
set JAVA=%LOCAL_JRE_JAVA%
echo Using local jre: %JAVA%...
goto commandlinearguments

:checkjavahome
if "%JAVA_HOME%"=="" goto checkpath
set JAVA_CHECK=%JAVA_HOME%\bin\java.exe
if exist "%JAVA_CHECK%" goto globaljre 
goto error3

:globaljre
set JAVA=%JAVA_HOME%\bin\java
echo Using global jre: %JAVA%...
goto commandlinearguments

:checkpath
java -version 2> nul:
if errorlevel 1 goto error2
goto globaljrepath

:globaljrepath
set JAVA=java
echo Using global jre found on path: %JAVA%
goto commandlinearguments


rem #########################################
rem ###                                   ###
rem ###  Handling Command Line Arguments  ###
rem ###                                   ###
rem #########################################

:commandlinearguments
set CMD_LINE_ARGS=
:args
if "%1"=="" goto start
set CMD_LINE_ARGS=%CMD_LINE_ARGS% %1
shift
goto args


rem #######################
rem ###                 ###
rem ###  Starting YALE  ###
rem ###                 ###
rem #######################

:start
set YALE_JAR=%YALE_HOME%\lib\yale.jar
set BUILD=%YALE_HOME%\build
set YALE_CLASSPATH=

if exist "%YALE_JAR%" set YALE_CLASSPATH=%YALE_JAR%
if exist "%BUILD%" set YALE_CLASSPATH=%BUILD%
if "%YALE_CLASSPATH%"=="" goto error1

set YALE_LIBRARIES=
for %%f in ("%YALE_HOME%\lib\*.jar") do set YALE_LIBRARIES=!YALE_LIBRARIES!;%%f
for %%f in ("%YALE_HOME%\lib\freehep\*.jar") do set YALE_LIBRARIES=!YALE_LIBRARIES!;%%f

set COMPLETE_CLASSPATH=%YALE_CLASSPATH%;%YALE_LIBRARIES%

if not "%YALE_JDBC_DRIVERS%"=="" set COMPLETE_CLASSPATH=%COMPLETE_CLASSPATH%;%YALE_JDBC_DRIVERS%

echo Starting Yale from '%YALE_HOME%' using classes from '%YALE_CLASSPATH%'...
rem echo The used classpath is '%COMPLETE_CLASSPATH%'...

"%JAVA%" -Xms%MAX_JAVA_MEMORY%m -Xmx%MAX_JAVA_MEMORY%m -classpath "%COMPLETE_CLASSPATH%" -Dyale.home="%YALE_HOME%" -Dyale.operators.additional="%YALE_OPERATORS_ADDITIONAL%" edu.udo.cs.yale.gui.YaleGUI %CMD_LINE_ARGS%
goto end


rem ########################
rem ###                  ###
rem ###  Error messages  ###
rem ###                  ###
rem ########################

:error1
echo.
echo ERROR: Neither 
echo %YALE_JAR% 
echo nor 
echo %BUILD% 
echo was found.
echo If you use the source version of YALE, try 
echo 'ant build' or 'ant dist' first.
echo.
pause
goto end

:error2
echo.
echo ERROR: Java cannot be found. 
echo Please install Java properly (check if JAVA_HOME is 
echo correctly set or ensure that 'java' is part of the 
echo PATH environment variable).
echo.
pause
goto end

:error3
echo.
echo ERROR: Java cannot be found in the path JAVA_HOME
echo Please install Java properly (it seems that the 
echo environment variable JAVA_HOME does not point to 
echo a Java installation).
echo.
pause
goto end

rem #############
rem ###       ###
rem ###  END  ###
rem ###       ###
rem #############

:end
