/*
 * Decompiled with CFR 0.152.
 */
package de.java.print;

import de.java.print.BrowseAction;
import de.java.print.Preview;
import de.java.print.ZoomAction;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;

public class PreviewDialog
extends JDialog
implements ActionListener {
    private static final double DEFAULT_ZOOM_FACTOR_STEP = 0.1;
    protected Pageable pageable;

    public PreviewDialog(String title, JFrame owner, Pageable pageable, double zoom) {
        super(owner, title, true);
        this.pageable = pageable;
        Preview preview = new Preview(pageable, zoom);
        JScrollPane scrollPane = new JScrollPane(preview);
        this.getContentPane().add((Component)scrollPane, "Center");
        JToolBar toolbar = new JToolBar();
        this.getContentPane().add((Component)toolbar, "North");
        toolbar.add(this.getButton("Back24.gif", new BrowseAction(preview, -1)));
        toolbar.add(this.getButton("Forward24.gif", new BrowseAction(preview, 1)));
        toolbar.add(new JToolBar.Separator());
        toolbar.add(this.getButton("ZoomIn24.gif", new ZoomAction(preview, 0.1)));
        toolbar.add(this.getButton("ZoomOut24.gif", new ZoomAction(preview, -0.1)));
        toolbar.add(new JToolBar.Separator());
        JPanel dialog = new JPanel();
        dialog.setLayout(new FlowLayout(2));
        JButton ok = new JButton("OK");
        ok.addActionListener(this);
        dialog.add(ok);
        this.getContentPane().add((Component)dialog, "South");
    }

    public PreviewDialog(String title, JFrame owner, Pageable pageable) {
        this(title, owner, pageable, 0.0);
    }

    public PreviewDialog(String title, JFrame owner, Printable printable, PageFormat format, int pages, double zoom) {
        this(title, owner, new MyPageable(printable, format, pages), zoom);
    }

    public PreviewDialog(String title, JFrame owner, Printable printable, PageFormat format, int pages) {
        this(title, owner, printable, format, pages, 0.0);
    }

    private JButton getButton(String iconName) {
        return this.getButton(null, iconName, null);
    }

    private JButton getButton(String iconName, AbstractAction action) {
        return this.getButton(null, iconName, action);
    }

    private JButton getButton(String name, String iconName, AbstractAction action) {
        JButton result = null;
        ImageIcon icon = null;
        URL imageURL = this.getClass().getClassLoader().getResource("images/" + iconName);
        if (imageURL != null) {
            icon = new ImageIcon(imageURL);
        }
        if (action != null) {
            if (icon != null) {
                action.putValue("SmallIcon", new ImageIcon(imageURL));
            }
            if (name != null) {
                action.putValue("Name", name);
            }
            result = new JButton(action);
        } else {
            result = new JButton(name, icon);
        }
        return result;
    }

    public void actionPerformed(ActionEvent e) {
        this.dispose();
    }

    private static class MyPageable
    implements Pageable {
        private Printable printable;
        private PageFormat format;
        private int pages;

        public MyPageable(Printable printable, PageFormat format, int pages) {
            this.printable = printable;
            this.format = format;
            this.pages = pages;
        }

        public int getNumberOfPages() {
            return this.pages;
        }

        public Printable getPrintable(int index) {
            if (index >= this.pages) {
                throw new IndexOutOfBoundsException();
            }
            return this.printable;
        }

        public PageFormat getPageFormat(int index) {
            if (index >= this.pages) {
                throw new IndexOutOfBoundsException();
            }
            return this.format;
        }
    }
}

