/*
 * Decompiled with CFR 0.152.
 */
package de.java.print;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import javax.swing.JComponent;

class Preview
extends JComponent {
    private static final int DEFAULT_PREVIEW_SIZE = 300;
    private static final double MINIMUM_ZOOM_FACTOR = 0.1;
    protected Pageable pageable;
    protected int index = 0;
    protected double zoom = 0.0;

    public Preview(Pageable pageable, double zoom) {
        this.pageable = pageable;
        PageFormat format = pageable.getPageFormat(this.index);
        this.zoom = zoom == 0.0 ? (format.getOrientation() == 1 ? 300.0 / format.getHeight() : 300.0 / format.getWidth()) : zoom;
        this.resize();
    }

    protected void paintPaper(Graphics g, PageFormat format) {
        g.setColor(Color.white);
        g.fillRect(0, 0, (int)format.getWidth(), (int)format.getHeight());
        g.setColor(Color.black);
        g.drawRect(0, 0, (int)format.getWidth() - 1, (int)format.getHeight() - 1);
    }

    public void paint(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.scale(this.zoom, this.zoom);
        try {
            PageFormat format = this.pageable.getPageFormat(this.index);
            Printable printable = this.pageable.getPrintable(this.index);
            this.paintPaper(g, format);
            printable.print(g, format, 0);
        }
        catch (PrinterException e) {
        }
        catch (IndexOutOfBoundsException e) {}
    }

    public void moveIndex(int indexStep) {
        int newIndex = this.index + indexStep;
        try {
            Printable printable = this.pageable.getPrintable(newIndex);
            this.resize();
            this.index = newIndex;
        }
        catch (IndexOutOfBoundsException ignored) {}
    }

    public void changeZoom(double zoom) {
        this.zoom = Math.max(0.1, this.zoom + zoom);
        this.resize();
    }

    public void resize() {
        PageFormat format = this.pageable.getPageFormat(this.index);
        int size = (int)Math.max(format.getWidth() * this.zoom, format.getHeight() * this.zoom);
        this.setPreferredSize(new Dimension(size, size));
        this.revalidate();
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }
}

