/*
 * Decompiled with CFR 0.152.
 */
package jal.INT;

import jal.INT.BinaryPredicate;
import jal.INT.Modification;
import jal.INT.Range;

public final class Sorting {
    private static final int partitionCutoff = 13;
    private static final int qsort_stacksize = 56;
    private static final int stableSortCutoff = 9;

    public static void sort(int[] nArray, int n, int n2) {
        if (n2 - n >= 13) {
            Sorting.qsortLoop(nArray, n, n2);
        }
        Sorting.insertion_sort(nArray, n, n2);
    }

    public static void sort(int[] nArray, int n, int n2, BinaryPredicate binaryPredicate) {
        if (n2 - n >= 13) {
            Sorting.qsortLoop(nArray, n, n2, binaryPredicate);
        }
        Sorting.insertion_sort(nArray, n, n2, binaryPredicate);
    }

    public static void insertion_sort(int[] nArray, int n, int n2) {
        int n3 = n;
        while (++n3 < n2) {
            int n4 = nArray[n3];
            int n5 = n3;
            int n6 = nArray[n5 - 1];
            while (n4 < n6) {
                nArray[n5] = n6;
                if (n == n5 - 1) {
                    --n5;
                    break;
                }
                n6 = nArray[--n5 - 1];
            }
            nArray[n5] = n4;
        }
    }

    public static void insertion_sort(int[] nArray, int n, int n2, BinaryPredicate binaryPredicate) {
        int n3 = n;
        while (++n3 < n2) {
            int n4 = nArray[n3];
            int n5 = n3;
            int n6 = nArray[n5 - 1];
            while (binaryPredicate.apply(n4, n6)) {
                nArray[n5] = n6;
                if (n == n5 - 1) {
                    --n5;
                    break;
                }
                n6 = nArray[--n5 - 1];
            }
            nArray[n5] = n4;
        }
    }

    private static int quickPartition(int[] nArray, int n, int n2) {
        int n3 = nArray[n];
        int n4 = nArray[n2 - 1];
        int n5 = nArray[n + (n2 - n) / 2];
        if (n5 < n3) {
            if (n3 < n4) {
                n5 = n3;
            } else if (n5 < n4) {
                n5 = n4;
            }
        } else if (n4 < n3) {
            n5 = n3;
        } else if (n4 < n5) {
            n5 = n4;
        }
        --n;
        while (true) {
            if (nArray[++n] < n5) {
                continue;
            }
            while (n5 < nArray[--n2]) {
            }
            if (n >= n2) {
                return n;
            }
            int n6 = nArray[n];
            nArray[n] = nArray[n2];
            nArray[n2] = n6;
        }
    }

    private static int quickPartition(int[] nArray, int n, int n2, BinaryPredicate binaryPredicate) {
        int n3 = nArray[n];
        int n4 = nArray[n2 - 1];
        int n5 = nArray[n + (n2 - n) / 2];
        if (binaryPredicate.apply(n5, n3)) {
            if (binaryPredicate.apply(n3, n4)) {
                n5 = n3;
            } else if (binaryPredicate.apply(n5, n4)) {
                n5 = n4;
            }
        } else if (binaryPredicate.apply(n4, n3)) {
            n5 = n3;
        } else if (binaryPredicate.apply(n4, n5)) {
            n5 = n4;
        }
        --n;
        while (true) {
            if (binaryPredicate.apply(nArray[++n], n5)) {
                continue;
            }
            while (binaryPredicate.apply(n5, nArray[--n2])) {
            }
            if (n >= n2) {
                return n;
            }
            int n6 = nArray[n];
            nArray[n] = nArray[n2];
            nArray[n2] = n6;
        }
    }

    private static void qsortLoop(int[] nArray, int n, int n2) {
        int[] nArray2 = new int[56];
        int n3 = 0;
        while (true) {
            int n4;
            if (n2 - (n4 = Sorting.quickPartition(nArray, n, n2)) < 13) {
                if (n4 - n < 13) {
                    if (n3 == 0) {
                        return;
                    }
                    n2 = nArray2[--n3];
                    n = nArray2[--n3];
                    continue;
                }
                n2 = n4;
                continue;
            }
            if (n4 - n < 13) {
                n = n4;
                continue;
            }
            if (n2 - n4 > n4 - n) {
                nArray2[n3++] = n4;
                nArray2[n3++] = n2;
                n2 = n4;
                continue;
            }
            nArray2[n3++] = n;
            nArray2[n3++] = n4;
            n = n4;
        }
    }

    private static void qsortLoop(int[] nArray, int n, int n2, BinaryPredicate binaryPredicate) {
        int[] nArray2 = new int[56];
        int n3 = 0;
        while (true) {
            int n4;
            if (n2 - (n4 = Sorting.quickPartition(nArray, n, n2, binaryPredicate)) < 13) {
                if (n4 - n < 13) {
                    if (n3 == 0) {
                        return;
                    }
                    n2 = nArray2[--n3];
                    n = nArray2[--n3];
                    continue;
                }
                n2 = n4;
                continue;
            }
            if (n4 - n < 13) {
                n = n4;
                continue;
            }
            if (n2 - n4 > n4 - n) {
                nArray2[n3++] = n4;
                nArray2[n3++] = n2;
                n2 = n4;
                continue;
            }
            nArray2[n3++] = n;
            nArray2[n3++] = n4;
            n = n4;
        }
    }

    public static void stable_sort(int[] nArray, int n, int n2) {
        if (n2 - n < 9) {
            Sorting.insertion_sort(nArray, n, n2);
        } else {
            int n3 = n + (n2 - n) / 2;
            Sorting.stable_sort(nArray, n, n3);
            Sorting.stable_sort(nArray, n3, n2);
            Sorting.inplace_merge(nArray, n, n3, n2);
        }
    }

    public static void stable_sort(int[] nArray, int n, int n2, BinaryPredicate binaryPredicate) {
        if (n2 - n < 9) {
            Sorting.insertion_sort(nArray, n, n2, binaryPredicate);
        } else {
            int n3 = n + (n2 - n) / 2;
            Sorting.stable_sort(nArray, n, n3, binaryPredicate);
            Sorting.stable_sort(nArray, n3, n2, binaryPredicate);
            Sorting.inplace_merge(nArray, n, n3, n2, binaryPredicate);
        }
    }

    public static void partial_sort(int[] nArray, int n, int n2, int n3) {
        Sorting.make_heap(nArray, n, n2);
        for (int i = n2; i < n3; ++i) {
            if (nArray[i] >= nArray[n]) continue;
            int n4 = nArray[i];
            nArray[i] = nArray[n];
            nArray[n] = n4;
            Sorting.adjust_heap(nArray, n, n, n2);
        }
        Sorting.sort_heap(nArray, n, n2);
    }

    public static void partial_sort(int[] nArray, int n, int n2, int n3, BinaryPredicate binaryPredicate) {
        Sorting.make_heap(nArray, n, n2, binaryPredicate);
        for (int i = n2; i < n3; ++i) {
            if (!binaryPredicate.apply(nArray[i], nArray[n])) continue;
            int n4 = nArray[i];
            nArray[i] = nArray[n];
            nArray[n] = n4;
            Sorting.adjust_heap(nArray, n, n, n2, binaryPredicate);
        }
        Sorting.sort_heap(nArray, n, n2, binaryPredicate);
    }

    public static int partial_sort_copy(int[] nArray, int[] nArray2, int n, int n2, int n3, int n4) {
        if (n3 == n4) {
            return n4;
        }
        int n5 = Math.min(n2 - n, n4 - n3);
        Modification.copy(nArray, nArray2, n, n + n5, n3);
        n4 = n3 + n5;
        Sorting.make_heap(nArray2, n3, n4);
        n += n5;
        while (n < n2) {
            if (nArray[n] < nArray2[n3]) {
                nArray2[n3] = nArray[n];
                Sorting.adjust_heap(nArray2, n3, n3, n4);
            }
            ++n;
        }
        Sorting.sort_heap(nArray2, n3, n4);
        return n4;
    }

    public static int partial_sort_copy(int[] nArray, int[] nArray2, int n, int n2, int n3, int n4, BinaryPredicate binaryPredicate) {
        if (n3 == n4) {
            return n4;
        }
        int n5 = Math.min(n2 - n, n4 - n3);
        Modification.copy(nArray, nArray2, n, n + n5, n3);
        n4 = n3 + n5;
        Sorting.make_heap(nArray2, n3, n4, binaryPredicate);
        n += n5;
        while (n < n2) {
            if (binaryPredicate.apply(nArray[n], nArray2[n3])) {
                nArray2[n3] = nArray[n];
                Sorting.adjust_heap(nArray2, n3, n3, n4, binaryPredicate);
            }
            ++n;
        }
        Sorting.sort_heap(nArray2, n3, n4, binaryPredicate);
        return n4;
    }

    public static void nth_element(int[] nArray, int n, int n2, int n3) {
        while (n3 - n > 3) {
            int n4 = Sorting.quickPartition(nArray, n, n3);
            if (n4 <= n2) {
                n = n4;
                continue;
            }
            n3 = n4;
        }
        Sorting.insertion_sort(nArray, n, n3);
    }

    public static void nth_element(int[] nArray, int n, int n2, int n3, BinaryPredicate binaryPredicate) {
        while (n3 - n > 3) {
            int n4 = Sorting.quickPartition(nArray, n, n3, binaryPredicate);
            if (n4 <= n2) {
                n = n4;
                continue;
            }
            n3 = n4;
        }
        Sorting.insertion_sort(nArray, n, n3, binaryPredicate);
    }

    public static int lower_bound(int[] nArray, int n, int n2, int n3) {
        int n4 = n2 - n;
        while (n4 > 0) {
            int n5 = n4 / 2;
            int n6 = n + n5;
            if (nArray[n6] < n3) {
                n = n6 + 1;
                n4 -= n5 + 1;
                continue;
            }
            n4 = n5;
        }
        return n;
    }

    public static int lower_bound(int[] nArray, int n, int n2, int n3, BinaryPredicate binaryPredicate) {
        int n4 = n2 - n;
        while (n4 > 0) {
            int n5 = n4 / 2;
            int n6 = n + n5;
            if (binaryPredicate.apply(nArray[n6], n3)) {
                n = n6 + 1;
                n4 -= n5 + 1;
                continue;
            }
            n4 = n5;
        }
        return n;
    }

    public static int upper_bound(int[] nArray, int n, int n2, int n3) {
        int n4 = n2 - n;
        while (n4 > 0) {
            int n5 = n4 / 2;
            int n6 = n + n5;
            if (n3 < nArray[n6]) {
                n4 = n5;
                continue;
            }
            n = n6 + 1;
            n4 -= n5 + 1;
        }
        return n;
    }

    public static int upper_bound(int[] nArray, int n, int n2, int n3, BinaryPredicate binaryPredicate) {
        int n4 = n2 - n;
        while (n4 > 0) {
            int n5 = n4 / 2;
            int n6 = n + n5;
            if (binaryPredicate.apply(n3, nArray[n6])) {
                n4 = n5;
                continue;
            }
            n = n6 + 1;
            n4 -= n5 + 1;
        }
        return n;
    }

    public static Range equal_range(int[] nArray, int n, int n2, int n3) {
        int n4 = n2 - n;
        while (n4 > 0) {
            int n5 = n4 / 2;
            int n6 = n + n5;
            if (nArray[n6] < n3) {
                n = n6 + 1;
                n4 = n4 - n5 + 1;
                continue;
            }
            if (n3 < nArray[n6]) {
                n4 = n5;
                continue;
            }
            int n7 = Sorting.lower_bound(nArray, n, n6, n3);
            int n8 = Sorting.upper_bound(nArray, n6 + 1, n + n4, n3);
            return new Range(nArray, n7, n8);
        }
        return new Range(nArray, n, n);
    }

    public static Range equal_range(int[] nArray, int n, int n2, int n3, BinaryPredicate binaryPredicate) {
        int n4 = n2 - n;
        while (n4 > 0) {
            int n5 = n4 / 2;
            int n6 = n + n5;
            if (binaryPredicate.apply(nArray[n6], n3)) {
                n = n6 + 1;
                n4 = n4 - n5 + 1;
                continue;
            }
            if (binaryPredicate.apply(n3, nArray[n6])) {
                n4 = n5;
                continue;
            }
            int n7 = Sorting.lower_bound(nArray, n, n6, n3, binaryPredicate);
            int n8 = Sorting.upper_bound(nArray, n6 + 1, n + n4, n3, binaryPredicate);
            return new Range(nArray, n7, n8);
        }
        return new Range(nArray, n, n);
    }

    public static boolean binary_search(int[] nArray, int n, int n2, int n3) {
        int n4 = Sorting.lower_bound(nArray, n, n2, n3);
        return n4 < n2 && n3 >= nArray[n4];
    }

    public static boolean binary_search(int[] nArray, int n, int n2, int n3, BinaryPredicate binaryPredicate) {
        int n4 = Sorting.lower_bound(nArray, n, n2, n3, binaryPredicate);
        return n4 < n2 && !binaryPredicate.apply(n3, nArray[n4]);
    }

    public static int merge(int[] nArray, int[] nArray2, int[] nArray3, int n, int n2, int n3, int n4, int n5) {
        while (n < n2 && n3 < n4) {
            if (nArray2[n3] < nArray[n]) {
                nArray3[n5++] = nArray2[n3++];
                continue;
            }
            nArray3[n5++] = nArray[n++];
        }
        Modification.copy(nArray, nArray3, n, n2, n5);
        Modification.copy(nArray2, nArray3, n3, n4, n5);
        return n5 + (n2 - n) + (n4 - n3);
    }

    public static int merge(int[] nArray, int[] nArray2, int[] nArray3, int n, int n2, int n3, int n4, int n5, BinaryPredicate binaryPredicate) {
        while (n < n2 && n3 < n4) {
            if (binaryPredicate.apply(nArray2[n3], nArray[n])) {
                nArray3[n5++] = nArray2[n3++];
                continue;
            }
            nArray3[n5++] = nArray[n++];
        }
        Modification.copy(nArray, nArray3, n, n2, n5);
        Modification.copy(nArray2, nArray3, n3, n4, n5);
        return n5 + (n2 - n) + (n4 - n3);
    }

    public static void inplace_merge(int[] nArray, int n, int n2, int n3) {
        int n4;
        int n5;
        if (n >= n2 || n2 >= n3) {
            return;
        }
        if (n3 - n == 2) {
            if (nArray[n2] < nArray[n]) {
                int n6 = nArray[n];
                nArray[n] = nArray[n2];
                nArray[n2] = n6;
            }
            return;
        }
        if (n2 - n > n3 - n2) {
            n5 = n + (n2 - n) / 2;
            n4 = Sorting.lower_bound(nArray, n2, n3, nArray[n5]);
        } else {
            n4 = n2 + (n3 - n2) / 2;
            n5 = Sorting.upper_bound(nArray, n, n2, nArray[n4]);
        }
        Modification.rotate(nArray, n5, n2, n4);
        n2 = n5 + (n4 - n2);
        Sorting.inplace_merge(nArray, n, n5, n2);
        Sorting.inplace_merge(nArray, n2, n4, n3);
    }

    public static void inplace_merge(int[] nArray, int n, int n2, int n3, BinaryPredicate binaryPredicate) {
        int n4;
        int n5;
        if (n >= n2 || n2 >= n3) {
            return;
        }
        if (n3 - n == 2) {
            if (binaryPredicate.apply(nArray[n2], nArray[n])) {
                int n6 = nArray[n];
                nArray[n] = nArray[n2];
                nArray[n2] = n6;
            }
            return;
        }
        if (n2 - n > n3 - n2) {
            n5 = n + (n2 - n) / 2;
            n4 = Sorting.lower_bound(nArray, n2, n3, nArray[n5], binaryPredicate);
        } else {
            n4 = n2 + (n3 - n2) / 2;
            n5 = Sorting.upper_bound(nArray, n, n2, nArray[n4], binaryPredicate);
        }
        Modification.rotate(nArray, n5, n2, n4);
        n2 = n5 + (n4 - n2);
        Sorting.inplace_merge(nArray, n, n5, n2, binaryPredicate);
        Sorting.inplace_merge(nArray, n2, n4, n3, binaryPredicate);
    }

    public static boolean includes(int[] nArray, int[] nArray2, int n, int n2, int n3, int n4) {
        while (n < n2 && n3 < n4) {
            if (nArray2[n3] < nArray[n]) {
                return false;
            }
            if (nArray[n] < nArray2[n3]) {
                ++n;
                continue;
            }
            ++n;
            ++n3;
        }
        return n3 == n4;
    }

    public static boolean includes(int[] nArray, int[] nArray2, int n, int n2, int n3, int n4, BinaryPredicate binaryPredicate) {
        while (n < n2 && n3 < n4) {
            if (binaryPredicate.apply(nArray2[n3], nArray[n])) {
                return false;
            }
            if (binaryPredicate.apply(nArray[n], nArray2[n3])) {
                ++n;
                continue;
            }
            ++n;
            ++n3;
        }
        return n3 == n4;
    }

    public static int set_union(int[] nArray, int[] nArray2, int[] nArray3, int n, int n2, int n3, int n4, int n5) {
        while (n < n2 && n3 < n4) {
            if (nArray[n] < nArray2[n3]) {
                nArray3[n5++] = nArray[n++];
                continue;
            }
            if (nArray2[n3] < nArray[n]) {
                nArray3[n5++] = nArray2[n3++];
                continue;
            }
            nArray3[n5++] = nArray[n++];
            ++n3;
        }
        Modification.copy(nArray, nArray3, n, n2, n5);
        Modification.copy(nArray2, nArray3, n3, n4, n5);
        return n5 + (n2 - n) + (n4 - n3);
    }

    public static int set_union(int[] nArray, int[] nArray2, int[] nArray3, int n, int n2, int n3, int n4, int n5, BinaryPredicate binaryPredicate) {
        while (n < n2 && n3 < n4) {
            if (binaryPredicate.apply(nArray[n], nArray2[n3])) {
                nArray3[n5++] = nArray[n++];
                continue;
            }
            if (binaryPredicate.apply(nArray2[n3], nArray[n])) {
                nArray3[n5++] = nArray2[n3++];
                continue;
            }
            nArray3[n5++] = nArray[n++];
            ++n3;
        }
        Modification.copy(nArray, nArray3, n, n2, n5);
        Modification.copy(nArray2, nArray3, n3, n4, n5);
        return n5 + (n2 - n) + (n4 - n3);
    }

    public static int set_intersection(int[] nArray, int[] nArray2, int[] nArray3, int n, int n2, int n3, int n4, int n5) {
        while (n < n2 && n3 < n4) {
            if (nArray[n] < nArray2[n3]) {
                ++n;
                continue;
            }
            if (nArray2[n3] < nArray[n]) {
                ++n3;
                continue;
            }
            nArray3[n5++] = nArray[n++];
            ++n3;
        }
        return n5;
    }

    public static int set_intersection(int[] nArray, int[] nArray2, int[] nArray3, int n, int n2, int n3, int n4, int n5, BinaryPredicate binaryPredicate) {
        while (n < n2 && n3 < n4) {
            if (binaryPredicate.apply(nArray[n], nArray2[n3])) {
                ++n;
                continue;
            }
            if (binaryPredicate.apply(nArray2[n3], nArray[n])) {
                ++n3;
                continue;
            }
            nArray3[n5++] = nArray[n++];
            ++n3;
        }
        return n5;
    }

    public static int set_difference(int[] nArray, int[] nArray2, int[] nArray3, int n, int n2, int n3, int n4, int n5) {
        while (n < n2 && n3 < n4) {
            if (nArray[n] < nArray2[n3]) {
                nArray3[n5++] = nArray[n++];
                continue;
            }
            if (nArray2[n3] < nArray[n]) {
                ++n3;
                continue;
            }
            ++n;
            ++n3;
        }
        Modification.copy(nArray, nArray3, n, n2, n5);
        return n5 + (n2 - n);
    }

    public static int set_difference(int[] nArray, int[] nArray2, int[] nArray3, int n, int n2, int n3, int n4, int n5, BinaryPredicate binaryPredicate) {
        while (n < n2 && n3 < n4) {
            if (binaryPredicate.apply(nArray[n], nArray2[n3])) {
                nArray3[n5++] = nArray[n++];
                continue;
            }
            if (binaryPredicate.apply(nArray2[n3], nArray[n])) {
                ++n3;
                continue;
            }
            ++n;
            ++n3;
        }
        Modification.copy(nArray, nArray3, n, n2, n5);
        return n5 + (n2 - n);
    }

    public static int set_symmetric_difference(int[] nArray, int[] nArray2, int[] nArray3, int n, int n2, int n3, int n4, int n5) {
        while (n < n2 && n3 < n4) {
            if (nArray[n] < nArray2[n3]) {
                nArray3[n5++] = nArray[n++];
                continue;
            }
            if (nArray2[n3] < nArray[n]) {
                nArray3[n5++] = nArray2[n3++];
                continue;
            }
            ++n;
            ++n3;
        }
        Modification.copy(nArray, nArray3, n, n2, n5);
        Modification.copy(nArray2, nArray3, n3, n4, n5);
        return n5 + (n2 - n) + (n4 - n3);
    }

    public static int set_symmetric_difference(int[] nArray, int[] nArray2, int[] nArray3, int n, int n2, int n3, int n4, int n5, BinaryPredicate binaryPredicate) {
        while (n < n2 && n3 < n4) {
            if (binaryPredicate.apply(nArray[n], nArray2[n3])) {
                nArray3[n5++] = nArray[n++];
                continue;
            }
            if (binaryPredicate.apply(nArray2[n3], nArray[n])) {
                nArray3[n5++] = nArray2[n3++];
                continue;
            }
            ++n;
            ++n3;
        }
        Modification.copy(nArray, nArray3, n, n2, n5);
        Modification.copy(nArray2, nArray3, n3, n4, n5);
        return n5 + (n2 - n) + (n4 - n3);
    }

    public static void push_heap(int[] nArray, int n, int n2) {
        if (n2 - n < 2) {
            return;
        }
        int n3 = nArray[--n2];
        int n4 = n + (n2 - n - 1) / 2;
        while (n2 > n && nArray[n4] < n3) {
            nArray[n2] = nArray[n4];
            n2 = n4;
            n4 = n + (n2 - n - 1) / 2;
        }
        nArray[n2] = n3;
    }

    public static void push_heap(int[] nArray, int n, int n2, BinaryPredicate binaryPredicate) {
        if (n2 - n < 2) {
            return;
        }
        int n3 = nArray[--n2];
        int n4 = n + (n2 - n - 1) / 2;
        while (n2 > n && binaryPredicate.apply(nArray[n4], n3)) {
            nArray[n2] = nArray[n4];
            n2 = n4;
            n4 = n + (n2 - n - 1) / 2;
        }
        nArray[n2] = n3;
    }

    private static void adjust_heap(int[] nArray, int n, int n2, int n3) {
        int n4;
        int n5 = nArray[n2];
        int n6 = n3 - n;
        int n7 = n2 - n;
        for (n4 = 2 * n7 + 2; n4 < n6; n4 *= 2) {
            if (nArray[n + n4] < nArray[n + (n4 - 1)]) {
                --n4;
            }
            nArray[n + n7] = nArray[n + n4];
            n7 = n4++;
        }
        if (n4-- == n6) {
            nArray[n + n7] = nArray[n + n4];
            n7 = n4;
        }
        int n8 = (n7 - 1) / 2;
        int n9 = n2 - n;
        while (n7 != n9 && nArray[n + n8] < n5) {
            nArray[n + n7] = nArray[n + n8];
            n7 = n8;
            n8 = (n7 - 1) / 2;
        }
        nArray[n + n7] = n5;
    }

    private static void adjust_heap(int[] nArray, int n, int n2, int n3, BinaryPredicate binaryPredicate) {
        int n4;
        int n5 = nArray[n2];
        int n6 = n3 - n;
        int n7 = n2 - n;
        for (n4 = 2 * n7 + 2; n4 < n6; n4 *= 2) {
            if (binaryPredicate.apply(nArray[n + n4], nArray[n + (n4 - 1)])) {
                --n4;
            }
            nArray[n + n7] = nArray[n + n4];
            n7 = n4++;
        }
        if (n4-- == n6) {
            nArray[n + n7] = nArray[n + n4];
            n7 = n4;
        }
        int n8 = (n7 - 1) / 2;
        int n9 = n2 - n;
        while (n7 != n9 && binaryPredicate.apply(nArray[n + n8], n5)) {
            nArray[n + n7] = nArray[n + n8];
            n7 = n8;
            n8 = (n7 - 1) / 2;
        }
        nArray[n + n7] = n5;
    }

    public static void pop_heap(int[] nArray, int n, int n2) {
        if (n2 - n < 2) {
            return;
        }
        int n3 = nArray[--n2];
        nArray[n2] = nArray[n];
        nArray[n] = n3;
        Sorting.adjust_heap(nArray, n, n, n2);
    }

    public static void pop_heap(int[] nArray, int n, int n2, BinaryPredicate binaryPredicate) {
        if (n2 - n < 2) {
            return;
        }
        int n3 = nArray[--n2];
        nArray[n2] = nArray[n];
        nArray[n] = n3;
        Sorting.adjust_heap(nArray, n, n, n2, binaryPredicate);
    }

    public static void make_heap(int[] nArray, int n, int n2) {
        if (n2 - n < 2) {
            return;
        }
        int n3 = (n2 - n - 2) / 2;
        do {
            Sorting.adjust_heap(nArray, n, n + n3, n2);
        } while (n3-- != 0);
    }

    public static void make_heap(int[] nArray, int n, int n2, BinaryPredicate binaryPredicate) {
        if (n2 - n < 2) {
            return;
        }
        int n3 = (n2 - n - 2) / 2;
        do {
            Sorting.adjust_heap(nArray, n, n + n3, n2, binaryPredicate);
        } while (n3-- != 0);
    }

    public static void sort_heap(int[] nArray, int n, int n2) {
        while (n2 - n > 1) {
            int n3 = nArray[--n2];
            nArray[n2] = nArray[n];
            nArray[n] = n3;
            Sorting.adjust_heap(nArray, n, n, n2);
        }
    }

    public static void sort_heap(int[] nArray, int n, int n2, BinaryPredicate binaryPredicate) {
        while (n2 - n > 1) {
            int n3 = nArray[--n2];
            nArray[n2] = nArray[n];
            nArray[n] = n3;
            Sorting.adjust_heap(nArray, n, n, n2, binaryPredicate);
        }
    }

    public static int max_element(int[] nArray, int n, int n2) {
        if (n >= n2) {
            return n2;
        }
        int n3 = n;
        while (++n < n2) {
            if (nArray[n3] >= nArray[n]) continue;
            n3 = n;
        }
        return n3;
    }

    public static int max_element(int[] nArray, int n, int n2, BinaryPredicate binaryPredicate) {
        if (n >= n2) {
            return n2;
        }
        int n3 = n;
        while (++n < n2) {
            if (!binaryPredicate.apply(nArray[n3], nArray[n])) continue;
            n3 = n;
        }
        return n3;
    }

    public static int min_element(int[] nArray, int n, int n2) {
        if (n >= n2) {
            return n2;
        }
        int n3 = n;
        while (++n < n2) {
            if (nArray[n] >= nArray[n3]) continue;
            n3 = n;
        }
        return n3;
    }

    public static int min_element(int[] nArray, int n, int n2, BinaryPredicate binaryPredicate) {
        if (n >= n2) {
            return n2;
        }
        int n3 = n;
        while (++n < n2) {
            if (!binaryPredicate.apply(nArray[n], nArray[n3])) continue;
            n3 = n;
        }
        return n3;
    }

    public static boolean lexicographical_compare(int[] nArray, int[] nArray2, int n, int n2, int n3, int n4) {
        while (n < n2 && n3 < n4) {
            if (nArray[n] < nArray2[n3]) {
                return true;
            }
            if (nArray2[n3++] >= nArray[n++]) continue;
            return false;
        }
        return n == n2 && n3 != n4;
    }

    public static boolean lexicographical_compare(int[] nArray, int[] nArray2, int n, int n2, int n3, int n4, BinaryPredicate binaryPredicate) {
        while (n < n2 && n3 < n4) {
            if (binaryPredicate.apply(nArray[n], nArray2[n3])) {
                return true;
            }
            if (!binaryPredicate.apply(nArray2[n3++], nArray[n++])) continue;
            return false;
        }
        return n == n2 && n3 != n4;
    }

    public static boolean next_permutation(int[] nArray, int n, int n2) {
        if (n2 - n < 2) {
            return false;
        }
        int n3 = n2 - 1;
        do {
            int n4;
            if (nArray[--n3] >= nArray[n4]) continue;
            int n5 = n2;
            while (nArray[n3] >= nArray[--n5]) {
            }
            int n6 = nArray[n3];
            nArray[n3] = nArray[n5];
            nArray[n5] = n6;
            Modification.reverse(nArray, n4, n2);
            return true;
        } while (n3 != n);
        Modification.reverse(nArray, n, n2);
        return false;
    }

    public static boolean next_permutation(int[] nArray, int n, int n2, BinaryPredicate binaryPredicate) {
        if (n2 - n < 2) {
            return false;
        }
        int n3 = n2 - 1;
        do {
            int n4;
            if (!binaryPredicate.apply(nArray[--n3], nArray[n4])) continue;
            int n5 = n2;
            while (!binaryPredicate.apply(nArray[n3], nArray[--n5])) {
            }
            int n6 = nArray[n3];
            nArray[n3] = nArray[n5];
            nArray[n5] = n6;
            Modification.reverse(nArray, n4, n2);
            return true;
        } while (n3 != n);
        Modification.reverse(nArray, n, n2);
        return false;
    }

    public static boolean prev_permutation(int[] nArray, int n, int n2) {
        if (n2 - n < 2) {
            return false;
        }
        int n3 = n2 - 1;
        do {
            int n4;
            if (nArray[n4] >= nArray[--n3]) continue;
            int n5 = n2;
            while (nArray[--n5] >= nArray[n3]) {
            }
            int n6 = nArray[n3];
            nArray[n3] = nArray[n5];
            nArray[n5] = n6;
            Modification.reverse(nArray, n4, n2);
            return true;
        } while (n3 != n);
        Modification.reverse(nArray, n, n2);
        return false;
    }

    public static boolean prev_permutation(int[] nArray, int n, int n2, BinaryPredicate binaryPredicate) {
        if (n2 - n < 2) {
            return false;
        }
        int n3 = n2 - 1;
        do {
            int n4;
            if (!binaryPredicate.apply(nArray[n4], nArray[--n3])) continue;
            int n5 = n2;
            while (!binaryPredicate.apply(nArray[--n5], nArray[n3])) {
            }
            int n6 = nArray[n3];
            nArray[n3] = nArray[n5];
            nArray[n5] = n6;
            Modification.reverse(nArray, n4, n2);
            return true;
        } while (n3 != n);
        Modification.reverse(nArray, n, n2);
        return false;
    }

    private Sorting() {
    }
}

