/*
 * Decompiled with CFR 0.152.
 */
package jal.FLOAT;

import jal.FLOAT.BinaryPredicate;
import jal.FLOAT.Modification;
import jal.FLOAT.Range;

public final class Sorting {
    private static final int partitionCutoff = 13;
    private static final int qsort_stacksize = 56;
    private static final int stableSortCutoff = 9;

    public static void sort(float[] fArray, int n, int n2) {
        if (n2 - n >= 13) {
            Sorting.qsortLoop(fArray, n, n2);
        }
        Sorting.insertion_sort(fArray, n, n2);
    }

    public static void sort(float[] fArray, int n, int n2, BinaryPredicate binaryPredicate) {
        if (n2 - n >= 13) {
            Sorting.qsortLoop(fArray, n, n2, binaryPredicate);
        }
        Sorting.insertion_sort(fArray, n, n2, binaryPredicate);
    }

    public static void insertion_sort(float[] fArray, int n, int n2) {
        int n3 = n;
        while (++n3 < n2) {
            float f = fArray[n3];
            int n4 = n3;
            float f2 = fArray[n4 - 1];
            while (f < f2) {
                fArray[n4] = f2;
                if (n == n4 - 1) {
                    --n4;
                    break;
                }
                f2 = fArray[--n4 - 1];
            }
            fArray[n4] = f;
        }
    }

    public static void insertion_sort(float[] fArray, int n, int n2, BinaryPredicate binaryPredicate) {
        int n3 = n;
        while (++n3 < n2) {
            float f = fArray[n3];
            int n4 = n3;
            float f2 = fArray[n4 - 1];
            while (binaryPredicate.apply(f, f2)) {
                fArray[n4] = f2;
                if (n == n4 - 1) {
                    --n4;
                    break;
                }
                f2 = fArray[--n4 - 1];
            }
            fArray[n4] = f;
        }
    }

    private static int quickPartition(float[] fArray, int n, int n2) {
        float f = fArray[n];
        float f2 = fArray[n2 - 1];
        float f3 = fArray[n + (n2 - n) / 2];
        if (f3 < f) {
            if (f < f2) {
                f3 = f;
            } else if (f3 < f2) {
                f3 = f2;
            }
        } else if (f2 < f) {
            f3 = f;
        } else if (f2 < f3) {
            f3 = f2;
        }
        --n;
        while (true) {
            if (fArray[++n] < f3) {
                continue;
            }
            while (f3 < fArray[--n2]) {
            }
            if (n >= n2) {
                return n;
            }
            float f4 = fArray[n];
            fArray[n] = fArray[n2];
            fArray[n2] = f4;
        }
    }

    private static int quickPartition(float[] fArray, int n, int n2, BinaryPredicate binaryPredicate) {
        float f = fArray[n];
        float f2 = fArray[n2 - 1];
        float f3 = fArray[n + (n2 - n) / 2];
        if (binaryPredicate.apply(f3, f)) {
            if (binaryPredicate.apply(f, f2)) {
                f3 = f;
            } else if (binaryPredicate.apply(f3, f2)) {
                f3 = f2;
            }
        } else if (binaryPredicate.apply(f2, f)) {
            f3 = f;
        } else if (binaryPredicate.apply(f2, f3)) {
            f3 = f2;
        }
        --n;
        while (true) {
            if (binaryPredicate.apply(fArray[++n], f3)) {
                continue;
            }
            while (binaryPredicate.apply(f3, fArray[--n2])) {
            }
            if (n >= n2) {
                return n;
            }
            float f4 = fArray[n];
            fArray[n] = fArray[n2];
            fArray[n2] = f4;
        }
    }

    private static void qsortLoop(float[] fArray, int n, int n2) {
        int[] nArray = new int[56];
        int n3 = 0;
        while (true) {
            int n4;
            if (n2 - (n4 = Sorting.quickPartition(fArray, n, n2)) < 13) {
                if (n4 - n < 13) {
                    if (n3 == 0) {
                        return;
                    }
                    n2 = nArray[--n3];
                    n = nArray[--n3];
                    continue;
                }
                n2 = n4;
                continue;
            }
            if (n4 - n < 13) {
                n = n4;
                continue;
            }
            if (n2 - n4 > n4 - n) {
                nArray[n3++] = n4;
                nArray[n3++] = n2;
                n2 = n4;
                continue;
            }
            nArray[n3++] = n;
            nArray[n3++] = n4;
            n = n4;
        }
    }

    private static void qsortLoop(float[] fArray, int n, int n2, BinaryPredicate binaryPredicate) {
        int[] nArray = new int[56];
        int n3 = 0;
        while (true) {
            int n4;
            if (n2 - (n4 = Sorting.quickPartition(fArray, n, n2, binaryPredicate)) < 13) {
                if (n4 - n < 13) {
                    if (n3 == 0) {
                        return;
                    }
                    n2 = nArray[--n3];
                    n = nArray[--n3];
                    continue;
                }
                n2 = n4;
                continue;
            }
            if (n4 - n < 13) {
                n = n4;
                continue;
            }
            if (n2 - n4 > n4 - n) {
                nArray[n3++] = n4;
                nArray[n3++] = n2;
                n2 = n4;
                continue;
            }
            nArray[n3++] = n;
            nArray[n3++] = n4;
            n = n4;
        }
    }

    public static void stable_sort(float[] fArray, int n, int n2) {
        if (n2 - n < 9) {
            Sorting.insertion_sort(fArray, n, n2);
        } else {
            int n3 = n + (n2 - n) / 2;
            Sorting.stable_sort(fArray, n, n3);
            Sorting.stable_sort(fArray, n3, n2);
            Sorting.inplace_merge(fArray, n, n3, n2);
        }
    }

    public static void stable_sort(float[] fArray, int n, int n2, BinaryPredicate binaryPredicate) {
        if (n2 - n < 9) {
            Sorting.insertion_sort(fArray, n, n2, binaryPredicate);
        } else {
            int n3 = n + (n2 - n) / 2;
            Sorting.stable_sort(fArray, n, n3, binaryPredicate);
            Sorting.stable_sort(fArray, n3, n2, binaryPredicate);
            Sorting.inplace_merge(fArray, n, n3, n2, binaryPredicate);
        }
    }

    public static void partial_sort(float[] fArray, int n, int n2, int n3) {
        Sorting.make_heap(fArray, n, n2);
        for (int i = n2; i < n3; ++i) {
            if (!(fArray[i] < fArray[n])) continue;
            float f = fArray[i];
            fArray[i] = fArray[n];
            fArray[n] = f;
            Sorting.adjust_heap(fArray, n, n, n2);
        }
        Sorting.sort_heap(fArray, n, n2);
    }

    public static void partial_sort(float[] fArray, int n, int n2, int n3, BinaryPredicate binaryPredicate) {
        Sorting.make_heap(fArray, n, n2, binaryPredicate);
        for (int i = n2; i < n3; ++i) {
            if (!binaryPredicate.apply(fArray[i], fArray[n])) continue;
            float f = fArray[i];
            fArray[i] = fArray[n];
            fArray[n] = f;
            Sorting.adjust_heap(fArray, n, n, n2, binaryPredicate);
        }
        Sorting.sort_heap(fArray, n, n2, binaryPredicate);
    }

    public static int partial_sort_copy(float[] fArray, float[] fArray2, int n, int n2, int n3, int n4) {
        if (n3 == n4) {
            return n4;
        }
        int n5 = Math.min(n2 - n, n4 - n3);
        Modification.copy(fArray, fArray2, n, n + n5, n3);
        n4 = n3 + n5;
        Sorting.make_heap(fArray2, n3, n4);
        n += n5;
        while (n < n2) {
            if (fArray[n] < fArray2[n3]) {
                fArray2[n3] = fArray[n];
                Sorting.adjust_heap(fArray2, n3, n3, n4);
            }
            ++n;
        }
        Sorting.sort_heap(fArray2, n3, n4);
        return n4;
    }

    public static int partial_sort_copy(float[] fArray, float[] fArray2, int n, int n2, int n3, int n4, BinaryPredicate binaryPredicate) {
        if (n3 == n4) {
            return n4;
        }
        int n5 = Math.min(n2 - n, n4 - n3);
        Modification.copy(fArray, fArray2, n, n + n5, n3);
        n4 = n3 + n5;
        Sorting.make_heap(fArray2, n3, n4, binaryPredicate);
        n += n5;
        while (n < n2) {
            if (binaryPredicate.apply(fArray[n], fArray2[n3])) {
                fArray2[n3] = fArray[n];
                Sorting.adjust_heap(fArray2, n3, n3, n4, binaryPredicate);
            }
            ++n;
        }
        Sorting.sort_heap(fArray2, n3, n4, binaryPredicate);
        return n4;
    }

    public static void nth_element(float[] fArray, int n, int n2, int n3) {
        while (n3 - n > 3) {
            int n4 = Sorting.quickPartition(fArray, n, n3);
            if (n4 <= n2) {
                n = n4;
                continue;
            }
            n3 = n4;
        }
        Sorting.insertion_sort(fArray, n, n3);
    }

    public static void nth_element(float[] fArray, int n, int n2, int n3, BinaryPredicate binaryPredicate) {
        while (n3 - n > 3) {
            int n4 = Sorting.quickPartition(fArray, n, n3, binaryPredicate);
            if (n4 <= n2) {
                n = n4;
                continue;
            }
            n3 = n4;
        }
        Sorting.insertion_sort(fArray, n, n3, binaryPredicate);
    }

    public static int lower_bound(float[] fArray, int n, int n2, float f) {
        int n3 = n2 - n;
        while (n3 > 0) {
            int n4 = n3 / 2;
            int n5 = n + n4;
            if (fArray[n5] < f) {
                n = n5 + 1;
                n3 -= n4 + 1;
                continue;
            }
            n3 = n4;
        }
        return n;
    }

    public static int lower_bound(float[] fArray, int n, int n2, float f, BinaryPredicate binaryPredicate) {
        int n3 = n2 - n;
        while (n3 > 0) {
            int n4 = n3 / 2;
            int n5 = n + n4;
            if (binaryPredicate.apply(fArray[n5], f)) {
                n = n5 + 1;
                n3 -= n4 + 1;
                continue;
            }
            n3 = n4;
        }
        return n;
    }

    public static int upper_bound(float[] fArray, int n, int n2, float f) {
        int n3 = n2 - n;
        while (n3 > 0) {
            int n4 = n3 / 2;
            int n5 = n + n4;
            if (f < fArray[n5]) {
                n3 = n4;
                continue;
            }
            n = n5 + 1;
            n3 -= n4 + 1;
        }
        return n;
    }

    public static int upper_bound(float[] fArray, int n, int n2, float f, BinaryPredicate binaryPredicate) {
        int n3 = n2 - n;
        while (n3 > 0) {
            int n4 = n3 / 2;
            int n5 = n + n4;
            if (binaryPredicate.apply(f, fArray[n5])) {
                n3 = n4;
                continue;
            }
            n = n5 + 1;
            n3 -= n4 + 1;
        }
        return n;
    }

    public static Range equal_range(float[] fArray, int n, int n2, float f) {
        int n3 = n2 - n;
        while (n3 > 0) {
            int n4 = n3 / 2;
            int n5 = n + n4;
            if (fArray[n5] < f) {
                n = n5 + 1;
                n3 = n3 - n4 + 1;
                continue;
            }
            if (f < fArray[n5]) {
                n3 = n4;
                continue;
            }
            int n6 = Sorting.lower_bound(fArray, n, n5, f);
            int n7 = Sorting.upper_bound(fArray, n5 + 1, n + n3, f);
            return new Range(fArray, n6, n7);
        }
        return new Range(fArray, n, n);
    }

    public static Range equal_range(float[] fArray, int n, int n2, float f, BinaryPredicate binaryPredicate) {
        int n3 = n2 - n;
        while (n3 > 0) {
            int n4 = n3 / 2;
            int n5 = n + n4;
            if (binaryPredicate.apply(fArray[n5], f)) {
                n = n5 + 1;
                n3 = n3 - n4 + 1;
                continue;
            }
            if (binaryPredicate.apply(f, fArray[n5])) {
                n3 = n4;
                continue;
            }
            int n6 = Sorting.lower_bound(fArray, n, n5, f, binaryPredicate);
            int n7 = Sorting.upper_bound(fArray, n5 + 1, n + n3, f, binaryPredicate);
            return new Range(fArray, n6, n7);
        }
        return new Range(fArray, n, n);
    }

    public static boolean binary_search(float[] fArray, int n, int n2, float f) {
        int n3 = Sorting.lower_bound(fArray, n, n2, f);
        return n3 < n2 && !(f < fArray[n3]);
    }

    public static boolean binary_search(float[] fArray, int n, int n2, float f, BinaryPredicate binaryPredicate) {
        int n3 = Sorting.lower_bound(fArray, n, n2, f, binaryPredicate);
        return n3 < n2 && !binaryPredicate.apply(f, fArray[n3]);
    }

    public static int merge(float[] fArray, float[] fArray2, float[] fArray3, int n, int n2, int n3, int n4, int n5) {
        while (n < n2 && n3 < n4) {
            if (fArray2[n3] < fArray[n]) {
                fArray3[n5++] = fArray2[n3++];
                continue;
            }
            fArray3[n5++] = fArray[n++];
        }
        Modification.copy(fArray, fArray3, n, n2, n5);
        Modification.copy(fArray2, fArray3, n3, n4, n5);
        return n5 + (n2 - n) + (n4 - n3);
    }

    public static int merge(float[] fArray, float[] fArray2, float[] fArray3, int n, int n2, int n3, int n4, int n5, BinaryPredicate binaryPredicate) {
        while (n < n2 && n3 < n4) {
            if (binaryPredicate.apply(fArray2[n3], fArray[n])) {
                fArray3[n5++] = fArray2[n3++];
                continue;
            }
            fArray3[n5++] = fArray[n++];
        }
        Modification.copy(fArray, fArray3, n, n2, n5);
        Modification.copy(fArray2, fArray3, n3, n4, n5);
        return n5 + (n2 - n) + (n4 - n3);
    }

    public static void inplace_merge(float[] fArray, int n, int n2, int n3) {
        int n4;
        int n5;
        if (n >= n2 || n2 >= n3) {
            return;
        }
        if (n3 - n == 2) {
            if (fArray[n2] < fArray[n]) {
                float f = fArray[n];
                fArray[n] = fArray[n2];
                fArray[n2] = f;
            }
            return;
        }
        if (n2 - n > n3 - n2) {
            n5 = n + (n2 - n) / 2;
            n4 = Sorting.lower_bound(fArray, n2, n3, fArray[n5]);
        } else {
            n4 = n2 + (n3 - n2) / 2;
            n5 = Sorting.upper_bound(fArray, n, n2, fArray[n4]);
        }
        Modification.rotate(fArray, n5, n2, n4);
        n2 = n5 + (n4 - n2);
        Sorting.inplace_merge(fArray, n, n5, n2);
        Sorting.inplace_merge(fArray, n2, n4, n3);
    }

    public static void inplace_merge(float[] fArray, int n, int n2, int n3, BinaryPredicate binaryPredicate) {
        int n4;
        int n5;
        if (n >= n2 || n2 >= n3) {
            return;
        }
        if (n3 - n == 2) {
            if (binaryPredicate.apply(fArray[n2], fArray[n])) {
                float f = fArray[n];
                fArray[n] = fArray[n2];
                fArray[n2] = f;
            }
            return;
        }
        if (n2 - n > n3 - n2) {
            n5 = n + (n2 - n) / 2;
            n4 = Sorting.lower_bound(fArray, n2, n3, fArray[n5], binaryPredicate);
        } else {
            n4 = n2 + (n3 - n2) / 2;
            n5 = Sorting.upper_bound(fArray, n, n2, fArray[n4], binaryPredicate);
        }
        Modification.rotate(fArray, n5, n2, n4);
        n2 = n5 + (n4 - n2);
        Sorting.inplace_merge(fArray, n, n5, n2, binaryPredicate);
        Sorting.inplace_merge(fArray, n2, n4, n3, binaryPredicate);
    }

    public static boolean includes(float[] fArray, float[] fArray2, int n, int n2, int n3, int n4) {
        while (n < n2 && n3 < n4) {
            if (fArray2[n3] < fArray[n]) {
                return false;
            }
            if (fArray[n] < fArray2[n3]) {
                ++n;
                continue;
            }
            ++n;
            ++n3;
        }
        return n3 == n4;
    }

    public static boolean includes(float[] fArray, float[] fArray2, int n, int n2, int n3, int n4, BinaryPredicate binaryPredicate) {
        while (n < n2 && n3 < n4) {
            if (binaryPredicate.apply(fArray2[n3], fArray[n])) {
                return false;
            }
            if (binaryPredicate.apply(fArray[n], fArray2[n3])) {
                ++n;
                continue;
            }
            ++n;
            ++n3;
        }
        return n3 == n4;
    }

    public static int set_union(float[] fArray, float[] fArray2, float[] fArray3, int n, int n2, int n3, int n4, int n5) {
        while (n < n2 && n3 < n4) {
            if (fArray[n] < fArray2[n3]) {
                fArray3[n5++] = fArray[n++];
                continue;
            }
            if (fArray2[n3] < fArray[n]) {
                fArray3[n5++] = fArray2[n3++];
                continue;
            }
            fArray3[n5++] = fArray[n++];
            ++n3;
        }
        Modification.copy(fArray, fArray3, n, n2, n5);
        Modification.copy(fArray2, fArray3, n3, n4, n5);
        return n5 + (n2 - n) + (n4 - n3);
    }

    public static int set_union(float[] fArray, float[] fArray2, float[] fArray3, int n, int n2, int n3, int n4, int n5, BinaryPredicate binaryPredicate) {
        while (n < n2 && n3 < n4) {
            if (binaryPredicate.apply(fArray[n], fArray2[n3])) {
                fArray3[n5++] = fArray[n++];
                continue;
            }
            if (binaryPredicate.apply(fArray2[n3], fArray[n])) {
                fArray3[n5++] = fArray2[n3++];
                continue;
            }
            fArray3[n5++] = fArray[n++];
            ++n3;
        }
        Modification.copy(fArray, fArray3, n, n2, n5);
        Modification.copy(fArray2, fArray3, n3, n4, n5);
        return n5 + (n2 - n) + (n4 - n3);
    }

    public static int set_intersection(float[] fArray, float[] fArray2, float[] fArray3, int n, int n2, int n3, int n4, int n5) {
        while (n < n2 && n3 < n4) {
            if (fArray[n] < fArray2[n3]) {
                ++n;
                continue;
            }
            if (fArray2[n3] < fArray[n]) {
                ++n3;
                continue;
            }
            fArray3[n5++] = fArray[n++];
            ++n3;
        }
        return n5;
    }

    public static int set_intersection(float[] fArray, float[] fArray2, float[] fArray3, int n, int n2, int n3, int n4, int n5, BinaryPredicate binaryPredicate) {
        while (n < n2 && n3 < n4) {
            if (binaryPredicate.apply(fArray[n], fArray2[n3])) {
                ++n;
                continue;
            }
            if (binaryPredicate.apply(fArray2[n3], fArray[n])) {
                ++n3;
                continue;
            }
            fArray3[n5++] = fArray[n++];
            ++n3;
        }
        return n5;
    }

    public static int set_difference(float[] fArray, float[] fArray2, float[] fArray3, int n, int n2, int n3, int n4, int n5) {
        while (n < n2 && n3 < n4) {
            if (fArray[n] < fArray2[n3]) {
                fArray3[n5++] = fArray[n++];
                continue;
            }
            if (fArray2[n3] < fArray[n]) {
                ++n3;
                continue;
            }
            ++n;
            ++n3;
        }
        Modification.copy(fArray, fArray3, n, n2, n5);
        return n5 + (n2 - n);
    }

    public static int set_difference(float[] fArray, float[] fArray2, float[] fArray3, int n, int n2, int n3, int n4, int n5, BinaryPredicate binaryPredicate) {
        while (n < n2 && n3 < n4) {
            if (binaryPredicate.apply(fArray[n], fArray2[n3])) {
                fArray3[n5++] = fArray[n++];
                continue;
            }
            if (binaryPredicate.apply(fArray2[n3], fArray[n])) {
                ++n3;
                continue;
            }
            ++n;
            ++n3;
        }
        Modification.copy(fArray, fArray3, n, n2, n5);
        return n5 + (n2 - n);
    }

    public static int set_symmetric_difference(float[] fArray, float[] fArray2, float[] fArray3, int n, int n2, int n3, int n4, int n5) {
        while (n < n2 && n3 < n4) {
            if (fArray[n] < fArray2[n3]) {
                fArray3[n5++] = fArray[n++];
                continue;
            }
            if (fArray2[n3] < fArray[n]) {
                fArray3[n5++] = fArray2[n3++];
                continue;
            }
            ++n;
            ++n3;
        }
        Modification.copy(fArray, fArray3, n, n2, n5);
        Modification.copy(fArray2, fArray3, n3, n4, n5);
        return n5 + (n2 - n) + (n4 - n3);
    }

    public static int set_symmetric_difference(float[] fArray, float[] fArray2, float[] fArray3, int n, int n2, int n3, int n4, int n5, BinaryPredicate binaryPredicate) {
        while (n < n2 && n3 < n4) {
            if (binaryPredicate.apply(fArray[n], fArray2[n3])) {
                fArray3[n5++] = fArray[n++];
                continue;
            }
            if (binaryPredicate.apply(fArray2[n3], fArray[n])) {
                fArray3[n5++] = fArray2[n3++];
                continue;
            }
            ++n;
            ++n3;
        }
        Modification.copy(fArray, fArray3, n, n2, n5);
        Modification.copy(fArray2, fArray3, n3, n4, n5);
        return n5 + (n2 - n) + (n4 - n3);
    }

    public static void push_heap(float[] fArray, int n, int n2) {
        if (n2 - n < 2) {
            return;
        }
        float f = fArray[--n2];
        int n3 = n + (n2 - n - 1) / 2;
        while (n2 > n && fArray[n3] < f) {
            fArray[n2] = fArray[n3];
            n2 = n3;
            n3 = n + (n2 - n - 1) / 2;
        }
        fArray[n2] = f;
    }

    public static void push_heap(float[] fArray, int n, int n2, BinaryPredicate binaryPredicate) {
        if (n2 - n < 2) {
            return;
        }
        float f = fArray[--n2];
        int n3 = n + (n2 - n - 1) / 2;
        while (n2 > n && binaryPredicate.apply(fArray[n3], f)) {
            fArray[n2] = fArray[n3];
            n2 = n3;
            n3 = n + (n2 - n - 1) / 2;
        }
        fArray[n2] = f;
    }

    private static void adjust_heap(float[] fArray, int n, int n2, int n3) {
        int n4;
        float f = fArray[n2];
        int n5 = n3 - n;
        int n6 = n2 - n;
        for (n4 = 2 * n6 + 2; n4 < n5; n4 *= 2) {
            if (fArray[n + n4] < fArray[n + (n4 - 1)]) {
                --n4;
            }
            fArray[n + n6] = fArray[n + n4];
            n6 = n4++;
        }
        if (n4-- == n5) {
            fArray[n + n6] = fArray[n + n4];
            n6 = n4;
        }
        int n7 = (n6 - 1) / 2;
        int n8 = n2 - n;
        while (n6 != n8 && fArray[n + n7] < f) {
            fArray[n + n6] = fArray[n + n7];
            n6 = n7;
            n7 = (n6 - 1) / 2;
        }
        fArray[n + n6] = f;
    }

    private static void adjust_heap(float[] fArray, int n, int n2, int n3, BinaryPredicate binaryPredicate) {
        int n4;
        float f = fArray[n2];
        int n5 = n3 - n;
        int n6 = n2 - n;
        for (n4 = 2 * n6 + 2; n4 < n5; n4 *= 2) {
            if (binaryPredicate.apply(fArray[n + n4], fArray[n + (n4 - 1)])) {
                --n4;
            }
            fArray[n + n6] = fArray[n + n4];
            n6 = n4++;
        }
        if (n4-- == n5) {
            fArray[n + n6] = fArray[n + n4];
            n6 = n4;
        }
        int n7 = (n6 - 1) / 2;
        int n8 = n2 - n;
        while (n6 != n8 && binaryPredicate.apply(fArray[n + n7], f)) {
            fArray[n + n6] = fArray[n + n7];
            n6 = n7;
            n7 = (n6 - 1) / 2;
        }
        fArray[n + n6] = f;
    }

    public static void pop_heap(float[] fArray, int n, int n2) {
        if (n2 - n < 2) {
            return;
        }
        float f = fArray[--n2];
        fArray[n2] = fArray[n];
        fArray[n] = f;
        Sorting.adjust_heap(fArray, n, n, n2);
    }

    public static void pop_heap(float[] fArray, int n, int n2, BinaryPredicate binaryPredicate) {
        if (n2 - n < 2) {
            return;
        }
        float f = fArray[--n2];
        fArray[n2] = fArray[n];
        fArray[n] = f;
        Sorting.adjust_heap(fArray, n, n, n2, binaryPredicate);
    }

    public static void make_heap(float[] fArray, int n, int n2) {
        if (n2 - n < 2) {
            return;
        }
        int n3 = (n2 - n - 2) / 2;
        do {
            Sorting.adjust_heap(fArray, n, n + n3, n2);
        } while (n3-- != 0);
    }

    public static void make_heap(float[] fArray, int n, int n2, BinaryPredicate binaryPredicate) {
        if (n2 - n < 2) {
            return;
        }
        int n3 = (n2 - n - 2) / 2;
        do {
            Sorting.adjust_heap(fArray, n, n + n3, n2, binaryPredicate);
        } while (n3-- != 0);
    }

    public static void sort_heap(float[] fArray, int n, int n2) {
        while (n2 - n > 1) {
            float f = fArray[--n2];
            fArray[n2] = fArray[n];
            fArray[n] = f;
            Sorting.adjust_heap(fArray, n, n, n2);
        }
    }

    public static void sort_heap(float[] fArray, int n, int n2, BinaryPredicate binaryPredicate) {
        while (n2 - n > 1) {
            float f = fArray[--n2];
            fArray[n2] = fArray[n];
            fArray[n] = f;
            Sorting.adjust_heap(fArray, n, n, n2, binaryPredicate);
        }
    }

    public static int max_element(float[] fArray, int n, int n2) {
        if (n >= n2) {
            return n2;
        }
        int n3 = n;
        while (++n < n2) {
            if (!(fArray[n3] < fArray[n])) continue;
            n3 = n;
        }
        return n3;
    }

    public static int max_element(float[] fArray, int n, int n2, BinaryPredicate binaryPredicate) {
        if (n >= n2) {
            return n2;
        }
        int n3 = n;
        while (++n < n2) {
            if (!binaryPredicate.apply(fArray[n3], fArray[n])) continue;
            n3 = n;
        }
        return n3;
    }

    public static int min_element(float[] fArray, int n, int n2) {
        if (n >= n2) {
            return n2;
        }
        int n3 = n;
        while (++n < n2) {
            if (!(fArray[n] < fArray[n3])) continue;
            n3 = n;
        }
        return n3;
    }

    public static int min_element(float[] fArray, int n, int n2, BinaryPredicate binaryPredicate) {
        if (n >= n2) {
            return n2;
        }
        int n3 = n;
        while (++n < n2) {
            if (!binaryPredicate.apply(fArray[n], fArray[n3])) continue;
            n3 = n;
        }
        return n3;
    }

    public static boolean lexicographical_compare(float[] fArray, float[] fArray2, int n, int n2, int n3, int n4) {
        while (n < n2 && n3 < n4) {
            if (fArray[n] < fArray2[n3]) {
                return true;
            }
            int n5 = n3++;
            int n6 = n++;
            if (!(fArray2[n5] < fArray[n6])) continue;
            return false;
        }
        return n == n2 && n3 != n4;
    }

    public static boolean lexicographical_compare(float[] fArray, float[] fArray2, int n, int n2, int n3, int n4, BinaryPredicate binaryPredicate) {
        while (n < n2 && n3 < n4) {
            if (binaryPredicate.apply(fArray[n], fArray2[n3])) {
                return true;
            }
            if (!binaryPredicate.apply(fArray2[n3++], fArray[n++])) continue;
            return false;
        }
        return n == n2 && n3 != n4;
    }

    public static boolean next_permutation(float[] fArray, int n, int n2) {
        if (n2 - n < 2) {
            return false;
        }
        int n3 = n2 - 1;
        do {
            int n4;
            if (!(fArray[--n3] < fArray[n4])) continue;
            int n5 = n2;
            while (!(fArray[n3] < fArray[--n5])) {
            }
            float f = fArray[n3];
            fArray[n3] = fArray[n5];
            fArray[n5] = f;
            Modification.reverse(fArray, n4, n2);
            return true;
        } while (n3 != n);
        Modification.reverse(fArray, n, n2);
        return false;
    }

    public static boolean next_permutation(float[] fArray, int n, int n2, BinaryPredicate binaryPredicate) {
        if (n2 - n < 2) {
            return false;
        }
        int n3 = n2 - 1;
        do {
            int n4;
            if (!binaryPredicate.apply(fArray[--n3], fArray[n4])) continue;
            int n5 = n2;
            while (!binaryPredicate.apply(fArray[n3], fArray[--n5])) {
            }
            float f = fArray[n3];
            fArray[n3] = fArray[n5];
            fArray[n5] = f;
            Modification.reverse(fArray, n4, n2);
            return true;
        } while (n3 != n);
        Modification.reverse(fArray, n, n2);
        return false;
    }

    public static boolean prev_permutation(float[] fArray, int n, int n2) {
        if (n2 - n < 2) {
            return false;
        }
        int n3 = n2 - 1;
        do {
            int n4;
            if (!(fArray[n4] < fArray[--n3])) continue;
            int n5 = n2;
            while (!(fArray[--n5] < fArray[n3])) {
            }
            float f = fArray[n3];
            fArray[n3] = fArray[n5];
            fArray[n5] = f;
            Modification.reverse(fArray, n4, n2);
            return true;
        } while (n3 != n);
        Modification.reverse(fArray, n, n2);
        return false;
    }

    public static boolean prev_permutation(float[] fArray, int n, int n2, BinaryPredicate binaryPredicate) {
        if (n2 - n < 2) {
            return false;
        }
        int n3 = n2 - 1;
        do {
            int n4;
            if (!binaryPredicate.apply(fArray[n4], fArray[--n3])) continue;
            int n5 = n2;
            while (!binaryPredicate.apply(fArray[--n5], fArray[n3])) {
            }
            float f = fArray[n3];
            fArray[n3] = fArray[n5];
            fArray[n5] = f;
            Modification.reverse(fArray, n4, n2);
            return true;
        } while (n3 != n);
        Modification.reverse(fArray, n, n2);
        return false;
    }

    private Sorting() {
    }
}

