/*
 * Decompiled with CFR 0.152.
 */
package jal.FLOAT;

import jal.FLOAT.BinaryOperator;
import jal.FLOAT.BinaryPredicate;
import jal.FLOAT.Generator;
import jal.FLOAT.Inspection;
import jal.FLOAT.Predicate;
import jal.FLOAT.UnaryOperator;
import java.util.Random;

public final class Modification {
    private static Random default_RNG = new Random();

    public static void copy(float[] fArray, float[] fArray2, int n, int n2, int n3) {
        if (n2 > n) {
            System.arraycopy(fArray, n, fArray2, n3, n2 - n);
        }
    }

    public static void swap_ranges(float[] fArray, float[] fArray2, int n, int n2, int n3) {
        while (n < n2) {
            float f = fArray2[n3];
            fArray2[n3] = fArray[n];
            fArray[n] = f;
            ++n;
            ++n3;
        }
    }

    public static void transform(float[] fArray, float[] fArray2, int n, int n2, int n3, UnaryOperator unaryOperator) {
        while (n < n2) {
            fArray2[n3++] = unaryOperator.apply(fArray[n++]);
        }
    }

    public static void transform(float[] fArray, float[] fArray2, float[] fArray3, int n, int n2, int n3, int n4, BinaryOperator binaryOperator) {
        while (n < n2) {
            fArray3[n4++] = binaryOperator.apply(fArray[n++], fArray2[n3++]);
        }
    }

    public static void replace(float[] fArray, int n, int n2, float f, float f2) {
        while (n < n2) {
            if (fArray[n] == f) {
                fArray[n] = f2;
            }
            ++n;
        }
    }

    public static void replace_if(float[] fArray, int n, int n2, Predicate predicate, float f) {
        while (n < n2) {
            if (predicate.apply(fArray[n])) {
                fArray[n] = f;
            }
            ++n;
        }
    }

    public static void replace_copy(float[] fArray, float[] fArray2, int n, int n2, int n3, float f, float f2) {
        while (n < n2) {
            float f3 = fArray[n++];
            fArray2[n3++] = f3 == f ? f2 : f3;
        }
    }

    public static void replace_copy_if(float[] fArray, float[] fArray2, int n, int n2, int n3, Predicate predicate, float f) {
        while (n < n2) {
            float f2 = fArray[n++];
            fArray2[n3++] = predicate.apply(f2) ? f : f2;
        }
    }

    public static void fill(float[] fArray, int n, int n2, float f) {
        while (n < n2) {
            fArray[n++] = f;
        }
    }

    public static void generate(float[] fArray, int n, int n2, Generator generator) {
        while (n < n2) {
            fArray[n++] = generator.apply();
        }
    }

    public static int remove_if(float[] fArray, int n, int n2, float f) {
        int n3 = n2;
        --n;
        while (true) {
            if (++n < n2 && fArray[n] != f) {
                continue;
            }
            while (n < --n2 && fArray[n2] == f) {
            }
            if (n >= n2) {
                return n;
            }
            fArray[n] = fArray[n2];
        }
    }

    public static int remove_if(float[] fArray, int n, int n2, Predicate predicate) {
        int n3 = n2;
        --n;
        while (true) {
            if (++n < n2 && !predicate.apply(fArray[n])) {
                continue;
            }
            while (n < --n2 && predicate.apply(fArray[n2])) {
            }
            if (n >= n2) {
                return n;
            }
            fArray[n] = fArray[n2];
        }
    }

    public static int stable_remove(float[] fArray, int n, int n2, float f) {
        n = Inspection.find(fArray, n, n2, f);
        int n3 = Inspection.find_not(fArray, n, n2, f);
        while (n3 < n2) {
            fArray[n++] = fArray[n3];
            ++n3;
            n3 = Inspection.find_not(fArray, n3, n2, f);
        }
        return n;
    }

    public static int stable_remove_if(float[] fArray, int n, int n2, Predicate predicate) {
        n = Inspection.find_if(fArray, n, n2, predicate);
        int n3 = Inspection.find_if_not(fArray, n, n2, predicate);
        while (n3 < n2) {
            fArray[n++] = fArray[n3];
            ++n3;
            n3 = Inspection.find_if_not(fArray, n3, n2, predicate);
        }
        return n;
    }

    public static int remove_copy(float[] fArray, float[] fArray2, int n, int n2, int n3, float f) {
        while (n < n2) {
            float f2;
            if ((f2 = fArray[n++]) == f) continue;
            fArray2[n3++] = f2;
        }
        return n3;
    }

    public static int remove_copy_if(float[] fArray, float[] fArray2, int n, int n2, int n3, Predicate predicate) {
        while (n < n2) {
            float f;
            if (predicate.apply(f = fArray[n++])) continue;
            fArray2[n3++] = f;
        }
        return n3;
    }

    public static int unique(float[] fArray, int n, int n2) {
        n = Inspection.adjacent_find(fArray, n, n2);
        return Modification.unique_copy(fArray, fArray, n, n2, n);
    }

    public static int unique(float[] fArray, int n, int n2, BinaryPredicate binaryPredicate) {
        n = Inspection.adjacent_find(fArray, n, n2, binaryPredicate);
        return Modification.unique_copy(fArray, fArray, n, n2, n, binaryPredicate);
    }

    public static int unique_copy(float[] fArray, float[] fArray2, int n, int n2, int n3) {
        if (n >= n2) {
            return n3;
        }
        fArray2[n3] = fArray[n];
        while (++n < n2) {
            if (fArray2[n3] == fArray[n]) continue;
            fArray2[++n3] = fArray[n];
        }
        return n3 + 1;
    }

    public static int unique_copy(float[] fArray, float[] fArray2, int n, int n2, int n3, BinaryPredicate binaryPredicate) {
        if (n >= n2) {
            return n3;
        }
        fArray2[n3] = fArray[n];
        while (++n < n2) {
            if (binaryPredicate.apply(fArray2[n3], fArray[n])) continue;
            fArray2[++n3] = fArray[n];
        }
        return n3 + 1;
    }

    public static void reverse(float[] fArray, int n, int n2) {
        while (n < --n2) {
            float f = fArray[n];
            fArray[n++] = fArray[n2];
            fArray[n2] = f;
        }
    }

    public static void reverse_copy(float[] fArray, int n, int n2, int n3) {
        while (n2 > n) {
            fArray[n3++] = fArray[--n2];
        }
    }

    public static void reverse_copy(float[] fArray, float[] fArray2, int n, int n2, int n3) {
        while (n2 > n) {
            fArray2[n3++] = fArray[--n2];
        }
    }

    public static void rotate(float[] fArray, int n, int n2, int n3) {
        if (n2 != n && n2 != n3) {
            Modification.reverse(fArray, n, n2);
            Modification.reverse(fArray, n2, n3);
            Modification.reverse(fArray, n, n3);
        }
    }

    public static void rotate_copy(float[] fArray, float[] fArray2, int n, int n2, int n3, int n4) {
        Modification.copy(fArray, fArray2, n2, n3, n4);
        Modification.copy(fArray, fArray2, n, n2, n4 + (n3 - n2));
    }

    public static void random_shuffle(float[] fArray, int n, int n2, Random random) {
        for (int i = n + 1; i < n2; ++i) {
            int n3 = Math.abs(random.nextInt()) % (i - n + 1);
            float f = fArray[n3];
            fArray[n3] = fArray[i];
            fArray[i] = f;
        }
    }

    public static void random_shuffle(float[] fArray, int n, int n2) {
        Modification.random_shuffle(fArray, n, n2, default_RNG);
    }

    public static int partition(float[] fArray, int n, int n2, Predicate predicate) {
        --n;
        while (true) {
            if (++n < n2 && predicate.apply(fArray[n])) {
                continue;
            }
            while (n < --n2 && !predicate.apply(fArray[n2])) {
            }
            if (n >= n2) {
                return n;
            }
            float f = fArray[n];
            fArray[n] = fArray[n2];
            fArray[n2] = f;
        }
    }

    public static int stable_partition(float[] fArray, int n, int n2, Predicate predicate) {
        if (n + 1 < n2) {
            int n3 = n + (n2 - n) / 2;
            int n4 = Modification.stable_partition(fArray, n, n3, predicate);
            int n5 = Modification.stable_partition(fArray, n3, n2, predicate);
            Modification.rotate(fArray, n4, n3, n5);
            return n4 + (n5 - n3);
        }
        if (n >= n2 || !predicate.apply(fArray[n])) {
            return n;
        }
        return n2;
    }

    private Modification() {
    }
}

