/*
 * Decompiled with CFR 0.152.
 */
package jal.CHAR;

import jal.CHAR.BinaryPredicate;
import jal.CHAR.Modification;
import jal.CHAR.Range;

public final class Sorting {
    private static final int partitionCutoff = 13;
    private static final int qsort_stacksize = 56;
    private static final int stableSortCutoff = 9;

    public static void sort(char[] cArray, int n, int n2) {
        if (n2 - n >= 13) {
            Sorting.qsortLoop(cArray, n, n2);
        }
        Sorting.insertion_sort(cArray, n, n2);
    }

    public static void sort(char[] cArray, int n, int n2, BinaryPredicate binaryPredicate) {
        if (n2 - n >= 13) {
            Sorting.qsortLoop(cArray, n, n2, binaryPredicate);
        }
        Sorting.insertion_sort(cArray, n, n2, binaryPredicate);
    }

    public static void insertion_sort(char[] cArray, int n, int n2) {
        int n3 = n;
        while (++n3 < n2) {
            char c = cArray[n3];
            int n4 = n3;
            char c2 = cArray[n4 - 1];
            while (c < c2) {
                cArray[n4] = c2;
                if (n == n4 - 1) {
                    --n4;
                    break;
                }
                c2 = cArray[--n4 - 1];
            }
            cArray[n4] = c;
        }
    }

    public static void insertion_sort(char[] cArray, int n, int n2, BinaryPredicate binaryPredicate) {
        int n3 = n;
        while (++n3 < n2) {
            char c = cArray[n3];
            int n4 = n3;
            char c2 = cArray[n4 - 1];
            while (binaryPredicate.apply(c, c2)) {
                cArray[n4] = c2;
                if (n == n4 - 1) {
                    --n4;
                    break;
                }
                c2 = cArray[--n4 - 1];
            }
            cArray[n4] = c;
        }
    }

    private static int quickPartition(char[] cArray, int n, int n2) {
        char c = cArray[n];
        char c2 = cArray[n2 - 1];
        char c3 = cArray[n + (n2 - n) / 2];
        if (c3 < c) {
            if (c < c2) {
                c3 = c;
            } else if (c3 < c2) {
                c3 = c2;
            }
        } else if (c2 < c) {
            c3 = c;
        } else if (c2 < c3) {
            c3 = c2;
        }
        --n;
        while (true) {
            if (cArray[++n] < c3) {
                continue;
            }
            while (c3 < cArray[--n2]) {
            }
            if (n >= n2) {
                return n;
            }
            char c4 = cArray[n];
            cArray[n] = cArray[n2];
            cArray[n2] = c4;
        }
    }

    private static int quickPartition(char[] cArray, int n, int n2, BinaryPredicate binaryPredicate) {
        char c = cArray[n];
        char c2 = cArray[n2 - 1];
        char c3 = cArray[n + (n2 - n) / 2];
        if (binaryPredicate.apply(c3, c)) {
            if (binaryPredicate.apply(c, c2)) {
                c3 = c;
            } else if (binaryPredicate.apply(c3, c2)) {
                c3 = c2;
            }
        } else if (binaryPredicate.apply(c2, c)) {
            c3 = c;
        } else if (binaryPredicate.apply(c2, c3)) {
            c3 = c2;
        }
        --n;
        while (true) {
            if (binaryPredicate.apply(cArray[++n], c3)) {
                continue;
            }
            while (binaryPredicate.apply(c3, cArray[--n2])) {
            }
            if (n >= n2) {
                return n;
            }
            char c4 = cArray[n];
            cArray[n] = cArray[n2];
            cArray[n2] = c4;
        }
    }

    private static void qsortLoop(char[] cArray, int n, int n2) {
        int[] nArray = new int[56];
        int n3 = 0;
        while (true) {
            int n4;
            if (n2 - (n4 = Sorting.quickPartition(cArray, n, n2)) < 13) {
                if (n4 - n < 13) {
                    if (n3 == 0) {
                        return;
                    }
                    n2 = nArray[--n3];
                    n = nArray[--n3];
                    continue;
                }
                n2 = n4;
                continue;
            }
            if (n4 - n < 13) {
                n = n4;
                continue;
            }
            if (n2 - n4 > n4 - n) {
                nArray[n3++] = n4;
                nArray[n3++] = n2;
                n2 = n4;
                continue;
            }
            nArray[n3++] = n;
            nArray[n3++] = n4;
            n = n4;
        }
    }

    private static void qsortLoop(char[] cArray, int n, int n2, BinaryPredicate binaryPredicate) {
        int[] nArray = new int[56];
        int n3 = 0;
        while (true) {
            int n4;
            if (n2 - (n4 = Sorting.quickPartition(cArray, n, n2, binaryPredicate)) < 13) {
                if (n4 - n < 13) {
                    if (n3 == 0) {
                        return;
                    }
                    n2 = nArray[--n3];
                    n = nArray[--n3];
                    continue;
                }
                n2 = n4;
                continue;
            }
            if (n4 - n < 13) {
                n = n4;
                continue;
            }
            if (n2 - n4 > n4 - n) {
                nArray[n3++] = n4;
                nArray[n3++] = n2;
                n2 = n4;
                continue;
            }
            nArray[n3++] = n;
            nArray[n3++] = n4;
            n = n4;
        }
    }

    public static void stable_sort(char[] cArray, int n, int n2) {
        if (n2 - n < 9) {
            Sorting.insertion_sort(cArray, n, n2);
        } else {
            int n3 = n + (n2 - n) / 2;
            Sorting.stable_sort(cArray, n, n3);
            Sorting.stable_sort(cArray, n3, n2);
            Sorting.inplace_merge(cArray, n, n3, n2);
        }
    }

    public static void stable_sort(char[] cArray, int n, int n2, BinaryPredicate binaryPredicate) {
        if (n2 - n < 9) {
            Sorting.insertion_sort(cArray, n, n2, binaryPredicate);
        } else {
            int n3 = n + (n2 - n) / 2;
            Sorting.stable_sort(cArray, n, n3, binaryPredicate);
            Sorting.stable_sort(cArray, n3, n2, binaryPredicate);
            Sorting.inplace_merge(cArray, n, n3, n2, binaryPredicate);
        }
    }

    public static void partial_sort(char[] cArray, int n, int n2, int n3) {
        Sorting.make_heap(cArray, n, n2);
        for (int i = n2; i < n3; ++i) {
            if (cArray[i] >= cArray[n]) continue;
            char c = cArray[i];
            cArray[i] = cArray[n];
            cArray[n] = c;
            Sorting.adjust_heap(cArray, n, n, n2);
        }
        Sorting.sort_heap(cArray, n, n2);
    }

    public static void partial_sort(char[] cArray, int n, int n2, int n3, BinaryPredicate binaryPredicate) {
        Sorting.make_heap(cArray, n, n2, binaryPredicate);
        for (int i = n2; i < n3; ++i) {
            if (!binaryPredicate.apply(cArray[i], cArray[n])) continue;
            char c = cArray[i];
            cArray[i] = cArray[n];
            cArray[n] = c;
            Sorting.adjust_heap(cArray, n, n, n2, binaryPredicate);
        }
        Sorting.sort_heap(cArray, n, n2, binaryPredicate);
    }

    public static int partial_sort_copy(char[] cArray, char[] cArray2, int n, int n2, int n3, int n4) {
        if (n3 == n4) {
            return n4;
        }
        int n5 = Math.min(n2 - n, n4 - n3);
        Modification.copy(cArray, cArray2, n, n + n5, n3);
        n4 = n3 + n5;
        Sorting.make_heap(cArray2, n3, n4);
        n += n5;
        while (n < n2) {
            if (cArray[n] < cArray2[n3]) {
                cArray2[n3] = cArray[n];
                Sorting.adjust_heap(cArray2, n3, n3, n4);
            }
            ++n;
        }
        Sorting.sort_heap(cArray2, n3, n4);
        return n4;
    }

    public static int partial_sort_copy(char[] cArray, char[] cArray2, int n, int n2, int n3, int n4, BinaryPredicate binaryPredicate) {
        if (n3 == n4) {
            return n4;
        }
        int n5 = Math.min(n2 - n, n4 - n3);
        Modification.copy(cArray, cArray2, n, n + n5, n3);
        n4 = n3 + n5;
        Sorting.make_heap(cArray2, n3, n4, binaryPredicate);
        n += n5;
        while (n < n2) {
            if (binaryPredicate.apply(cArray[n], cArray2[n3])) {
                cArray2[n3] = cArray[n];
                Sorting.adjust_heap(cArray2, n3, n3, n4, binaryPredicate);
            }
            ++n;
        }
        Sorting.sort_heap(cArray2, n3, n4, binaryPredicate);
        return n4;
    }

    public static void nth_element(char[] cArray, int n, int n2, int n3) {
        while (n3 - n > 3) {
            int n4 = Sorting.quickPartition(cArray, n, n3);
            if (n4 <= n2) {
                n = n4;
                continue;
            }
            n3 = n4;
        }
        Sorting.insertion_sort(cArray, n, n3);
    }

    public static void nth_element(char[] cArray, int n, int n2, int n3, BinaryPredicate binaryPredicate) {
        while (n3 - n > 3) {
            int n4 = Sorting.quickPartition(cArray, n, n3, binaryPredicate);
            if (n4 <= n2) {
                n = n4;
                continue;
            }
            n3 = n4;
        }
        Sorting.insertion_sort(cArray, n, n3, binaryPredicate);
    }

    public static int lower_bound(char[] cArray, int n, int n2, char c) {
        int n3 = n2 - n;
        while (n3 > 0) {
            int n4 = n3 / 2;
            int n5 = n + n4;
            if (cArray[n5] < c) {
                n = n5 + 1;
                n3 -= n4 + 1;
                continue;
            }
            n3 = n4;
        }
        return n;
    }

    public static int lower_bound(char[] cArray, int n, int n2, char c, BinaryPredicate binaryPredicate) {
        int n3 = n2 - n;
        while (n3 > 0) {
            int n4 = n3 / 2;
            int n5 = n + n4;
            if (binaryPredicate.apply(cArray[n5], c)) {
                n = n5 + 1;
                n3 -= n4 + 1;
                continue;
            }
            n3 = n4;
        }
        return n;
    }

    public static int upper_bound(char[] cArray, int n, int n2, char c) {
        int n3 = n2 - n;
        while (n3 > 0) {
            int n4 = n3 / 2;
            int n5 = n + n4;
            if (c < cArray[n5]) {
                n3 = n4;
                continue;
            }
            n = n5 + 1;
            n3 -= n4 + 1;
        }
        return n;
    }

    public static int upper_bound(char[] cArray, int n, int n2, char c, BinaryPredicate binaryPredicate) {
        int n3 = n2 - n;
        while (n3 > 0) {
            int n4 = n3 / 2;
            int n5 = n + n4;
            if (binaryPredicate.apply(c, cArray[n5])) {
                n3 = n4;
                continue;
            }
            n = n5 + 1;
            n3 -= n4 + 1;
        }
        return n;
    }

    public static Range equal_range(char[] cArray, int n, int n2, char c) {
        int n3 = n2 - n;
        while (n3 > 0) {
            int n4 = n3 / 2;
            int n5 = n + n4;
            if (cArray[n5] < c) {
                n = n5 + 1;
                n3 = n3 - n4 + 1;
                continue;
            }
            if (c < cArray[n5]) {
                n3 = n4;
                continue;
            }
            int n6 = Sorting.lower_bound(cArray, n, n5, c);
            int n7 = Sorting.upper_bound(cArray, n5 + 1, n + n3, c);
            return new Range(cArray, n6, n7);
        }
        return new Range(cArray, n, n);
    }

    public static Range equal_range(char[] cArray, int n, int n2, char c, BinaryPredicate binaryPredicate) {
        int n3 = n2 - n;
        while (n3 > 0) {
            int n4 = n3 / 2;
            int n5 = n + n4;
            if (binaryPredicate.apply(cArray[n5], c)) {
                n = n5 + 1;
                n3 = n3 - n4 + 1;
                continue;
            }
            if (binaryPredicate.apply(c, cArray[n5])) {
                n3 = n4;
                continue;
            }
            int n6 = Sorting.lower_bound(cArray, n, n5, c, binaryPredicate);
            int n7 = Sorting.upper_bound(cArray, n5 + 1, n + n3, c, binaryPredicate);
            return new Range(cArray, n6, n7);
        }
        return new Range(cArray, n, n);
    }

    public static boolean binary_search(char[] cArray, int n, int n2, char c) {
        int n3 = Sorting.lower_bound(cArray, n, n2, c);
        return n3 < n2 && c >= cArray[n3];
    }

    public static boolean binary_search(char[] cArray, int n, int n2, char c, BinaryPredicate binaryPredicate) {
        int n3 = Sorting.lower_bound(cArray, n, n2, c, binaryPredicate);
        return n3 < n2 && !binaryPredicate.apply(c, cArray[n3]);
    }

    public static int merge(char[] cArray, char[] cArray2, char[] cArray3, int n, int n2, int n3, int n4, int n5) {
        while (n < n2 && n3 < n4) {
            if (cArray2[n3] < cArray[n]) {
                cArray3[n5++] = cArray2[n3++];
                continue;
            }
            cArray3[n5++] = cArray[n++];
        }
        Modification.copy(cArray, cArray3, n, n2, n5);
        Modification.copy(cArray2, cArray3, n3, n4, n5);
        return n5 + (n2 - n) + (n4 - n3);
    }

    public static int merge(char[] cArray, char[] cArray2, char[] cArray3, int n, int n2, int n3, int n4, int n5, BinaryPredicate binaryPredicate) {
        while (n < n2 && n3 < n4) {
            if (binaryPredicate.apply(cArray2[n3], cArray[n])) {
                cArray3[n5++] = cArray2[n3++];
                continue;
            }
            cArray3[n5++] = cArray[n++];
        }
        Modification.copy(cArray, cArray3, n, n2, n5);
        Modification.copy(cArray2, cArray3, n3, n4, n5);
        return n5 + (n2 - n) + (n4 - n3);
    }

    public static void inplace_merge(char[] cArray, int n, int n2, int n3) {
        int n4;
        int n5;
        if (n >= n2 || n2 >= n3) {
            return;
        }
        if (n3 - n == 2) {
            if (cArray[n2] < cArray[n]) {
                char c = cArray[n];
                cArray[n] = cArray[n2];
                cArray[n2] = c;
            }
            return;
        }
        if (n2 - n > n3 - n2) {
            n5 = n + (n2 - n) / 2;
            n4 = Sorting.lower_bound(cArray, n2, n3, cArray[n5]);
        } else {
            n4 = n2 + (n3 - n2) / 2;
            n5 = Sorting.upper_bound(cArray, n, n2, cArray[n4]);
        }
        Modification.rotate(cArray, n5, n2, n4);
        n2 = n5 + (n4 - n2);
        Sorting.inplace_merge(cArray, n, n5, n2);
        Sorting.inplace_merge(cArray, n2, n4, n3);
    }

    public static void inplace_merge(char[] cArray, int n, int n2, int n3, BinaryPredicate binaryPredicate) {
        int n4;
        int n5;
        if (n >= n2 || n2 >= n3) {
            return;
        }
        if (n3 - n == 2) {
            if (binaryPredicate.apply(cArray[n2], cArray[n])) {
                char c = cArray[n];
                cArray[n] = cArray[n2];
                cArray[n2] = c;
            }
            return;
        }
        if (n2 - n > n3 - n2) {
            n5 = n + (n2 - n) / 2;
            n4 = Sorting.lower_bound(cArray, n2, n3, cArray[n5], binaryPredicate);
        } else {
            n4 = n2 + (n3 - n2) / 2;
            n5 = Sorting.upper_bound(cArray, n, n2, cArray[n4], binaryPredicate);
        }
        Modification.rotate(cArray, n5, n2, n4);
        n2 = n5 + (n4 - n2);
        Sorting.inplace_merge(cArray, n, n5, n2, binaryPredicate);
        Sorting.inplace_merge(cArray, n2, n4, n3, binaryPredicate);
    }

    public static boolean includes(char[] cArray, char[] cArray2, int n, int n2, int n3, int n4) {
        while (n < n2 && n3 < n4) {
            if (cArray2[n3] < cArray[n]) {
                return false;
            }
            if (cArray[n] < cArray2[n3]) {
                ++n;
                continue;
            }
            ++n;
            ++n3;
        }
        return n3 == n4;
    }

    public static boolean includes(char[] cArray, char[] cArray2, int n, int n2, int n3, int n4, BinaryPredicate binaryPredicate) {
        while (n < n2 && n3 < n4) {
            if (binaryPredicate.apply(cArray2[n3], cArray[n])) {
                return false;
            }
            if (binaryPredicate.apply(cArray[n], cArray2[n3])) {
                ++n;
                continue;
            }
            ++n;
            ++n3;
        }
        return n3 == n4;
    }

    public static int set_union(char[] cArray, char[] cArray2, char[] cArray3, int n, int n2, int n3, int n4, int n5) {
        while (n < n2 && n3 < n4) {
            if (cArray[n] < cArray2[n3]) {
                cArray3[n5++] = cArray[n++];
                continue;
            }
            if (cArray2[n3] < cArray[n]) {
                cArray3[n5++] = cArray2[n3++];
                continue;
            }
            cArray3[n5++] = cArray[n++];
            ++n3;
        }
        Modification.copy(cArray, cArray3, n, n2, n5);
        Modification.copy(cArray2, cArray3, n3, n4, n5);
        return n5 + (n2 - n) + (n4 - n3);
    }

    public static int set_union(char[] cArray, char[] cArray2, char[] cArray3, int n, int n2, int n3, int n4, int n5, BinaryPredicate binaryPredicate) {
        while (n < n2 && n3 < n4) {
            if (binaryPredicate.apply(cArray[n], cArray2[n3])) {
                cArray3[n5++] = cArray[n++];
                continue;
            }
            if (binaryPredicate.apply(cArray2[n3], cArray[n])) {
                cArray3[n5++] = cArray2[n3++];
                continue;
            }
            cArray3[n5++] = cArray[n++];
            ++n3;
        }
        Modification.copy(cArray, cArray3, n, n2, n5);
        Modification.copy(cArray2, cArray3, n3, n4, n5);
        return n5 + (n2 - n) + (n4 - n3);
    }

    public static int set_intersection(char[] cArray, char[] cArray2, char[] cArray3, int n, int n2, int n3, int n4, int n5) {
        while (n < n2 && n3 < n4) {
            if (cArray[n] < cArray2[n3]) {
                ++n;
                continue;
            }
            if (cArray2[n3] < cArray[n]) {
                ++n3;
                continue;
            }
            cArray3[n5++] = cArray[n++];
            ++n3;
        }
        return n5;
    }

    public static int set_intersection(char[] cArray, char[] cArray2, char[] cArray3, int n, int n2, int n3, int n4, int n5, BinaryPredicate binaryPredicate) {
        while (n < n2 && n3 < n4) {
            if (binaryPredicate.apply(cArray[n], cArray2[n3])) {
                ++n;
                continue;
            }
            if (binaryPredicate.apply(cArray2[n3], cArray[n])) {
                ++n3;
                continue;
            }
            cArray3[n5++] = cArray[n++];
            ++n3;
        }
        return n5;
    }

    public static int set_difference(char[] cArray, char[] cArray2, char[] cArray3, int n, int n2, int n3, int n4, int n5) {
        while (n < n2 && n3 < n4) {
            if (cArray[n] < cArray2[n3]) {
                cArray3[n5++] = cArray[n++];
                continue;
            }
            if (cArray2[n3] < cArray[n]) {
                ++n3;
                continue;
            }
            ++n;
            ++n3;
        }
        Modification.copy(cArray, cArray3, n, n2, n5);
        return n5 + (n2 - n);
    }

    public static int set_difference(char[] cArray, char[] cArray2, char[] cArray3, int n, int n2, int n3, int n4, int n5, BinaryPredicate binaryPredicate) {
        while (n < n2 && n3 < n4) {
            if (binaryPredicate.apply(cArray[n], cArray2[n3])) {
                cArray3[n5++] = cArray[n++];
                continue;
            }
            if (binaryPredicate.apply(cArray2[n3], cArray[n])) {
                ++n3;
                continue;
            }
            ++n;
            ++n3;
        }
        Modification.copy(cArray, cArray3, n, n2, n5);
        return n5 + (n2 - n);
    }

    public static int set_symmetric_difference(char[] cArray, char[] cArray2, char[] cArray3, int n, int n2, int n3, int n4, int n5) {
        while (n < n2 && n3 < n4) {
            if (cArray[n] < cArray2[n3]) {
                cArray3[n5++] = cArray[n++];
                continue;
            }
            if (cArray2[n3] < cArray[n]) {
                cArray3[n5++] = cArray2[n3++];
                continue;
            }
            ++n;
            ++n3;
        }
        Modification.copy(cArray, cArray3, n, n2, n5);
        Modification.copy(cArray2, cArray3, n3, n4, n5);
        return n5 + (n2 - n) + (n4 - n3);
    }

    public static int set_symmetric_difference(char[] cArray, char[] cArray2, char[] cArray3, int n, int n2, int n3, int n4, int n5, BinaryPredicate binaryPredicate) {
        while (n < n2 && n3 < n4) {
            if (binaryPredicate.apply(cArray[n], cArray2[n3])) {
                cArray3[n5++] = cArray[n++];
                continue;
            }
            if (binaryPredicate.apply(cArray2[n3], cArray[n])) {
                cArray3[n5++] = cArray2[n3++];
                continue;
            }
            ++n;
            ++n3;
        }
        Modification.copy(cArray, cArray3, n, n2, n5);
        Modification.copy(cArray2, cArray3, n3, n4, n5);
        return n5 + (n2 - n) + (n4 - n3);
    }

    public static void push_heap(char[] cArray, int n, int n2) {
        if (n2 - n < 2) {
            return;
        }
        char c = cArray[--n2];
        int n3 = n + (n2 - n - 1) / 2;
        while (n2 > n && cArray[n3] < c) {
            cArray[n2] = cArray[n3];
            n2 = n3;
            n3 = n + (n2 - n - 1) / 2;
        }
        cArray[n2] = c;
    }

    public static void push_heap(char[] cArray, int n, int n2, BinaryPredicate binaryPredicate) {
        if (n2 - n < 2) {
            return;
        }
        char c = cArray[--n2];
        int n3 = n + (n2 - n - 1) / 2;
        while (n2 > n && binaryPredicate.apply(cArray[n3], c)) {
            cArray[n2] = cArray[n3];
            n2 = n3;
            n3 = n + (n2 - n - 1) / 2;
        }
        cArray[n2] = c;
    }

    private static void adjust_heap(char[] cArray, int n, int n2, int n3) {
        int n4;
        char c = cArray[n2];
        int n5 = n3 - n;
        int n6 = n2 - n;
        for (n4 = 2 * n6 + 2; n4 < n5; n4 *= 2) {
            if (cArray[n + n4] < cArray[n + (n4 - 1)]) {
                --n4;
            }
            cArray[n + n6] = cArray[n + n4];
            n6 = n4++;
        }
        if (n4-- == n5) {
            cArray[n + n6] = cArray[n + n4];
            n6 = n4;
        }
        int n7 = (n6 - 1) / 2;
        int n8 = n2 - n;
        while (n6 != n8 && cArray[n + n7] < c) {
            cArray[n + n6] = cArray[n + n7];
            n6 = n7;
            n7 = (n6 - 1) / 2;
        }
        cArray[n + n6] = c;
    }

    private static void adjust_heap(char[] cArray, int n, int n2, int n3, BinaryPredicate binaryPredicate) {
        int n4;
        char c = cArray[n2];
        int n5 = n3 - n;
        int n6 = n2 - n;
        for (n4 = 2 * n6 + 2; n4 < n5; n4 *= 2) {
            if (binaryPredicate.apply(cArray[n + n4], cArray[n + (n4 - 1)])) {
                --n4;
            }
            cArray[n + n6] = cArray[n + n4];
            n6 = n4++;
        }
        if (n4-- == n5) {
            cArray[n + n6] = cArray[n + n4];
            n6 = n4;
        }
        int n7 = (n6 - 1) / 2;
        int n8 = n2 - n;
        while (n6 != n8 && binaryPredicate.apply(cArray[n + n7], c)) {
            cArray[n + n6] = cArray[n + n7];
            n6 = n7;
            n7 = (n6 - 1) / 2;
        }
        cArray[n + n6] = c;
    }

    public static void pop_heap(char[] cArray, int n, int n2) {
        if (n2 - n < 2) {
            return;
        }
        char c = cArray[--n2];
        cArray[n2] = cArray[n];
        cArray[n] = c;
        Sorting.adjust_heap(cArray, n, n, n2);
    }

    public static void pop_heap(char[] cArray, int n, int n2, BinaryPredicate binaryPredicate) {
        if (n2 - n < 2) {
            return;
        }
        char c = cArray[--n2];
        cArray[n2] = cArray[n];
        cArray[n] = c;
        Sorting.adjust_heap(cArray, n, n, n2, binaryPredicate);
    }

    public static void make_heap(char[] cArray, int n, int n2) {
        if (n2 - n < 2) {
            return;
        }
        int n3 = (n2 - n - 2) / 2;
        do {
            Sorting.adjust_heap(cArray, n, n + n3, n2);
        } while (n3-- != 0);
    }

    public static void make_heap(char[] cArray, int n, int n2, BinaryPredicate binaryPredicate) {
        if (n2 - n < 2) {
            return;
        }
        int n3 = (n2 - n - 2) / 2;
        do {
            Sorting.adjust_heap(cArray, n, n + n3, n2, binaryPredicate);
        } while (n3-- != 0);
    }

    public static void sort_heap(char[] cArray, int n, int n2) {
        while (n2 - n > 1) {
            char c = cArray[--n2];
            cArray[n2] = cArray[n];
            cArray[n] = c;
            Sorting.adjust_heap(cArray, n, n, n2);
        }
    }

    public static void sort_heap(char[] cArray, int n, int n2, BinaryPredicate binaryPredicate) {
        while (n2 - n > 1) {
            char c = cArray[--n2];
            cArray[n2] = cArray[n];
            cArray[n] = c;
            Sorting.adjust_heap(cArray, n, n, n2, binaryPredicate);
        }
    }

    public static int max_element(char[] cArray, int n, int n2) {
        if (n >= n2) {
            return n2;
        }
        int n3 = n;
        while (++n < n2) {
            if (cArray[n3] >= cArray[n]) continue;
            n3 = n;
        }
        return n3;
    }

    public static int max_element(char[] cArray, int n, int n2, BinaryPredicate binaryPredicate) {
        if (n >= n2) {
            return n2;
        }
        int n3 = n;
        while (++n < n2) {
            if (!binaryPredicate.apply(cArray[n3], cArray[n])) continue;
            n3 = n;
        }
        return n3;
    }

    public static int min_element(char[] cArray, int n, int n2) {
        if (n >= n2) {
            return n2;
        }
        int n3 = n;
        while (++n < n2) {
            if (cArray[n] >= cArray[n3]) continue;
            n3 = n;
        }
        return n3;
    }

    public static int min_element(char[] cArray, int n, int n2, BinaryPredicate binaryPredicate) {
        if (n >= n2) {
            return n2;
        }
        int n3 = n;
        while (++n < n2) {
            if (!binaryPredicate.apply(cArray[n], cArray[n3])) continue;
            n3 = n;
        }
        return n3;
    }

    public static boolean lexicographical_compare(char[] cArray, char[] cArray2, int n, int n2, int n3, int n4) {
        while (n < n2 && n3 < n4) {
            if (cArray[n] < cArray2[n3]) {
                return true;
            }
            if (cArray2[n3++] >= cArray[n++]) continue;
            return false;
        }
        return n == n2 && n3 != n4;
    }

    public static boolean lexicographical_compare(char[] cArray, char[] cArray2, int n, int n2, int n3, int n4, BinaryPredicate binaryPredicate) {
        while (n < n2 && n3 < n4) {
            if (binaryPredicate.apply(cArray[n], cArray2[n3])) {
                return true;
            }
            if (!binaryPredicate.apply(cArray2[n3++], cArray[n++])) continue;
            return false;
        }
        return n == n2 && n3 != n4;
    }

    public static boolean next_permutation(char[] cArray, int n, int n2) {
        if (n2 - n < 2) {
            return false;
        }
        int n3 = n2 - 1;
        do {
            int n4;
            if (cArray[--n3] >= cArray[n4]) continue;
            int n5 = n2;
            while (cArray[n3] >= cArray[--n5]) {
            }
            char c = cArray[n3];
            cArray[n3] = cArray[n5];
            cArray[n5] = c;
            Modification.reverse(cArray, n4, n2);
            return true;
        } while (n3 != n);
        Modification.reverse(cArray, n, n2);
        return false;
    }

    public static boolean next_permutation(char[] cArray, int n, int n2, BinaryPredicate binaryPredicate) {
        if (n2 - n < 2) {
            return false;
        }
        int n3 = n2 - 1;
        do {
            int n4;
            if (!binaryPredicate.apply(cArray[--n3], cArray[n4])) continue;
            int n5 = n2;
            while (!binaryPredicate.apply(cArray[n3], cArray[--n5])) {
            }
            char c = cArray[n3];
            cArray[n3] = cArray[n5];
            cArray[n5] = c;
            Modification.reverse(cArray, n4, n2);
            return true;
        } while (n3 != n);
        Modification.reverse(cArray, n, n2);
        return false;
    }

    public static boolean prev_permutation(char[] cArray, int n, int n2) {
        if (n2 - n < 2) {
            return false;
        }
        int n3 = n2 - 1;
        do {
            int n4;
            if (cArray[n4] >= cArray[--n3]) continue;
            int n5 = n2;
            while (cArray[--n5] >= cArray[n3]) {
            }
            char c = cArray[n3];
            cArray[n3] = cArray[n5];
            cArray[n5] = c;
            Modification.reverse(cArray, n4, n2);
            return true;
        } while (n3 != n);
        Modification.reverse(cArray, n, n2);
        return false;
    }

    public static boolean prev_permutation(char[] cArray, int n, int n2, BinaryPredicate binaryPredicate) {
        if (n2 - n < 2) {
            return false;
        }
        int n3 = n2 - 1;
        do {
            int n4;
            if (!binaryPredicate.apply(cArray[n4], cArray[--n3])) continue;
            int n5 = n2;
            while (!binaryPredicate.apply(cArray[--n5], cArray[n3])) {
            }
            char c = cArray[n3];
            cArray[n3] = cArray[n5];
            cArray[n5] = c;
            Modification.reverse(cArray, n4, n2);
            return true;
        } while (n3 != n);
        Modification.reverse(cArray, n, n2);
        return false;
    }

    private Sorting() {
    }
}

