/*
 * Decompiled with CFR 0.152.
 */
package edu.oswego.cs.dl.util.concurrent.misc;

import edu.oswego.cs.dl.util.concurrent.BrokenBarrierException;
import edu.oswego.cs.dl.util.concurrent.Channel;
import edu.oswego.cs.dl.util.concurrent.ClockDaemon;
import edu.oswego.cs.dl.util.concurrent.CyclicBarrier;
import edu.oswego.cs.dl.util.concurrent.DefaultChannelCapacity;
import edu.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import edu.oswego.cs.dl.util.concurrent.SynchronizedInt;
import edu.oswego.cs.dl.util.concurrent.SynchronizedRef;
import edu.oswego.cs.dl.util.concurrent.WaitableInt;
import edu.oswego.cs.dl.util.concurrent.misc.ChanRNG;
import edu.oswego.cs.dl.util.concurrent.misc.DelegatedRNG;
import edu.oswego.cs.dl.util.concurrent.misc.Fraction;
import edu.oswego.cs.dl.util.concurrent.misc.PCTestLoop;
import edu.oswego.cs.dl.util.concurrent.misc.RNG;
import edu.oswego.cs.dl.util.concurrent.misc.TestLoop;
import edu.oswego.cs.dl.util.concurrent.misc.Threads;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.InvocationTargetException;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;

public class SynchronizationTimer {
    static final int[] nthreadsChoices = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024};
    static final int BLOCK_MODE = 0;
    static final int TIMEOUT_MODE = 1;
    static final int[] syncModes = new int[]{0, 1};
    static final int PRECISION = 10;
    final ThreadInfo[] threadInfo = new ThreadInfo[nthreadsChoices.length];
    static final int headerRows = 1;
    static final int classColumn = 0;
    static final int headerColumns = 1;
    final int tableRows = TestedClass.classes.length + 1;
    final int tableColumns = nthreadsChoices.length + 1;
    final JComponent[][] resultTable_ = new JComponent[this.tableRows][this.tableColumns];
    final SynchronizedInt nextClassIdx_ = new SynchronizedInt(0);
    final SynchronizedInt nextThreadIdx_ = new SynchronizedInt(0);
    ClockDaemon timeDaemon = new ClockDaemon();
    private final SynchronizedRef contention_ = new SynchronizedRef(null);
    private final SynchronizedInt loopsPerTest_ = new SynchronizedInt(0);
    private final SynchronizedBoolean echoToSystemOut = new SynchronizedBoolean(false);
    private final JButton startstop_ = new JButton("Start");
    private WaitableInt testNumber_ = new WaitableInt(1);
    private SynchronizedBoolean running_ = new SynchronizedBoolean(false);
    static /* synthetic */ Class class$edu$oswego$cs$dl$util$concurrent$misc$NoSynchRNG;
    static /* synthetic */ Class class$edu$oswego$cs$dl$util$concurrent$misc$PublicSynchRNG;
    static /* synthetic */ Class class$edu$oswego$cs$dl$util$concurrent$misc$AllSynchRNG;
    static /* synthetic */ Class class$edu$oswego$cs$dl$util$concurrent$misc$SDelegatedRNG;
    static /* synthetic */ Class class$edu$oswego$cs$dl$util$concurrent$misc$SynchLongRNG;
    static /* synthetic */ Class class$edu$oswego$cs$dl$util$concurrent$misc$AClongRNG;
    static /* synthetic */ Class class$edu$oswego$cs$dl$util$concurrent$misc$SemRNG;
    static /* synthetic */ Class class$edu$oswego$cs$dl$util$concurrent$misc$WpSemRNG;
    static /* synthetic */ Class class$edu$oswego$cs$dl$util$concurrent$misc$FifoRNG;
    static /* synthetic */ Class class$edu$oswego$cs$dl$util$concurrent$misc$PrioritySemRNG;
    static /* synthetic */ Class class$edu$oswego$cs$dl$util$concurrent$misc$MutexRNG;
    static /* synthetic */ Class class$edu$oswego$cs$dl$util$concurrent$misc$RlockRNG;
    static /* synthetic */ Class class$edu$oswego$cs$dl$util$concurrent$misc$WpRWlockRNG;
    static /* synthetic */ Class class$edu$oswego$cs$dl$util$concurrent$misc$ReaderPrefRWlockRNG;
    static /* synthetic */ Class class$edu$oswego$cs$dl$util$concurrent$misc$FIFORWlockRNG;
    static /* synthetic */ Class class$edu$oswego$cs$dl$util$concurrent$misc$ReentrantRWlockRNG;
    static /* synthetic */ Class class$edu$oswego$cs$dl$util$concurrent$misc$ChanRNG;
    static /* synthetic */ Class class$edu$oswego$cs$dl$util$concurrent$LinkedQueue;
    static /* synthetic */ Class class$edu$oswego$cs$dl$util$concurrent$WaitFreeQueue;
    static /* synthetic */ Class class$edu$oswego$cs$dl$util$concurrent$BoundedLinkedQueue;
    static /* synthetic */ Class class$edu$oswego$cs$dl$util$concurrent$BoundedBuffer;
    static /* synthetic */ Class class$edu$oswego$cs$dl$util$concurrent$misc$CVBuffer;
    static /* synthetic */ Class class$edu$oswego$cs$dl$util$concurrent$BoundedPriorityQueue;
    static /* synthetic */ Class class$edu$oswego$cs$dl$util$concurrent$Slot;
    static /* synthetic */ Class class$edu$oswego$cs$dl$util$concurrent$SynchronousChannel;
    static /* synthetic */ Class class$edu$oswego$cs$dl$util$concurrent$misc$DirectExecutorRNG;
    static /* synthetic */ Class class$edu$oswego$cs$dl$util$concurrent$misc$LockedSemRNG;
    static /* synthetic */ Class class$edu$oswego$cs$dl$util$concurrent$misc$QueuedExecutorRNG;
    static /* synthetic */ Class class$edu$oswego$cs$dl$util$concurrent$misc$ThreadedExecutorRNG;
    static /* synthetic */ Class class$edu$oswego$cs$dl$util$concurrent$misc$PooledExecutorRNG;

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("Times per call in microseconds");
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        jFrame.getContentPane().add(new SynchronizationTimer().mainPanel());
        jFrame.pack();
        jFrame.setVisible(true);
    }

    static String modeToString(int n) {
        String string = n == 0 ? "block" : (n == 1 ? "timeout" : "No such mode");
        return string;
    }

    static String biasToString(int n) {
        String string = n < 0 ? "slower producer" : (n == 0 ? "balanced prod/cons rate" : (n > 0 ? "slower consumer" : "No such bias"));
        return string;
    }

    static String p2ToString(int n) {
        String string = "";
        if (n >= 1024) {
            string = "K";
            if ((n /= 1024) >= 1024) {
                n /= 1024;
                string = "M";
            }
        }
        return n + string;
    }

    static String formatTime(long l, boolean bl) {
        long l2 = l / 10L;
        long l3 = l % 10L;
        if (!bl) {
            if (l3 >= 5L) {
                ++l2;
            }
            return Long.toString(l2);
        }
        String string = Long.toString(l2);
        String string2 = Long.toString(l3);
        if (l3 == 0L) {
            for (int i = 10; i > 10; i /= 10) {
                string2 = "0" + string2;
            }
        }
        String string3 = string + "." + string2;
        return string3;
    }

    boolean threadEnabled(int n) {
        return this.threadInfo[n].getEnabled();
    }

    JPanel resultPanel() {
        JCheckBox jCheckBox;
        int n;
        int n2;
        JPanel[] jPanelArray = new JPanel[this.tableColumns];
        for (int i = 0; i < this.tableColumns; ++i) {
            jPanelArray[i] = new JPanel();
            jPanelArray[i].setLayout(new GridLayout(this.tableRows, 1));
            if (i == 0) continue;
            jPanelArray[i].setBackground(Color.white);
        }
        Color color = jPanelArray[0].getBackground();
        LineBorder lineBorder = new LineBorder(color);
        Font font = new Font("Dialog", 0, 12);
        Dimension dimension = new Dimension(40, 16);
        Dimension dimension2 = new Dimension(154, 16);
        JLabel jLabel = new JLabel(" Classes      \\      Threads");
        jLabel.setMinimumSize(dimension2);
        jLabel.setPreferredSize(dimension2);
        jLabel.setFont(font);
        this.resultTable_[0][0] = jLabel;
        jPanelArray[0].add(jLabel);
        for (n2 = 1; n2 < this.tableColumns; ++n2) {
            n = n2 - 1;
            jCheckBox = new JCheckBox(this.threadInfo[n].name, true);
            jCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SynchronizationTimer.this.threadInfo[n].toggleEnabled();
                }
            });
            jCheckBox.setMinimumSize(dimension);
            jCheckBox.setPreferredSize(dimension);
            jCheckBox.setFont(font);
            jCheckBox.setBackground(color);
            this.resultTable_[0][n2] = jCheckBox;
            jPanelArray[n2].add(jCheckBox);
        }
        for (n2 = 1; n2 < this.tableRows; ++n2) {
            n = n2 - 1;
            jCheckBox = new JCheckBox(TestedClass.classes[n].name, true);
            jCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    TestedClass.classes[n].toggleEnabled();
                }
            });
            this.resultTable_[n2][0] = jCheckBox;
            jCheckBox.setMinimumSize(dimension2);
            jCheckBox.setPreferredSize(dimension2);
            jCheckBox.setFont(font);
            jPanelArray[0].add(jCheckBox);
            for (int i = 1; i < this.tableColumns; ++i) {
                int n3 = i - 1;
                JLabel jLabel2 = new JLabel("");
                this.resultTable_[n2][i] = jLabel2;
                jLabel2.setMinimumSize(dimension);
                jLabel2.setPreferredSize(dimension);
                jLabel2.setBorder(lineBorder);
                jLabel2.setFont(font);
                jLabel2.setBackground(Color.white);
                jLabel2.setForeground(Color.black);
                jLabel2.setHorizontalAlignment(4);
                jPanelArray[i].add(jLabel2);
            }
        }
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        for (n = 0; n < this.tableColumns; ++n) {
            jPanel.add(jPanelArray[n]);
        }
        return jPanel;
    }

    void setTime(final long l, int n, int n2) {
        int n3 = n + 1;
        int n4 = n2 + 1;
        final JLabel jLabel = (JLabel)this.resultTable_[n3][n4];
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                jLabel.setText(SynchronizationTimer.formatTime(l, true));
            }
        });
    }

    void clearTable() {
        for (int i = 1; i < this.tableRows; ++i) {
            for (int j = 1; j < this.tableColumns; ++j) {
                ((JLabel)this.resultTable_[i][j]).setText("");
            }
        }
    }

    void setChecks(boolean bl) {
        for (int i = 0; i < TestedClass.classes.length; ++i) {
            TestedClass.classes[i].setEnabled(new Boolean(bl));
            ((JCheckBox)this.resultTable_[i + 1][0]).setSelected(bl);
        }
    }

    public SynchronizationTimer() {
        for (int i = 0; i < this.threadInfo.length; ++i) {
            this.threadInfo[i] = new ThreadInfo(nthreadsChoices[i]);
        }
    }

    JPanel mainPanel() {
        new PrintStart();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(5, 3));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(1, 3));
        this.startstop_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (SynchronizationTimer.this.running_.get()) {
                    SynchronizationTimer.this.cancel();
                } else {
                    try {
                        SynchronizationTimer.this.startTestSeries(new TestSeries());
                    }
                    catch (InterruptedException interruptedException) {
                        SynchronizationTimer.this.endTestSeries();
                    }
                }
            }
        });
        jPanel.add(this.startstop_);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(1, 2));
        JButton jButton = new JButton("Continue");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!SynchronizationTimer.this.running_.get()) {
                    try {
                        SynchronizationTimer.this.startTestSeries(new TestSeries(SynchronizationTimer.this.nextClassIdx_.get(), SynchronizationTimer.this.nextThreadIdx_.get()));
                    }
                    catch (InterruptedException interruptedException) {
                        SynchronizationTimer.this.endTestSeries();
                    }
                }
            }
        });
        jPanel3.add(jButton);
        JButton jButton2 = new JButton("Clear cells");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SynchronizationTimer.this.clearTable();
            }
        });
        jPanel3.add(jButton2);
        jPanel.add(jPanel3);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayout(1, 2));
        JButton jButton3 = new JButton("All classes");
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SynchronizationTimer.this.setChecks(true);
            }
        });
        jPanel4.add(jButton3);
        JButton jButton4 = new JButton("No classes");
        jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SynchronizationTimer.this.setChecks(false);
            }
        });
        jPanel4.add(jButton4);
        jPanel.add(jPanel4);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BoxLayout(jPanel5, 0));
        JCheckBox jCheckBox = new JCheckBox("Console echo");
        jCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                SynchronizationTimer.this.echoToSystemOut.complement();
            }
        });
        JLabel jLabel = new JLabel("Active threads:      0");
        jPanel5.add(jLabel);
        jPanel5.add(jCheckBox);
        jPanel.add(jPanel5);
        jPanel.add(this.contentionBox());
        jPanel.add(this.itersBox());
        jPanel.add(this.cloopBox());
        jPanel.add(this.barrierBox());
        jPanel.add(this.exchangeBox());
        jPanel.add(this.biasBox());
        jPanel.add(this.capacityBox());
        jPanel.add(this.timeoutBox());
        jPanel.add(this.syncModePanel());
        jPanel.add(this.producerSyncModePanel());
        jPanel.add(this.consumerSyncModePanel());
        this.startPoolStatus(jLabel);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BoxLayout(jPanel6, 1));
        JPanel jPanel7 = this.resultPanel();
        jPanel6.add(jPanel7);
        jPanel6.add(jPanel);
        return jPanel6;
    }

    JComboBox syncModePanel() {
        JComboBox<String> jComboBox = new JComboBox<String>();
        for (int i = 0; i < syncModes.length; ++i) {
            String string = "Locks: " + SynchronizationTimer.modeToString(syncModes[i]);
            jComboBox.addItem(string);
        }
        jComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                JComboBox jComboBox = (JComboBox)itemEvent.getItemSelectable();
                int n = jComboBox.getSelectedIndex();
                RNG.syncMode.set(syncModes[n]);
            }
        });
        RNG.syncMode.set(syncModes[0]);
        jComboBox.setSelectedIndex(0);
        return jComboBox;
    }

    JComboBox producerSyncModePanel() {
        JComboBox<String> jComboBox = new JComboBox<String>();
        for (int i = 0; i < syncModes.length; ++i) {
            String string = "Producers: " + SynchronizationTimer.modeToString(syncModes[i]);
            jComboBox.addItem(string);
        }
        jComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                JComboBox jComboBox = (JComboBox)itemEvent.getItemSelectable();
                int n = jComboBox.getSelectedIndex();
                RNG.producerMode.set(syncModes[n]);
            }
        });
        RNG.producerMode.set(syncModes[0]);
        jComboBox.setSelectedIndex(0);
        return jComboBox;
    }

    JComboBox consumerSyncModePanel() {
        JComboBox<String> jComboBox = new JComboBox<String>();
        for (int i = 0; i < syncModes.length; ++i) {
            String string = "Consumers: " + SynchronizationTimer.modeToString(syncModes[i]);
            jComboBox.addItem(string);
        }
        jComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                JComboBox jComboBox = (JComboBox)itemEvent.getItemSelectable();
                int n = jComboBox.getSelectedIndex();
                RNG.consumerMode.set(syncModes[n]);
            }
        });
        RNG.consumerMode.set(syncModes[0]);
        jComboBox.setSelectedIndex(0);
        return jComboBox;
    }

    JComboBox contentionBox() {
        final Fraction[] fractionArray = new Fraction[]{new Fraction(0L, 1L), new Fraction(1L, 16L), new Fraction(1L, 8L), new Fraction(1L, 4L), new Fraction(1L, 2L), new Fraction(1L, 1L)};
        JComboBox<String> jComboBox = new JComboBox<String>();
        for (int i = 0; i < fractionArray.length; ++i) {
            String string = fractionArray[i].asDouble() * 100.0 + "% contention/sharing";
            jComboBox.addItem(string);
        }
        jComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                JComboBox jComboBox = (JComboBox)itemEvent.getItemSelectable();
                int n = jComboBox.getSelectedIndex();
                SynchronizationTimer.this.contention_.set(fractionArray[n]);
            }
        });
        this.contention_.set(fractionArray[3]);
        jComboBox.setSelectedIndex(3);
        return jComboBox;
    }

    JComboBox itersBox() {
        final int[] nArray = new int[]{1, 16, 256, 1024, 2048, 4096, 8192, 16384, 32768, 65536, 131072, 262144, 524288, 0x100000};
        JComboBox<String> jComboBox = new JComboBox<String>();
        for (int i = 0; i < nArray.length; ++i) {
            String string = SynchronizationTimer.p2ToString(nArray[i]) + " calls per thread per test";
            jComboBox.addItem(string);
        }
        jComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                JComboBox jComboBox = (JComboBox)itemEvent.getItemSelectable();
                int n = jComboBox.getSelectedIndex();
                SynchronizationTimer.this.loopsPerTest_.set(nArray[n]);
            }
        });
        this.loopsPerTest_.set(nArray[8]);
        jComboBox.setSelectedIndex(8);
        return jComboBox;
    }

    JComboBox cloopBox() {
        final int[] nArray = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192, 16384, 32768, 65536};
        JComboBox<String> jComboBox = new JComboBox<String>();
        for (int i = 0; i < nArray.length; ++i) {
            String string = SynchronizationTimer.p2ToString(nArray[i]) + " computations per call";
            jComboBox.addItem(string);
        }
        jComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                JComboBox jComboBox = (JComboBox)itemEvent.getItemSelectable();
                int n = jComboBox.getSelectedIndex();
                RNG.computeLoops.set(nArray[n]);
            }
        });
        RNG.computeLoops.set(nArray[3]);
        jComboBox.setSelectedIndex(3);
        return jComboBox;
    }

    JComboBox barrierBox() {
        final int[] nArray = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192, 16384, 32768, 65536, 131072, 262144, 524288, 0x100000};
        JComboBox<String> jComboBox = new JComboBox<String>();
        for (int i = 0; i < nArray.length; ++i) {
            String string = SynchronizationTimer.p2ToString(nArray[i]) + " iterations per barrier";
            jComboBox.addItem(string);
        }
        jComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                JComboBox jComboBox = (JComboBox)itemEvent.getItemSelectable();
                int n = jComboBox.getSelectedIndex();
                RNG.itersPerBarrier.set(nArray[n]);
            }
        });
        RNG.itersPerBarrier.set(nArray[13]);
        jComboBox.setSelectedIndex(13);
        return jComboBox;
    }

    JComboBox exchangeBox() {
        final int[] nArray = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024};
        JComboBox<String> jComboBox = new JComboBox<String>();
        for (int i = 0; i < nArray.length; ++i) {
            String string = SynchronizationTimer.p2ToString(nArray[i]) + " max threads per barrier";
            jComboBox.addItem(string);
        }
        jComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                JComboBox jComboBox = (JComboBox)itemEvent.getItemSelectable();
                int n = jComboBox.getSelectedIndex();
                RNG.exchangeParties.set(nArray[n]);
            }
        });
        RNG.exchangeParties.set(nArray[1]);
        jComboBox.setSelectedIndex(1);
        return jComboBox;
    }

    JComboBox biasBox() {
        final int[] nArray = new int[]{-1, 0, 1};
        JComboBox<String> jComboBox = new JComboBox<String>();
        for (int i = 0; i < nArray.length; ++i) {
            String string = SynchronizationTimer.biasToString(nArray[i]);
            jComboBox.addItem(string);
        }
        jComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                JComboBox jComboBox = (JComboBox)itemEvent.getItemSelectable();
                int n = jComboBox.getSelectedIndex();
                RNG.bias.set(nArray[n]);
            }
        });
        RNG.bias.set(nArray[1]);
        jComboBox.setSelectedIndex(1);
        return jComboBox;
    }

    JComboBox capacityBox() {
        final int[] nArray = new int[]{1, 4, 64, 256, 1024, 4096, 16384, 65536, 262144, 0x100000};
        JComboBox<String> jComboBox = new JComboBox<String>();
        for (int i = 0; i < nArray.length; ++i) {
            String string = SynchronizationTimer.p2ToString(nArray[i]) + " element bounded buffers";
            jComboBox.addItem(string);
        }
        jComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                JComboBox jComboBox = (JComboBox)itemEvent.getItemSelectable();
                int n = jComboBox.getSelectedIndex();
                DefaultChannelCapacity.set(nArray[n]);
            }
        });
        DefaultChannelCapacity.set(nArray[3]);
        jComboBox.setSelectedIndex(3);
        return jComboBox;
    }

    JComboBox timeoutBox() {
        final long[] lArray = new long[]{0L, 1L, 10L, 100L, 1000L, 10000L, 100000L};
        JComboBox<String> jComboBox = new JComboBox<String>();
        for (int i = 0; i < lArray.length; ++i) {
            String string = lArray[i] + " msec timeouts";
            jComboBox.addItem(string);
        }
        jComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                JComboBox jComboBox = (JComboBox)itemEvent.getItemSelectable();
                int n = jComboBox.getSelectedIndex();
                RNG.timeout.set(lArray[n]);
            }
        });
        RNG.timeout.set(lArray[3]);
        jComboBox.setSelectedIndex(3);
        return jComboBox;
    }

    void startPoolStatus(final JLabel jLabel) {
        Runnable runnable = new Runnable(){
            int lastps = 0;

            public void run() {
                int n = Threads.activeThreads.get();
                if (this.lastps != n) {
                    this.lastps = n;
                    SwingUtilities.invokeLater(new Runnable(this, n){
                        private final /* synthetic */ int val$ps;
                        private final /* synthetic */ 22 this$1;
                        {
                            this.this$1 = var1_1;
                            this.val$ps = n;
                        }

                        public void run() {
                            22.access$400(this.this$1).setText("Active threads: " + this.val$ps);
                        }
                    });
                }
            }

            static /* synthetic */ JLabel access$400(22 var0) {
                return var0.jLabel;
            }
        };
        this.timeDaemon.executePeriodically(250L, runnable, false);
    }

    private void runOneTest(Runnable runnable) throws InterruptedException {
        int n = this.testNumber_.get();
        Threads.pool.execute(runnable);
        this.testNumber_.whenNotEqual(n, null);
    }

    private void endOneTest() {
        this.testNumber_.increment();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancel() {
        Object object = RNG.constructionLock;
        synchronized (object) {
            try {
                Threads.pool.interruptAll();
            }
            catch (Exception exception) {
                System.out.println("\nException during cancel:\n" + exception);
                return;
            }
        }
    }

    void startTestSeries(Runnable runnable) throws InterruptedException {
        this.running_.set(true);
        this.startstop_.setText("Stop");
        Threads.pool.execute(runnable);
    }

    void endTestSeries() {
        this.running_.set(false);
        SwingUtilities.invokeLater(new PrintStart());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class OneTest
    implements Runnable {
        final int clsIdx;
        final int nthreadsIdx;

        OneTest(int n, int n2) {
            this.clsIdx = n;
            this.nthreadsIdx = n2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            Color color;
            JLabel jLabel;
            boolean bl;
            block26: {
                block25: {
                    block24: {
                        boolean bl2;
                        block23: {
                            Thread.currentThread().setPriority(2);
                            bl = false;
                            TestedClass testedClass = TestedClass.classes[this.clsIdx];
                            jLabel = (JLabel)SynchronizationTimer.this.resultTable_[this.clsIdx + 1][this.nthreadsIdx + 1];
                            color = jLabel.getForeground();
                            try {
                                try {
                                    if (Thread.interrupted()) {
                                        Object var21_5 = null;
                                        bl2 = bl;
                                        break block23;
                                    }
                                    if (!SynchronizationTimer.this.threadEnabled(this.nthreadsIdx)) {
                                        break block24;
                                    }
                                    int n = nthreadsChoices[this.nthreadsIdx];
                                    int n2 = SynchronizationTimer.this.loopsPerTest_.get();
                                    Fraction fraction = (Fraction)SynchronizationTimer.this.contention_.get();
                                    if (!testedClass.isEnabled(n, fraction)) {
                                        break block25;
                                    }
                                    BarrierTimer barrierTimer = new BarrierTimer();
                                    CyclicBarrier cyclicBarrier = new CyclicBarrier(n + 1, barrierTimer);
                                    Class clazz = testedClass.cls;
                                    Class clazz2 = testedClass.buffCls;
                                    try {
                                        SwingUtilities.invokeAndWait(new Runnable(this, jLabel){
                                            private final /* synthetic */ JLabel val$cell;
                                            private final /* synthetic */ OneTest this$1;
                                            {
                                                this.this$1 = oneTest;
                                                this.val$cell = jLabel;
                                            }

                                            public void run() {
                                                this.val$cell.setForeground(Color.blue);
                                                this.val$cell.setText("RUN");
                                                this.val$cell.repaint();
                                            }
                                        });
                                    }
                                    catch (InvocationTargetException invocationTargetException) {
                                        invocationTargetException.printStackTrace();
                                        System.exit(-1);
                                    }
                                    Object object = RNG.constructionLock;
                                    synchronized (object) {
                                        Object object2;
                                        RNG.reset(n);
                                        if (clazz2 == null) {
                                            RNG rNG = (RNG)clazz.newInstance();
                                            for (int i = 0; i < n; ++i) {
                                                RNG rNG2 = (RNG)clazz.newInstance();
                                                object2 = new TestLoop(rNG, rNG2, fraction, n2, cyclicBarrier);
                                                Threads.pool.execute(((TestLoop)object2).testLoop());
                                            }
                                        } else {
                                            Channel channel = (Channel)clazz2.newInstance();
                                            if (n == 1) {
                                                ChanRNG chanRNG = (ChanRNG)clazz.newInstance();
                                                chanRNG.setSingle(true);
                                                PCTestLoop pCTestLoop = new PCTestLoop(chanRNG.getDelegate(), chanRNG, fraction, n2, cyclicBarrier, channel, channel);
                                                Threads.pool.execute(pCTestLoop.testLoop(true));
                                            } else {
                                                if (n % 2 != 0) {
                                                    throw new Error("Must have even number of threads!");
                                                }
                                                int n3 = n / 2;
                                                for (int i = 0; i < n3; ++i) {
                                                    object2 = (ChanRNG)clazz.newInstance();
                                                    ((ChanRNG)object2).setSingle(false);
                                                    Channel channel2 = (Channel)clazz2.newInstance();
                                                    PCTestLoop pCTestLoop = new PCTestLoop(((DelegatedRNG)object2).getDelegate(), (RNG)object2, fraction, n2, cyclicBarrier, channel, channel2);
                                                    Threads.pool.execute(pCTestLoop.testLoop(false));
                                                    Threads.pool.execute(pCTestLoop.testLoop(true));
                                                }
                                            }
                                        }
                                        if (SynchronizationTimer.this.echoToSystemOut.get()) {
                                            System.out.print(testedClass.name + " " + n + "T " + fraction + "S " + RNG.computeLoops.get() + "I " + RNG.syncMode.get() + "Lm " + RNG.timeout.get() + "TO " + RNG.producerMode.get() + "Pm " + RNG.consumerMode.get() + "Cm " + RNG.bias.get() + "B " + DefaultChannelCapacity.get() + "C " + RNG.exchangeParties.get() + "Xp " + RNG.itersPerBarrier.get() + "Ib : ");
                                        }
                                    }
                                    cyclicBarrier.barrier();
                                    cyclicBarrier.barrier();
                                    long l = barrierTimer.getTime();
                                    long l2 = n * n2;
                                    double d = (double)l * 1000.0 * 10.0 / (double)l2;
                                    long l3 = Math.round(d);
                                    SynchronizationTimer.this.setTime(l3, this.clsIdx, this.nthreadsIdx);
                                    if (SynchronizationTimer.this.echoToSystemOut.get()) {
                                        System.out.println(SynchronizationTimer.formatTime(l3, true));
                                    }
                                    break block26;
                                }
                                catch (BrokenBarrierException brokenBarrierException) {
                                    bl = true;
                                    Object var21_9 = null;
                                    boolean bl3 = bl;
                                    SwingUtilities.invokeLater(new Runnable(this, bl3, jLabel, color){
                                        private final /* synthetic */ boolean val$clear;
                                        private final /* synthetic */ JLabel val$cell;
                                        private final /* synthetic */ Color val$oldfg;
                                        private final /* synthetic */ OneTest this$1;
                                        {
                                            this.this$1 = oneTest;
                                            this.val$clear = bl;
                                            this.val$cell = jLabel;
                                            this.val$oldfg = color;
                                        }

                                        public void run() {
                                            if (this.val$clear) {
                                                this.val$cell.setText("");
                                            }
                                            this.val$cell.setForeground(this.val$oldfg);
                                            this.val$cell.repaint();
                                        }
                                    });
                                    Thread.currentThread().setPriority(5);
                                    SynchronizationTimer.this.endOneTest();
                                    return;
                                }
                                catch (InterruptedException interruptedException) {
                                    bl = true;
                                    Thread.currentThread().interrupt();
                                    Object var21_10 = null;
                                    boolean bl4 = bl;
                                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                                    Thread.currentThread().setPriority(5);
                                    SynchronizationTimer.this.endOneTest();
                                    return;
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                    System.out.println("Construction Exception?");
                                    System.exit(-1);
                                    Object var21_11 = null;
                                    boolean bl5 = bl;
                                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                                    Thread.currentThread().setPriority(5);
                                    SynchronizationTimer.this.endOneTest();
                                    return;
                                }
                            }
                            catch (Throwable throwable) {
                                Object var21_12 = null;
                                boolean bl6 = bl;
                                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                                Thread.currentThread().setPriority(5);
                                SynchronizationTimer.this.endOneTest();
                                throw throwable;
                            }
                        }
                        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                        Thread.currentThread().setPriority(5);
                        SynchronizationTimer.this.endOneTest();
                        return;
                    }
                    Object var21_6 = null;
                    boolean bl7 = bl;
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                    Thread.currentThread().setPriority(5);
                    SynchronizationTimer.this.endOneTest();
                    return;
                }
                Object var21_7 = null;
                boolean bl8 = bl;
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                Thread.currentThread().setPriority(5);
                SynchronizationTimer.this.endOneTest();
                return;
            }
            Object var21_8 = null;
            boolean bl9 = bl;
            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            Thread.currentThread().setPriority(5);
            SynchronizationTimer.this.endOneTest();
        }
    }

    static class BarrierTimer
    implements Runnable {
        private long startTime_ = 0L;
        private long endTime_ = 0L;

        BarrierTimer() {
        }

        public synchronized long getTime() {
            return this.endTime_ - this.startTime_;
        }

        public synchronized void run() {
            long l = System.currentTimeMillis();
            if (this.startTime_ == 0L) {
                this.startTime_ = l;
            } else {
                this.endTime_ = l;
            }
        }
    }

    class TestSeries
    implements Runnable {
        final int firstclass;
        final int firstnthreads;

        TestSeries() {
            this.firstclass = 0;
            this.firstnthreads = 0;
        }

        TestSeries(int n, int n2) {
            this.firstclass = n;
            this.firstnthreads = n2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block10: {
                Thread.currentThread().setPriority(5);
                try {
                    int n = this.firstnthreads;
                    int n2 = this.firstclass;
                    if (n >= nthreadsChoices.length || n2 >= TestedClass.classes.length) break block10;
                    while (true) {
                        if (SynchronizationTimer.this.threadEnabled(n)) {
                            TestedClass testedClass = TestedClass.classes[n2];
                            int n3 = nthreadsChoices[n];
                            int n4 = SynchronizationTimer.this.loopsPerTest_.get();
                            Fraction fraction = (Fraction)SynchronizationTimer.this.contention_.get();
                            if (testedClass.isEnabled(n3, fraction)) {
                                SynchronizationTimer.this.runOneTest(new OneTest(n2, n));
                            }
                        }
                        if (++n2 >= TestedClass.classes.length) {
                            n2 = 0;
                            if (++n >= nthreadsChoices.length) {
                                break;
                            }
                        }
                        SynchronizationTimer.this.nextClassIdx_.set(n2);
                        SynchronizationTimer.this.nextThreadIdx_.set(n);
                    }
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
                finally {
                    SynchronizationTimer.this.endTestSeries();
                }
            }
        }
    }

    class PrintStart
    implements Runnable {
        PrintStart() {
        }

        public void run() {
            SynchronizationTimer.this.startstop_.setText("Start");
        }
    }

    static class ThreadInfo {
        final String name;
        final int number;
        Boolean enabled;

        ThreadInfo(int n) {
            this.number = n;
            this.name = SynchronizationTimer.p2ToString(n);
            this.enabled = new Boolean(true);
        }

        synchronized Boolean getEnabled() {
            return this.enabled;
        }

        synchronized void setEnabled(Boolean bl) {
            this.enabled = bl;
        }

        synchronized void toggleEnabled() {
            this.enabled = new Boolean(this.enabled == false);
        }
    }

    static class TestedClass {
        final String name;
        final Class cls;
        final boolean multipleOK;
        final boolean singleOK;
        final Class buffCls;
        Boolean enabled_ = new Boolean(true);
        static final TestedClass dummy = new TestedClass("", null, false, false);
        static final TestedClass[] classes = new TestedClass[]{new TestedClass("NoSynchronization", class$edu$oswego$cs$dl$util$concurrent$misc$NoSynchRNG == null ? (class$edu$oswego$cs$dl$util$concurrent$misc$NoSynchRNG = SynchronizationTimer.class$("edu.oswego.cs.dl.util.concurrent.misc.NoSynchRNG")) : class$edu$oswego$cs$dl$util$concurrent$misc$NoSynchRNG, false, true), new TestedClass("PublicSynchronization", class$edu$oswego$cs$dl$util$concurrent$misc$PublicSynchRNG == null ? (class$edu$oswego$cs$dl$util$concurrent$misc$PublicSynchRNG = SynchronizationTimer.class$("edu.oswego.cs.dl.util.concurrent.misc.PublicSynchRNG")) : class$edu$oswego$cs$dl$util$concurrent$misc$PublicSynchRNG, true, true), new TestedClass("NestedSynchronization", class$edu$oswego$cs$dl$util$concurrent$misc$AllSynchRNG == null ? (class$edu$oswego$cs$dl$util$concurrent$misc$AllSynchRNG = SynchronizationTimer.class$("edu.oswego.cs.dl.util.concurrent.misc.AllSynchRNG")) : class$edu$oswego$cs$dl$util$concurrent$misc$AllSynchRNG, true, true), new TestedClass("SDelegated", class$edu$oswego$cs$dl$util$concurrent$misc$SDelegatedRNG == null ? (class$edu$oswego$cs$dl$util$concurrent$misc$SDelegatedRNG = SynchronizationTimer.class$("edu.oswego.cs.dl.util.concurrent.misc.SDelegatedRNG")) : class$edu$oswego$cs$dl$util$concurrent$misc$SDelegatedRNG, true, true), new TestedClass("SynchLongUsingSet", class$edu$oswego$cs$dl$util$concurrent$misc$SynchLongRNG == null ? (class$edu$oswego$cs$dl$util$concurrent$misc$SynchLongRNG = SynchronizationTimer.class$("edu.oswego.cs.dl.util.concurrent.misc.SynchLongRNG")) : class$edu$oswego$cs$dl$util$concurrent$misc$SynchLongRNG, true, true), new TestedClass("SynchLongUsingCommit", class$edu$oswego$cs$dl$util$concurrent$misc$AClongRNG == null ? (class$edu$oswego$cs$dl$util$concurrent$misc$AClongRNG = SynchronizationTimer.class$("edu.oswego.cs.dl.util.concurrent.misc.AClongRNG")) : class$edu$oswego$cs$dl$util$concurrent$misc$AClongRNG, true, true), new TestedClass("Semaphore", class$edu$oswego$cs$dl$util$concurrent$misc$SemRNG == null ? (class$edu$oswego$cs$dl$util$concurrent$misc$SemRNG = SynchronizationTimer.class$("edu.oswego.cs.dl.util.concurrent.misc.SemRNG")) : class$edu$oswego$cs$dl$util$concurrent$misc$SemRNG, true, true), new TestedClass("WaiterPrefSemaphore", class$edu$oswego$cs$dl$util$concurrent$misc$WpSemRNG == null ? (class$edu$oswego$cs$dl$util$concurrent$misc$WpSemRNG = SynchronizationTimer.class$("edu.oswego.cs.dl.util.concurrent.misc.WpSemRNG")) : class$edu$oswego$cs$dl$util$concurrent$misc$WpSemRNG, true, true), new TestedClass("FIFOSemaphore", class$edu$oswego$cs$dl$util$concurrent$misc$FifoRNG == null ? (class$edu$oswego$cs$dl$util$concurrent$misc$FifoRNG = SynchronizationTimer.class$("edu.oswego.cs.dl.util.concurrent.misc.FifoRNG")) : class$edu$oswego$cs$dl$util$concurrent$misc$FifoRNG, true, true), new TestedClass("PrioritySemaphore", class$edu$oswego$cs$dl$util$concurrent$misc$PrioritySemRNG == null ? (class$edu$oswego$cs$dl$util$concurrent$misc$PrioritySemRNG = SynchronizationTimer.class$("edu.oswego.cs.dl.util.concurrent.misc.PrioritySemRNG")) : class$edu$oswego$cs$dl$util$concurrent$misc$PrioritySemRNG, true, true), new TestedClass("Mutex", class$edu$oswego$cs$dl$util$concurrent$misc$MutexRNG == null ? (class$edu$oswego$cs$dl$util$concurrent$misc$MutexRNG = SynchronizationTimer.class$("edu.oswego.cs.dl.util.concurrent.misc.MutexRNG")) : class$edu$oswego$cs$dl$util$concurrent$misc$MutexRNG, true, true), new TestedClass("ReentrantLock", class$edu$oswego$cs$dl$util$concurrent$misc$RlockRNG == null ? (class$edu$oswego$cs$dl$util$concurrent$misc$RlockRNG = SynchronizationTimer.class$("edu.oswego.cs.dl.util.concurrent.misc.RlockRNG")) : class$edu$oswego$cs$dl$util$concurrent$misc$RlockRNG, true, true), new TestedClass("WriterPrefRWLock", class$edu$oswego$cs$dl$util$concurrent$misc$WpRWlockRNG == null ? (class$edu$oswego$cs$dl$util$concurrent$misc$WpRWlockRNG = SynchronizationTimer.class$("edu.oswego.cs.dl.util.concurrent.misc.WpRWlockRNG")) : class$edu$oswego$cs$dl$util$concurrent$misc$WpRWlockRNG, true, true), new TestedClass("ReaderPrefRWLock", class$edu$oswego$cs$dl$util$concurrent$misc$ReaderPrefRWlockRNG == null ? (class$edu$oswego$cs$dl$util$concurrent$misc$ReaderPrefRWlockRNG = SynchronizationTimer.class$("edu.oswego.cs.dl.util.concurrent.misc.ReaderPrefRWlockRNG")) : class$edu$oswego$cs$dl$util$concurrent$misc$ReaderPrefRWlockRNG, true, true), new TestedClass("FIFORWLock", class$edu$oswego$cs$dl$util$concurrent$misc$FIFORWlockRNG == null ? (class$edu$oswego$cs$dl$util$concurrent$misc$FIFORWlockRNG = SynchronizationTimer.class$("edu.oswego.cs.dl.util.concurrent.misc.FIFORWlockRNG")) : class$edu$oswego$cs$dl$util$concurrent$misc$FIFORWlockRNG, true, true), new TestedClass("ReentrantRWL", class$edu$oswego$cs$dl$util$concurrent$misc$ReentrantRWlockRNG == null ? (class$edu$oswego$cs$dl$util$concurrent$misc$ReentrantRWlockRNG = SynchronizationTimer.class$("edu.oswego.cs.dl.util.concurrent.misc.ReentrantRWlockRNG")) : class$edu$oswego$cs$dl$util$concurrent$misc$ReentrantRWlockRNG, true, true), new TestedClass("LinkedQueue", class$edu$oswego$cs$dl$util$concurrent$misc$ChanRNG == null ? (class$edu$oswego$cs$dl$util$concurrent$misc$ChanRNG = SynchronizationTimer.class$("edu.oswego.cs.dl.util.concurrent.misc.ChanRNG")) : class$edu$oswego$cs$dl$util$concurrent$misc$ChanRNG, true, true, class$edu$oswego$cs$dl$util$concurrent$LinkedQueue == null ? (class$edu$oswego$cs$dl$util$concurrent$LinkedQueue = SynchronizationTimer.class$("edu.oswego.cs.dl.util.concurrent.LinkedQueue")) : class$edu$oswego$cs$dl$util$concurrent$LinkedQueue), new TestedClass("WaitFreeQueue", class$edu$oswego$cs$dl$util$concurrent$misc$ChanRNG == null ? (class$edu$oswego$cs$dl$util$concurrent$misc$ChanRNG = SynchronizationTimer.class$("edu.oswego.cs.dl.util.concurrent.misc.ChanRNG")) : class$edu$oswego$cs$dl$util$concurrent$misc$ChanRNG, true, true, class$edu$oswego$cs$dl$util$concurrent$WaitFreeQueue == null ? (class$edu$oswego$cs$dl$util$concurrent$WaitFreeQueue = SynchronizationTimer.class$("edu.oswego.cs.dl.util.concurrent.WaitFreeQueue")) : class$edu$oswego$cs$dl$util$concurrent$WaitFreeQueue), new TestedClass("BoundedLinkedQueue", class$edu$oswego$cs$dl$util$concurrent$misc$ChanRNG == null ? (class$edu$oswego$cs$dl$util$concurrent$misc$ChanRNG = SynchronizationTimer.class$("edu.oswego.cs.dl.util.concurrent.misc.ChanRNG")) : class$edu$oswego$cs$dl$util$concurrent$misc$ChanRNG, true, true, class$edu$oswego$cs$dl$util$concurrent$BoundedLinkedQueue == null ? (class$edu$oswego$cs$dl$util$concurrent$BoundedLinkedQueue = SynchronizationTimer.class$("edu.oswego.cs.dl.util.concurrent.BoundedLinkedQueue")) : class$edu$oswego$cs$dl$util$concurrent$BoundedLinkedQueue), new TestedClass("BoundedBuffer", class$edu$oswego$cs$dl$util$concurrent$misc$ChanRNG == null ? (class$edu$oswego$cs$dl$util$concurrent$misc$ChanRNG = SynchronizationTimer.class$("edu.oswego.cs.dl.util.concurrent.misc.ChanRNG")) : class$edu$oswego$cs$dl$util$concurrent$misc$ChanRNG, true, true, class$edu$oswego$cs$dl$util$concurrent$BoundedBuffer == null ? (class$edu$oswego$cs$dl$util$concurrent$BoundedBuffer = SynchronizationTimer.class$("edu.oswego.cs.dl.util.concurrent.BoundedBuffer")) : class$edu$oswego$cs$dl$util$concurrent$BoundedBuffer), new TestedClass("CondVarBoundedBuffer", class$edu$oswego$cs$dl$util$concurrent$misc$ChanRNG == null ? (class$edu$oswego$cs$dl$util$concurrent$misc$ChanRNG = SynchronizationTimer.class$("edu.oswego.cs.dl.util.concurrent.misc.ChanRNG")) : class$edu$oswego$cs$dl$util$concurrent$misc$ChanRNG, true, true, class$edu$oswego$cs$dl$util$concurrent$misc$CVBuffer == null ? (class$edu$oswego$cs$dl$util$concurrent$misc$CVBuffer = SynchronizationTimer.class$("edu.oswego.cs.dl.util.concurrent.misc.CVBuffer")) : class$edu$oswego$cs$dl$util$concurrent$misc$CVBuffer), new TestedClass("BoundedPriorityQueue", class$edu$oswego$cs$dl$util$concurrent$misc$ChanRNG == null ? (class$edu$oswego$cs$dl$util$concurrent$misc$ChanRNG = SynchronizationTimer.class$("edu.oswego.cs.dl.util.concurrent.misc.ChanRNG")) : class$edu$oswego$cs$dl$util$concurrent$misc$ChanRNG, true, true, class$edu$oswego$cs$dl$util$concurrent$BoundedPriorityQueue == null ? (class$edu$oswego$cs$dl$util$concurrent$BoundedPriorityQueue = SynchronizationTimer.class$("edu.oswego.cs.dl.util.concurrent.BoundedPriorityQueue")) : class$edu$oswego$cs$dl$util$concurrent$BoundedPriorityQueue), new TestedClass("Slot", class$edu$oswego$cs$dl$util$concurrent$misc$ChanRNG == null ? (class$edu$oswego$cs$dl$util$concurrent$misc$ChanRNG = SynchronizationTimer.class$("edu.oswego.cs.dl.util.concurrent.misc.ChanRNG")) : class$edu$oswego$cs$dl$util$concurrent$misc$ChanRNG, true, true, class$edu$oswego$cs$dl$util$concurrent$Slot == null ? (class$edu$oswego$cs$dl$util$concurrent$Slot = SynchronizationTimer.class$("edu.oswego.cs.dl.util.concurrent.Slot")) : class$edu$oswego$cs$dl$util$concurrent$Slot), new TestedClass("SynchronousChannel", class$edu$oswego$cs$dl$util$concurrent$misc$ChanRNG == null ? (class$edu$oswego$cs$dl$util$concurrent$misc$ChanRNG = SynchronizationTimer.class$("edu.oswego.cs.dl.util.concurrent.misc.ChanRNG")) : class$edu$oswego$cs$dl$util$concurrent$misc$ChanRNG, true, false, class$edu$oswego$cs$dl$util$concurrent$SynchronousChannel == null ? (class$edu$oswego$cs$dl$util$concurrent$SynchronousChannel = SynchronizationTimer.class$("edu.oswego.cs.dl.util.concurrent.SynchronousChannel")) : class$edu$oswego$cs$dl$util$concurrent$SynchronousChannel), new TestedClass("DirectExecutor", class$edu$oswego$cs$dl$util$concurrent$misc$DirectExecutorRNG == null ? (class$edu$oswego$cs$dl$util$concurrent$misc$DirectExecutorRNG = SynchronizationTimer.class$("edu.oswego.cs.dl.util.concurrent.misc.DirectExecutorRNG")) : class$edu$oswego$cs$dl$util$concurrent$misc$DirectExecutorRNG, true, true), new TestedClass("SemaphoreLckExecutor", class$edu$oswego$cs$dl$util$concurrent$misc$LockedSemRNG == null ? (class$edu$oswego$cs$dl$util$concurrent$misc$LockedSemRNG = SynchronizationTimer.class$("edu.oswego.cs.dl.util.concurrent.misc.LockedSemRNG")) : class$edu$oswego$cs$dl$util$concurrent$misc$LockedSemRNG, true, true), new TestedClass("QueuedExecutor", class$edu$oswego$cs$dl$util$concurrent$misc$QueuedExecutorRNG == null ? (class$edu$oswego$cs$dl$util$concurrent$misc$QueuedExecutorRNG = SynchronizationTimer.class$("edu.oswego.cs.dl.util.concurrent.misc.QueuedExecutorRNG")) : class$edu$oswego$cs$dl$util$concurrent$misc$QueuedExecutorRNG, true, true), new TestedClass("ThreadedExecutor", class$edu$oswego$cs$dl$util$concurrent$misc$ThreadedExecutorRNG == null ? (class$edu$oswego$cs$dl$util$concurrent$misc$ThreadedExecutorRNG = SynchronizationTimer.class$("edu.oswego.cs.dl.util.concurrent.misc.ThreadedExecutorRNG")) : class$edu$oswego$cs$dl$util$concurrent$misc$ThreadedExecutorRNG, true, true), new TestedClass("PooledExecutor", class$edu$oswego$cs$dl$util$concurrent$misc$PooledExecutorRNG == null ? (class$edu$oswego$cs$dl$util$concurrent$misc$PooledExecutorRNG = SynchronizationTimer.class$("edu.oswego.cs.dl.util.concurrent.misc.PooledExecutorRNG")) : class$edu$oswego$cs$dl$util$concurrent$misc$PooledExecutorRNG, true, true)};

        synchronized void setEnabled(Boolean bl) {
            this.enabled_ = bl;
        }

        synchronized Boolean getEnabled() {
            return this.enabled_;
        }

        synchronized void toggleEnabled() {
            boolean bl = this.enabled_;
            this.enabled_ = new Boolean(!bl);
        }

        synchronized boolean isEnabled(int n, Fraction fraction) {
            boolean bl = this.enabled_;
            if (!bl) {
                return false;
            }
            if (!this.singleOK && n <= 1) {
                return false;
            }
            return this.multipleOK || n <= 1 || fraction.compareTo(0L) <= 0;
        }

        TestedClass(String string, Class clazz, boolean bl, boolean bl2) {
            this.name = string;
            this.cls = clazz;
            this.multipleOK = bl;
            this.singleOK = bl2;
            this.buffCls = null;
        }

        TestedClass(String string, Class clazz, boolean bl, boolean bl2, Class clazz2) {
            this.name = string;
            this.cls = clazz;
            this.multipleOK = bl;
            this.singleOK = bl2;
            this.buffCls = clazz2;
        }
    }
}

