/*
 * Decompiled with CFR 0.152.
 */
package edu.oswego.cs.dl.util.concurrent.misc;

import edu.oswego.cs.dl.util.concurrent.Channel;
import edu.oswego.cs.dl.util.concurrent.misc.DelegatedRNG;
import edu.oswego.cs.dl.util.concurrent.misc.PublicSynchRNG;
import edu.oswego.cs.dl.util.concurrent.misc.RNG;

class ChanRNG
extends DelegatedRNG {
    boolean single_;

    ChanRNG() {
        this.setDelegate(new PublicSynchRNG());
    }

    public synchronized void setSingle(boolean bl) {
        this.single_ = bl;
    }

    public synchronized boolean isSingle() {
        return this.single_;
    }

    public long producerNext(Channel channel) throws InterruptedException {
        RNG rNG = this.getDelegate();
        if (this.isSingle()) {
            channel.put(rNG);
            rNG = (RNG)channel.take();
            rNG.update();
        } else {
            if (this.pcBias < 0) {
                rNG.update();
                rNG.update();
            } else if (this.pcBias == 0) {
                rNG.update();
            }
            if (this.pmode == 0) {
                channel.put(rNG);
            } else {
                while (!channel.offer(rNG, this.waitTime)) {
                }
            }
        }
        return rNG.get();
    }

    public long consumerNext(Channel channel) throws InterruptedException {
        RNG rNG = null;
        if (this.cmode == 0) {
            rNG = (RNG)channel.take();
        } else {
            while (rNG == null) {
                rNG = (RNG)channel.poll(this.waitTime);
            }
        }
        if (this.pcBias == 0) {
            rNG.update();
        } else if (this.pcBias > 0) {
            rNG.update();
            rNG.update();
        }
        return rNG.get();
    }
}

