/*
 * Decompiled with CFR 0.152.
 */
package edu.oswego.cs.dl.util.concurrent;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;

public class VetoableChangeMulticaster
implements Serializable {
    protected transient VetoableChangeListener[] listeners = new VetoableChangeListener[0];
    protected final Object source;
    protected HashMap children;

    protected synchronized VetoableChangeMulticaster getChild(String string) {
        return this.children == null ? null : (VetoableChangeMulticaster)this.children.get(string);
    }

    public VetoableChangeMulticaster(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        this.source = object;
    }

    public synchronized void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener == null) {
            throw new NullPointerException();
        }
        int n = this.listeners.length;
        VetoableChangeListener[] vetoableChangeListenerArray = new VetoableChangeListener[n + 1];
        if (n > 0) {
            System.arraycopy(this.listeners, 0, vetoableChangeListenerArray, 0, n);
        }
        vetoableChangeListenerArray[n] = vetoableChangeListener;
        this.listeners = vetoableChangeListenerArray;
    }

    public synchronized void addVetoableChangeListenerIfAbsent(VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener == null) {
            throw new NullPointerException();
        }
        int n = this.listeners.length;
        VetoableChangeListener[] vetoableChangeListenerArray = new VetoableChangeListener[n + 1];
        for (int i = 0; i < n; ++i) {
            vetoableChangeListenerArray[i] = this.listeners[i];
            if (!vetoableChangeListener.equals(this.listeners[i])) continue;
            return;
        }
        vetoableChangeListenerArray[n] = vetoableChangeListener;
        this.listeners = vetoableChangeListenerArray;
    }

    public synchronized void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        int n = this.listeners.length - 1;
        if (n < 0 || vetoableChangeListener == null) {
            return;
        }
        VetoableChangeListener[] vetoableChangeListenerArray = new VetoableChangeListener[n];
        for (int i = 0; i < n; ++i) {
            if (vetoableChangeListener.equals(this.listeners[i])) {
                for (int j = i + 1; j <= n; ++j) {
                    vetoableChangeListenerArray[j - 1] = this.listeners[j];
                }
                this.listeners = vetoableChangeListenerArray;
                return;
            }
            vetoableChangeListenerArray[i] = this.listeners[i];
        }
        if (vetoableChangeListener.equals(this.listeners[n])) {
            this.listeners = vetoableChangeListenerArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVetoableChangeListener(String string, VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener == null) {
            throw new NullPointerException();
        }
        VetoableChangeMulticaster vetoableChangeMulticaster = null;
        VetoableChangeMulticaster vetoableChangeMulticaster2 = this;
        synchronized (vetoableChangeMulticaster2) {
            if (this.children == null) {
                this.children = new HashMap();
            } else {
                vetoableChangeMulticaster = (VetoableChangeMulticaster)this.children.get(string);
            }
            if (vetoableChangeMulticaster == null) {
                vetoableChangeMulticaster = new VetoableChangeMulticaster(this.source);
                this.children.put(string, vetoableChangeMulticaster);
            }
        }
        vetoableChangeMulticaster.addVetoableChangeListener(vetoableChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVetoableChangeListenerIfAbsent(String string, VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener == null) {
            throw new NullPointerException();
        }
        VetoableChangeMulticaster vetoableChangeMulticaster = null;
        VetoableChangeMulticaster vetoableChangeMulticaster2 = this;
        synchronized (vetoableChangeMulticaster2) {
            if (this.children == null) {
                this.children = new HashMap();
            } else {
                vetoableChangeMulticaster = (VetoableChangeMulticaster)this.children.get(string);
            }
            if (vetoableChangeMulticaster == null) {
                vetoableChangeMulticaster = new VetoableChangeMulticaster(this.source);
                this.children.put(string, vetoableChangeMulticaster);
            }
        }
        vetoableChangeMulticaster.addVetoableChangeListenerIfAbsent(vetoableChangeListener);
    }

    public void removeVetoableChangeListener(String string, VetoableChangeListener vetoableChangeListener) {
        VetoableChangeMulticaster vetoableChangeMulticaster = this.getChild(string);
        if (vetoableChangeMulticaster != null) {
            vetoableChangeMulticaster.removeVetoableChangeListener(vetoableChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void multicast(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        VetoableChangeListener[] vetoableChangeListenerArray;
        VetoableChangeMulticaster vetoableChangeMulticaster = null;
        VetoableChangeMulticaster vetoableChangeMulticaster2 = this;
        synchronized (vetoableChangeMulticaster2) {
            vetoableChangeListenerArray = this.listeners;
            if (this.children != null && propertyChangeEvent.getPropertyName() != null) {
                vetoableChangeMulticaster = (VetoableChangeMulticaster)this.children.get(propertyChangeEvent.getPropertyName());
            }
        }
        int n = 0;
        try {
            for (n = 0; n < vetoableChangeListenerArray.length; ++n) {
                vetoableChangeListenerArray[n].vetoableChange(propertyChangeEvent);
            }
            if (vetoableChangeMulticaster != null) {
                vetoableChangeMulticaster.multicast(propertyChangeEvent);
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            PropertyChangeEvent propertyChangeEvent2 = new PropertyChangeEvent(propertyChangeEvent.getSource(), propertyChangeEvent.getPropertyName(), propertyChangeEvent.getNewValue(), propertyChangeEvent.getOldValue());
            int n2 = n < vetoableChangeListenerArray.length ? n : vetoableChangeListenerArray.length - 1;
            for (int i = 0; i <= n2; ++i) {
                try {
                    vetoableChangeListenerArray[i].vetoableChange(propertyChangeEvent2);
                    continue;
                }
                catch (PropertyVetoException propertyVetoException2) {
                    // empty catch block
                }
            }
            throw propertyVetoException;
        }
    }

    public void fireVetoableChange(String string, Object object, Object object2) throws PropertyVetoException {
        if (object == null || object2 == null || !object.equals(object2)) {
            this.multicast(new PropertyChangeEvent(this.source, string, object, object2));
        }
    }

    public void fireVetoableChange(String string, int n, int n2) throws PropertyVetoException {
        if (n != n2) {
            this.multicast(new PropertyChangeEvent(this.source, string, new Integer(n), new Integer(n2)));
        }
    }

    public void fireVetoableChange(String string, boolean bl, boolean bl2) throws PropertyVetoException {
        if (bl != bl2) {
            this.multicast(new PropertyChangeEvent(this.source, string, new Boolean(bl), new Boolean(bl2)));
        }
    }

    public void fireVetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        Object object = propertyChangeEvent.getOldValue();
        Object object2 = propertyChangeEvent.getNewValue();
        if (object == null || object2 == null || !object.equals(object2)) {
            this.multicast(propertyChangeEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasListeners(String string) {
        VetoableChangeMulticaster vetoableChangeMulticaster;
        VetoableChangeMulticaster vetoableChangeMulticaster2 = this;
        synchronized (vetoableChangeMulticaster2) {
            if (this.listeners.length > 0) {
                return true;
            }
            if (string == null || this.children == null) {
                return false;
            }
            vetoableChangeMulticaster = (VetoableChangeMulticaster)this.children.get(string);
            if (vetoableChangeMulticaster == null) {
                return false;
            }
        }
        return vetoableChangeMulticaster.hasListeners(null);
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        for (int i = 0; i < this.listeners.length; ++i) {
            VetoableChangeListener vetoableChangeListener = this.listeners[i];
            if (!(this.listeners[i] instanceof Serializable)) continue;
            objectOutputStream.writeObject(this.listeners[i]);
        }
        objectOutputStream.writeObject(null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        Object object;
        this.listeners = new VetoableChangeListener[0];
        objectInputStream.defaultReadObject();
        while (null != (object = objectInputStream.readObject())) {
            this.addVetoableChangeListener((VetoableChangeListener)object);
        }
    }
}

