/*
 * Decompiled with CFR 0.152.
 */
package edu.oswego.cs.dl.util.concurrent;

import edu.oswego.cs.dl.util.concurrent.BoundedChannel;
import edu.oswego.cs.dl.util.concurrent.Semaphore;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public abstract class SemaphoreControlledChannel
implements BoundedChannel {
    protected final Semaphore putGuard_;
    protected final Semaphore takeGuard_;
    protected int capacity_;

    public SemaphoreControlledChannel(int n) throws IllegalArgumentException {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        this.capacity_ = n;
        this.putGuard_ = new Semaphore(n);
        this.takeGuard_ = new Semaphore(0L);
    }

    public SemaphoreControlledChannel(int n, Class clazz) throws IllegalArgumentException, NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, InvocationTargetException {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        this.capacity_ = n;
        Class[] classArray = new Class[]{Integer.TYPE};
        Constructor constructor = clazz.getDeclaredConstructor(classArray);
        Object[] objectArray = new Integer[]{new Integer(n)};
        this.putGuard_ = (Semaphore)constructor.newInstance(objectArray);
        Object[] objectArray2 = new Integer[]{new Integer(0)};
        this.takeGuard_ = (Semaphore)constructor.newInstance(objectArray2);
    }

    public int capacity() {
        return this.capacity_;
    }

    public int size() {
        return (int)this.takeGuard_.permits();
    }

    protected abstract void insert(Object var1);

    protected abstract Object extract();

    public void put(Object object) throws InterruptedException {
        if (object == null) {
            throw new IllegalArgumentException();
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        this.putGuard_.acquire();
        try {
            this.insert(object);
            this.takeGuard_.release();
        }
        catch (ClassCastException classCastException) {
            this.putGuard_.release();
            throw classCastException;
        }
    }

    public boolean offer(Object object, long l) throws InterruptedException {
        if (object == null) {
            throw new IllegalArgumentException();
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (!this.putGuard_.attempt(l)) {
            return false;
        }
        try {
            this.insert(object);
            this.takeGuard_.release();
            return true;
        }
        catch (ClassCastException classCastException) {
            this.putGuard_.release();
            throw classCastException;
        }
    }

    public Object take() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        this.takeGuard_.acquire();
        try {
            Object object = this.extract();
            this.putGuard_.release();
            return object;
        }
        catch (ClassCastException classCastException) {
            this.takeGuard_.release();
            throw classCastException;
        }
    }

    public Object poll(long l) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (!this.takeGuard_.attempt(l)) {
            return null;
        }
        try {
            Object object = this.extract();
            this.putGuard_.release();
            return object;
        }
        catch (ClassCastException classCastException) {
            this.takeGuard_.release();
            throw classCastException;
        }
    }
}

