/*
 * Decompiled with CFR 0.152.
 */
package edu.oswego.cs.dl.util.concurrent;

import edu.oswego.cs.dl.util.concurrent.BoundedLinkedQueue;
import edu.oswego.cs.dl.util.concurrent.Channel;
import edu.oswego.cs.dl.util.concurrent.Executor;
import edu.oswego.cs.dl.util.concurrent.ThreadFactoryUser;

public class QueuedExecutor
extends ThreadFactoryUser
implements Executor {
    protected Thread thread_;
    protected static Runnable ENDTASK = new Runnable(){

        public void run() {
        }
    };
    protected volatile boolean shutdown_;
    protected final Channel queue_;
    protected final RunLoop runLoop_;

    public synchronized Thread getThread() {
        return this.thread_;
    }

    protected synchronized void clearThread() {
        this.thread_ = null;
    }

    public QueuedExecutor(Channel channel) {
        this.queue_ = channel;
        this.runLoop_ = new RunLoop();
    }

    public QueuedExecutor() {
        this(new BoundedLinkedQueue());
    }

    public synchronized void restart() {
        if (this.thread_ == null && !this.shutdown_) {
            this.thread_ = this.threadFactory_.newThread(this.runLoop_);
            this.thread_.start();
        }
    }

    public void execute(Runnable runnable) throws InterruptedException {
        this.restart();
        this.queue_.put(runnable);
    }

    public synchronized void shutdownAfterProcessingCurrentlyQueuedTasks() {
        if (this.thread_ != null && !this.shutdown_) {
            try {
                this.queue_.put(ENDTASK);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public synchronized void shutdownAfterProcessingCurrentTask() {
        this.shutdown_ = true;
        if (this.thread_ != null) {
            try {
                while (this.queue_.poll(0L) != null) {
                }
                this.queue_.put(ENDTASK);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public synchronized void shutdownNow() {
        this.shutdown_ = true;
        if (this.thread_ != null) {
            this.thread_.interrupt();
            this.shutdownAfterProcessingCurrentTask();
        }
    }

    protected class RunLoop
    implements Runnable {
        protected RunLoop() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                while (!QueuedExecutor.this.shutdown_) {
                    Runnable runnable = (Runnable)QueuedExecutor.this.queue_.take();
                    if (runnable == ENDTASK) {
                        QueuedExecutor.this.shutdown_ = true;
                    } else if (runnable != null) {
                        runnable.run();
                        runnable = null;
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                QueuedExecutor.this.clearThread();
            }
        }
    }
}

