/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.random;

import cern.jet.random.AbstractContinousDistribution;
import edu.cornell.lassp.houle.RngPack.RandomElement;

public class BreitWigner
extends AbstractContinousDistribution {
    protected double mean;
    protected double gamma;
    protected double cut;
    protected static BreitWigner shared = new BreitWigner(1.0, 0.2, 1.0, BreitWigner.makeDefaultGenerator());

    public BreitWigner(double d, double d2, double d3, RandomElement randomElement) {
        this.setRandomGenerator(randomElement);
        this.setState(d, d2, d3);
    }

    public double nextDouble() {
        return this.nextDouble(this.mean, this.gamma, this.cut);
    }

    public double nextDouble(double d, double d2, double d3) {
        if (d2 == 0.0) {
            return d;
        }
        if (d3 == Double.NEGATIVE_INFINITY) {
            double d4 = 2.0 * this.randomGenerator.raw() - 1.0;
            double d5 = 0.5 * d2 * Math.tan(d4 * 1.5707963267948966);
            return d + d5;
        }
        double d6 = Math.atan(2.0 * d3 / d2);
        double d7 = 2.0 * this.randomGenerator.raw() - 1.0;
        double d8 = 0.5 * d2 * Math.tan(d7 * d6);
        return d + d8;
    }

    public void setState(double d, double d2, double d3) {
        this.mean = d;
        this.gamma = d2;
        this.cut = d3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double staticNextDouble(double d, double d2, double d3) {
        BreitWigner breitWigner = shared;
        synchronized (breitWigner) {
            return shared.nextDouble(d, d2, d3);
        }
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.mean + "," + this.gamma + "," + this.cut + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void xstaticSetRandomGenerator(RandomElement randomElement) {
        BreitWigner breitWigner = shared;
        synchronized (breitWigner) {
            shared.setRandomGenerator(randomElement);
        }
    }
}

