/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.random;

import cern.jet.random.AbstractContinousDistribution;
import cern.jet.random.Fun;
import cern.jet.stat.Probability;
import edu.cornell.lassp.houle.RngPack.RandomElement;

public class Beta
extends AbstractContinousDistribution {
    protected double alpha;
    protected double beta;
    double PDF_CONST;
    double a_last = 0.0;
    double b_last = 0.0;
    double a_;
    double b_;
    double t;
    double fa;
    double fb;
    double p1;
    double p2;
    double c;
    double ml;
    double mu;
    double p_last = 0.0;
    double q_last = 0.0;
    double a;
    double b;
    double s;
    double m;
    double D;
    double Dl;
    double x1;
    double x2;
    double x4;
    double x5;
    double f1;
    double f2;
    double f4;
    double f5;
    double ll;
    double lr;
    double z2;
    double z4;
    double p3;
    double p4;
    protected static Beta shared = new Beta(10.0, 10.0, Beta.makeDefaultGenerator());

    public Beta(double d, double d2, RandomElement randomElement) {
        this.setRandomGenerator(randomElement);
        this.setState(d, d2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected double b00(double d, double d2, RandomElement randomElement) {
        if (d != this.a_last || d2 != this.b_last) {
            this.a_last = d;
            this.b_last = d2;
            this.a_ = d - 1.0;
            this.b_ = d2 - 1.0;
            this.c = d2 * this.b_ / (d * this.a_);
            this.t = this.c == 1.0 ? 0.5 : (1.0 - Math.sqrt(this.c)) / (1.0 - this.c);
            this.fa = Math.exp(this.a_ * Math.log(this.t));
            this.fb = Math.exp(this.b_ * Math.log(1.0 - this.t));
            this.p1 = this.t / d;
            this.p2 = (1.0 - this.t) / d2 + this.p1;
        }
        while (true) {
            double d3;
            double d4;
            double d5;
            double d6;
            double d7;
            double d8 = randomElement.raw() * this.p2;
            if (d7 <= this.p1) {
                double d9;
                d6 = Math.exp(Math.log(d8 / this.p1) / d);
                d5 = this.t * d6;
                d4 = randomElement.raw() * this.fb;
                if (!(d9 <= 1.0 - this.b_ * d5) && (!(d4 <= 1.0 + (this.fb - 1.0) * d6) || !(Math.log(d4) <= this.b_ * Math.log(1.0 - d5)))) continue;
                return d5;
            }
            d6 = Math.exp(Math.log((d8 - this.p1) / (this.p2 - this.p1)) / d2);
            d5 = 1.0 - (1.0 - this.t) * d6;
            d4 = randomElement.raw() * this.fa;
            if (d3 <= 1.0 - this.a_ * (1.0 - d5) || d4 <= 1.0 + (this.fa - 1.0) * d6 && Math.log(d4) <= this.a_ * Math.log(d5)) return d5;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected double b01(double d, double d2, RandomElement randomElement) {
        if (d != this.a_last || d2 != this.b_last) {
            this.a_last = d;
            this.b_last = d2;
            this.a_ = d - 1.0;
            this.b_ = d2 - 1.0;
            this.t = this.a_ / (d - d2);
            this.fb = Math.exp((this.b_ - 1.0) * Math.log(1.0 - this.t));
            this.fa = d - (d + this.b_) * this.t;
            this.t -= (this.t - (1.0 - this.fa) * (1.0 - this.t) * this.fb / d2) / (1.0 - this.fa * this.fb);
            this.fa = Math.exp(this.a_ * Math.log(this.t));
            this.fb = Math.exp(this.b_ * Math.log(1.0 - this.t));
            if (this.b_ <= 1.0) {
                this.ml = (1.0 - this.fb) / this.t;
                this.mu = this.b_ * this.t;
            } else {
                this.ml = this.b_;
                this.mu = 1.0 - this.fb;
            }
            this.p1 = this.t / d;
            this.p2 = this.fb * (1.0 - this.t) / d2 + this.p1;
        }
        while (true) {
            double d3;
            double d4;
            double d5;
            double d6;
            double d7;
            double d8 = randomElement.raw() * this.p2;
            if (d7 <= this.p1) {
                double d9;
                d6 = Math.exp(Math.log(d8 / this.p1) / d);
                d5 = this.t * d6;
                d4 = randomElement.raw();
                if (!(d9 <= 1.0 - this.ml * d5) && (!(d4 <= 1.0 - this.mu * d6) || !(Math.log(d4) <= this.b_ * Math.log(1.0 - d5)))) continue;
                return d5;
            }
            d6 = Math.exp(Math.log((d8 - this.p1) / (this.p2 - this.p1)) / d2);
            d5 = 1.0 - (1.0 - this.t) * d6;
            d4 = randomElement.raw() * this.fa;
            if (d3 <= 1.0 - this.a_ * (1.0 - d5) || d4 <= 1.0 + (this.fa - 1.0) * d6 && Math.log(d4) <= this.a_ * Math.log(d5)) return d5;
        }
    }

    protected double b1prs(double d, double d2, RandomElement randomElement) {
        double d3;
        if (d != this.p_last || d2 != this.q_last) {
            this.p_last = d;
            this.q_last = d2;
            this.a = d - 1.0;
            this.b = d2 - 1.0;
            this.s = this.a + this.b;
            this.m = this.a / this.s;
            if (this.a > 1.0 || this.b > 1.0) {
                this.D = Math.sqrt(this.m * (1.0 - this.m) / (this.s - 1.0));
            }
            if (this.a <= 1.0) {
                this.x2 = this.Dl = this.m * 0.5;
                this.z2 = 0.0;
                this.x1 = 0.0;
                this.ll = 0.0;
                this.f1 = 0.0;
            } else {
                this.x2 = this.m - this.D;
                this.x1 = this.x2 - this.D;
                this.z2 = this.x2 * (1.0 - (1.0 - this.x2) / (this.s * this.D));
                if (this.x1 <= 0.0 || (this.s - 6.0) * this.x2 - this.a + 3.0 > 0.0) {
                    this.x1 = this.z2;
                    this.x2 = (this.x1 + this.m) * 0.5;
                    this.Dl = this.m - this.x2;
                } else {
                    this.Dl = this.D;
                }
                this.f1 = Beta.f(this.x1, this.a, this.b, this.m);
                this.ll = this.x1 * (1.0 - this.x1) / (this.s * (this.m - this.x1));
            }
            this.f2 = Beta.f(this.x2, this.a, this.b, this.m);
            if (this.b <= 1.0) {
                this.D = (1.0 - this.m) * 0.5;
                this.x4 = 1.0 - this.D;
                this.z4 = 1.0;
                this.x5 = 1.0;
                this.lr = 0.0;
                this.f5 = 0.0;
            } else {
                this.x4 = this.m + this.D;
                this.x5 = this.x4 + this.D;
                this.z4 = this.x4 * (1.0 + (1.0 - this.x4) / (this.s * this.D));
                if (this.x5 >= 1.0 || (this.s - 6.0) * this.x4 - this.a + 3.0 < 0.0) {
                    this.x5 = this.z4;
                    this.x4 = (this.m + this.x5) * 0.5;
                    this.D = this.x4 - this.m;
                }
                this.f5 = Beta.f(this.x5, this.a, this.b, this.m);
                this.lr = this.x5 * (1.0 - this.x5) / (this.s * (this.x5 - this.m));
            }
            this.f4 = Beta.f(this.x4, this.a, this.b, this.m);
            this.p1 = this.f2 * (this.Dl + this.Dl);
            this.p2 = this.f4 * (this.D + this.D) + this.p1;
            this.p3 = this.f1 * this.ll + this.p2;
            this.p4 = this.f5 * this.lr + this.p3;
        }
        while (true) {
            double d4;
            double d5;
            double d6;
            double d7;
            double d8 = randomElement.raw() * this.p4;
            if (d7 <= this.p1) {
                double d9;
                double d10;
                d6 = d8 / this.Dl - this.f2;
                if (d10 <= 0.0) {
                    return this.m - d8 / this.f2;
                }
                if (d6 <= this.f1) {
                    return this.x2 - d6 / this.f1 * this.Dl;
                }
                d8 = randomElement.raw();
                d5 = this.Dl * d8;
                d3 = this.x2 - d5;
                d4 = this.x2 + d5;
                if (d6 * (this.x2 - this.z2) <= this.f2 * (d3 - this.z2)) {
                    return d3;
                }
                d5 = this.f2 + this.f2 - d6;
                if (d9 < 1.0) {
                    if (d5 <= this.f2 + (1.0 - this.f2) * d8) {
                        return d4;
                    }
                    if (d5 <= Beta.f(d4, this.a, this.b, this.m)) {
                        return d4;
                    }
                }
            } else if (d8 <= this.p2) {
                double d11;
                double d12;
                d6 = (d8 -= this.p1) / this.D - this.f4;
                if (d12 <= 0.0) {
                    return this.m + d8 / this.f4;
                }
                if (d6 <= this.f5) {
                    return this.x4 + d6 / this.f5 * this.D;
                }
                d8 = randomElement.raw();
                d5 = this.D * d8;
                d3 = this.x4 + d5;
                d4 = this.x4 - d5;
                if (d6 * (this.z4 - this.x4) <= this.f4 * (this.z4 - d3)) {
                    return d3;
                }
                d5 = this.f4 + this.f4 - d6;
                if (d11 < 1.0) {
                    if (d5 <= this.f4 + (1.0 - this.f4) * d8) {
                        return d4;
                    }
                    if (d5 <= Beta.f(d4, this.a, this.b, this.m)) {
                        return d4;
                    }
                }
            } else if (d8 <= this.p3) {
                double d13;
                d8 = (d8 - this.p2) / (this.p3 - this.p2);
                d4 = Math.log(d8);
                d3 = this.x1 + this.ll * d4;
                if (d13 <= 0.0) continue;
                d6 = randomElement.raw() * d8;
                if (d6 <= 1.0 + d4) {
                    return d3;
                }
                d6 *= this.f1;
            } else {
                double d14;
                d8 = (d8 - this.p3) / (this.p4 - this.p3);
                d4 = Math.log(d8);
                d3 = this.x5 - this.lr * d4;
                if (d14 >= 1.0) continue;
                d6 = randomElement.raw() * d8;
                if (d6 <= 1.0 + d4) {
                    return d3;
                }
                d6 *= this.f5;
            }
            if (Math.log(d6) <= this.a * Math.log(d3 / this.m) + this.b * Math.log((1.0 - d3) / (1.0 - this.m))) break;
        }
        return d3;
    }

    public double cdf(double d) {
        return Probability.beta(this.alpha, this.beta, d);
    }

    private static double f(double d, double d2, double d3, double d4) {
        return Math.exp(d2 * Math.log(d / d4) + d3 * Math.log((1.0 - d) / (1.0 - d4)));
    }

    public double nextDouble() {
        return this.nextDouble(this.alpha, this.beta);
    }

    public double nextDouble(double d, double d2) {
        double d3 = d;
        double d4 = d2;
        if (d3 > 1.0) {
            if (d4 > 1.0) {
                return this.b1prs(d3, d4, this.randomGenerator);
            }
            if (d4 < 1.0) {
                return 1.0 - this.b01(d4, d3, this.randomGenerator);
            }
            if (d4 == 1.0) {
                return Math.exp(Math.log(this.randomGenerator.raw()) / d3);
            }
        }
        if (d3 < 1.0) {
            if (d4 > 1.0) {
                return this.b01(d3, d4, this.randomGenerator);
            }
            if (d4 < 1.0) {
                return this.b00(d3, d4, this.randomGenerator);
            }
            if (d4 == 1.0) {
                return Math.exp(Math.log(this.randomGenerator.raw()) / d3);
            }
        }
        if (d3 == 1.0) {
            if (d4 != 1.0) {
                return 1.0 - Math.exp(Math.log(this.randomGenerator.raw()) / d4);
            }
            if (d4 == 1.0) {
                return this.randomGenerator.raw();
            }
        }
        return 0.0;
    }

    public double pdf(double d) {
        if (d < 0.0 || d > 1.0) {
            return 0.0;
        }
        return Math.exp(this.PDF_CONST) * Math.pow(d, this.alpha - 1.0) * Math.pow(1.0 - d, this.beta - 1.0);
    }

    public void setState(double d, double d2) {
        this.alpha = d;
        this.beta = d2;
        this.PDF_CONST = Fun.logGamma(d + d2) - Fun.logGamma(d) - Fun.logGamma(d2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double staticNextDouble(double d, double d2) {
        Beta beta = shared;
        synchronized (beta) {
            return shared.nextDouble(d, d2);
        }
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.alpha + "," + this.beta + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void xstaticSetRandomGenerator(RandomElement randomElement) {
        Beta beta = shared;
        synchronized (beta) {
            shared.setRandomGenerator(randomElement);
        }
    }
}

