/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.random;

import cern.colt.PersistentObject;
import cern.colt.Timer;
import cern.colt.list.DoubleArrayList;
import cern.colt.list.IntArrayList;
import cern.jet.random.AbstractDistribution;
import cern.jet.random.Gamma;
import cern.jet.random.Poisson;
import cern.jet.random.engine.MersenneTwister;
import edu.cornell.lassp.houle.RngPack.RandomElement;
import hep.aida.bin.DynamicBin1D;

public class Benchmark
extends PersistentObject {
    protected RandomElement randomGenerator;

    protected Benchmark() {
        throw new RuntimeException("Non instantiable");
    }

    public static void demo1() {
        double d = 5.0;
        double d2 = 1.5;
        double d3 = d * d / d2;
        double d4 = 1.0 / (d2 / d);
        MersenneTwister mersenneTwister = new MersenneTwister();
        Gamma gamma = new Gamma(d3, d4, mersenneTwister);
        int n = 100000;
        DoubleArrayList doubleArrayList = new DoubleArrayList(n);
        for (int i = 0; i < n; ++i) {
            doubleArrayList.add(((AbstractDistribution)gamma).nextDouble());
        }
        DynamicBin1D dynamicBin1D = new DynamicBin1D();
        dynamicBin1D.addAllOf(doubleArrayList);
        System.out.println(dynamicBin1D);
    }

    public static void main(String[] stringArray) {
        int n = Integer.parseInt(stringArray[0]);
        boolean bl = new Boolean(stringArray[1]);
        double d = new Double(stringArray[2]);
        String string = stringArray[3];
        Benchmark.random(n, bl, d, string);
    }

    public static void random(int n, boolean bl, double d, String string) {
        RandomElement randomElement;
        System.out.println("Generating " + n + " random numbers per distribution...\n");
        int n2 = 100;
        try {
            randomElement = (RandomElement)Class.forName(string).newInstance();
        }
        catch (Exception exception) {
            throw new InternalError(exception.getMessage());
        }
        Benchmark.randomInstance(n, bl, new Poisson(d, (RandomElement)randomElement.clone()));
    }

    public static void randomInstance(int n, boolean bl, AbstractDistribution abstractDistribution) {
        System.out.print("\n" + abstractDistribution + " ...");
        Timer timer = new Timer().start();
        int n2 = n;
        while (--n2 >= 0) {
            double d = abstractDistribution.nextDouble();
            if (!bl) continue;
            if ((n - n2 - 1) % 8 == 0) {
                System.out.println();
            }
            System.out.print((float)d + ", ");
        }
        timer.stop();
        System.out.println("\n" + timer);
    }

    public static void test(int n, AbstractDistribution abstractDistribution) {
        int n2 = 0;
        int n3 = n;
        while (--n3 >= 0) {
            System.out.print(" " + abstractDistribution.nextDouble());
            if (n2 % 8 == 7) {
                System.out.println();
            }
            ++n2;
        }
        System.out.println("\n\nGood bye.\n");
    }

    public static void test2(int n, AbstractDistribution abstractDistribution) {
        DynamicBin1D dynamicBin1D = new DynamicBin1D();
        int n2 = 0;
        int n3 = n;
        while (--n3 >= 0) {
            dynamicBin1D.add(abstractDistribution.nextDouble());
            ++n2;
        }
        System.out.println(dynamicBin1D);
        System.out.println("\n\nGood bye.\n");
    }

    public static void test2(int n, AbstractDistribution abstractDistribution, AbstractDistribution abstractDistribution2) {
        DynamicBin1D dynamicBin1D = new DynamicBin1D();
        DynamicBin1D dynamicBin1D2 = new DynamicBin1D();
        int n2 = 0;
        int n3 = n;
        while (--n3 >= 0) {
            dynamicBin1D.add(abstractDistribution.nextDouble());
            dynamicBin1D2.add(abstractDistribution2.nextDouble());
            ++n2;
        }
        System.out.println("\n\nBenchmarking frequencies...\n");
        IntArrayList intArrayList = new IntArrayList();
        DoubleArrayList doubleArrayList = new DoubleArrayList();
        Timer timer = new Timer();
        timer.reset();
        timer.start();
        dynamicBin1D.frequencies(doubleArrayList, intArrayList);
        timer.stop().display();
        System.out.println("\n\nGood bye.\n");
    }
}

