/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.math;

import cern.colt.function.DoubleDoubleFunction;
import cern.colt.function.DoubleFunction;
import cern.colt.function.ThresholdVectorVectorFunction;
import cern.colt.function.VectorFunction;
import cern.colt.function.VectorVectorFunction;
import cern.colt.list.DoubleArrayList;
import cern.colt.matrix.DoubleMatrix1D;
import cern.jet.math.Functions;
import cern.jet.stat.quantile.DoubleQuantileFinder;
import cern.jet.stat.quantile.QuantileFinderFactory;

public class VectorFunctions {
    private static final Functions F = Functions.functions;
    public static final VectorFunctions vectorFunctions = new VectorFunctions();
    public static final VectorFunction max = new VectorFunction(){

        public final double apply(DoubleMatrix1D doubleMatrix1D) {
            F;
            F;
            return doubleMatrix1D.aggregate(Functions.max, Functions.identity);
        }
    };
    public static final VectorFunction maxNaN = new VectorFunction(){

        public final double apply(DoubleMatrix1D doubleMatrix1D) {
            F;
            F;
            return doubleMatrix1D.aggregate(Functions.maxNaN, Functions.identity);
        }
    };
    public static final VectorFunction min = new VectorFunction(){

        public final double apply(DoubleMatrix1D doubleMatrix1D) {
            F;
            F;
            return doubleMatrix1D.aggregate(Functions.min, Functions.identity);
        }
    };
    public static final VectorFunction minNaN = new VectorFunction(){

        public final double apply(DoubleMatrix1D doubleMatrix1D) {
            F;
            F;
            return doubleMatrix1D.aggregate(Functions.minNaN, Functions.identity);
        }
    };
    public static final VectorFunction mean = new VectorFunction(){

        public final double apply(DoubleMatrix1D doubleMatrix1D) {
            F;
            F;
            return doubleMatrix1D.aggregate(Functions.plus, Functions.identity) / (double)doubleMatrix1D.size();
        }
    };
    public static final VectorFunction meanNaN = new VectorFunction(){

        public final double apply(DoubleMatrix1D doubleMatrix1D) {
            F;
            F;
            double d = doubleMatrix1D.aggregate(Functions.plusNaN, Functions.identity);
            double d2 = doubleMatrix1D.size();
            F;
            F;
            return d / (d2 - doubleMatrix1D.aggregate(Functions.plus, Functions.isNaN));
        }
    };
    public static final VectorFunction nans = new VectorFunction(){

        public final double apply(DoubleMatrix1D doubleMatrix1D) {
            F;
            F;
            return doubleMatrix1D.aggregate(Functions.plus, Functions.isNaN);
        }
    };
    public static final VectorFunction standardDeviation = new VectorFunction(){

        public final double apply(DoubleMatrix1D doubleMatrix1D) {
            return Math.sqrt(variance.apply(doubleMatrix1D));
        }
    };
    public static final VectorFunction standardDeviationNaN = new VectorFunction(){

        public final double apply(DoubleMatrix1D doubleMatrix1D) {
            return Math.sqrt(varianceNaN.apply(doubleMatrix1D));
        }
    };
    public static final VectorFunction sum = new VectorFunction(){

        public final double apply(DoubleMatrix1D doubleMatrix1D) {
            F;
            F;
            return doubleMatrix1D.aggregate(Functions.plus, Functions.identity);
        }
    };
    public static final VectorFunction sumNaN = new VectorFunction(){

        public final double apply(DoubleMatrix1D doubleMatrix1D) {
            F;
            F;
            return doubleMatrix1D.aggregate(Functions.plusNaN, Functions.identity);
        }
    };
    public static final VectorFunction variance = new VectorFunction(){

        public final double apply(DoubleMatrix1D doubleMatrix1D) {
            double d = mean.apply(doubleMatrix1D);
            F;
            F;
            double d2 = doubleMatrix1D.aggregate(Functions.plus, Functions.square);
            F;
            F;
            return (d2 - d * doubleMatrix1D.aggregate(Functions.plus, Functions.identity)) / (double)(doubleMatrix1D.size() - 1);
        }
    };
    public static final VectorFunction varianceNaN = new VectorFunction(){

        public final double apply(DoubleMatrix1D doubleMatrix1D) {
            double d = meanNaN.apply(doubleMatrix1D);
            F;
            F;
            double d2 = doubleMatrix1D.aggregate(Functions.plusNaN, Functions.square);
            F;
            F;
            return (d2 - d * doubleMatrix1D.aggregate(Functions.plusNaN, Functions.identity)) / ((double)(doubleMatrix1D.size() - 1) - nans.apply(doubleMatrix1D));
        }
    };
    public static final VectorVectorFunction MANHATTAN = new VectorVectorFunction(){

        public final double apply(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
            F;
            F;
            F;
            F;
            return doubleMatrix1D.aggregate(doubleMatrix1D2, Functions.plus, Functions.chain(Functions.abs, Functions.minus));
        }
    };
    public static final ThresholdVectorVectorFunction MANHATTAN_UPTO = new ThresholdVectorVectorFunction(){
        protected double threshold;

        public final void setThreshold(double d) {
            this.threshold = d;
        }

        public final double apply(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
            F;
            F;
            F;
            F;
            return doubleMatrix1D.aggregateUpTo(doubleMatrix1D2, Functions.plus, Functions.chain(Functions.abs, Functions.minus), this.threshold);
        }
    };
    public static final VectorVectorFunction MANHATTAN_NAN = new VectorVectorFunction(){

        public final double apply(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
            F;
            F;
            F;
            F;
            return doubleMatrix1D.aggregate(doubleMatrix1D2, Functions.plusNaN, Functions.chain(Functions.abs, Functions.minus));
        }
    };
    public static final ThresholdVectorVectorFunction MANHATTAN_NAN_UPTO = new ThresholdVectorVectorFunction(){
        protected double threshold;

        public final void setThreshold(double d) {
            this.threshold = d;
        }

        public final double apply(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
            F;
            F;
            F;
            F;
            return doubleMatrix1D.aggregateUpTo(doubleMatrix1D2, Functions.plusNaN, Functions.chain(Functions.abs, Functions.minus), this.threshold);
        }
    };
    public static final VectorVectorFunction EUCLID = new VectorVectorFunction(){

        public final double apply(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
            F;
            F;
            F;
            F;
            return Math.sqrt(doubleMatrix1D.aggregate(doubleMatrix1D2, Functions.plus, Functions.chain(Functions.square, Functions.minus)));
        }
    };
    public static final ThresholdVectorVectorFunction EUCLID_UPTO = new ThresholdVectorVectorFunction(){
        protected double threshold;

        public final void setThreshold(double d) {
            this.threshold = Math.pow(d, 2.0);
        }

        public final double apply(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
            F;
            F;
            F;
            F;
            return Math.sqrt(doubleMatrix1D.aggregateUpTo(doubleMatrix1D2, Functions.plus, Functions.chain(Functions.square, Functions.minus), this.threshold));
        }
    };
    public static final VectorVectorFunction EUCLID_NAN = new VectorVectorFunction(){

        public final double apply(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
            F;
            F;
            F;
            F;
            return Math.sqrt(doubleMatrix1D.aggregate(doubleMatrix1D2, Functions.plusNaN, Functions.chain(Functions.square, Functions.minus)));
        }
    };
    public static final ThresholdVectorVectorFunction EUCLID_NAN_UPTO = new ThresholdVectorVectorFunction(){
        protected double threshold;

        public final void setThreshold(double d) {
            this.threshold = Math.pow(d, 2.0);
        }

        public final double apply(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
            F;
            F;
            F;
            F;
            return Math.sqrt(doubleMatrix1D.aggregateUpTo(doubleMatrix1D2, Functions.plusNaN, Functions.chain(Functions.square, Functions.minus), this.threshold));
        }
    };
    public static final VectorVectorFunction SQUARED_EUCLID = new VectorVectorFunction(){

        public final double apply(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
            F;
            F;
            F;
            F;
            return doubleMatrix1D.aggregate(doubleMatrix1D2, Functions.plus, Functions.chain(Functions.square, Functions.minus));
        }
    };
    public static final ThresholdVectorVectorFunction SQUARED_EUCLID_UPTO = new ThresholdVectorVectorFunction(){
        protected double threshold;

        public final void setThreshold(double d) {
            this.threshold = d;
        }

        public final double apply(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
            F;
            F;
            F;
            F;
            return doubleMatrix1D.aggregateUpTo(doubleMatrix1D2, Functions.plus, Functions.chain(Functions.square, Functions.minus), this.threshold);
        }
    };
    public static final VectorVectorFunction SQUARED_EUCLID_NAN = new VectorVectorFunction(){

        public final double apply(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
            F;
            F;
            F;
            F;
            return doubleMatrix1D.aggregate(doubleMatrix1D2, Functions.plusNaN, Functions.chain(Functions.square, Functions.minus));
        }
    };
    public static final ThresholdVectorVectorFunction SQUARED_EUCLID_NAN_UPTO = new ThresholdVectorVectorFunction(){
        protected double threshold;

        public final void setThreshold(double d) {
            this.threshold = d;
        }

        public final double apply(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
            F;
            F;
            F;
            F;
            return doubleMatrix1D.aggregateUpTo(doubleMatrix1D2, Functions.plusNaN, Functions.chain(Functions.square, Functions.minus), this.threshold);
        }
    };
    public static final VectorVectorFunction MAXIMUM = new VectorVectorFunction(){

        public final double apply(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
            F;
            F;
            F;
            F;
            return doubleMatrix1D.aggregate(doubleMatrix1D2, Functions.max, Functions.chain(Functions.abs, Functions.minus));
        }
    };
    public static final ThresholdVectorVectorFunction MAXIMUM_UPTO = new ThresholdVectorVectorFunction(){
        protected double threshold;

        public final void setThreshold(double d) {
            this.threshold = d;
        }

        public final double apply(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
            F;
            F;
            F;
            F;
            return doubleMatrix1D.aggregateUpTo(doubleMatrix1D2, Functions.max, Functions.chain(Functions.abs, Functions.minus), this.threshold);
        }
    };
    public static final VectorVectorFunction MAXIMUM_NAN = new VectorVectorFunction(){

        public final double apply(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
            F;
            F;
            F;
            F;
            return doubleMatrix1D.aggregate(doubleMatrix1D2, Functions.maxNaN, Functions.chain(Functions.abs, Functions.minus));
        }
    };
    public static final ThresholdVectorVectorFunction MAXIMUM_NAN_UPTO = new ThresholdVectorVectorFunction(){
        protected double threshold;

        public final void setThreshold(double d) {
            this.threshold = d;
        }

        public final double apply(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
            F;
            F;
            F;
            F;
            return doubleMatrix1D.aggregateUpTo(doubleMatrix1D2, Functions.maxNaN, Functions.chain(Functions.abs, Functions.minus), this.threshold);
        }
    };
    public static final VectorVectorFunction CORRELATION = new VectorVectorFunction(){

        public final double apply(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
            return 1.0 - correlation.apply(doubleMatrix1D, doubleMatrix1D2);
        }
    };
    public static final VectorVectorFunction CORRELATION_NAN = new VectorVectorFunction(){

        public final double apply(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
            return 1.0 - correlationNaN.apply(doubleMatrix1D, doubleMatrix1D2);
        }
    };
    public static final VectorVectorFunction COSINE = new VectorVectorFunction(){

        public final double apply(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
            int n = doubleMatrix1D.size();
            double d = dotProduct.apply(doubleMatrix1D, doubleMatrix1D2);
            double d2 = dotProduct.apply(doubleMatrix1D, doubleMatrix1D);
            double d3 = dotProduct.apply(doubleMatrix1D2, doubleMatrix1D2);
            return 1.0 - d / Math.sqrt(d2) / Math.sqrt(d3);
        }
    };
    public static final VectorVectorFunction COSINE_NAN = new VectorVectorFunction(){

        public final double apply(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
            int n = doubleMatrix1D.size();
            double d = dotProductNaN.apply(doubleMatrix1D, doubleMatrix1D2);
            double d2 = dotProductNaN.apply(doubleMatrix1D, doubleMatrix1D);
            double d3 = dotProductNaN.apply(doubleMatrix1D2, doubleMatrix1D2);
            return 1.0 - d / Math.sqrt(d2) / Math.sqrt(d3);
        }
    };
    public static final VectorVectorFunction BRAY_CURTIS = new VectorVectorFunction(){

        public final double apply(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
            F;
            F;
            F;
            F;
            double d = doubleMatrix1D.aggregate(doubleMatrix1D2, Functions.plus, Functions.chain(Functions.abs, Functions.minus));
            F;
            F;
            return d / doubleMatrix1D.aggregate(doubleMatrix1D2, Functions.plus, Functions.plus);
        }
    };
    public static final VectorVectorFunction CANBERRA = new VectorVectorFunction(){
        DoubleDoubleFunction fun = new DoubleDoubleFunction(this){
            private final /* synthetic */ 50 this$0;
            {
                this.this$0 = var1_1;
            }

            public final double apply(double d, double d2) {
                return Math.abs(d - d2) / Math.abs(d + d2);
            }
        };

        public final double apply(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
            F;
            return doubleMatrix1D.aggregate(doubleMatrix1D2, Functions.plus, this.fun);
        }
    };
    public static final VectorVectorFunction covariance = new VectorVectorFunction(){

        public final double apply(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
            int n = doubleMatrix1D.size();
            double d = mean.apply(doubleMatrix1D);
            double d2 = mean.apply(doubleMatrix1D2);
            double d3 = 0.0;
            for (int i = 0; i < n; ++i) {
                d3 += (doubleMatrix1D.getQuick(i) - d) * (doubleMatrix1D2.getQuick(i) - d2);
            }
            return d3 / (double)(n - 1);
        }
    };
    public static final VectorVectorFunction covarianceNaN = new VectorVectorFunction(){

        public final double apply(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
            int n = doubleMatrix1D.size();
            double d = 0.0;
            double d2 = 0.0;
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                if (Double.isNaN(doubleMatrix1D.getQuick(i)) || Double.isNaN(doubleMatrix1D2.getQuick(i))) continue;
                d += doubleMatrix1D.getQuick(i);
                d2 += doubleMatrix1D2.getQuick(i);
                ++n2;
            }
            d /= (double)n2;
            d2 /= (double)n2;
            double d3 = 0.0;
            for (int i = 0; i < n; ++i) {
                if (Double.isNaN(doubleMatrix1D.getQuick(i)) || Double.isNaN(doubleMatrix1D2.getQuick(i))) continue;
                d3 += (doubleMatrix1D.getQuick(i) - d) * (doubleMatrix1D2.getQuick(i) - d2);
            }
            return d3 / (double)(n2 - 1);
        }
    };
    public static final VectorVectorFunction correlation = new VectorVectorFunction(){

        public final double apply(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
            double d = standardDeviation.apply(doubleMatrix1D);
            double d2 = standardDeviation.apply(doubleMatrix1D2);
            return covariance.apply(doubleMatrix1D, doubleMatrix1D2) / (d * d2);
        }
    };
    public static final VectorVectorFunction correlationNaN = new VectorVectorFunction(){

        public final double apply(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
            double d = standardDeviationNaN.apply(doubleMatrix1D);
            double d2 = standardDeviationNaN.apply(doubleMatrix1D2);
            return covarianceNaN.apply(doubleMatrix1D, doubleMatrix1D2) / (d * d2);
        }
    };
    public static final VectorVectorFunction dotProduct = new VectorVectorFunction(){

        public final double apply(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
            F;
            F;
            return doubleMatrix1D.aggregate(doubleMatrix1D2, Functions.plus, Functions.mult);
        }
    };
    public static final VectorVectorFunction dotProductNaN = new VectorVectorFunction(){

        public final double apply(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
            F;
            F;
            return doubleMatrix1D.aggregate(doubleMatrix1D2, Functions.plusNaN, Functions.mult);
        }
    };

    public static VectorVectorFunction LP(final double d) {
        return new VectorVectorFunction(){

            public final double apply(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
                F;
                F;
                F;
                DoubleFunction doubleFunction = Functions.pow(d);
                F;
                F;
                F;
                return Math.pow(doubleMatrix1D.aggregate(doubleMatrix1D2, Functions.plus, Functions.chain(doubleFunction, Functions.chain(Functions.abs, Functions.minus))), 1.0 / d);
            }
        };
    }

    public static ThresholdVectorVectorFunction LP_UPTO(final double d) {
        return new ThresholdVectorVectorFunction(){
            protected double threshold;

            public final void setThreshold(double d2) {
                this.threshold = Math.pow(d2, d);
            }

            public final double apply(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
                F;
                F;
                F;
                DoubleFunction doubleFunction = Functions.pow(d);
                F;
                F;
                F;
                return Math.pow(doubleMatrix1D.aggregateUpTo(doubleMatrix1D2, Functions.plus, Functions.chain(doubleFunction, Functions.chain(Functions.abs, Functions.minus)), this.threshold), 1.0 / d);
            }
        };
    }

    public static VectorVectorFunction LP_NAN(final double d) {
        return new VectorVectorFunction(){

            public final double apply(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
                F;
                F;
                F;
                DoubleFunction doubleFunction = Functions.pow(d);
                F;
                F;
                F;
                return Math.pow(doubleMatrix1D.aggregate(doubleMatrix1D2, Functions.plusNaN, Functions.chain(doubleFunction, Functions.chain(Functions.abs, Functions.minus))), 1.0 / d);
            }
        };
    }

    public static ThresholdVectorVectorFunction LP_NAN_UPTO(final double d) {
        return new ThresholdVectorVectorFunction(){
            protected double threshold;

            public final void setThreshold(double d2) {
                this.threshold = Math.pow(d2, d);
            }

            public final double apply(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
                F;
                F;
                F;
                DoubleFunction doubleFunction = Functions.pow(d);
                F;
                F;
                F;
                return Math.pow(doubleMatrix1D.aggregateUpTo(doubleMatrix1D2, Functions.plusNaN, Functions.chain(doubleFunction, Functions.chain(Functions.abs, Functions.minus)), this.threshold), 1.0 / d);
            }
        };
    }

    public static VectorVectorFunction PTH_LP(final double d) {
        return new VectorVectorFunction(){

            public final double apply(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
                F;
                F;
                F;
                DoubleFunction doubleFunction = Functions.pow(d);
                F;
                F;
                F;
                return doubleMatrix1D.aggregate(doubleMatrix1D2, Functions.plus, Functions.chain(doubleFunction, Functions.chain(Functions.abs, Functions.minus)));
            }
        };
    }

    public static ThresholdVectorVectorFunction PTH_LP_UPTO(final double d) {
        return new ThresholdVectorVectorFunction(){
            protected double threshold;

            public final void setThreshold(double d2) {
                this.threshold = d2;
            }

            public final double apply(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
                F;
                F;
                F;
                DoubleFunction doubleFunction = Functions.pow(d);
                F;
                F;
                F;
                return doubleMatrix1D.aggregateUpTo(doubleMatrix1D2, Functions.plus, Functions.chain(doubleFunction, Functions.chain(Functions.abs, Functions.minus)), this.threshold);
            }
        };
    }

    public static VectorVectorFunction PTH_LP_NAN(final double d) {
        return new VectorVectorFunction(){

            public final double apply(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
                F;
                F;
                F;
                DoubleFunction doubleFunction = Functions.pow(d);
                F;
                F;
                F;
                return doubleMatrix1D.aggregate(doubleMatrix1D2, Functions.plusNaN, Functions.chain(doubleFunction, Functions.chain(Functions.abs, Functions.minus)));
            }
        };
    }

    public static ThresholdVectorVectorFunction PTH_LP_NAN_UPTO(final double d) {
        return new ThresholdVectorVectorFunction(){
            protected double threshold;

            public final void setThreshold(double d2) {
                this.threshold = Math.pow(d2, d);
            }

            public final double apply(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
                F;
                F;
                F;
                DoubleFunction doubleFunction = Functions.pow(d);
                F;
                F;
                F;
                return doubleMatrix1D.aggregateUpTo(doubleMatrix1D2, Functions.plusNaN, Functions.chain(doubleFunction, Functions.chain(Functions.abs, Functions.minus)), this.threshold);
            }
        };
    }

    public static VectorVectorFunction LQUARTER() {
        return VectorFunctions.LP(0.25);
    }

    public static ThresholdVectorVectorFunction LQUARTER_UPTO() {
        return VectorFunctions.LP_UPTO(0.25);
    }

    public static VectorVectorFunction LQUARTER_NAN() {
        return VectorFunctions.LP_NAN(0.25);
    }

    public static ThresholdVectorVectorFunction LQUARTER_NAN_UPTO() {
        return VectorFunctions.LP_NAN_UPTO(0.25);
    }

    public static VectorVectorFunction PLQUARTER() {
        return VectorFunctions.PTH_LP(0.25);
    }

    public static ThresholdVectorVectorFunction PLQUARTER_UPTO() {
        return VectorFunctions.PTH_LP_UPTO(0.25);
    }

    public static VectorVectorFunction PLQUARTER_NAN() {
        return VectorFunctions.PTH_LP_NAN(0.25);
    }

    public static ThresholdVectorVectorFunction PLQUARTER_NAN_UPTO() {
        return VectorFunctions.PTH_LP_NAN_UPTO(0.25);
    }

    public static VectorVectorFunction LTHIRD() {
        return VectorFunctions.LP(0.3333333333333333);
    }

    public static ThresholdVectorVectorFunction LTHIRD_UPTO() {
        return VectorFunctions.LP_UPTO(0.3333333333333333);
    }

    public static VectorVectorFunction LTHIRD_NAN() {
        return VectorFunctions.LP_NAN(0.3333333333333333);
    }

    public static ThresholdVectorVectorFunction LTHIRD_NAN_UPTO() {
        return VectorFunctions.LP_NAN_UPTO(0.3333333333333333);
    }

    public static VectorVectorFunction PLTHIRD() {
        return VectorFunctions.PTH_LP(0.3333333333333333);
    }

    public static ThresholdVectorVectorFunction PLTHIRD_UPTO() {
        return VectorFunctions.PTH_LP_UPTO(0.3333333333333333);
    }

    public static VectorVectorFunction PLTHIRD_NAN() {
        return VectorFunctions.PTH_LP_NAN(0.3333333333333333);
    }

    public static ThresholdVectorVectorFunction PLTHIRD_NAN_UPTO() {
        return VectorFunctions.PTH_LP_NAN_UPTO(0.3333333333333333);
    }

    public static VectorVectorFunction LHALF() {
        return VectorFunctions.LP(0.5);
    }

    public static ThresholdVectorVectorFunction LHALF_UPTO() {
        return VectorFunctions.LP_UPTO(0.5);
    }

    public static VectorVectorFunction LHALF_NAN() {
        return VectorFunctions.LP_NAN(0.5);
    }

    public static ThresholdVectorVectorFunction LHALF_NAN_UPTO() {
        return VectorFunctions.LP_NAN_UPTO(0.5);
    }

    public static VectorVectorFunction PLHALF() {
        return VectorFunctions.PTH_LP(0.5);
    }

    public static ThresholdVectorVectorFunction PLHALF_UPTO() {
        return VectorFunctions.PTH_LP_UPTO(0.5);
    }

    public static VectorVectorFunction PLHALF_NAN() {
        return VectorFunctions.PTH_LP_NAN(0.5);
    }

    public static ThresholdVectorVectorFunction PLHALF_NAN_UPTO() {
        return VectorFunctions.PTH_LP_NAN_UPTO(0.5);
    }

    public static VectorVectorFunction L1() {
        return VectorFunctions.LP(1.0);
    }

    public static ThresholdVectorVectorFunction L1_UPTO() {
        return VectorFunctions.LP_UPTO(1.0);
    }

    public static VectorVectorFunction L1_NAN() {
        return VectorFunctions.LP_NAN(1.0);
    }

    public static ThresholdVectorVectorFunction L1_NAN_UPTO() {
        return VectorFunctions.LP_NAN_UPTO(1.0);
    }

    public static VectorVectorFunction L2() {
        return VectorFunctions.LP(2.0);
    }

    public static ThresholdVectorVectorFunction L2_UPTO() {
        return VectorFunctions.LP_UPTO(2.0);
    }

    public static VectorVectorFunction L2_NAN() {
        return VectorFunctions.LP_NAN(2.0);
    }

    public static ThresholdVectorVectorFunction L2_NAN_UPTO() {
        return VectorFunctions.LP_NAN_UPTO(2.0);
    }

    public static VectorVectorFunction PL2() {
        return VectorFunctions.PTH_LP(2.0);
    }

    public static ThresholdVectorVectorFunction PL2_UPTO() {
        return VectorFunctions.PTH_LP_UPTO(2.0);
    }

    public static VectorVectorFunction PL2_NAN() {
        return VectorFunctions.PTH_LP_NAN(2.0);
    }

    public static ThresholdVectorVectorFunction PL2_NAN_UPTO() {
        return VectorFunctions.PTH_LP_NAN_UPTO(2.0);
    }

    public static VectorVectorFunction L3() {
        return VectorFunctions.LP(3.0);
    }

    public static ThresholdVectorVectorFunction L3_UPTO() {
        return VectorFunctions.LP_UPTO(3.0);
    }

    public static VectorVectorFunction L3_NAN() {
        return VectorFunctions.LP_NAN(3.0);
    }

    public static ThresholdVectorVectorFunction L3_NAN_UPTO() {
        return VectorFunctions.LP_NAN_UPTO(3.0);
    }

    public static VectorVectorFunction PL3() {
        return VectorFunctions.PTH_LP(3.0);
    }

    public static ThresholdVectorVectorFunction PL3_UPTO() {
        return VectorFunctions.PTH_LP_UPTO(3.0);
    }

    public static VectorVectorFunction PL3_NAN() {
        return VectorFunctions.PTH_LP_NAN(3.0);
    }

    public static ThresholdVectorVectorFunction PL3_NAN_UPTO() {
        return VectorFunctions.PTH_LP_NAN_UPTO(3.0);
    }

    public static VectorVectorFunction L4() {
        return VectorFunctions.LP(4.0);
    }

    public static ThresholdVectorVectorFunction L4_UPTO() {
        return VectorFunctions.LP_UPTO(4.0);
    }

    public static VectorVectorFunction L4_NAN() {
        return VectorFunctions.LP_NAN(4.0);
    }

    public static ThresholdVectorVectorFunction L4_NAN_UPTO() {
        return VectorFunctions.LP_NAN_UPTO(4.0);
    }

    public static VectorVectorFunction PL4() {
        return VectorFunctions.PTH_LP(4.0);
    }

    public static ThresholdVectorVectorFunction PL4_UPTO() {
        return VectorFunctions.PTH_LP_UPTO(4.0);
    }

    public static VectorVectorFunction PL4_NAN() {
        return VectorFunctions.PTH_LP_NAN(4.0);
    }

    public static ThresholdVectorVectorFunction PL4_NAN_UPTO() {
        return VectorFunctions.PTH_LP_NAN_UPTO(4.0);
    }

    public static ThresholdVectorVectorFunction WRAPPER_UPTO(final VectorVectorFunction vectorVectorFunction) {
        return new ThresholdVectorVectorFunction(){

            public final void setThreshold(double d) {
            }

            public final double apply(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
                return vectorVectorFunction.apply(doubleMatrix1D, doubleMatrix1D2);
            }
        };
    }

    protected VectorFunctions() {
    }

    public static VectorFunction bindArg1(final VectorVectorFunction vectorVectorFunction, final DoubleMatrix1D doubleMatrix1D) {
        return new VectorFunction(){

            public final double apply(DoubleMatrix1D doubleMatrix1D2) {
                return vectorVectorFunction.apply(doubleMatrix1D, doubleMatrix1D2);
            }
        };
    }

    public static VectorFunction bindArg2(final VectorVectorFunction vectorVectorFunction, final DoubleMatrix1D doubleMatrix1D) {
        return new VectorFunction(){

            public final double apply(DoubleMatrix1D doubleMatrix1D2) {
                return vectorVectorFunction.apply(doubleMatrix1D2, doubleMatrix1D);
            }
        };
    }

    public static VectorVectorFunction swapArgs(final VectorVectorFunction vectorVectorFunction) {
        return new VectorVectorFunction(){

            public final double apply(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
                return vectorVectorFunction.apply(doubleMatrix1D2, doubleMatrix1D);
            }
        };
    }

    public static VectorFunction median() {
        return VectorFunctions.quantile(0.5);
    }

    public static VectorFunction medianNaN() {
        return VectorFunctions.quantileNaN(0.5);
    }

    public static VectorFunction quantile(final double d) {
        return new VectorFunction(){

            public final double apply(DoubleMatrix1D doubleMatrix1D) {
                DoubleQuantileFinder doubleQuantileFinder = QuantileFinderFactory.newDoubleQuantileFinder(true, doubleMatrix1D.size(), 0.0, 0.0, 1, null);
                for (int i = 0; i < doubleMatrix1D.size(); ++i) {
                    doubleQuantileFinder.add(doubleMatrix1D.getQuick(i));
                }
                DoubleArrayList doubleArrayList = new DoubleArrayList(1);
                doubleArrayList.add(d);
                DoubleArrayList doubleArrayList2 = doubleQuantileFinder.quantileElements(doubleArrayList);
                return doubleArrayList2.get(0);
            }
        };
    }

    public static VectorFunction quantileNaN(final double d) {
        return new VectorFunction(){

            public final double apply(DoubleMatrix1D doubleMatrix1D) {
                DoubleQuantileFinder doubleQuantileFinder = QuantileFinderFactory.newDoubleQuantileFinder(true, doubleMatrix1D.size(), 0.0, 0.0, 1, null);
                for (int i = 0; i < doubleMatrix1D.size(); ++i) {
                    if (Double.isNaN(doubleMatrix1D.getQuick(i))) continue;
                    doubleQuantileFinder.add(doubleMatrix1D.getQuick(i));
                }
                DoubleArrayList doubleArrayList = new DoubleArrayList(1);
                doubleArrayList.add(d);
                DoubleArrayList doubleArrayList2 = doubleQuantileFinder.quantileElements(doubleArrayList);
                return doubleArrayList2.get(0);
            }
        };
    }
}

