/*
 * Decompiled with CFR 0.152.
 */
package cern.colt;

import cern.colt.Partitioning;
import cern.colt.list.DoubleArrayList;
import cern.colt.list.IntArrayList;
import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleFactory3D;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.DoubleMatrix3D;
import cern.colt.matrix.doublealgo.Sorting;
import cern.colt.matrix.impl.AbstractMatrix;
import cern.jet.random.Uniform;
import cern.jet.random.engine.MersenneTwister;
import jal.INT.Modification;

class PartitioningTest {
    protected PartitioningTest() {
    }

    public static void main(String[] stringArray) {
        int n = Integer.parseInt(stringArray[0]);
        int n2 = Integer.parseInt(stringArray[1]);
        int n3 = Integer.parseInt(stringArray[2]);
        boolean bl = new Boolean(stringArray[3]);
        String string = stringArray[4];
        boolean bl2 = stringArray[5].equals("new");
    }

    public static void testPartition() {
        System.out.println("\n\n");
        AbstractMatrix abstractMatrix = DoubleFactory2D.dense.descending(4, 2);
        double[] dArray = new double[]{5.0, 10.0, 12.0};
        DoubleMatrix1D doubleMatrix1D = abstractMatrix.viewColumn(0);
        int[] nArray = new int[dArray.length];
        System.out.println(abstractMatrix);
        System.out.println("col1=" + doubleMatrix1D);
        double[] dArray2 = doubleMatrix1D.toArray();
        System.out.println("col2=" + new DoubleArrayList(dArray2));
        System.out.println("col3=" + new DoubleArrayList(dArray2));
        System.out.println("sorted1=" + Sorting.quickSort.sort((DoubleMatrix2D)abstractMatrix, 0));
        System.out.println(cern.colt.matrix.doublealgo.Partitioning.partition(abstractMatrix, 0, dArray, nArray));
        System.out.println("splitters=" + new DoubleArrayList(dArray));
        System.out.println("splitIndexes=" + new IntArrayList(nArray));
        System.out.println(abstractMatrix);
        abstractMatrix = DoubleFactory3D.dense.descending(4, 2, 3);
        System.out.println(abstractMatrix);
        System.out.println("sorted1=" + Sorting.quickSort.sort((DoubleMatrix3D)abstractMatrix, 0, 0));
        System.out.println(abstractMatrix);
    }

    public static void testPartition(IntArrayList intArrayList, int n, int n2, IntArrayList intArrayList2) {
        int n3;
        int n4;
        IntArrayList intArrayList3 = new IntArrayList(intArrayList2.size());
        intArrayList3.setSize(intArrayList2.size());
        IntArrayList intArrayList4 = intArrayList.copy();
        Partitioning.partition(intArrayList4.elements(), n, n2, intArrayList2.elements(), 0, intArrayList2.size() - 1, intArrayList3.elements());
        int n5 = Integer.MIN_VALUE;
        int n6 = n - 1;
        for (n4 = 0; n4 < intArrayList2.size(); ++n4) {
            n3 = intArrayList2.get(n4);
            int n7 = intArrayList3.get(n4);
            for (int i = n6 + 1; i <= n7; ++i) {
                if (n5 <= intArrayList4.get(i) && intArrayList4.get(i) < n3) continue;
                throw new RuntimeException("bug detected");
            }
            n5 = n3;
            n6 = n7;
        }
        for (n4 = 1 + n6; n4 <= n2; ++n4) {
            if (n5 <= intArrayList4.get(n4) && intArrayList4.get(n4) <= Integer.MAX_VALUE) continue;
            System.out.println("list   =" + intArrayList.partFromTo(n, n2));
            System.out.println("partial=" + intArrayList4.partFromTo(n, n2));
            System.out.println("splitters=" + intArrayList2);
            System.out.println("splitIndexes=" + intArrayList3);
            System.out.println("j=" + n4);
            System.out.println("element[j]=" + intArrayList4.get(n4));
            System.out.println("lastSplitter=" + n5);
            throw new RuntimeException("bug detected");
        }
        intArrayList4.sortFromTo(n, n2);
        IntArrayList intArrayList5 = intArrayList.copy();
        intArrayList5.sortFromTo(n, n2);
        n3 = intArrayList.size();
        if (n3 != intArrayList4.size() || !jal.INT.Sorting.includes(intArrayList4.elements(), intArrayList5.elements(), n, n2 + 1, n, n2 + 1) || !jal.INT.Sorting.includes(intArrayList5.elements(), intArrayList4.elements(), n, n2 + 1, n, n2 + 1)) {
            System.out.println("sortedList=" + intArrayList5.partFromTo(n, n2));
            System.out.println("partiallySorted=" + intArrayList4.partFromTo(n, n2));
            throw new RuntimeException("bug detected");
        }
    }

    public static void testPartitionRandomly(int n) {
        MersenneTwister mersenneTwister = new MersenneTwister();
        Uniform uniform = new Uniform(mersenneTwister);
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3;
            int n4;
            int n5 = 50;
            int n6 = 2 * n5;
            int n7 = uniform.nextIntFromTo(0, n5);
            if (n7 == 0) {
                n4 = 0;
                n3 = -1;
            } else {
                n4 = uniform.nextIntFromTo(0, n7 - 1);
                n3 = uniform.nextIntFromTo(Math.min(n4, n7 - 1), n7 - 1);
            }
            int n8 = uniform.nextIntFromTo(n7 / 2, 2 * n7);
            int n9 = uniform.nextIntFromTo(n8, 2 * n7);
            IntArrayList intArrayList = new IntArrayList(n7);
            for (n2 = 0; n2 < n7; ++n2) {
                intArrayList.add(uniform.nextIntFromTo(n8, n9));
            }
            n2 = uniform.nextIntFromTo(0, n6);
            IntArrayList intArrayList2 = new IntArrayList(n2);
            for (int j = 0; j < n2; ++j) {
                intArrayList2.add(uniform.nextIntFromTo(n8 / 2, 2 * n9));
            }
            intArrayList2.sort();
            n2 = Modification.unique(intArrayList2.elements(), 0, n2);
            intArrayList2.setSize(n2);
            PartitioningTest.testPartition(intArrayList, n4, n3, intArrayList2);
        }
        System.out.println("All tests passed. No bug detected.");
    }
}

