/*
 * Decompiled with CFR 0.152.
 */
package cern.colt;

import cern.colt.Swapper;
import cern.colt.function.IntComparator;

public class GenericSorting {
    private static final int SMALL = 7;
    private static final int MEDIUM = 40;

    protected GenericSorting() {
    }

    private static void inplace_merge(int n, int n2, int n3, IntComparator intComparator, Swapper swapper) {
        int n4;
        int n5;
        if (n >= n2 || n2 >= n3) {
            return;
        }
        if (n3 - n == 2) {
            if (intComparator.compare(n2, n) < 0) {
                swapper.swap(n, n2);
            }
            return;
        }
        if (n2 - n > n3 - n2) {
            n5 = n + (n2 - n) / 2;
            n4 = GenericSorting.lower_bound(n2, n3, n5, intComparator);
        } else {
            n4 = n2 + (n3 - n2) / 2;
            n5 = GenericSorting.upper_bound(n, n2, n4, intComparator);
        }
        int n6 = n5;
        int n7 = n2;
        int n8 = n4;
        if (n7 != n6 && n7 != n8) {
            int n9 = n6;
            int n10 = n7;
            while (n9 < --n10) {
                swapper.swap(n9++, n10);
            }
            n9 = n7;
            n10 = n8;
            while (n9 < --n10) {
                swapper.swap(n9++, n10);
            }
            n9 = n6;
            n10 = n8;
            while (n9 < --n10) {
                swapper.swap(n9++, n10);
            }
        }
        n2 = n5 + (n4 - n2);
        GenericSorting.inplace_merge(n, n5, n2, intComparator, swapper);
        GenericSorting.inplace_merge(n2, n4, n3, intComparator, swapper);
    }

    public static int lower_bound(int n, int n2, int n3, IntComparator intComparator) {
        int n4 = n2 - n;
        while (n4 > 0) {
            int n5 = n4 / 2;
            int n6 = n + n5;
            if (intComparator.compare(n6, n3) < 0) {
                n = n6 + 1;
                n4 -= n5 + 1;
                continue;
            }
            n4 = n5;
        }
        return n;
    }

    private static int med3(int n, int n2, int n3, IntComparator intComparator) {
        int n4 = intComparator.compare(n, n2);
        int n5 = intComparator.compare(n, n3);
        int n6 = intComparator.compare(n2, n3);
        return n4 < 0 ? (n6 < 0 ? n2 : (n5 < 0 ? n3 : n)) : (n6 > 0 ? n2 : (n5 > 0 ? n3 : n));
    }

    public static void mergeSort(int n, int n2, IntComparator intComparator, Swapper swapper) {
        int n3 = n2 - n;
        if (n3 < 7) {
            for (int i = n; i < n2; ++i) {
                for (int j = i; j > n && intComparator.compare(j - 1, j) > 0; --j) {
                    swapper.swap(j, j - 1);
                }
            }
            return;
        }
        int n4 = (n + n2) / 2;
        GenericSorting.mergeSort(n, n4, intComparator, swapper);
        GenericSorting.mergeSort(n4, n2, intComparator, swapper);
        if (intComparator.compare(n4 - 1, n4) <= 0) {
            return;
        }
        GenericSorting.inplace_merge(n, n4, n2, intComparator, swapper);
    }

    public static void quickSort(int n, int n2, IntComparator intComparator, Swapper swapper) {
        GenericSorting.quickSort1(n, n2 - n, intComparator, swapper);
    }

    private static void quickSort1(int n, int n2, IntComparator intComparator, Swapper swapper) {
        int n3;
        int n4;
        int n5;
        int n6;
        if (n2 < 7) {
            for (int i = n; i < n2 + n; ++i) {
                for (int j = i; j > n && intComparator.compare(j - 1, j) > 0; --j) {
                    swapper.swap(j, j - 1);
                }
            }
            return;
        }
        int n7 = n + n2 / 2;
        if (n2 > 7) {
            n6 = n;
            n5 = n + n2 - 1;
            if (n2 > 40) {
                n4 = n2 / 8;
                n6 = GenericSorting.med3(n6, n6 + n4, n6 + 2 * n4, intComparator);
                n7 = GenericSorting.med3(n7 - n4, n7, n7 + n4, intComparator);
                n5 = GenericSorting.med3(n5 - 2 * n4, n5 - n4, n5, intComparator);
            }
            n7 = GenericSorting.med3(n6, n7, n5, intComparator);
        }
        n5 = n6 = n;
        int n8 = n4 = n + n2 - 1;
        while (true) {
            if (n5 <= n4 && (n3 = intComparator.compare(n5, n7)) <= 0) {
                if (n3 == 0) {
                    if (n6 == n7) {
                        n7 = n5;
                    } else if (n5 == n7) {
                        n7 = n6;
                    }
                    swapper.swap(n6++, n5);
                }
                ++n5;
                continue;
            }
            while (n4 >= n5 && (n3 = intComparator.compare(n4, n7)) >= 0) {
                if (n3 == 0) {
                    if (n4 == n7) {
                        n7 = n8;
                    } else if (n8 == n7) {
                        n7 = n4;
                    }
                    swapper.swap(n4, n8--);
                }
                --n4;
            }
            if (n5 > n4) break;
            if (n5 == n7) {
                n7 = n8;
            } else if (n4 == n7) {
                n7 = n4;
            }
            swapper.swap(n5++, n4--);
        }
        int n9 = n + n2;
        n3 = Math.min(n6 - n, n5 - n6);
        GenericSorting.vecswap(swapper, n, n5 - n3, n3);
        n3 = Math.min(n8 - n4, n9 - n8 - 1);
        GenericSorting.vecswap(swapper, n5, n9 - n3, n3);
        n3 = n5 - n6;
        if (n3 > 1) {
            GenericSorting.quickSort1(n, n3, intComparator, swapper);
        }
        if ((n3 = n8 - n4) > 1) {
            GenericSorting.quickSort1(n9 - n3, n3, intComparator, swapper);
        }
    }

    private static void reverse(int n, int n2, Swapper swapper) {
        while (n < --n2) {
            swapper.swap(n++, n2);
        }
    }

    public static void rotate(int n, int n2, int n3, Swapper swapper) {
        if (n2 != n && n2 != n3) {
            GenericSorting.reverse(n, n2, swapper);
            GenericSorting.reverse(n2, n3, swapper);
            GenericSorting.reverse(n, n3, swapper);
        }
    }

    public static int upper_bound(int n, int n2, int n3, IntComparator intComparator) {
        int n4 = n2 - n;
        while (n4 > 0) {
            int n5 = n4 / 2;
            int n6 = n + n5;
            if (intComparator.compare(n3, n6) < 0) {
                n4 = n5;
                continue;
            }
            n = n6 + 1;
            n4 -= n5 + 1;
        }
        return n;
    }

    private static void vecswap(Swapper swapper, int n, int n2, int n3) {
        int n4 = 0;
        while (n4 < n3) {
            swapper.swap(n, n2);
            ++n4;
            ++n;
            ++n2;
        }
    }
}

