/*
 * Decompiled with CFR 0.152.
 */
package org.kobjects.jdbc.sql;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.kobjects.jdbc.Column;
import org.kobjects.jdbc.sql.Condition;
import org.kobjects.jdbc.stream.ReaderResultSet;

public class FilteredResultSet
extends ReaderResultSet {
    ResultSet base;
    int[] fieldMap;
    Condition condition;

    public FilteredResultSet(ResultSet base, int[] fieldMap, Condition condition) throws SQLException {
        int i;
        this.base = base;
        this.condition = condition;
        ResultSetMetaData meta = base.getMetaData();
        if (fieldMap == null) {
            fieldMap = new int[meta.getColumnCount()];
            i = 0;
            while (i < fieldMap.length) {
                fieldMap[i] = i + 1;
                ++i;
            }
        }
        this.fieldMap = fieldMap;
        i = 0;
        while (i < fieldMap.length) {
            this.getColumnSet().addColumn(new Column(meta, fieldMap[i]));
            ++i;
        }
    }

    protected Object[] readRow() throws SQLException, IOException {
        while (this.base.next() && !this.condition.evaluate(this.base)) {
        }
        if (this.base.isAfterLast()) {
            return null;
        }
        Object[] row = new Object[this.fieldMap.length];
        int i = 0;
        while (i < this.fieldMap.length) {
            row[i] = this.base.getObject(this.fieldMap[i]);
            ++i;
        }
        return row;
    }

    public void close() throws SQLException {
        this.base.close();
    }
}

