/*
 * Decompiled with CFR 0.152.
 */
package org.kobjects.jdbc.format.bibtex;

import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.sql.SQLException;
import java.util.Properties;
import org.kobjects.io.LookAheadReader;
import org.kobjects.jdbc.Column;
import org.kobjects.jdbc.stream.ReaderResultSet;
import org.kobjects.jdbc.stream.WriterResultSet;

public class BibtexReader
extends ReaderResultSet {
    LookAheadReader reader;
    Object[] currentEntry;
    static String[] FIELD_NAMES = new String[]{"bibtype", "bibkey", "id", "address", "author", "title", "chapter", "booktitle", "crossref", "edition", "editor", "howpublished", "institution", "journal", "key", "month", "note", "number", "organization", "pages", "publisher", "school", "series", "title", "type", "volume", "year"};
    static String[] CODES = new String[]{"#", "\\#", "$", "\\$", "&", "\\&", "_", "\\_", "^", "\\^", "%", "\\%", "\u00c0", "\\`{A}", "\u00c1", "\\'{A}", "\u00c2", "\\^{A}", "\u00c3", "\\~{A}", "\u00c4", "\\\"{A}", "\u00c4", "{\\\"A}", "\u00c5", "{\\AA}", "\u00c6", "{\\AE}", "\u00c7", "\\c{C}", "\u00c8", "\\`{E}", "\u00c9", "\\'{E}", "\u00ca", "\\^{E}", "\u00cb", "\\\"{E}", "\u00cc", "\\`{I}", "\u00cd", "\\'{I}", "\u00ce", "\\^{I}", "\u00cf", "\\\"{I}", "\u00d1", "\\~{N}", "\u00d2", "\\`{O}", "\u00d3", "\\'{O}", "\u00d4", "\\^{O}", "\u00d5", "\\~{O}", "\u00d6", "\\\"{O}", "\u00d6", "{\\\"O}", "\u00d8", "{\\O}", "\u00d9", "\\`{U}", "\u00da", "\\'{U}", "\u00db", "\\^{U}", "\u00dc", "\\\"{U}", "\u00dc", "{\\\"U}", "\u00dd", "\\'{Y}", "\u00df", "{\\ss}", "\u00e0", "\\`{a}", "\u00e1", "\\'{a}", "\u00e2", "\\^{a}", "\u00e3", "\\~{a}", "\u00e4", "\\\"{a}", "\u00e4", "{\\\"a}", "\u00e5", "{\\aa}", "\u00e6", "{\\ae}", "\u00e7", "\\c{c}", "\u00e8", "\\`{e}", "\u00e9", "\\'{e}", "\u00ea", "\\^{e}", "\u00eb", "\\\"{e}", "\u00ec", "\\`{\\i}", "\u00ed", "\\'{\\i}", "\u00ee", "\\^{\\i}", "\u00ef", "\\\"{\\i}", "\u00f1", "\\~{n}", "\u00f2", "\\`{o}", "\u00f3", "\\'{o}", "\u00f4", "\\^{o}", "\u00f5", "\\~{o}", "\u00f6", "\\\"{o}", "\u00f6", "{\\\"o}", "\u00f8", "{\\o}", "\u00f9", "\\`{u}", "\u00fa", "\\'{u}", "\u00fb", "\\^{u}", "\u00fc", "\\\"{u}", "\u00fc", "{\\\"u}", "\u00fd", "\\'{y}", "\u00ff", "\\\"{y}"};

    public BibtexReader(String file, Properties properties) throws IOException, IOException {
        this(new FileReader(file));
    }

    public BibtexReader(Reader reader) throws IOException {
        this.reader = new LookAheadReader(reader);
        int i = 0;
        while (i < FIELD_NAMES.length) {
            this.getColumnSet().addColumn(new Column(FIELD_NAMES[i], 12));
            ++i;
        }
    }

    static String replace(String src, String replace, String by) {
        int i = src.indexOf(replace);
        return i == -1 ? src : String.valueOf(src.substring(0, i)) + by + BibtexReader.replace(src.substring(i + replace.length()), replace, by);
    }

    public static String toUnicode(String s) {
        if (s.indexOf(92) != -1) {
            int i = 0;
            while (i < CODES.length) {
                s = BibtexReader.replace(s, CODES[i + 1], CODES[i]);
                i += 2;
            }
        }
        return s;
    }

    public Object[] readRow() throws IOException, SQLException {
        if (this.reader == null) {
            throw new RuntimeException("Read past end of bibtex file");
        }
        this.reader.readTo("@<*");
        int i = this.reader.read();
        if (i == 42) {
            Object[] del = new Object[this.getColumnSet().getColumnCount()];
            del[this.getColumnSet().findColumn((String)"bibkey") - 1] = "*" + this.reader.readTo("\n\r\t ");
            return del;
        }
        if (i != 64) {
            this.reader.close();
            this.reader = null;
            this.currentEntry = null;
            return null;
        }
        this.currentEntry = new Object[this.getColumnSet().getColumnCount()];
        StringBuffer type = new StringBuffer();
        StringBuffer id = new StringBuffer();
        type.append(this.reader.readTo('{'));
        this.reader.read();
        id.append(this.reader.readTo(",}"));
        int c = this.reader.read();
        this.addEntry(type.toString().trim().toLowerCase(), id.toString().trim());
        if (c == 44) {
            while (this.readLine()) {
            }
        }
        return this.currentEntry;
    }

    void addEntry(String type, String key) throws SQLException {
        this.currentEntry = new Object[this.getColumnSet().getColumnCount()];
        this.addProperty("bibtype", type);
        this.addProperty("bibkey", key);
    }

    void addProperty(String id, String value) throws SQLException {
        this.currentEntry[this.getColumnSet().findColumn((String)id.toLowerCase().trim()) - 1] = BibtexReader.toUnicode(value);
    }

    void recurse(StringBuffer buf) throws IOException {
        while (true) {
            buf.append(this.reader.readTo("{}"));
            if (this.reader.read() != 123) break;
            buf.append('{');
            this.recurse(buf);
            buf.append('}');
        }
    }

    boolean readLine() throws IOException, SQLException {
        StringBuffer idBuf = new StringBuffer();
        StringBuffer valueBuf = new StringBuffer();
        String id = this.reader.readTo("}=").trim().toLowerCase();
        if (this.reader.read() == 125) {
            return false;
        }
        valueBuf.append(this.reader.readTo("{,}\""));
        int c = this.reader.read();
        if (c == 123) {
            this.recurse(valueBuf);
            valueBuf.append(this.reader.readTo(",}"));
            c = this.reader.read();
        } else if (c == 34) {
            while (true) {
                valueBuf.append(this.reader.readTo("\"\\"));
                int d = this.reader.read();
                if (d == 34 || d == -1) break;
                valueBuf.append((char)d);
                valueBuf.append((char)this.reader.read());
            }
            this.reader.readTo(",}");
            c = this.reader.read();
        }
        String value = valueBuf.toString().trim();
        this.addProperty(id, value);
        return c == 44;
    }

    public WriterResultSet getWriterResultSet(Writer writer) throws SQLException {
        throw new RuntimeException("NYI");
    }

    public void close() throws SQLException {
        try {
            if (this.reader != null) {
                this.reader.close();
            }
        }
        catch (IOException e) {
            throw new SQLException(e.toString());
        }
    }
}

