/*
 * Decompiled with CFR 0.152.
 */
package org.kobjects.jdbc.format.arff;

import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Properties;
import org.kobjects.io.LookAheadReader;
import org.kobjects.jdbc.Column;
import org.kobjects.jdbc.format.csv.CsvReader;
import org.kobjects.util.Csv;

public class ArffReader
extends CsvReader {
    String cut(StringBuffer buf) {
        int i = 0;
        String result = buf.toString();
        while (i < result.length() && result.charAt(i) > ' ') {
            ++i;
        }
        result = result.substring(0, i);
        while (i < buf.length() && buf.charAt(i) <= ' ') {
            ++i;
        }
        int j = 0;
        while (i < buf.length()) {
            buf.setCharAt(j++, buf.charAt(i++));
        }
        buf.setLength(j);
        return result;
    }

    public ArffReader(String file, Properties properties) throws IOException {
        this(new FileReader(file));
    }

    public ArffReader(Reader reader) throws IOException {
        super(new LookAheadReader(reader));
        this.commentsChar = (char)37;
        this.nullValue = "?";
        while (true) {
            int type;
            String line;
            if ((line = this.reader.readLine()) == null) {
                throw new RuntimeException("Unexpected EOF");
            }
            if ((line = line.trim()).equals("") || line.startsWith("%")) continue;
            if (line.equalsIgnoreCase("@data")) break;
            StringBuffer buf = new StringBuffer(line);
            String cmd = this.cut(buf).toLowerCase();
            if (cmd.equals("@relation")) {
                buf.toString();
                continue;
            }
            if (!cmd.equals("@attribute")) continue;
            String name = this.cut(buf);
            String remainder = buf.toString().trim();
            Object[] values = null;
            if (remainder.equalsIgnoreCase("real")) {
                type = 8;
            } else if (remainder.startsWith("{")) {
                type = 12;
                values = Csv.decode(remainder.substring(1, remainder.length() - 1));
            } else {
                System.err.println("unrecognized type: '" + remainder + "' assuming string");
                type = 12;
            }
            Column column = new Column(name, type);
            if (values != null) {
                column.setValues(values);
            }
            this.getColumnSet().addColumn(column);
        }
    }
}

