/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.exportchooser;

import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.TreeSet;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.spi.RegisterableService;
import javax.imageio.spi.ServiceRegistry;
import org.freehep.graphicsio.ImageGraphics2D;
import org.freehep.graphicsio.exportchooser.ImageExportFileType;
import org.freehep.util.export.ExportFileType;

public class ImageIOExportFileType
implements RegisterableService {
    public void onRegistration(ServiceRegistry registry, Class category) {
        IIORegistry imageRegistry = IIORegistry.getDefaultInstance();
        Iterator providers = imageRegistry.getServiceProviders(ImageWriterSpi.class, false);
        TreeSet<String> formatSet = new TreeSet<String>();
        while (providers.hasNext()) {
            ImageWriterSpi writerSpi = (ImageWriterSpi)providers.next();
            String[] formats = writerSpi.getFileSuffixes();
            if (formats != null && formats[0] != null) {
                formatSet.add(formats[0]);
                continue;
            }
            System.err.println(this.getClass() + ": Cannot register " + writerSpi + " because it has no filesuffixes.");
        }
        ExportFileType previous = null;
        Iterator exportTypes = registry.getServiceProviders(ExportFileType.class, true);
        while (exportTypes.hasNext()) {
            previous = (ExportFileType)exportTypes.next();
        }
        Iterator formats = formatSet.iterator();
        while (formats.hasNext()) {
            String format = (String)formats.next();
            ImageExportFileType export = ImageExportFileType.getInstance(format);
            if (export != null) {
                registry.registerServiceProvider(export, class$org$freehep$util$export$ExportFileType == null ? ImageIOExportFileType.class$("org.freehep.util.export.ExportFileType") : class$org$freehep$util$export$ExportFileType);
                if (previous != null) {
                    registry.unsetOrdering(class$org$freehep$util$export$ExportFileType == null ? ImageIOExportFileType.class$("org.freehep.util.export.ExportFileType") : class$org$freehep$util$export$ExportFileType, previous, export);
                    boolean result = registry.setOrdering(class$org$freehep$util$export$ExportFileType == null ? ImageIOExportFileType.class$("org.freehep.util.export.ExportFileType") : class$org$freehep$util$export$ExportFileType, previous, export);
                }
                previous = export;
                continue;
            }
            System.err.println(this.getClass() + ": Invalid format: " + format + ".");
        }
        registry.deregisterServiceProvider(this, category);
    }

    public void onDeregistration(ServiceRegistry registry, Class category) {
    }

    public static void main(String[] args) throws Exception {
        System.out.println("WRITERS");
        IIORegistry imageRegistry = IIORegistry.getDefaultInstance();
        Iterator providers = imageRegistry.getServiceProviders(ImageWriterSpi.class, false);
        while (providers.hasNext()) {
            ImageWriterSpi writerSpi = (ImageWriterSpi)providers.next();
            System.out.println("   " + writerSpi);
            System.out.println("      " + writerSpi.getDescription(Locale.US));
            System.out.print("      ");
            String[] formats = writerSpi.getFileSuffixes();
            for (int i = 0; i < formats.length; ++i) {
                System.out.print(formats[i] + ", ");
            }
            System.out.println();
        }
        System.out.println();
        System.out.println("MIMETYPES");
        String[] formats = ImageIO.getWriterMIMETypes();
        for (int i = 0; i < formats.length; ++i) {
            System.out.println("   " + formats[i]);
            ImageWriter writer = ImageGraphics2D.getPreferredImageWriterForMIMEType(formats[i]);
            String[] suffixes = writer.getOriginatingProvider().getFileSuffixes();
            System.out.print("      ");
            for (int j = 0; j < suffixes.length; ++j) {
                System.out.print(suffixes[j] + " ");
            }
            System.out.println();
            System.out.println("      " + writer);
        }
        System.out.println();
        System.out.println("READERS");
        providers = imageRegistry.getServiceProviders(ImageReaderSpi.class, false);
        while (providers.hasNext()) {
            System.out.println("   " + providers.next());
        }
        System.out.println();
        System.out.println("All ExportFileTypes");
        List exportFileTypes = ExportFileType.getExportFileTypes();
        Iterator iterator = exportFileTypes.iterator();
        while (iterator.hasNext()) {
            System.out.println("   " + iterator.next());
        }
    }
}

