/*
 * Decompiled with CFR 0.152.
 */
package com.Trendy.swing.plaf.filechooser;

import com.Trendy.swing.plaf.Themes.TrendyTheme;
import com.Trendy.swing.plaf.TrendyConfiguration;
import com.Trendy.swing.plaf.filechooser.HelperTools;
import com.Trendy.swing.plaf.filechooser.ItemsPanel;
import com.Trendy.swing.plaf.filechooser.MultiLineLabel;
import com.Trendy.swing.plaf.filechooser.trendyFilePane;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.io.File;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.filechooser.FileSystemView;
import javax.swing.plaf.ColorUIResource;

public class VirtualItem
extends JComponent
implements Comparable,
MouseListener {
    private mouseMotionAdapter mousemotionlistener = new mouseMotionAdapter(this);
    protected MultiLineLabel nameLabel = new MultiLineLabel("");
    protected JLabel imageLabel = new JLabel("");
    private ItemsPanel parentPane;
    private int tx;
    private int ty;
    private String file_name = "";
    private String file_path = "";
    private long file_size = 0L;
    private long file_last_modified;
    private File file;
    private boolean isDirectory = false;
    private boolean isFloppyDrive = false;
    private boolean isDrive = false;
    private JMenuItem addToFavouritesMenuItem;
    private static Border selectedThumbBorder;
    private static Border emptyBorder;
    private static Border focusBorder;
    public static Border grayImageBorder;
    public static Border emptyImageBorder;
    public static Border defaultThumbBorder;
    private JPopupMenu popup;
    private JMenuItem pasteMenuItem;
    private String response;
    private String compare_type = trendyFilePane.ORDER_BY_FILE_NAME;
    private ImageIcon thumbIcon;
    private ImageIcon bigSystemIcon;
    private ImageIcon smallSystemIcon;
    private String file_type;
    private static FileSystemView fsv;
    private menuActionListener mal;
    private Point initPosition;
    private boolean selectionStatus = false;
    private Dimension bestSize = new Dimension(10, 10);
    public static Font menuFont;
    public static Font strongMenuFont;

    public static void updateVirtualItemForTheme(TrendyTheme currentTheme) {
        selectedThumbBorder = currentTheme == null ? BorderFactory.createLineBorder(new ColorUIResource(122, 170, 233), 2) : BorderFactory.createLineBorder(currentTheme.getFileChooserColors()[1], 2);
    }

    public void setBestSize(int w, int h) {
        this.bestSize = new Dimension(w, h);
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    public Dimension getBestSize() {
        return this.bestSize;
    }

    public void setCompare_type(String compare_type) {
        this.compare_type = compare_type;
    }

    public ItemsPanel getParentPane() {
        return this.parentPane;
    }

    public File getFile() {
        return this.file;
    }

    public long getFile_last_modified() {
        if (fsv.isFloppyDrive(this.file)) {
            return 0L;
        }
        if (this.file_last_modified == 0L) {
            this.file_last_modified = this.file.lastModified();
        }
        return this.file_last_modified;
    }

    public String getFile_name() {
        return this.file_name;
    }

    public long getFile_size() {
        if (fsv.isFloppyDrive(this.file) || this.file.isDirectory()) {
            return 0L;
        }
        if (this.file_size == 0L) {
            this.file_size = this.file.length();
        }
        return this.file_size;
    }

    public String getCompare_type() {
        return this.compare_type;
    }

    public VirtualItem(ItemsPanel parent, File f) {
        if (selectedThumbBorder == null) {
            VirtualItem.updateVirtualItemForTheme(null);
        }
        try {
            fsv = parent.getFilePane().getFSV();
            this.file = f;
            this.parentPane = parent;
            this.getFileData();
            this.addListeners();
            this.setOpaque(false);
            this.setBorder(defaultThumbBorder);
            this.setFocusable(true);
            this.imageLabel.setFocusable(false);
            this.nameLabel.setFocusable(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void getFileData() {
        this.file_name = fsv.getSystemDisplayName(this.file);
        try {
            this.isDirectory = this.file.isDirectory();
        }
        catch (Exception exp) {
            this.isDirectory = false;
        }
        try {
            this.isFloppyDrive = fsv.isFloppyDrive(this.file);
        }
        catch (Exception exp) {
            this.isFloppyDrive = false;
        }
        try {
            this.isDrive = fsv.isDrive(this.file);
        }
        catch (Exception exp) {
            this.isDrive = false;
        }
        this.nameLabel.setText(this.file_name);
        this.setToolTipText("");
        this.file_type = this.isDirectory && !this.isDrive ? "File Folder" : this.parentPane.getFilePane().cachSystemDetails(this.file, this.file_name)[1].toString();
        if (this.isFloppyDrive) {
            this.getFloppyData();
        }
    }

    public void finalizeAll() {
        try {
            this.smallSystemIcon = null;
            this.bigSystemIcon = null;
            this.imageLabel.setIcon(null);
            this.thumbIcon = null;
            this.removeMouseListener(this);
            this.removeMouseMotionListener(this.mousemotionlistener);
            this.finalize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setImageIcon(ImageIcon pic) {
        this.thumbIcon = pic;
        this.imageLabel.setIcon(this.thumbIcon);
    }

    void addListeners() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this.mousemotionlistener);
    }

    public void componentMouseDragged(Point point) {
        this.setLocation((int)((double)this.getX() + point.getX() - (double)this.tx), (int)((double)this.getY() + point.getY() - (double)this.ty));
        if (this.getX() > this.getParentPane().getWidth()) {
            this.getParentPane().setSize(this.getParentPane().getWidth() + 20, this.getParentPane().getHeight());
            this.getParentPane().repaint();
        }
        if (this.getY() > this.getParentPane().getHeight()) {
            this.getParentPane().setSize(this.getParentPane().getWidth(), this.getParentPane().getHeight() + 20);
            this.getParentPane().repaint();
        }
    }

    public void componentMousePressed(MouseEvent e) {
        this.tx = e.getX();
        this.ty = e.getY();
        this.initPosition = this.getLocation();
    }

    public void componentMouseReleased(MouseEvent e) {
        if (!this.parentPane.getFilePane().isAutoArrange()) {
            return;
        }
        this.setLocation(this.initPosition);
    }

    public String getItemName() {
        return this.file_name;
    }

    public long getItemFileSize() {
        return this.file_size;
    }

    public long getItemFileLastModified() {
        return this.file_last_modified;
    }

    public void updateSelectionMode(boolean isSelected) {
        if (isSelected == this.selectionStatus) {
            return;
        }
        this.selectionStatus = isSelected;
        if (isSelected) {
            if (this.parentPane.filePane.filechooserUI.VIEW.equals("Thumbnail") || this.parentPane.filePane.filechooserUI.VIEW.equals("Icon")) {
                this.setBorder(selectedThumbBorder);
                this.nameLabel.setMultiLine(true);
                this.setSize((int)this.bestSize.getWidth(), (int)this.bestSize.getHeight() + this.nameLabel.getLineDiff());
            }
            this.nameLabel.setOpaque(true);
            this.nameLabel.setNeed_update(true);
            this.nameLabel.setForeground(UIManager.getColor("textHighlightText"));
        } else {
            if (this.parentPane.filePane.filechooserUI.VIEW.equals("Thumbnail") || this.parentPane.filePane.filechooserUI.VIEW.equals("Icon")) {
                this.setBorder(defaultThumbBorder);
            }
            this.setSize((int)this.bestSize.getWidth(), (int)this.bestSize.getHeight());
            this.nameLabel.setMultiLine(false);
            this.nameLabel.setOpaque(false);
            this.nameLabel.setForeground(UIManager.getColor("textText"));
        }
        this.repaint();
    }

    public JPopupMenu getPopupMenu() {
        this.getAdditionalFileData();
        this.createPopupMenu();
        return this.popup;
    }

    public void setAddToFavouritesMenuItemStatus(boolean val) {
        if (this.addToFavouritesMenuItem != null) {
            this.addToFavouritesMenuItem.setVisible(val);
        }
    }

    public void createPopupMenu() {
        if (this.popup != null) {
            return;
        }
        this.mal = new menuActionListener(this);
        this.popup = new JPopupMenu();
        if (this.isDirectory) {
            JMenuItem menuItem = new JMenuItem("Open");
            menuItem.setFont(strongMenuFont);
            menuItem.addActionListener(this.mal);
            this.popup.add(menuItem);
            if (this.getFileChooser().isDirectorySelectionEnabled()) {
                menuItem = new JMenuItem("Select");
                menuItem.setFont(menuFont);
                menuItem.addActionListener(this.mal);
                this.popup.add(menuItem);
            }
            this.popup.addSeparator();
            this.addToFavouritesMenuItem = new JMenuItem("Add to Favourites");
            this.addToFavouritesMenuItem.setFont(menuFont);
            this.addToFavouritesMenuItem.setActionCommand("faves");
            this.addToFavouritesMenuItem.addActionListener(this.mal);
            if (!new File(this.file.getAbsolutePath()).exists()) {
                this.addToFavouritesMenuItem.setEnabled(false);
            }
            this.addToFavouritesMenuItem.setVisible(TrendyConfiguration.isFavouritesVisible(this.parentPane.filePane.fc));
            this.popup.add(this.addToFavouritesMenuItem);
            this.popup.getComponent();
            menuItem = new JMenuItem("Rename the Directory");
            menuItem.addActionListener(this.mal);
            this.popup.add(menuItem);
            menuItem = new JMenuItem("Delete");
            menuItem.addActionListener(this.mal);
            this.popup.add(menuItem);
        } else {
            JMenuItem menuItem = new JMenuItem("Select");
            menuItem.setFont(strongMenuFont);
            menuItem.addActionListener(this.mal);
            this.popup.add(menuItem);
            this.popup.addSeparator();
            menuItem = new JMenuItem("Rename the File");
            menuItem.addActionListener(this.mal);
            this.popup.add(menuItem);
            menuItem = new JMenuItem("Delete");
            menuItem.addActionListener(this.mal);
            this.popup.add(menuItem);
        }
    }

    private void renameFile() {
        this.response = JOptionPane.showInputDialog(this.getFileChooser(), "Please insert the new name for selected file.", this.file_name);
        try {
            if (this.response.equals("") || this.response == null) {
                JOptionPane.showConfirmDialog(this.getFileChooser(), "Please insert a valid name.", "Rename the file", -1, 0);
            } else if (this.file.renameTo(new File(this.file.getParentFile(), this.response))) {
                this.file = new File(this.file.getParentFile(), this.response);
                this.getFileData();
                this.parentPane.filePane.rescanDirectory();
                this.repaint();
            } else {
                JOptionPane.showConfirmDialog(this.getFileChooser(), "An error occured while renaming the file.", "Rename the file", -1, 0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setPasteMenuItemStatus(boolean state) {
        if (this.isDirectory && this.pasteMenuItem != null) {
            this.pasteMenuItem.setEnabled(state);
        }
    }

    public String convertToCorrectFormat(long f) {
        if (this.isDirectory) {
            return "";
        }
        if ((f /= 1024L) < 1024L) {
            return (f == 0L ? 1L : f) + " KB";
        }
        if ((f /= 1024L) < 1024L) {
            return f + " MB";
        }
        return (f /= 1024L) + " GB";
    }

    public int compareTo(Object o) {
        VirtualItem other = (VirtualItem)o;
        int res = 0;
        boolean isFirstDir = this.getFile().isDirectory();
        boolean isSecondDir = other.getFile().isDirectory();
        if (isFirstDir && !isSecondDir) {
            res = -1;
        } else if (!isFirstDir && isSecondDir) {
            res = 1;
        } else if (this.compare_type.equals(trendyFilePane.ORDER_BY_FILE_NAME)) {
            res = this.getFile_name().toLowerCase().compareTo(other.getFile_name().toLowerCase());
        } else if (this.compare_type.equals(trendyFilePane.ORDER_BY_FILE_SIZE)) {
            res = new Long(this.getFile_size()).compareTo(new Long(other.getFile_size()));
        } else if (this.compare_type.equals(trendyFilePane.ORDER_BY_FILE_MODIFIED)) {
            res = new Long(this.getFile_last_modified()).compareTo(new Long(other.getFile_last_modified()));
        } else if (this.compare_type.equals(trendyFilePane.ORDER_BY_FILE_TYPE)) {
            res = this.getFile_type().compareTo(other.getFile_type());
        }
        if (res == 0) {
            res = -1;
        }
        return res;
    }

    private boolean delete() {
        return this.getFile().delete();
    }

    public void updateTumbnail() {
        if (this.isImage()) {
            this.imageLabel.setIcon(this.getThumbnailIcon());
        }
    }

    public void updateItemIcon() {
        if (this.parentPane.filePane.filechooserUI.getView().equals("Thumbnail") || this.parentPane.filePane.filechooserUI.getView().equals("Icon")) {
            this.imageLabel.setIcon(this.getBigSystemIcon());
        } else if (this.parentPane.filePane.filechooserUI.getView().equals("List") || this.parentPane.filePane.filechooserUI.getView().equals("Details")) {
            this.imageLabel.setIcon(this.getSmallSystemIcon());
        }
    }

    private ImageIcon getThumbnailIcon() {
        if (this.thumbIcon == null) {
            if (this.isDirectory) {
                this.thumbIcon = this.getBigSystemIcon();
            } else {
                try {
                    this.thumbIcon = new ImageIcon(HelperTools.getScaledInstance(this.file));
                    if (this.thumbIcon == null) {
                        this.thumbIcon = this.getBigSystemIcon();
                    }
                }
                catch (Exception ex) {
                    this.thumbIcon = this.getBigSystemIcon();
                }
            }
        }
        return this.thumbIcon;
    }

    public ImageIcon getSmallSystemIcon() {
        if (this.smallSystemIcon == null) {
            try {
                this.smallSystemIcon = this.parentPane.getFilePane().getSystemIcon(this.file, this.file_name, this.isDirectory, false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.smallSystemIcon;
    }

    private ImageIcon getBigSystemIcon() {
        if (this.bigSystemIcon == null) {
            try {
                this.bigSystemIcon = this.parentPane.getFilePane().getSystemIcon(this.file, this.file_name, this.isDirectory, true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.bigSystemIcon;
    }

    public String getFile_type() {
        return this.file_type;
    }

    private boolean isImage() {
        String file_original_name = this.file.getName().toLowerCase();
        return file_original_name.endsWith("jpeg") || file_original_name.endsWith("jpg") || file_original_name.endsWith("png") || file_original_name.endsWith("gif") || file_original_name.endsWith("bmp") || file_original_name.endsWith("tif") || file_original_name.endsWith("tiff");
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            if (this.isDirectory) {
                this.updateChooserPath();
            } else {
                this.parentPane.filePane.fc.setSelectedFile(this.getFile());
                this.getParentPane().getFilePane().filechooserUI.getApproveSelectionAction().actionPerformed(null);
            }
        }
    }

    protected void updateChooserPath() {
        this.parentPane.filePane.filechooserUI.setCurrentDirectoryOfFileChooser(this.file);
    }

    public void mouseEntered(MouseEvent e) {
        this.getAdditionalFileData();
    }

    private void getFloppyData() {
        this.file_size = 0L;
        this.file_last_modified = 0L;
        this.file_path = this.file.getPath();
        this.setToolTipText("<html><body><strong>" + this.file_name + "</strong><br>" + "Last modified : " + DateFormat.getDateInstance().format(new Date(this.file_last_modified)) + "<br>" + (this.isDirectory ? "" : "Fle size : " + this.convertToCorrectFormat(this.file_size) + "<br>") + "Fle Description : " + this.file_type + "</body></html>");
    }

    protected void getAdditionalFileData() {
        if (this.getToolTipText().equals("")) {
            if (this.isFloppyDrive) {
                this.file_size = 0L;
                this.file_last_modified = 0L;
                this.file_path = this.file.getPath();
            } else {
                this.file_size = this.file.length();
                this.file_last_modified = this.file.lastModified();
                this.file_path = this.file.getPath();
            }
            if (new File(this.file.getAbsolutePath()).exists()) {
                this.setToolTipText("<html><body><strong>" + this.file_name + "</strong><br>" + "Last modified : " + DateFormat.getDateInstance().format(new Date(this.file_last_modified)) + "<br>" + (this.isDirectory ? "" : "Fle size : " + this.convertToCorrectFormat(this.file_size) + "<br>") + "Fle Description : " + this.file_type + "<br>" + this.file.getPath() + "</body></html>");
            } else {
                this.setToolTipText("<html><body><strong>" + this.file_name + "</strong>" + "</body></html>");
            }
        }
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        this.requestFocusInWindow();
        this.processEvent(e);
        this.getParentPane().selectedComponentMousePressed(e);
        this.checkForPopup(e);
    }

    public void mouseReleased(MouseEvent e) {
        this.getParentPane().selectedComponentMouseReleased(e);
        this.checkForPopup(e);
    }

    private void checkForPopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            try {
                this.createPopupMenu();
                this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setSelectioMode(boolean b) {
        this.selectionStatus = b;
    }

    public boolean getSelectioMode() {
        return this.selectionStatus;
    }

    void processEvent(MouseEvent e) {
        this.getParentPane().getFilePane().updateFilechooserSelectedItems(this, e.isControlDown());
    }

    private JFileChooser getFileChooser() {
        return this.getParentPane().getFilePane().fc;
    }

    static {
        emptyBorder = BorderFactory.createEmptyBorder(1, 5, 1, 5);
        focusBorder = BorderFactory.createEmptyBorder(1, 5, 1, 5);
        grayImageBorder = BorderFactory.createLineBorder(Color.lightGray);
        emptyImageBorder = BorderFactory.createEmptyBorder(1, 1, 1, 1);
        defaultThumbBorder = BorderFactory.createEmptyBorder(2, 2, 2, 2);
        menuFont = new Font("Arial", 0, 12);
        strongMenuFont = new Font("Arial", 1, 12);
    }

    class menuActionListener
    implements ActionListener {
        String response;
        boolean res = false;
        VirtualItem adaptee;

        menuActionListener(VirtualItem adaptee) {
            this.adaptee = adaptee;
        }

        public void actionPerformed(ActionEvent e) {
            this.res = false;
            if (e.getActionCommand().startsWith("Rename the")) {
                VirtualItem.this.renameFile();
            } else if (e.getActionCommand().equals("faves")) {
                this.adaptee.getParentPane().getFilePane().addToFavesList(VirtualItem.this.file);
            } else if (e.getActionCommand().equals("Select")) {
                VirtualItem.this.getFileChooser().setSelectedFile(this.adaptee.getFile());
                this.adaptee.getParentPane().getFilePane().filechooserUI.getApproveSelectionAction().actionPerformed(null);
            } else if (e.getActionCommand().equals("Open")) {
                ((VirtualItem)VirtualItem.this).parentPane.filePane.filechooserUI.setCurrentDirectoryOfFileChooser(this.adaptee.getFile());
            } else if (e.getActionCommand().equals("Delete")) {
                int resInt = JOptionPane.showConfirmDialog(VirtualItem.this.getFileChooser(), "Are you sure you want to delete " + this.adaptee.getItemName() + "?", "Delete file", 1, 3);
                if (resInt == 0) {
                    try {
                        this.res = this.adaptee.delete();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (!this.res) {
                        JOptionPane.showConfirmDialog(VirtualItem.this.getFileChooser(), "Unable to delete the selected file.", "Delete file", -1, 0);
                    } else {
                        VirtualItem.this.getParentPane().getFilePane().rescanDirectory();
                    }
                } else if (e.getActionCommand().equals("")) {
                    // empty if block
                }
            }
        }
    }

    class mouseAdapter
    extends MouseAdapter {
        VirtualItem adaptee;

        mouseAdapter(VirtualItem adaptee) {
            this.adaptee = adaptee;
        }
    }

    class mouseMotionAdapter
    extends MouseMotionAdapter {
        VirtualItem adaptee;

        mouseMotionAdapter(VirtualItem adaptee) {
            this.adaptee = adaptee;
        }

        public void mouseDragged(MouseEvent e) {
            this.adaptee.requestFocusInWindow();
            if (this.adaptee.getSelectioMode()) {
                VirtualItem.this.getParentPane().selectedComponentMouseDragged(e.getPoint());
            }
        }
    }
}

