/*
 * Decompiled with CFR 0.152.
 */
package com.Trendy.swing.plaf.filechooser;

import com.Trendy.swing.plaf.TrendyBorders;
import com.Trendy.swing.plaf.filechooser.ButtonAreaLayout;
import com.Trendy.swing.plaf.filechooser.ItemsPanel;
import com.Trendy.swing.plaf.filechooser.trendyFilePane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicFileChooserUI;
import sun.awt.shell.ShellFolder;

public class TrendyFileChooserUI
extends BasicFileChooserUI {
    private ButtonGroup changeViewButtonGroup;
    private Enumeration els;
    public String VIEW = "List";
    private static Border buttonsEmptyBorder = BorderFactory.createEmptyBorder(2, 2, 2, 2);
    private Action goToParentDirectoryAction = new ChangeToParentDirectoryAction();
    private Action goBackAction = new GoBackAction();
    protected Vector backPathVector = new Vector();
    protected JButton favesButton;
    JPopupMenu changeViewPopup;
    protected Icon changeViewNormal = null;
    protected Icon changeViewHighlighted = null;
    protected Icon favouritesAddNormal = null;
    protected Icon favouritesAddHighlighted = null;
    protected Icon homeNormal = null;
    protected Icon homeHighlighted = null;
    protected Icon homeDisabled = null;
    protected Icon newFolderNormal = null;
    protected Icon newFolderHighlighted = null;
    protected Icon newFolderDisabled = null;
    protected Icon upFolderNormal = null;
    protected Icon upFolderHighlighted = null;
    protected Icon upFolderDisabled = null;
    protected Icon backNormal = null;
    protected Icon backHighlighted = null;
    protected Icon backDisabled = null;
    protected boolean allowBrowsing = true;
    private final Border roundComboboxListRendererBorder = TrendyBorders.getComboBoxlistCellRendererFocusBorder();
    private static File userHomeDirectory;
    private JToggleButton changeViewButton;
    protected trendyFilePane filepane;
    private JLabel lookInLabel;
    private JComboBox directoryComboBox;
    private DirectoryComboBoxModel directoryComboBoxModel;
    private Action directoryComboBoxAction = new DirectoryComboBoxAction();
    private FilterComboBoxModel filterComboBoxModel;
    private JTextField fileNameTextField;
    private JPanel currentViewPanel;
    private FocusListener editorFocusListener = new FocusAdapter(){

        public void focusLost(FocusEvent e) {
            if (!e.isTemporary()) {
                // empty if block
            }
        }
    };
    private boolean useShellFolder;
    private JButton approveButton;
    private JButton cancelButton;
    private JPanel buttonPanel;
    private JPanel bottomPanel;
    private JComboBox filterComboBox;
    private static final Dimension hstrut5;
    private static final Dimension hstrut10;
    private static final Dimension vstrut5;
    private static final Insets shrinkwrap;
    private static final int COLUMN_FILENAME = 0;
    private static final int COLUMN_FILESIZE = 1;
    private static final int COLUMN_FILETYPE = 2;
    private static final int COLUMN_FILEDATE = 3;
    private static final int COLUMN_FILEATTR = 4;
    private static final int COLUMN_COLCOUNT = 5;
    private int lookInLabelMnemonic = 0;
    private String lookInLabelText = null;
    private String saveInLabelText = null;
    private int fileNameLabelMnemonic = 0;
    private String fileNameLabelText = null;
    private int filesOfTypeLabelMnemonic = 0;
    private String filesOfTypeLabelText = null;
    private String upFolderToolTipText = null;
    private String upFolderAccessibleName = null;
    private String homeFolderToolTipText = null;
    private String homeFolderAccessibleName = null;
    private String newFolderToolTipText = null;
    private String newFolderAccessibleName = null;
    private String backButtonToolTipText = "Go to Previous Folder Visited";
    private String backButtonAccessibleName = " ";
    private String fileNameHeaderText = null;
    private String fileSizeHeaderText = null;
    private String fileTypeHeaderText = null;
    private String fileDateHeaderText = null;
    private String fileAttrHeaderText = null;
    private BasicFileChooserUI.BasicFileView fileView = new TrendyFileView();
    private Action cancelSelectionAction = new CancelSelectionAction();
    protected Action addToFavouritesAction = new AddToFavouritesAction();
    private Action approveSelectionAction2 = new ApproveSelectionAction2();
    static final int space = 10;

    public Action getCancelSelectionAction() {
        return this.cancelSelectionAction;
    }

    ActionMap createActionMap() {
        AbstractAction escAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                TrendyFileChooserUI.this.filepane.stopTumbnailGeneration();
                TrendyFileChooserUI.this.getFileChooser().cancelSelection();
            }

            public boolean isEnabled() {
                return TrendyFileChooserUI.this.getFileChooser().isEnabled();
            }
        };
        ActionMapUIResource map = new ActionMapUIResource();
        map.put("approveSelection", this.getApproveSelectionAction());
        map.put("cancelSelection", escAction);
        return map;
    }

    public Action getApproveSelectionAction() {
        return this.approveSelectionAction2;
    }

    public String getView() {
        return this.VIEW;
    }

    public static ComponentUI createUI(JComponent c) {
        return new TrendyFileChooserUI((JFileChooser)c);
    }

    public TrendyFileChooserUI(JFileChooser filechooser) {
        super(filechooser);
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        c.putClientProperty("TRENDY_FILECHOOSER_FAVOURITES", Boolean.FALSE);
        c.putClientProperty("TRENDY_FILECHOOSER_ALLOW_BROWSING", Boolean.TRUE);
    }

    public void uninstallComponents(JFileChooser fc) {
        fc.removeAll();
        this.bottomPanel = null;
        this.buttonPanel = null;
        this.filepane = null;
        super.uninstallComponents(fc);
    }

    public void installIcons(JFileChooser fc) {
        super.installIcons(fc);
        this.changeViewNormal = UIManager.getIcon("FileChooser.TrendyChangeViewNormalIcon");
        this.changeViewHighlighted = UIManager.getIcon("FileChooser.TrendyChangeViewHighlightedIcon");
        this.favouritesAddNormal = UIManager.getIcon("FileChooser.TrendyFavouritesAddNormalIcon");
        this.favouritesAddHighlighted = UIManager.getIcon("FileChooser.TrendyFavouritesAddHighlightedIcon");
        this.homeNormal = UIManager.getIcon("FileChooser.TrendyHomeNormalIcon");
        this.homeHighlighted = UIManager.getIcon("FileChooser.TrendyHomeHighlightedIcon");
        this.homeDisabled = UIManager.getIcon("FileChooser.TrendyHomeDisabledIcon");
        this.newFolderNormal = UIManager.getIcon("FileChooser.TrendyNewFolderNormalIcon");
        this.newFolderHighlighted = UIManager.getIcon("FileChooser.TrendyNewFolderHighlightedIcon");
        this.newFolderDisabled = UIManager.getIcon("FileChooser.TrendyNewFolderDisabledIcon");
        this.upFolderNormal = UIManager.getIcon("FileChooser.TrendyUpFolderNormalIcon");
        this.upFolderHighlighted = UIManager.getIcon("FileChooser.TrendyUpFolderHighlightedIcon");
        this.upFolderDisabled = UIManager.getIcon("FileChooser.TrendyUpFolderDisabledIcon");
        this.backNormal = UIManager.getIcon("FileChooser.TrendyBackFolderNormalIcon");
        this.backHighlighted = UIManager.getIcon("FileChooser.TrendyBackFolderHighlightedIcon");
        this.backDisabled = UIManager.getIcon("FileChooser.TrendyBackFolderDisabledIcon");
        if (UIManager.getIcon("FileChooser.defaultDirectoryIcon") == null) {
            UIManager.getLookAndFeelDefaults().put("FileChooser.defaultDirectoryIcon", new ImageIcon(this.getClass().getResource("resources/Directory.png")));
        }
    }

    protected void uninstallIcons(JFileChooser fc) {
        super.uninstallIcons(fc);
        this.changeViewNormal = null;
        this.changeViewHighlighted = null;
        this.favouritesAddNormal = null;
        this.favouritesAddHighlighted = null;
        this.homeNormal = null;
        this.homeHighlighted = null;
        this.homeDisabled = null;
        this.newFolderNormal = null;
        this.newFolderHighlighted = null;
        this.newFolderDisabled = null;
        this.upFolderNormal = null;
        this.upFolderHighlighted = null;
        this.upFolderDisabled = null;
        this.backNormal = null;
        this.backHighlighted = null;
        this.backDisabled = null;
    }

    public void installComponents(JFileChooser fc) {
        File[] cbFolders;
        FileSystemView fsv = fc.getFileSystemView();
        userHomeDirectory = fsv.getHomeDirectory();
        this.changeViewPopup = this.createViewPopupMenu();
        fc.setBorder(new EmptyBorder(12, 12, 11, 11));
        fc.setLayout(new BorderLayout(0, 11));
        JToolBar topPanel = new JToolBar();
        topPanel.setFloatable(false);
        topPanel.setBorder(null);
        topPanel.setOpaque(false);
        fc.add((Component)topPanel, "North");
        this.lookInLabel = new JLabel(this.lookInLabelText);
        this.lookInLabel.setDisplayedMnemonic(this.lookInLabelMnemonic);
        topPanel.add((Component)this.lookInLabel, "Before");
        this.directoryComboBox = new JComboBox();
        this.directoryComboBox.setOpaque(false);
        this.directoryComboBox.getAccessibleContext().setAccessibleDescription(this.lookInLabelText);
        this.directoryComboBox.putClientProperty("JComboBox.lightweightKeyboardNavigation", "Lightweight");
        this.lookInLabel.setLabelFor(this.directoryComboBox);
        this.directoryComboBoxModel = this.createDirectoryComboBoxModel(fc);
        this.directoryComboBox.setModel(this.directoryComboBoxModel);
        this.directoryComboBox.addActionListener(this.directoryComboBoxAction);
        this.directoryComboBox.setRenderer(this.createDirectoryComboBoxRenderer(fc));
        this.directoryComboBox.setMaximumRowCount(9);
        this.directoryComboBox.setMaximumSize(new Dimension((int)this.directoryComboBox.getMaximumSize().getWidth(), 27));
        topPanel.add((Component)this.directoryComboBox, "Center");
        topPanel.add(Box.createRigidArea(hstrut10));
        JButton backButton = new JButton(this.getGoBackAction());
        backButton.setText(null);
        backButton.setRolloverEnabled(true);
        backButton.setIcon(this.backNormal);
        backButton.setPressedIcon(this.backHighlighted);
        backButton.setRolloverIcon(this.backHighlighted);
        backButton.setDisabledIcon(this.backDisabled);
        backButton.setToolTipText(this.backButtonToolTipText);
        backButton.getAccessibleContext().setAccessibleName(this.backButtonAccessibleName);
        backButton.setBorder(buttonsEmptyBorder);
        backButton.setAlignmentX(0.0f);
        backButton.setAlignmentY(0.5f);
        backButton.setMargin(shrinkwrap);
        backButton.setBackground((Color)UIManager.get("control"));
        backButton.setOpaque(false);
        backButton.setFocusable(false);
        topPanel.add(backButton);
        topPanel.add(Box.createRigidArea(hstrut5));
        JButton upFolderButton = new JButton(this.getChangeToParentDirectoryAction());
        upFolderButton.setText(null);
        upFolderButton.setRolloverEnabled(true);
        upFolderButton.setIcon(this.upFolderNormal);
        upFolderButton.setPressedIcon(this.upFolderHighlighted);
        upFolderButton.setRolloverIcon(this.upFolderHighlighted);
        upFolderButton.setDisabledIcon(this.upFolderDisabled);
        upFolderButton.setToolTipText(this.upFolderToolTipText);
        upFolderButton.getAccessibleContext().setAccessibleName(this.upFolderAccessibleName);
        upFolderButton.setBorder(buttonsEmptyBorder);
        upFolderButton.setAlignmentX(0.0f);
        upFolderButton.setAlignmentY(0.5f);
        upFolderButton.setMargin(shrinkwrap);
        upFolderButton.setBackground((Color)UIManager.get("control"));
        upFolderButton.setFocusable(false);
        upFolderButton.setOpaque(false);
        topPanel.add(upFolderButton);
        topPanel.add(Box.createRigidArea(hstrut5));
        this.favesButton = new JButton(new favesAction());
        this.favesButton.setRolloverEnabled(true);
        this.favesButton.setOpaque(false);
        this.favesButton.setIcon(this.favouritesAddNormal);
        this.favesButton.setPressedIcon(this.favouritesAddHighlighted);
        this.favesButton.setRolloverIcon(this.favouritesAddHighlighted);
        this.favesButton.setBorder(buttonsEmptyBorder);
        this.favesButton.setFocusable(false);
        this.favesButton.setToolTipText("Add to favourites");
        this.favesButton.setVisible(false);
        this.favesButton.getAccessibleContext().setAccessibleName(this.homeFolderAccessibleName);
        this.favesButton.setAlignmentX(0.0f);
        this.favesButton.setAlignmentY(0.5f);
        this.favesButton.setMargin(shrinkwrap);
        this.favesButton.setBackground((Color)UIManager.get("control"));
        topPanel.add(this.favesButton);
        topPanel.add(Box.createRigidArea(hstrut5));
        File homeDir = fsv.getHomeDirectory();
        String toolTipText = this.homeFolderToolTipText;
        if (fsv.isRoot(homeDir)) {
            toolTipText = this.getFileView(fc).getName(homeDir);
        }
        JButton b = new JButton(this.getGoHomeAction());
        b.setRolloverEnabled(true);
        b.setIcon(this.homeNormal);
        b.setPressedIcon(this.homeHighlighted);
        b.setRolloverIcon(this.homeHighlighted);
        b.setDisabledIcon(this.homeDisabled);
        b.setText("");
        b.setToolTipText(toolTipText);
        b.getAccessibleContext().setAccessibleName(this.homeFolderAccessibleName);
        b.setAlignmentX(0.0f);
        b.setAlignmentY(0.5f);
        b.setMargin(shrinkwrap);
        b.setBorder(buttonsEmptyBorder);
        b.setFocusable(false);
        b.setOpaque(false);
        topPanel.add(b);
        topPanel.add(Box.createRigidArea(hstrut5));
        b = new JButton(this.getNewFolderAction());
        b.setText(null);
        b.setRolloverEnabled(true);
        b.setIcon(this.newFolderNormal);
        b.setPressedIcon(this.newFolderHighlighted);
        b.setRolloverIcon(this.newFolderHighlighted);
        b.setDisabledIcon(this.newFolderDisabled);
        b.setBorder(buttonsEmptyBorder);
        b.setOpaque(false);
        b.setFocusable(false);
        b.setToolTipText(this.newFolderToolTipText);
        b.getAccessibleContext().setAccessibleName(this.newFolderAccessibleName);
        b.setAlignmentX(0.0f);
        b.setAlignmentY(0.5f);
        b.setMargin(shrinkwrap);
        topPanel.add(b);
        topPanel.add(Box.createRigidArea(hstrut5));
        this.changeViewButton = new JToggleButton(new chnageViewAction());
        this.changeViewButton.setText(null);
        this.changeViewButton.setRolloverEnabled(true);
        this.changeViewButton.setIcon(this.changeViewNormal);
        this.changeViewButton.setPressedIcon(this.changeViewHighlighted);
        this.changeViewButton.setRolloverIcon(this.changeViewHighlighted);
        this.changeViewButton.setSelectedIcon(this.changeViewHighlighted);
        this.changeViewButton.setToolTipText("Change view");
        this.changeViewButton.getAccessibleContext().setAccessibleName(this.newFolderAccessibleName);
        this.changeViewButton.setAlignmentX(0.0f);
        this.changeViewButton.setAlignmentY(0.5f);
        this.changeViewButton.setMargin(shrinkwrap);
        this.changeViewButton.setBackground((Color)UIManager.get("control"));
        this.changeViewButton.setBorder(buttonsEmptyBorder);
        this.changeViewButton.setOpaque(false);
        this.changeViewButton.setFocusable(false);
        topPanel.add(this.changeViewButton);
        topPanel.add(Box.createRigidArea(hstrut5));
        topPanel.setBackground((Color)UIManager.get("control"));
        this.useShellFolder = false;
        File[] roots = fsv.getRoots();
        if (roots != null && roots.length == 1 && (cbFolders = (File[])ShellFolder.get("fileChooserComboBoxFolders")) != null && cbFolders.length > 0 && roots[0] == cbFolders[0]) {
            this.useShellFolder = true;
        }
        this.filepane = new trendyFilePane(this, fc);
        fc.addPropertyChangeListener(this.filepane);
        this.filepane.add((Component)this.getAccessoryPanel(), "After");
        JComponent accessory = fc.getAccessory();
        if (accessory != null) {
            this.getAccessoryPanel().add(accessory);
        }
        fc.add((Component)this.filepane, "Center");
        JPanel bottomPanel = this.getBottomPanel();
        bottomPanel.setOpaque(false);
        bottomPanel.setLayout(new BoxLayout(bottomPanel, 1));
        fc.add((Component)bottomPanel, "South");
        JPanel fileNamePanel = new JPanel();
        fileNamePanel.setOpaque(false);
        fileNamePanel.setLayout(new BoxLayout(fileNamePanel, 2));
        bottomPanel.add(fileNamePanel);
        bottomPanel.add(Box.createRigidArea(vstrut5));
        AlignedLabel fileNameLabel = new AlignedLabel(this.fileNameLabelText);
        fileNameLabel.setDisplayedMnemonic(this.fileNameLabelMnemonic);
        fileNamePanel.add(fileNameLabel);
        this.fileNameTextField = new JTextField(){

            public Dimension getMaximumSize() {
                return new Dimension(Short.MAX_VALUE, super.getPreferredSize().height);
            }
        };
        fileNamePanel.add(this.fileNameTextField);
        if (fc.isMultiSelectionEnabled()) {
            this.setFileName(this.fileNameString(fc.getSelectedFiles()));
        } else {
            this.setFileName(this.fileNameString(fc.getSelectedFile()));
        }
        JPanel filesOfTypePanel = new JPanel();
        filesOfTypePanel.setOpaque(false);
        filesOfTypePanel.setLayout(new BoxLayout(filesOfTypePanel, 2));
        bottomPanel.add(filesOfTypePanel);
        AlignedLabel filesOfTypeLabel = new AlignedLabel(this.filesOfTypeLabelText);
        filesOfTypeLabel.setDisplayedMnemonic(this.filesOfTypeLabelMnemonic);
        filesOfTypePanel.add(filesOfTypeLabel);
        this.filterComboBoxModel = this.createFilterComboBoxModel();
        fc.addPropertyChangeListener(this.filterComboBoxModel);
        this.filterComboBox = new JComboBox(this.filterComboBoxModel);
        this.filterComboBox.setOpaque(false);
        this.filterComboBox.getAccessibleContext().setAccessibleDescription(this.filesOfTypeLabelText);
        filesOfTypeLabel.setLabelFor(this.filterComboBox);
        this.filterComboBox.setRenderer(this.createFilterComboBoxRenderer());
        filesOfTypePanel.add(this.filterComboBox);
        this.getButtonPanel().setLayout(new ButtonAreaLayout());
        this.approveButton = new JButton(this.getApproveButtonText(fc));
        this.approveButton.setOpaque(false);
        this.approveButton.addActionListener(this.getApproveSelectionAction());
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(fc));
        this.getButtonPanel().add(this.approveButton);
        this.cancelButton = new JButton(this.cancelButtonText);
        this.cancelButton.setOpaque(false);
        this.cancelButton.setToolTipText(this.cancelButtonToolTipText);
        this.cancelButton.addActionListener(this.getCancelSelectionAction());
        this.getButtonPanel().add(this.cancelButton);
        if (fc.getControlButtonsAreShown()) {
            this.addControlButtons();
        }
        TrendyFileChooserUI.groupLabels(new AlignedLabel[]{fileNameLabel, filesOfTypeLabel});
    }

    protected JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel();
            this.buttonPanel.setOpaque(false);
        }
        return this.buttonPanel;
    }

    protected JPanel getBottomPanel() {
        if (this.bottomPanel == null) {
            this.bottomPanel = new JPanel();
        }
        return this.bottomPanel;
    }

    protected void installStrings(JFileChooser fc) {
        super.installStrings(fc);
        Locale l = fc.getLocale();
        this.lookInLabelMnemonic = UIManager.getInt("FileChooser.lookInLabelMnemonic");
        this.lookInLabelText = UIManager.getString((Object)"FileChooser.lookInLabelText", l);
        this.saveInLabelText = UIManager.getString((Object)"FileChooser.saveInLabelText", l);
        this.fileNameLabelMnemonic = UIManager.getInt("FileChooser.fileNameLabelMnemonic");
        this.fileNameLabelText = UIManager.getString((Object)"FileChooser.fileNameLabelText", l);
        this.filesOfTypeLabelMnemonic = UIManager.getInt("FileChooser.filesOfTypeLabelMnemonic");
        this.filesOfTypeLabelText = UIManager.getString((Object)"FileChooser.filesOfTypeLabelText", l);
        this.upFolderToolTipText = UIManager.getString((Object)"FileChooser.upFolderToolTipText", l);
        this.upFolderAccessibleName = UIManager.getString((Object)"FileChooser.upFolderAccessibleName", l);
        this.homeFolderToolTipText = UIManager.getString((Object)"FileChooser.homeFolderToolTipText", l);
        this.homeFolderAccessibleName = UIManager.getString((Object)"FileChooser.homeFolderAccessibleName", l);
        this.newFolderToolTipText = UIManager.getString((Object)"FileChooser.newFolderToolTipText", l);
        this.newFolderAccessibleName = UIManager.getString((Object)"FileChooser.newFolderAccessibleName", l);
        this.fileNameHeaderText = "File Name";
        this.fileSizeHeaderText = "Size";
        this.fileTypeHeaderText = "Type";
        this.fileDateHeaderText = "Modified";
        this.fileAttrHeaderText = "Attributes";
    }

    protected void installListeners(JFileChooser fc) {
        super.installListeners(fc);
        this.changeViewPopup.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().toLowerCase().equals("visible")) {
                    TrendyFileChooserUI.this.changeViewButton.setSelected(new Boolean(e.getNewValue().toString()));
                }
            }
        });
        ActionMap actionMap = this.getActionMap();
        SwingUtilities.replaceUIActionMap(fc, actionMap);
    }

    protected ActionMap getActionMap() {
        return this.createActionMap();
    }

    public void uninstallUI(JComponent c) {
        c.removePropertyChangeListener(this.filterComboBoxModel);
        this.cancelButton.removeActionListener(this.getCancelSelectionAction());
        this.approveButton.removeActionListener(this.getApproveSelectionAction());
        this.fileNameTextField.removeActionListener(this.getApproveSelectionAction());
        super.uninstallUI(c);
    }

    public Dimension getMaximumSize(JComponent c) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    void setFileSelected() {
    }

    private String fileNameString(File file) {
        if (file == null) {
            return null;
        }
        JFileChooser fc = this.getFileChooser();
        if (fc.isDirectorySelectionEnabled() && !fc.isFileSelectionEnabled()) {
            return file.getPath();
        }
        return file.getName();
    }

    private String fileNameString(File[] files) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; files != null && i < files.length; ++i) {
            if (i > 0) {
                buf.append(" ");
            }
            if (files.length > 1) {
                buf.append("\"");
            }
            buf.append(this.fileNameString(files[i]));
            if (files.length <= 1) continue;
            buf.append("\"");
        }
        return buf.toString();
    }

    private void doSelectedFileChanged(PropertyChangeEvent e) {
        File f = (File)e.getNewValue();
        JFileChooser fc = this.getFileChooser();
        if (f != null && (fc.isFileSelectionEnabled() && !f.isDirectory() || f.isDirectory() && fc.isDirectorySelectionEnabled())) {
            this.setFileName(this.fileNameString(f));
            this.setFileSelected();
        }
    }

    private void doSelectedFilesChanged(PropertyChangeEvent e) {
        File[] files = (File[])e.getNewValue();
        JFileChooser fc = this.getFileChooser();
        if (files != null && files.length > 0 && (files.length > 1 || fc.isDirectorySelectionEnabled() || !files[0].isDirectory())) {
            this.setFileName(this.fileNameString(files));
        } else {
            this.setFileName("");
        }
    }

    private void doDirectoryChanged(PropertyChangeEvent e) {
        JFileChooser fc = this.getFileChooser();
        FileSystemView fsv = fc.getFileSystemView();
        this.clearIconCache();
        File currentDirectory = fc.getCurrentDirectory();
        this.filepane.updatePath(currentDirectory);
        if (currentDirectory != null) {
            this.directoryComboBoxModel.addItem(currentDirectory);
            this.getNewFolderAction().setEnabled(currentDirectory.canWrite());
            this.getChangeToParentDirectoryAction().setEnabled(!fsv.isRoot(currentDirectory));
            this.getChangeToParentDirectoryAction().setEnabled(!fsv.isRoot(currentDirectory));
            this.getGoHomeAction().setEnabled(!userHomeDirectory.equals(currentDirectory));
            if (fc.isDirectorySelectionEnabled() && !fc.isFileSelectionEnabled()) {
                if (fsv.isFileSystem(currentDirectory)) {
                    this.setFileName(currentDirectory.getPath());
                } else {
                    this.setFileName(null);
                }
            }
        }
    }

    private void doFilterChanged(PropertyChangeEvent e) {
        this.filepane.doFilterChanged();
    }

    private void doFileSelectionModeChanged(PropertyChangeEvent e) {
        this.doFilterChanged(e);
        JFileChooser fc = this.getFileChooser();
        File currentDirectory = fc.getCurrentDirectory();
        if (currentDirectory != null && fc.isDirectorySelectionEnabled() && !fc.isFileSelectionEnabled() && fc.getFileSystemView().isFileSystem(currentDirectory)) {
            this.setFileName(currentDirectory.getPath());
        } else {
            this.setFileName(null);
        }
    }

    private void doMultiSelectionChanged(PropertyChangeEvent e) {
        if (!this.getFileChooser().isMultiSelectionEnabled()) {
            this.getFileChooser().setSelectedFiles(null);
        }
    }

    private void doAccessoryChanged(PropertyChangeEvent e) {
        if (this.getAccessoryPanel() != null) {
            JComponent accessory;
            if (e.getOldValue() != null) {
                this.getAccessoryPanel().remove((JComponent)e.getOldValue());
            }
            if ((accessory = (JComponent)e.getNewValue()) != null) {
                this.getAccessoryPanel().add((Component)accessory, "Center");
            }
        }
    }

    private void doApproveButtonTextChanged(PropertyChangeEvent e) {
        JFileChooser chooser = this.getFileChooser();
        this.approveButton.setText(this.getApproveButtonText(chooser));
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(chooser));
    }

    private void doDialogTypeChanged(PropertyChangeEvent e) {
        JFileChooser chooser = this.getFileChooser();
        this.approveButton.setText(this.getApproveButtonText(chooser));
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(chooser));
        if (chooser.getDialogType() == 1) {
            this.lookInLabel.setText(this.saveInLabelText);
        } else {
            this.lookInLabel.setText(this.lookInLabelText);
        }
    }

    private void doApproveButtonMnemonicChanged(PropertyChangeEvent e) {
    }

    private void doControlButtonsChanged(PropertyChangeEvent e) {
        if (this.getFileChooser().getControlButtonsAreShown()) {
            this.addControlButtons();
        } else {
            this.removeControlButtons();
        }
    }

    public PropertyChangeListener createPropertyChangeListener(JFileChooser fc) {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                String s = e.getPropertyName();
                if (s.equals("SelectedFileChangedProperty")) {
                    TrendyFileChooserUI.this.doSelectedFileChanged(e);
                } else if (s.equals("SelectedFilesChangedProperty")) {
                    TrendyFileChooserUI.this.doSelectedFilesChanged(e);
                } else if (s.equals("directoryChanged")) {
                    TrendyFileChooserUI.this.doDirectoryChanged(e);
                } else if (s.equals("fileFilterChanged")) {
                    TrendyFileChooserUI.this.doFilterChanged(e);
                } else if (s.equals("fileSelectionChanged")) {
                    TrendyFileChooserUI.this.doFileSelectionModeChanged(e);
                } else if (s.equals("MultiSelectionEnabledChangedProperty")) {
                    TrendyFileChooserUI.this.doMultiSelectionChanged(e);
                } else if (s.equals("AccessoryChangedProperty")) {
                    TrendyFileChooserUI.this.doAccessoryChanged(e);
                } else if (s.equals("ApproveButtonTextChangedProperty") || s.equals("ApproveButtonToolTipTextChangedProperty")) {
                    TrendyFileChooserUI.this.doApproveButtonTextChanged(e);
                } else if (s.equals("DialogTypeChangedProperty")) {
                    TrendyFileChooserUI.this.doDialogTypeChanged(e);
                } else if (s.equals("ApproveButtonMnemonicChangedProperty")) {
                    TrendyFileChooserUI.this.doApproveButtonMnemonicChanged(e);
                } else if (s.equals("ControlButtonsAreShownChangedProperty")) {
                    TrendyFileChooserUI.this.doControlButtonsChanged(e);
                } else if (s.equals("FileHidingChanged")) {
                    TrendyFileChooserUI.this.filepane.doFilterChanged();
                } else if (s.equals("componentOrientation")) {
                    ComponentOrientation o = (ComponentOrientation)e.getNewValue();
                    JFileChooser cc = (JFileChooser)e.getSource();
                    if (o != (ComponentOrientation)e.getOldValue()) {
                        cc.applyComponentOrientation(o);
                    }
                } else if (s.equals("ancestor") && e.getOldValue() == null && e.getNewValue() != null) {
                    TrendyFileChooserUI.this.fileNameTextField.selectAll();
                    TrendyFileChooserUI.this.filepane.itemsPanel.requestFocus();
                }
            }
        };
    }

    protected void removeControlButtons() {
        this.getBottomPanel().remove(this.getButtonPanel());
    }

    protected void addControlButtons() {
        this.getBottomPanel().add(this.getButtonPanel());
    }

    public void ensureFileIsVisible(JFileChooser fc, File f) {
    }

    public void rescanCurrentDirectory(JFileChooser fc) {
        this.filepane.rescanDirectory();
    }

    public String getFileName() {
        if (this.fileNameTextField != null) {
            return this.fileNameTextField.getText();
        }
        return null;
    }

    public void setFileName(String filename) {
        if (this.fileNameTextField != null) {
            this.fileNameTextField.setText(filename);
        }
    }

    protected void setDirectorySelected(boolean directorySelected) {
        super.setDirectorySelected(directorySelected);
        JFileChooser chooser = this.getFileChooser();
        if (directorySelected) {
            this.approveButton.setText(this.directoryOpenButtonText);
            this.approveButton.setToolTipText(this.directoryOpenButtonToolTipText);
        } else {
            this.approveButton.setText(this.getApproveButtonText(chooser));
            this.approveButton.setToolTipText(this.getApproveButtonToolTipText(chooser));
        }
    }

    public String getDirectoryName() {
        return null;
    }

    public void setDirectoryName(String dirname) {
    }

    protected DirectoryComboBoxRenderer createDirectoryComboBoxRenderer(JFileChooser fc) {
        return new DirectoryComboBoxRenderer();
    }

    protected DirectoryComboBoxModel createDirectoryComboBoxModel(JFileChooser fc) {
        return new DirectoryComboBoxModel();
    }

    protected FilterComboBoxRenderer createFilterComboBoxRenderer() {
        return new FilterComboBoxRenderer();
    }

    protected FilterComboBoxModel createFilterComboBoxModel() {
        return new FilterComboBoxModel();
    }

    public void valueChanged(ListSelectionEvent e) {
        JFileChooser fc = this.getFileChooser();
        File f = fc.getSelectedFile();
        if (!e.getValueIsAdjusting() && f != null && !this.getFileChooser().isTraversable(f)) {
            this.setFileName(this.fileNameString(f));
        }
    }

    protected void setCurrentDirectoryOfFileChooser(File f) {
        if (this.allowBrowsing) {
            this.getFileChooser().setCurrentDirectory(f);
        }
    }

    protected JButton getApproveButton(JFileChooser fc) {
        return this.approveButton;
    }

    private static void groupLabels(AlignedLabel[] group) {
        for (int i = 0; i < group.length; ++i) {
            AlignedLabel.access$1802(group[i], group);
        }
    }

    public FileView getFileView(JFileChooser fc) {
        return this.fileView;
    }

    public void goBack() {
        if (this.backPathVector.size() > 0) {
            this.setCurrentDirectoryOfFileChooser(new File(this.backPathVector.elementAt(this.backPathVector.size() - 1).toString()));
            if (this.backPathVector.size() > 1) {
                this.backPathVector.setSize(this.backPathVector.size() - 2);
            } else {
                this.backPathVector.setSize(this.backPathVector.size() - 1);
            }
            if (this.backPathVector.size() <= 0) {
                this.getGoBackAction().setEnabled(false);
            }
        }
    }

    public Action getGoBackAction() {
        return this.goBackAction;
    }

    public Action getChangeToParentDirectoryAction() {
        return this.goToParentDirectoryAction;
    }

    public JPopupMenu createViewPopupMenu() {
        changeViewActionListener mal = new changeViewActionListener();
        this.changeViewPopup = new JPopupMenu();
        this.changeViewButtonGroup = new ButtonGroup();
        JRadioButtonMenuItem menuItem = new JRadioButtonMenuItem("Thumbnail");
        this.changeViewButtonGroup.add(menuItem);
        menuItem.setActionCommand("Thumbnail");
        menuItem.addActionListener(mal);
        this.changeViewPopup.add(menuItem);
        menuItem = new JRadioButtonMenuItem("Icon");
        menuItem.setActionCommand("Icon");
        this.changeViewButtonGroup.add(menuItem);
        menuItem.addActionListener(mal);
        this.changeViewPopup.add(menuItem);
        menuItem = new JRadioButtonMenuItem("List");
        menuItem.setActionCommand("List");
        this.changeViewButtonGroup.add(menuItem);
        menuItem.addActionListener(mal);
        menuItem.setSelected(true);
        this.changeViewPopup.add(menuItem);
        menuItem = new JRadioButtonMenuItem("Details");
        menuItem.setActionCommand("Details");
        this.changeViewButtonGroup.add(menuItem);
        menuItem.addActionListener(mal);
        this.changeViewPopup.add(menuItem);
        return this.changeViewPopup;
    }

    protected void updateView(String s) {
        if (!(s.equals("Details") || s.equals("Icon") || s.equals("List") || s.equals("Thumbnail"))) {
            return;
        }
        this.VIEW = s;
        this.filepane.changeCardForView();
        Enumeration<AbstractButton> en = this.changeViewButtonGroup.getElements();
        while (en.hasMoreElements()) {
            JRadioButtonMenuItem rbm = (JRadioButtonMenuItem)en.nextElement();
            if (!rbm.getActionCommand().equals(this.getView())) continue;
            this.changeViewButtonGroup.setSelected(rbm.getModel(), true);
        }
    }

    static {
        hstrut5 = new Dimension(5, 5);
        hstrut10 = new Dimension(15, 15);
        vstrut5 = new Dimension(1, 5);
        shrinkwrap = new Insets(0, 0, 0, 0);
    }

    protected class changeViewActionListener
    implements ActionListener {
        ItemsPanel contentsPane;
        trendyFilePane tfc;

        protected changeViewActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            TrendyFileChooserUI.this.updateView(e.getActionCommand());
        }
    }

    public class chnageViewAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
            TrendyFileChooserUI.this.changeViewPopup.show((JToggleButton)e.getSource(), 0, ((JToggleButton)e.getSource()).getHeight() - 3);
        }
    }

    protected class ChangeToParentDirectoryAction
    extends AbstractAction {
        protected ChangeToParentDirectoryAction() {
            super("Go Up");
        }

        public void actionPerformed(ActionEvent e) {
            TrendyFileChooserUI.this.getFileChooser().changeToParentDirectory();
        }
    }

    protected class GoBackAction
    extends AbstractAction {
        protected GoBackAction() {
            super("Go Back");
        }

        public void actionPerformed(ActionEvent e) {
            TrendyFileChooserUI.this.goBack();
        }
    }

    public class favesAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
            TrendyFileChooserUI.this.filepane.addToFavesList();
        }
    }

    protected class TrendyFileView
    extends BasicFileChooserUI.BasicFileView {
        protected TrendyFileView() {
            super(TrendyFileChooserUI.this);
        }

        public Icon getIcon(File f) {
            Icon icon = this.getCachedIcon(f);
            if (icon != null) {
                return icon;
            }
            if (f != null) {
                icon = TrendyFileChooserUI.this.getFileChooser().getFileSystemView().getSystemIcon(f);
            }
            if (icon == null) {
                icon = super.getIcon(f);
            }
            this.cacheIcon(f, icon);
            return icon;
        }
    }

    private class AlignedLabel
    extends JLabel {
        private AlignedLabel[] group;
        private int maxWidth;

        AlignedLabel(String text) {
            super(text);
            this.maxWidth = 0;
            this.setAlignmentX(0.0f);
        }

        public Dimension getPreferredSize() {
            Dimension d = super.getPreferredSize();
            return new Dimension(this.getMaxWidth() + 11, d.height);
        }

        private int getMaxWidth() {
            if (this.maxWidth == 0 && this.group != null) {
                int i;
                int max = 0;
                for (i = 0; i < this.group.length; ++i) {
                    max = Math.max(this.group[i].getSuperPreferredWidth(), max);
                }
                for (i = 0; i < this.group.length; ++i) {
                    this.group[i].maxWidth = max;
                }
            }
            return this.maxWidth;
        }

        private int getSuperPreferredWidth() {
            return super.getPreferredSize().width;
        }

        static /* synthetic */ AlignedLabel[] access$1802(AlignedLabel x0, AlignedLabel[] x1) {
            x0.group = x1;
            return x1;
        }
    }

    protected class nameTextFieldComboBoxAction
    extends AbstractAction {
        protected nameTextFieldComboBoxAction() {
        }

        public void actionPerformed(ActionEvent e) {
            System.out.println("aaaa");
        }
    }

    protected class DirectoryComboBoxAction
    extends AbstractAction {
        protected DirectoryComboBoxAction() {
            super("DirectoryComboBoxAction");
        }

        public void actionPerformed(ActionEvent e) {
            File f = (File)TrendyFileChooserUI.this.directoryComboBox.getSelectedItem();
            TrendyFileChooserUI.this.setCurrentDirectoryOfFileChooser(f);
            TrendyFileChooserUI.this.fileNameTextField.requestFocus();
        }
    }

    protected class FilterComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel,
    PropertyChangeListener {
        protected FileFilter[] filters;

        protected FilterComboBoxModel() {
            this.filters = TrendyFileChooserUI.this.getFileChooser().getChoosableFileFilters();
        }

        public void propertyChange(PropertyChangeEvent e) {
            String prop = e.getPropertyName();
            if (prop == "ChoosableFileFilterChangedProperty") {
                this.filters = (FileFilter[])e.getNewValue();
                this.fireContentsChanged(this, -1, -1);
            } else if (prop == "fileFilterChanged") {
                this.fireContentsChanged(this, -1, -1);
            }
        }

        public void setSelectedItem(Object filter) {
            if (filter != null) {
                TrendyFileChooserUI.this.getFileChooser().setFileFilter((FileFilter)filter);
                TrendyFileChooserUI.this.setFileName(null);
                this.fireContentsChanged(this, -1, -1);
            }
        }

        public Object getSelectedItem() {
            FileFilter currentFilter = TrendyFileChooserUI.this.getFileChooser().getFileFilter();
            boolean found = false;
            if (currentFilter != null) {
                for (int i = 0; i < this.filters.length; ++i) {
                    if (this.filters[i] != currentFilter) continue;
                    found = true;
                }
                if (!found) {
                    TrendyFileChooserUI.this.getFileChooser().addChoosableFileFilter(currentFilter);
                }
            }
            return TrendyFileChooserUI.this.getFileChooser().getFileFilter();
        }

        public int getSize() {
            if (this.filters != null) {
                return this.filters.length;
            }
            return 0;
        }

        public Object getElementAt(int index) {
            if (index > this.getSize() - 1) {
                return TrendyFileChooserUI.this.getFileChooser().getFileFilter();
            }
            if (this.filters != null) {
                return this.filters[index];
            }
            return null;
        }
    }

    public class FilterComboBoxRenderer
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value != null && value instanceof FileFilter) {
                this.setText(((FileFilter)value).getDescription());
            }
            if (isSelected && index > -1) {
                this.setBorder(TrendyFileChooserUI.this.roundComboboxListRendererBorder);
            }
            return this;
        }
    }

    protected class DirectoryComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        Vector directories = new Vector();
        int[] depths = null;
        File selectedDirectory = null;
        JFileChooser chooser = TrendyFileChooserUI.this.getFileChooser();
        FileSystemView fsv = this.chooser.getFileSystemView();

        public DirectoryComboBoxModel() {
            File dir = TrendyFileChooserUI.this.getFileChooser().getCurrentDirectory();
            if (dir != null) {
                this.addItem(dir);
            }
        }

        private void addItem(File directory) {
            if (directory == null) {
                return;
            }
            this.directories.clear();
            File[] baseFolders = TrendyFileChooserUI.this.useShellFolder ? (File[])ShellFolder.get("fileChooserComboBoxFolders") : this.fsv.getRoots();
            this.directories.addAll(Arrays.asList(baseFolders));
            File canonical = null;
            try {
                canonical = directory.getCanonicalFile();
            }
            catch (IOException e) {
                canonical = directory;
            }
            try {
                ShellFolder sf;
                File f = sf = ShellFolder.getShellFolder(canonical);
                Vector<ShellFolder> path = new Vector<ShellFolder>(10);
                do {
                    path.addElement((ShellFolder)f);
                } while ((f = ((File)f).getParentFile()) != null);
                int pathCount = path.size();
                for (int i = 0; i < pathCount; ++i) {
                    f = (File)path.get(i);
                    if (!this.directories.contains(f)) continue;
                    int topIndex = this.directories.indexOf(f);
                    for (int j = i - 1; j >= 0; --j) {
                        this.directories.insertElementAt(path.get(j), topIndex + i - j);
                    }
                    break;
                }
                this.calculateDepths();
                this.setSelectedItem(sf);
            }
            catch (FileNotFoundException ex) {
                this.calculateDepths();
            }
        }

        private void calculateDepths() {
            this.depths = new int[this.directories.size()];
            block0: for (int i = 0; i < this.depths.length; ++i) {
                File dir = (File)this.directories.get(i);
                File parent = dir.getParentFile();
                this.depths[i] = 0;
                if (parent == null) continue;
                for (int j = i - 1; j >= 0; --j) {
                    if (!parent.equals((File)this.directories.get(j))) continue;
                    this.depths[i] = this.depths[j] + 1;
                    continue block0;
                }
            }
        }

        public int getDepth(int i) {
            return this.depths != null && i >= 0 && i < this.depths.length ? this.depths[i] : 0;
        }

        public void setSelectedItem(Object selectedDirectory) {
            if (TrendyFileChooserUI.this.allowBrowsing) {
                this.selectedDirectory = (File)selectedDirectory;
                this.fireContentsChanged(this, -1, -1);
            }
        }

        public Object getSelectedItem() {
            return this.selectedDirectory;
        }

        public int getSize() {
            return this.directories.size();
        }

        public Object getElementAt(int index) {
            return this.directories.elementAt(index);
        }
    }

    class IndentIcon
    implements Icon {
        Icon icon;
        int depth = 0;

        IndentIcon() {
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (c.getComponentOrientation().isLeftToRight()) {
                this.icon.paintIcon(c, g, x + this.depth * 10, y);
            } else {
                this.icon.paintIcon(c, g, x, y);
            }
        }

        public int getIconWidth() {
            return this.icon.getIconWidth() + this.depth * 10;
        }

        public int getIconHeight() {
            return this.icon.getIconHeight();
        }
    }

    class DirectoryComboBoxRenderer
    extends DefaultListCellRenderer {
        IndentIcon ii;

        DirectoryComboBoxRenderer() {
            this.ii = new IndentIcon();
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value == null) {
                this.setText("");
                return this;
            }
            File directory = (File)value;
            this.setText(TrendyFileChooserUI.this.getFileChooser().getName(directory));
            Icon icon = TrendyFileChooserUI.this.getFileChooser().getIcon(directory);
            if (icon == null) {
                icon = UIManager.getIcon("FileChooser.defaultDirectoryIcon");
            }
            this.ii.icon = icon;
            this.ii.depth = TrendyFileChooserUI.this.directoryComboBoxModel.getDepth(index);
            this.setIcon(this.ii);
            if (isSelected && index > -1) {
                this.setBorder(TrendyFileChooserUI.this.roundComboboxListRendererBorder);
            }
            return this;
        }
    }

    private class DelayedSelectionUpdater
    implements Runnable {
        DelayedSelectionUpdater() {
            SwingUtilities.invokeLater(this);
        }

        public void run() {
            TrendyFileChooserUI.this.setFileSelected();
        }
    }

    protected class ApproveSelectionAction2
    extends BasicFileChooserUI.ApproveSelectionAction {
        protected ApproveSelectionAction2() {
            super(TrendyFileChooserUI.this);
        }

        public void actionPerformed(ActionEvent e) {
            TrendyFileChooserUI.this.filepane.stopTumbnailGeneration();
            super.actionPerformed(e);
        }
    }

    protected class AddToFavouritesAction
    extends AbstractAction {
        protected AddToFavouritesAction() {
        }

        public void actionPerformed(ActionEvent e) {
            TrendyFileChooserUI.this.filepane.stopTumbnailGeneration();
            TrendyFileChooserUI.this.getFileChooser().cancelSelection();
        }
    }

    protected class CancelSelectionAction
    extends AbstractAction {
        protected CancelSelectionAction() {
        }

        public void actionPerformed(ActionEvent e) {
            TrendyFileChooserUI.this.filepane.stopTumbnailGeneration();
            TrendyFileChooserUI.this.getFileChooser().cancelSelection();
        }
    }
}

