/*
 * Decompiled with CFR 0.152.
 */
package com.Trendy.swing.plaf.filechooser;

import com.Trendy.swing.plaf.TrendyUtils;
import com.Trendy.swing.plaf.filechooser.TableSpecialLanel;
import com.Trendy.swing.plaf.filechooser.VirtualItem;
import com.Trendy.swing.plaf.filechooser.trendyFilePane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class TableContainer
extends JTable
implements MouseListener,
MouseMotionListener {
    private boolean mouseDownFlag = false;
    private boolean pointChanged = false;
    private int mpx;
    private int mpy;
    private int mpcx;
    private int mpcy;
    private int tx;
    private int ty;
    private Rectangle selectionRect;
    private Rectangle scrollRect;
    private JPopupMenu panePopup;
    private JPopupMenu headerPopup;
    private JMenuItem menuItem = new JMenuItem();
    private int row;
    private int col;
    private int counetr;
    private trendyFilePane filepane;
    private DefaultTableModel dtm;
    private Vector columnNames = new Vector();
    private Vector originalColumsWidth = new Vector();
    private tableHeaderMouseListener tableHeaderListener = new tableHeaderMouseListener();
    private tableKeyListener tablekeylistener = new tableKeyListener();
    private VirtualItem tempItem;
    private int mainColumnIndex;
    private Enumeration en;
    private headerActionListener hal = new headerActionListener();
    private boolean mouseDragging = false;
    protected int[] columnsWidth;
    private long mouseDraggingStartTime = 0L;

    public TableContainer(trendyFilePane chooser) {
        this.filepane = chooser;
        this.init();
    }

    public int getHeaderHeight() {
        return (int)this.tableHeader.getHeaderRect(0).getHeight();
    }

    public String getToolTipText(MouseEvent event) {
        this.row = this.rowAtPoint(event.getPoint());
        this.col = this.columnAtPoint(event.getPoint());
        if (this.col == this.mainColumnIndex && this.row > -1) {
            ((VirtualItem)this.filepane.visibleItemsList.elementAt(this.row)).getAdditionalFileData();
            return String.valueOf(((VirtualItem)this.filepane.visibleItemsList.elementAt(this.row)).getToolTipText());
        }
        return null;
    }

    TableContainer(Object[][] a, Object[] b) {
        super(a, b);
        this.init();
    }

    public boolean isCellEditable(int r, int c) {
        return false;
    }

    private void init() {
        this.dtm = (DefaultTableModel)this.getModel();
        this.columnNames.removeAllElements();
        this.columnNames.add("File Name");
        this.columnNames.add("Size");
        this.columnNames.add("Type");
        this.columnNames.add("Last modified");
        this.originalColumsWidth.add(new Integer(0));
        this.originalColumsWidth.add(new Integer(0));
        this.originalColumsWidth.add(new Integer(0));
        this.originalColumsWidth.add(new Integer(0));
        this.setBackground(Color.white);
        this.setShowGrid(false);
        this.setRowMargin(0);
        this.setSelectionBackground(Color.white);
        this.setFont(VirtualItem.menuFont);
        this.setRowHeight(Math.max(this.getFont().getSize(), 18) + 2);
        this.getTableHeader().setPreferredSize(new Dimension(20, 20));
        this.getTableHeader().setSize(new Dimension(20, 20));
        this.createPopupMenu();
        this.getTableHeader().addMouseListener(this.tableHeaderListener);
        this.getTableHeader().addMouseMotionListener(this.tableHeaderListener);
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.addKeyListener(this.tablekeylistener);
        this.setSelectionMode(2);
        this.setCellSelectionEnabled(true);
        this.clearSelection();
    }

    public void changeSelection(int rowIndex, int columnIndex, boolean toggle, boolean extend) {
    }

    private void createPopupMenu() {
        this.panePopup = this.filepane.getPanePopup();
        this.headerPopup = new JPopupMenu();
        String col = "";
        this.en = this.columnNames.elements();
        while (this.en.hasMoreElements()) {
            col = this.en.nextElement().toString();
            this.menuItem = new JCheckBoxMenuItem(col);
            this.menuItem.setSelected(true);
            this.menuItem.addActionListener(this.hal);
            this.headerPopup.add(this.menuItem);
        }
    }

    private void synchFilechooser() {
        this.filepane.selectedFilesVector.removeAllElements();
        for (int i = 0; i < this.getRowCount(); ++i) {
            this.tempItem = (VirtualItem)this.filepane.visibleItemsList.elementAt(i);
            if (this.getSelectionModel().isSelectedIndex(i)) {
                this.tempItem.updateSelectionMode(true);
                this.filepane.selectedFilesVector.add(this.tempItem);
                continue;
            }
            this.tempItem.updateSelectionMode(false);
            if (!this.filepane.selectedFilesVector.contains(this.tempItem)) continue;
            this.filepane.selectedFilesVector.remove(this.tempItem);
        }
        this.filepane.synchFilechoserSelction();
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.filepane.fc.isMultiSelectionEnabled()) {
            if (this.pointChanged) {
                if (this.mpcx < 0) {
                    this.tx = this.mpcx + this.mpx;
                    this.mpcx *= -1;
                } else {
                    this.tx = this.mpx;
                }
                if (this.mpcy < 0) {
                    this.ty = this.mpcy + this.mpy;
                    this.mpcy *= -1;
                } else {
                    this.ty = this.mpy;
                }
                this.selectionRect = new Rectangle(this.tx, this.ty, this.mpcx, this.mpcy);
                this.testFor(this.selectionRect);
                this.pointChanged = false;
            }
            if (this.mouseDownFlag) {
                g.setColor(new Color(TrendyUtils.currentTheme().getFileChooserColors()[0].getRed(), TrendyUtils.currentTheme().getFileChooserColors()[0].getGreen(), TrendyUtils.currentTheme().getFileChooserColors()[0].getBlue(), 40));
                g.fillRect(this.tx, this.ty, this.mpcx, this.mpcy);
                g.setColor(TrendyUtils.currentTheme().getFileChooserColors()[0]);
                g.drawRect(this.tx, this.ty, this.mpcx, this.mpcy);
            }
        }
    }

    private void testFor(Rectangle rect) {
        this.clearSelection();
        int x = (int)this.tableHeader.getHeaderRect(this.mainColumnIndex).getX();
        int y = 0;
        ++this.counetr;
        for (int i = 0; i < this.getRowCount(); ++i) {
            Dimension d;
            y = (i - 1) * this.getRowHeight() + this.getHeaderHeight();
            Rectangle r = new Rectangle(x, y, Math.min((int)(d = ((TableSpecialLanel)this.getValueAt(i, this.mainColumnIndex)).getPreferredSize()).getWidth(), this.getColumnModel().getColumn(this.mainColumnIndex).getWidth()), this.getRowHeight(i));
            if (r.intersects(rect)) {
                if (this.getSelectionModel().isSelectedIndex(i)) continue;
                this.updateSelectionInterval(i, true);
                continue;
            }
            if (this.getSelectionModel().isSelectedIndex(i)) continue;
            this.getSelectionModel().removeIndexInterval(i, i);
        }
        this.synchFilechooser();
    }

    public void mouseDragged(MouseEvent e) {
        this.mpcx = e.getX() - this.mpx;
        this.mpcy = e.getY() - this.mpy;
        this.pointChanged = true;
        this.mouseDragging = true;
        this.scrollRect = new Rectangle(e.getX(), e.getY(), 1, 1);
        this.scrollRectToVisible(this.scrollRect);
        this.repaint();
    }

    public void mouseMoved(MouseEvent e) {
    }

    private void resetPane() {
        this.mouseDownFlag = false;
        this.mpcx = 0;
        this.mpcy = 0;
        this.mpx = 0;
        this.mpy = 0;
        this.tx = 0;
        this.ty = 0;
        this.repaint();
    }

    public void mouseClicked(MouseEvent e) {
        this.synchFilechooser();
        if (e.getClickCount() == 2 && !(e.getSource() instanceof JTableHeader)) {
            this.row = ((JTable)e.getComponent()).rowAtPoint(e.getPoint());
            this.col = ((JTable)e.getComponent()).columnAtPoint(e.getPoint());
            if (this.getColumnName(this.col).equals(this.getColumnName(this.mainColumnIndex)) && this.row > -1) {
                this.tempItem = (VirtualItem)this.filepane.visibleItemsList.elementAt(this.row);
                if (this.tempItem.isDirectory()) {
                    this.filepane.filechooserUI.setCurrentDirectoryOfFileChooser(this.tempItem.getFile());
                } else {
                    this.filepane.fc.setSelectedFile(this.tempItem.getFile());
                    this.filepane.filechooserUI.getApproveSelectionAction().actionPerformed(null);
                }
            }
        }
    }

    private void doActionPerformed() {
        if (this.filepane.selectedFilesVector.contains(this.filepane.lastSelected)) {
            this.tempItem = this.filepane.lastSelected;
            if (this.tempItem.isDirectory()) {
                this.filepane.filechooserUI.setCurrentDirectoryOfFileChooser(this.tempItem.getFile());
            } else {
                this.filepane.fc.setSelectedFile(this.tempItem.getFile());
                this.filepane.filechooserUI.getApproveSelectionAction().actionPerformed(null);
            }
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
        this.mouseDraggingStartTime = 0L;
    }

    public void mousePressed(MouseEvent e) {
        this.mpx = e.getX();
        this.mpy = e.getY();
        this.mouseDownFlag = true;
        this.maybeShowPopup(e);
        if (e.getSource() instanceof JTable && !this.mouseDragging) {
            Dimension d;
            this.row = ((JTable)e.getComponent()).rowAtPoint(e.getPoint());
            this.col = ((JTable)e.getComponent()).columnAtPoint(e.getPoint());
            if (this.row < 0) {
                return;
            }
            int x = (int)this.tableHeader.getHeaderRect(this.mainColumnIndex).getX();
            int y = 0;
            ++this.counetr;
            y = (this.row - 1) * this.getRowHeight() + this.getHeaderHeight();
            Rectangle r = new Rectangle(x, y, Math.min((int)(d = ((TableSpecialLanel)this.getValueAt(this.row, this.mainColumnIndex)).getPreferredSize()).getWidth(), this.getColumnModel().getColumn(this.mainColumnIndex).getWidth()), this.getRowHeight(this.row));
            if (r.contains(e.getPoint())) {
                if (e.isControlDown()) {
                    if (this.isCellSelected(this.row, this.mainColumnIndex)) {
                        if (!e.isPopupTrigger()) {
                            this.getSelectionModel().removeSelectionInterval(this.row, this.row);
                        }
                    } else {
                        this.updateSelectionInterval(this.row, true);
                    }
                } else if (!this.isCellSelected(this.row, this.mainColumnIndex)) {
                    this.updateSelectionInterval(this.row, false);
                }
            } else {
                this.clearSelection();
            }
        }
        this.synchFilechooser();
    }

    public void mouseReleased(MouseEvent e) {
        this.mouseDownFlag = false;
        this.mouseDragging = false;
        this.resetPane();
        this.maybeShowPopup(e);
        this.repaint();
    }

    public void clearSelection() {
        super.clearSelection();
        this.getColumnModel().getSelectionModel().setSelectionInterval(this.mainColumnIndex, this.mainColumnIndex);
    }

    private void maybeShowPopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            if (e.getComponent() instanceof JTableHeader) {
                this.headerPopup.show(e.getComponent(), e.getX(), e.getY());
            } else {
                Dimension d;
                int y;
                this.row = ((JTable)e.getComponent()).rowAtPoint(e.getPoint());
                this.col = ((JTable)e.getComponent()).columnAtPoint(e.getPoint());
                if (this.row < 0) {
                    this.panePopup.show(e.getComponent(), e.getX(), e.getY());
                    return;
                }
                int x = (int)this.tableHeader.getHeaderRect(this.mainColumnIndex).getX();
                Rectangle r = new Rectangle(x, y = (this.row - 1) * this.getRowHeight() + this.getHeaderHeight(), Math.min((int)(d = ((TableSpecialLanel)this.getValueAt(this.row, this.mainColumnIndex)).getPreferredSize()).getWidth(), this.getColumnModel().getColumn(this.mainColumnIndex).getWidth()), this.getRowHeight(this.row));
                if (r.contains(e.getPoint())) {
                    this.tempItem = (VirtualItem)this.filepane.visibleItemsList.elementAt(this.row);
                    this.tempItem.getPopupMenu().show(e.getComponent(), e.getX(), e.getY());
                    this.filepane.lastSelected = this.tempItem;
                } else {
                    this.panePopup.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        }
    }

    public void updateData(Object[][] vals) {
        this.en = this.getColumnModel().getColumns();
        Vector<String> vec = new Vector<String>();
        while (this.en.hasMoreElements()) {
            vec.add(((TableColumn)this.en.nextElement()).getHeaderValue().toString());
        }
        if (vec.size() <= 0) {
            this.dtm.setDataVector(vals, this.columnNames.toArray());
        } else {
            this.dtm.setDataVector(vals, vec.toArray());
        }
        if (this.doINeedColumnSize()) {
            this.columnsWidth = new int[]{(int)((double)this.getWidth() * 0.5), (int)((double)this.getWidth() * 0.1), (int)((double)this.getWidth() * 0.21), (int)((double)this.getWidth() * 0.19)};
        }
        this.en = this.getColumnModel().getColumns();
        int i = 0;
        while (this.en.hasMoreElements()) {
            TableColumn tempColumn = (TableColumn)this.en.nextElement();
            int cw = this.columnsWidth[i];
            if (cw == 0) {
                tempColumn.setMinWidth(cw);
            }
            tempColumn.setPreferredWidth(cw);
            tempColumn.setWidth(cw);
            ++i;
        }
        this.mainColumnIndex = this.getColumnModel().getColumnIndex("File Name");
        this.getColumnModel().getColumn(this.mainColumnIndex).setCellRenderer(new labelRenderer());
        this.setSize(this.getPreferredSize());
        this.clearSelection();
    }

    private void captureColumnsWidth() {
        this.columnsWidth = new int[]{this.getColumnModel().getColumn(0).getWidth(), this.getColumnModel().getColumn(1).getWidth(), this.getColumnModel().getColumn(2).getWidth(), this.getColumnModel().getColumn(3).getWidth()};
    }

    private boolean doINeedColumnSize() {
        if (this.columnsWidth == null || this.columnsWidth.length < 4) {
            return true;
        }
        return this.columnsWidth[0] == 0 && this.columnsWidth[1] == 0 && this.columnsWidth[2] == 0 && this.columnsWidth[3] == 0;
    }

    public int getInitialHeight() {
        int height = 0;
        int rowCount = this.getRowCount();
        if (rowCount > 0 && this.getColumnCount() > 0) {
            Rectangle r = this.getCellRect(rowCount - 1, 0, true);
            height = r.y + r.height;
        }
        return height + this.getTableHeader().getHeight();
    }

    private void updateLastSelected() {
        int tempNum = this.filepane.visibleItemsList.indexOf(this.filepane.lastSelected);
        this.updateSelectionInterval(tempNum, false);
        this.synchFilechooser();
    }

    public void selectAll() {
        if (this.filepane.fc.isMultiSelectionEnabled()) {
            this.clearSelection();
            this.getSelectionModel().addSelectionInterval(0, this.getRowCount() - 1);
            this.synchFilechooser();
        }
    }

    private void updateMainColumnIndex() {
        this.mainColumnIndex = this.getColumnModel().getColumnIndex(this.columnNames.elementAt(0));
    }

    protected void updateSelectionInterval(int row, boolean add) {
        if (add && this.filepane.fc.isMultiSelectionEnabled()) {
            this.getSelectionModel().addSelectionInterval(row, row);
        } else {
            this.clearSelection();
            this.getSelectionModel().addSelectionInterval(row, row);
        }
        this.filepane.lastSelected = (VirtualItem)this.filepane.visibleItemsList.elementAt(row);
        if (!this.mouseDownFlag) {
            this.scrollRectToVisible(this.getCellRect(row, this.mainColumnIndex, false));
        }
    }

    private void headerMenuChanged(String col, JCheckBoxMenuItem source) {
        int index = this.getColumnModel().getColumnIndex(col);
        if (!source.isSelected()) {
            int tv = 0;
            for (int i = 0; i < this.getColumnCount(); ++i) {
                tv += this.getColumnModel().getColumn(i).getWidth();
            }
            if (tv == this.getColumn(col).getWidth()) {
                source.setSelected(true);
                return;
            }
            this.originalColumsWidth.set(this.columnNames.indexOf(col), new Integer(this.getColumnModel().getColumn(index).getWidth()));
            this.getColumnModel().getColumn(index).setMaxWidth(0);
            this.getColumnModel().getColumn(index).setMinWidth(0);
            this.getColumnModel().getColumn(index).setWidth(0);
            this.getColumnModel().getColumn(index).setPreferredWidth(0);
            this.getTableHeader().resizeAndRepaint();
        } else {
            this.getColumnModel().getColumn(index).setMaxWidth(Integer.MAX_VALUE);
            this.getColumnModel().getColumn(index).setPreferredWidth((Integer)this.originalColumsWidth.get(this.columnNames.indexOf(col)));
            this.getColumnModel().getColumn(index).setWidth((Integer)this.originalColumsWidth.get(this.columnNames.indexOf(col)));
            this.originalColumsWidth.set(this.columnNames.indexOf(col), new Integer(0));
            this.getTableHeader().resizeAndRepaint();
        }
    }

    private void forwardToNearestFor(String pre) {
        int index = this.filepane.visibleItemsList.indexOf(this.filepane.lastSelected) + 1;
        for (int i = 0; i < this.filepane.visibleItemsList.size(); ++i) {
            if (index == this.filepane.visibleItemsList.size()) {
                index = 0;
            }
            if (((VirtualItem)this.filepane.visibleItemsList.elementAt(index)).getFile_name().toLowerCase().startsWith(pre)) {
                this.updateSelectionInterval(index, false);
                this.scrollRectToVisible(this.getCellRect(index, this.mainColumnIndex, false));
                this.updateLastSelected();
                return;
            }
            ++index;
        }
    }

    private class tableKeyListener
    extends KeyAdapter {
        TableContainer tb;
        int tempNum = 0;

        private tableKeyListener() {
        }

        public void keyPressed(KeyEvent e) {
            if (this.tb == null) {
                this.tb = (TableContainer)e.getSource();
            }
            if (e.getKeyCode() == 27) {
                ((TableContainer)TableContainer.this).filepane.filechooserUI.getCancelSelectionAction().actionPerformed(null);
            } else if (e.getKeyCode() == 32) {
                TableContainer.this.updateLastSelected();
            } else if (e.getKeyCode() == 38) {
                this.tempNum = ((TableContainer)TableContainer.this).filepane.visibleItemsList.indexOf(((TableContainer)TableContainer.this).filepane.lastSelected);
                if (this.tempNum < ((TableContainer)TableContainer.this).filepane.visibleItemsList.size() && this.tempNum > 0) {
                    ((TableContainer)TableContainer.this).filepane.lastSelected = (VirtualItem)((TableContainer)TableContainer.this).filepane.visibleItemsList.elementAt(this.tempNum - 1);
                    TableContainer.this.updateLastSelected();
                }
            } else if (e.getKeyCode() == 40) {
                this.tempNum = ((TableContainer)TableContainer.this).filepane.visibleItemsList.indexOf(((TableContainer)TableContainer.this).filepane.lastSelected);
                if (this.tempNum < ((TableContainer)TableContainer.this).filepane.visibleItemsList.size() - 1) {
                    ((TableContainer)TableContainer.this).filepane.lastSelected = (VirtualItem)((TableContainer)TableContainer.this).filepane.visibleItemsList.elementAt(this.tempNum + 1);
                    TableContainer.this.updateLastSelected();
                }
            } else if (e.getKeyCode() == 36) {
                ((TableContainer)TableContainer.this).filepane.lastSelected = (VirtualItem)((TableContainer)TableContainer.this).filepane.visibleItemsList.elementAt(0);
                TableContainer.this.updateLastSelected();
            } else if (e.getKeyCode() == 35) {
                ((TableContainer)TableContainer.this).filepane.lastSelected = (VirtualItem)((TableContainer)TableContainer.this).filepane.visibleItemsList.elementAt(((TableContainer)TableContainer.this).filepane.visibleItemsList.size() - 1);
                TableContainer.this.updateLastSelected();
            } else if (e.getKeyCode() == 10) {
                TableContainer.this.doActionPerformed();
            } else if (e.getKeyCode() == 33) {
                this.tempNum = ((TableContainer)TableContainer.this).filepane.visibleItemsList.indexOf(((TableContainer)TableContainer.this).filepane.lastSelected);
                int diff = (int)(((JViewport)this.tb.getParent()).getViewRect().getHeight() / this.tb.getCellRect(this.tempNum, 0, true).getHeight()) - 1;
                if (this.tempNum - diff < 0) {
                    ((TableContainer)TableContainer.this).filepane.lastSelected = (VirtualItem)((TableContainer)TableContainer.this).filepane.visibleItemsList.elementAt(0);
                    TableContainer.this.updateLastSelected();
                } else {
                    ((TableContainer)TableContainer.this).filepane.lastSelected = (VirtualItem)((TableContainer)TableContainer.this).filepane.visibleItemsList.elementAt(this.tempNum - diff);
                    TableContainer.this.updateLastSelected();
                }
            } else if (e.getKeyCode() == 34) {
                this.tempNum = ((TableContainer)TableContainer.this).filepane.visibleItemsList.indexOf(((TableContainer)TableContainer.this).filepane.lastSelected);
                int diff = (int)(((JViewport)this.tb.getParent()).getViewRect().getHeight() / this.tb.getCellRect(this.tempNum, 0, true).getHeight()) - 1;
                if (this.tempNum + diff >= ((TableContainer)TableContainer.this).filepane.visibleItemsList.size()) {
                    ((TableContainer)TableContainer.this).filepane.lastSelected = (VirtualItem)((TableContainer)TableContainer.this).filepane.visibleItemsList.elementAt(((TableContainer)TableContainer.this).filepane.visibleItemsList.size() - 1);
                    TableContainer.this.updateLastSelected();
                } else {
                    ((TableContainer)TableContainer.this).filepane.lastSelected = (VirtualItem)((TableContainer)TableContainer.this).filepane.visibleItemsList.elementAt(this.tempNum + diff);
                    TableContainer.this.updateLastSelected();
                }
            } else {
                if (KeyEvent.getKeyText(e.getKeyCode()).toLowerCase().equals("a")) {
                    if (e.getModifiersEx() == 128) {
                        this.tb.selectAll();
                    }
                }
                if (e.getModifiersEx() == 0) {
                    this.tb.forwardToNearestFor(String.valueOf(e.getKeyChar()).toLowerCase());
                }
            }
        }
    }

    private class tableHeaderMouseListener
    extends MouseAdapter
    implements MouseMotionListener {
        private tableHeaderMouseListener() {
        }

        public void mouseClicked(MouseEvent e) {
            int viewColumn;
            JTableHeader h;
            TableColumnModel columnModel;
            int column;
            if (!e.isPopupTrigger() && (column = (columnModel = (h = (JTableHeader)e.getSource()).getColumnModel()).getColumn(viewColumn = columnModel.getColumnIndexAtX(e.getX())).getModelIndex()) != -1) {
                if (columnModel.getColumn(viewColumn).getHeaderValue().equals("File Name")) {
                    trendyFilePane trendyFilePane2 = TableContainer.this.filepane;
                    TableContainer.this.filepane;
                    trendyFilePane2.orderBy(trendyFilePane.ORDER_BY_FILE_NAME, false);
                    TableContainer.this.filepane.updateTableData();
                } else if (columnModel.getColumn(viewColumn).getHeaderValue().equals("Type")) {
                    trendyFilePane trendyFilePane3 = TableContainer.this.filepane;
                    TableContainer.this.filepane;
                    trendyFilePane3.orderBy(trendyFilePane.ORDER_BY_FILE_TYPE, false);
                    TableContainer.this.filepane.updateTableData();
                } else if (columnModel.getColumn(viewColumn).getHeaderValue().equals("Last modified")) {
                    trendyFilePane trendyFilePane4 = TableContainer.this.filepane;
                    TableContainer.this.filepane;
                    trendyFilePane4.orderBy(trendyFilePane.ORDER_BY_FILE_MODIFIED, false);
                    TableContainer.this.filepane.updateTableData();
                } else if (columnModel.getColumn(viewColumn).getHeaderValue().equals("Size")) {
                    trendyFilePane trendyFilePane5 = TableContainer.this.filepane;
                    TableContainer.this.filepane;
                    trendyFilePane5.orderBy(trendyFilePane.ORDER_BY_FILE_SIZE, false);
                    TableContainer.this.filepane.updateTableData();
                }
            }
        }

        public void mousePressed(MouseEvent e) {
            TableContainer.this.maybeShowPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            TableContainer.this.maybeShowPopup(e);
        }

        public void mouseDragged(MouseEvent e) {
            TableContainer.this.updateMainColumnIndex();
            TableContainer.this.captureColumnsWidth();
        }

        public void mouseMoved(MouseEvent e) {
        }
    }

    private class headerActionListener
    implements ActionListener {
        private headerActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            TableContainer.this.headerMenuChanged(e.getActionCommand(), (JCheckBoxMenuItem)e.getSource());
            TableContainer.this.captureColumnsWidth();
        }
    }

    class labelRenderer
    extends TableSpecialLanel
    implements TableCellRenderer {
        labelRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                return null;
            }
            TableSpecialLanel label = (TableSpecialLanel)value;
            label.setOpaque(false);
            label.setSelected(isSelected);
            if (isSelected) {
                label.setForeground(UIManager.getColor("textHighlightText"));
            } else {
                label.setForeground(UIManager.getColor("textText"));
            }
            return label;
        }
    }
}

