/*
 * Decompiled with CFR 0.152.
 */
package com.Trendy.swing.plaf.filechooser;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.SwingConstants;
import javax.swing.UIManager;

public class MultiLineLabel
extends JComponent
implements SwingConstants {
    int line_height;
    int line_ascent;
    int max_width = -1;
    int text_height = -1;
    int[] line_widths;
    int btnMarginWidth = 1;
    private String text = "";
    private boolean multiLine = true;
    private static Font labelFont = new Font("Arial", 0, 11);
    private int horizontalAlignment = 10;
    private int textAlignment = 10;
    private int verticalAlignment = 0;
    private FontMetrics fontmetrics;
    private Vector vec;
    private boolean need_update = true;

    public MultiLineLabel() {
        this("", 0, 0, 1);
    }

    public MultiLineLabel(String text) {
        this(text, 10, 10, 1);
    }

    public MultiLineLabel(String text, int horizontalAlignment) {
        this(text, horizontalAlignment, 10, 0);
    }

    public MultiLineLabel(String text, int horizontalAlignment, int textAlignment) {
        this(text, horizontalAlignment, textAlignment, 0);
    }

    public MultiLineLabel(String str, int horizontalAlignment, int textAlignment, int verticalAlignment) {
        this.setForeground(UIManager.getColor("Label.foreground"));
        this.setBackground(UIManager.getColor("textHighlight"));
        this.setFont(labelFont);
        this.setText(str);
        this.horizontalAlignment = horizontalAlignment;
        this.textAlignment = textAlignment;
        this.verticalAlignment = verticalAlignment;
        this.need_update = true;
        this.putClientProperty("TRENDY_ANTIALIASED_FONT_MINIMUM_SIZE", UIManager.get("Label.TRENDY_ANTIALIASED_FONT_MINIMUM_SIZE"));
    }

    private void updateTextVector() {
        this.vec = new Vector();
        String str = "";
        String lineStr = "";
        int w = this.getWidth();
        if (w > 6) {
            w -= 4;
        }
        int counter = 0;
        char[] ca = this.text.toCharArray();
        String tempStr = "";
        Vector<String> sentVec = new Vector<String>();
        char lastChar = ca[0];
        tempStr = tempStr + lastChar;
        for (int i = 1; i < ca.length; ++i) {
            if (lastChar == ' ') {
                if (ca[i] == ' ') {
                    tempStr = tempStr + ca[i];
                } else {
                    sentVec.add(tempStr);
                    tempStr = String.valueOf(ca[i]);
                }
            } else if (ca[i] == ' ') {
                sentVec.add(tempStr);
                tempStr = String.valueOf(ca[i]);
            } else {
                tempStr = tempStr + ca[i];
            }
            lastChar = ca[i];
        }
        if (!tempStr.equals("")) {
            sentVec.add(tempStr);
        }
        Enumeration els = sentVec.elements();
        while (els.hasMoreElements()) {
            str = els.nextElement().toString();
            ++counter;
            if (this.fontmetrics.stringWidth(str) <= w) {
                if (this.fontmetrics.stringWidth(lineStr + str) <= w) {
                    lineStr = lineStr + str;
                    continue;
                }
                if (!lineStr.equals("")) {
                    this.vec.add(lineStr);
                    lineStr = "";
                }
                lineStr = str;
                continue;
            }
            if (!lineStr.equals("")) {
                this.vec.add(lineStr);
                lineStr = "";
            }
            ca = str.toCharArray();
            int first = 0;
            for (int i = 0; i < ca.length; ++i) {
                if (this.fontmetrics.stringWidth(str.substring(first, i)) <= w) continue;
                this.vec.add(str.substring(first, i - 1));
                first = i - 1;
            }
            lineStr = str.substring(first, str.length());
        }
        if (!lineStr.equals("")) {
            this.vec.add(lineStr);
        }
    }

    private void recalculateDimension() {
        this.fontmetrics = this.getFontMetrics(this.getFont());
        this.line_height = this.fontmetrics.getHeight();
        this.line_ascent = this.fontmetrics.getAscent();
        this.line_widths = new int[this.vec.size()];
        this.max_width = 0;
        for (int i = 0; i < this.vec.size(); ++i) {
            this.line_widths[i] = this.fontmetrics.stringWidth(this.vec.elementAt(i).toString());
            this.max_width = Math.max(this.max_width, this.line_widths[i]);
        }
        this.max_width += 2 * this.btnMarginWidth;
        this.text_height = this.vec.size() * this.line_height;
        this.revalidate();
    }

    public Dimension getMaximumSize() {
        return new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
    }

    public Dimension getMinimumSize() {
        return new Dimension(10, 20);
    }

    public Dimension getMinimumSize1() {
        if (this.max_width == -1 || this.text_height == -1) {
            this.recalculateDimension();
        }
        Insets insets = this.getInsets();
        return new Dimension(this.max_width + insets.left + insets.right, this.text_height + insets.top + insets.bottom);
    }

    private void paintOneLine(Graphics g, Dimension d, Insets insets, int y) {
        int ha = this.getBidiHorizontalAlignment(this.horizontalAlignment);
        int ww = this.fontmetrics.stringWidth(this.text);
        int x = 0;
        if (ha == 2) {
            ha = this.getBidiHorizontalAlignment(this.textAlignment);
            if (ha == 2) {
                x = insets.left;
            } else if (ha == 4) {
                x = this.max_width - ww + insets.left;
            } else if (ha == 0) {
                x = insets.left + (this.max_width - ww) / 2;
            }
        } else if (ha == 4) {
            ha = this.getBidiHorizontalAlignment(this.textAlignment);
            if (ha == 2) {
                x = d.width - this.max_width - insets.right;
            } else if (ha == 4) {
                x = d.width - ww - insets.right;
            } else if (ha == 0) {
                x = d.width - this.max_width - insets.right + (this.max_width - ww) / 2;
            }
        } else if (ha == 0) {
            ha = this.getBidiHorizontalAlignment(this.textAlignment);
            int clientAreaWidth = d.width - insets.left - insets.right;
            if (ha == 2) {
                x = insets.left + (clientAreaWidth - this.max_width) / 2;
            } else if (ha == 4) {
                x = insets.left + (clientAreaWidth - this.max_width) / 2 + (this.max_width - ww);
            } else if (ha == 0) {
                x = insets.left + (clientAreaWidth - ww) / 2;
            }
        }
        int re = (this.getHeight() + this.fontmetrics.getHeight()) / 2 - 2;
        int w = this.fontmetrics.stringWidth(this.text);
        int last = 0;
        if (w > this.getWidth()) {
            char[] ca = this.text.toCharArray();
            last = ca.length;
            for (int i = 0; i < ca.length; ++i) {
                if (this.fontmetrics.stringWidth(this.text.substring(0, i) + "..." + 2) <= this.getWidth()) continue;
                last = i - 1;
                g.drawString(this.text.substring(0, last) + "...", 2, re);
                return;
            }
        }
        g.drawString(this.text, x, re);
    }

    protected void paintComponent(Graphics g) {
        if (this.getWidth() <= 0 || this.getHeight() <= 0) {
            return;
        }
        super.paintComponent(g);
        this.updateInfo();
        if (this.isOpaque()) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        g.setColor(this.getForeground());
        Dimension d = this.getSize();
        if (d.width != this.max_width || d.height != this.text_height) {
            this.recalculateDimension();
        }
        Insets insets = this.getInsets();
        int y = 0;
        y = insets.top + this.line_ascent;
        if (this.multiLine) {
            this.paintMultiLine(g, d, insets, y);
        } else {
            this.paintOneLine(g, d, insets, y);
        }
    }

    private void paintMultiLine(Graphics g, Dimension d, Insets insets, int y) {
        for (int i = 0; i < this.vec.size(); ++i) {
            int x = 0;
            int clientAreaWidth = d.width - insets.left - insets.right;
            x = insets.left + (clientAreaWidth - this.line_widths[i]) / 2;
            g.drawString(this.vec.elementAt(i).toString(), x += this.btnMarginWidth, y);
            y += this.line_height;
        }
    }

    private void updateInfo() {
        if (this.text == null || this.text == "") {
            return;
        }
        if (!this.need_update) {
            return;
        }
        this.updateTextVector();
        this.recalculateDimension();
        this.need_update = false;
    }

    public void setText(String str) {
        this.text = str;
        this.fontmetrics = this.getFontMetrics(this.getFont());
        this.need_update = true;
    }

    private int getBidiHorizontalAlignment(int ha) {
        if (ha == 10) {
            ha = this.getComponentOrientation().isLeftToRight() ? 2 : 4;
        } else if (ha == 11) {
            ha = this.getComponentOrientation().isLeftToRight() ? 4 : 2;
        }
        return ha;
    }

    public int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(int verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
        this.need_update = true;
        this.repaint();
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(int horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
        this.need_update = true;
        this.repaint();
    }

    public int getTextAlignment() {
        return this.textAlignment;
    }

    public void setTextAlignment(int textAlignment) {
        this.textAlignment = textAlignment;
        this.need_update = true;
        this.repaint();
    }

    public void setMultiLine(boolean b) {
        this.multiLine = b;
        this.need_update = true;
        this.updateInfo();
    }

    public void setNeed_update(boolean need_update) {
        this.need_update = need_update;
    }

    public int getPreferredLineWidth() {
        return this.fontmetrics.stringWidth(this.text);
    }

    public int getPreferredLineHeight() {
        return this.fontmetrics.getHeight();
    }

    public int getLineDiff() {
        if (this.vec.size() > 1) {
            return this.fontmetrics.getHeight() * (this.vec.size() - 1);
        }
        return 0;
    }

    public Dimension getPreferredSize() {
        if (this.multiLine) {
            return new Dimension(this.getPreferredLineWidth(), this.fontmetrics.getHeight() * this.vec.size());
        }
        return new Dimension(this.getPreferredLineWidth(), this.fontmetrics.getHeight());
    }
}

