/*
 * Decompiled with CFR 0.152.
 */
package com.Trendy.swing.plaf.filechooser;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import sun.awt.AppContext;

class HelperTools {
    private static final Object sharedFrameKey = JOptionPane.class;
    private static final Object sharedOwnerFrameKey = new StringBuffer("SwingUtilities.sharedOwnerFrame");
    private static int w;
    private static int h;
    static BufferedImage dest;
    static BufferedImage dest2;
    static Graphics g;
    static float val;
    static float[] blurElements;
    static Kernel blurKernel;
    static ConvolveOp blurCop;
    static float[] sharpenElements;
    static Kernel sharpenKernel;
    static ConvolveOp sharpenCop;
    private static BufferedImage srcBImage;

    HelperTools() {
    }

    static Object appContextGet(Object key) {
        return AppContext.getAppContext().get(key);
    }

    static void appContextPut(Object key, Object value) {
        AppContext.getAppContext().put(key, value);
    }

    static Frame getSharedOwnerFrame() throws HeadlessException {
        Frame sharedOwnerFrame = (Frame)HelperTools.appContextGet(sharedOwnerFrameKey);
        if (sharedOwnerFrame == null) {
            sharedOwnerFrame = new Frame(){

                public void show() {
                }

                public synchronized void dispose() {
                    try {
                        this.getToolkit().getSystemEventQueue();
                        super.dispose();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            HelperTools.appContextPut(sharedOwnerFrameKey, sharedOwnerFrame);
        }
        return sharedOwnerFrame;
    }

    public static Frame getRootFrame() throws HeadlessException {
        Frame sharedFrame = (Frame)HelperTools.appContextGet(sharedFrameKey);
        if (sharedFrame == null) {
            sharedFrame = HelperTools.getSharedOwnerFrame();
            HelperTools.appContextPut(sharedFrameKey, sharedFrame);
        }
        return sharedFrame;
    }

    static Window getWindowForComponent(Component parentComponent) throws HeadlessException {
        if (parentComponent == null) {
            return HelperTools.getRootFrame();
        }
        if (parentComponent instanceof Frame || parentComponent instanceof Dialog) {
            return (Window)parentComponent;
        }
        return HelperTools.getWindowForComponent(parentComponent.getParent());
    }

    public static ImageIcon getSmallSystemIcon(Image img) throws Exception {
        if (img.getWidth(null) > 20 || img.getHeight(null) > 20) {
            if (img.getWidth(null) > img.getHeight(null)) {
                w = 18;
                h = img.getHeight(null) * 18 / img.getWidth(null);
            } else {
                h = 18;
                w = img.getWidth(null) * 18 / img.getHeight(null);
            }
        } else {
            return new ImageIcon(img);
        }
        dest = new BufferedImage(w, h, 6);
        dest2 = new BufferedImage(w, h, 6);
        g = dest.getGraphics();
        g.drawImage(img, 1, 1, w, h, null);
        g.dispose();
        blurCop.filter(dest, dest2);
        return new ImageIcon(dest2);
    }

    public static ImageIcon getBigSystemIcon(Image img) throws Exception {
        if (img.getWidth(null) < 20 || img.getHeight(null) < 20) {
            if (img.getWidth(null) > img.getHeight(null)) {
                w = 24;
                h = img.getHeight(null) * 24 / img.getWidth(null);
            } else {
                h = 24;
                w = img.getWidth(null) * 24 / img.getHeight(null);
            }
        } else {
            return new ImageIcon(img);
        }
        dest = new BufferedImage(w, h, 5);
        dest2 = new BufferedImage(w, h, 5);
        g = dest.getGraphics();
        g.setColor(Color.white);
        g.fillRect(0, 0, 22, 22);
        g.drawImage(img, 0, 0, w, h, null);
        g.dispose();
        sharpenCop.filter(dest, dest2);
        return new ImageIcon(dest);
    }

    public static Image getScaledInstance(File file) throws Exception {
        srcBImage = ImageIO.read(file);
        if (srcBImage.getWidth() > srcBImage.getHeight()) {
            w = 100;
            h = srcBImage.getHeight() * 100 / srcBImage.getWidth();
        } else {
            h = 100;
            w = srcBImage.getWidth() * 100 / srcBImage.getHeight();
        }
        dest = new BufferedImage(w, h, 5);
        dest2 = new BufferedImage(w, h, 5);
        g = dest.getGraphics();
        g.setColor(Color.white);
        g.fillRect(0, 0, 100, 100);
        g.drawImage(srcBImage, 0, 0, w, h, null);
        g.dispose();
        srcBImage = null;
        blurCop.filter(dest, dest2);
        return dest2;
    }

    static {
        val = 0.055f;
        blurElements = new float[]{val, val, val, val, 0.66f, val, val, val, val};
        blurKernel = new Kernel(3, 3, blurElements);
        blurCop = new ConvolveOp(blurKernel, 1, null);
        sharpenElements = new float[]{-0.03f, -0.03f, -0.03f, -0.03f, 1.24f, -0.03f, -0.03f, -0.03f, -0.03f};
        sharpenKernel = new Kernel(3, 3, sharpenElements);
        sharpenCop = new ConvolveOp(sharpenKernel, 1, null);
    }
}

