/*
 * Decompiled with CFR 0.152.
 */
package com.Trendy.swing.plaf.filechooser;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

class ButtonAreaLayout
implements LayoutManager {
    private int hGap = 5;
    private int topMargin = 17;

    ButtonAreaLayout() {
    }

    public void addLayoutComponent(String string, Component comp) {
    }

    public void layoutContainer(Container container) {
        Component[] children = container.getComponents();
        if (children != null && children.length > 0) {
            int xOffset;
            int xLocation;
            int numChildren = children.length;
            Dimension[] sizes = new Dimension[numChildren];
            Insets insets = container.getInsets();
            int yLocation = insets.top + this.topMargin;
            int maxWidth = 0;
            for (int counter = 0; counter < numChildren; ++counter) {
                sizes[counter] = children[counter].getPreferredSize();
                maxWidth = Math.max(maxWidth, sizes[counter].width);
            }
            if (container.getComponentOrientation().isLeftToRight()) {
                xLocation = container.getSize().width - insets.left - maxWidth;
                xOffset = this.hGap + maxWidth;
            } else {
                xLocation = insets.left;
                xOffset = -(this.hGap + maxWidth);
            }
            for (int counter = numChildren - 1; counter >= 0; --counter) {
                children[counter].setBounds(xLocation, yLocation, maxWidth, sizes[counter].height);
                xLocation -= xOffset;
            }
        }
    }

    public Dimension minimumLayoutSize(Container c) {
        Component[] children;
        if (c != null && (children = c.getComponents()) != null && children.length > 0) {
            int numChildren = children.length;
            int height = 0;
            Insets cInsets = c.getInsets();
            int extraHeight = this.topMargin + cInsets.top + cInsets.bottom;
            int extraWidth = cInsets.left + cInsets.right;
            int maxWidth = 0;
            for (int counter = 0; counter < numChildren; ++counter) {
                Dimension aSize = children[counter].getPreferredSize();
                height = Math.max(height, aSize.height);
                maxWidth = Math.max(maxWidth, aSize.width);
            }
            return new Dimension(extraWidth + numChildren * maxWidth + (numChildren - 1) * this.hGap, extraHeight + height);
        }
        return new Dimension(0, 0);
    }

    public Dimension preferredLayoutSize(Container c) {
        return this.minimumLayoutSize(c);
    }

    public void removeLayoutComponent(Component c) {
    }
}

