/*
 * Decompiled with CFR 0.152.
 */
package com.Trendy.swing.plaf;

import com.Trendy.swing.plaf.Themes.TrendyTheme;
import com.Trendy.swing.plaf.TrendyCashedPainter;
import com.Trendy.swing.plaf.TrendyLookAndFeel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;

public final class TrendyUtils {
    public static void clearMenuCache() {
        TrendyCashedPainter.clearMenuCache();
    }

    public static TrendyTheme currentTheme() {
        TrendyLookAndFeel cfr_ignored_0 = (TrendyLookAndFeel)UIManager.getLookAndFeel();
        return TrendyLookAndFeel.getCurrentTheme();
    }

    static void drawRoundRectBorder(Graphics g, int w, int h, String action, boolean down) {
        ColorUIResource c1 = new ColorUIResource(0);
        ColorUIResource c2 = new ColorUIResource(0);
        ColorUIResource c3 = new ColorUIResource(0);
        ColorUIResource c4 = new ColorUIResource(0);
        ColorUIResource c5 = new ColorUIResource(0);
        ColorUIResource c6 = new ColorUIResource(0);
        ColorUIResource c7 = new ColorUIResource(0);
        if (action.equals("NORMAL")) {
            c1 = TrendyUtils.currentTheme().getButtonBorderColors()[0][0];
            c2 = TrendyUtils.currentTheme().getButtonBorderColors()[0][1];
            c3 = TrendyUtils.currentTheme().getButtonBorderColors()[0][2];
            c4 = TrendyUtils.currentTheme().getButtonBorderColors()[0][3];
            c5 = TrendyUtils.currentTheme().getButtonBorderColors()[0][4];
            c6 = TrendyUtils.currentTheme().getButtonBorderColors()[0][5];
            c7 = TrendyUtils.currentTheme().getButtonBorderColors()[0][6];
        } else if (action.equals("ROLLOVER")) {
            c1 = TrendyUtils.currentTheme().getButtonBorderColors()[1][0];
            c2 = TrendyUtils.currentTheme().getButtonBorderColors()[1][1];
            c3 = TrendyUtils.currentTheme().getButtonBorderColors()[1][2];
            c4 = TrendyUtils.currentTheme().getButtonBorderColors()[1][3];
            c5 = TrendyUtils.currentTheme().getButtonBorderColors()[1][4];
            c6 = TrendyUtils.currentTheme().getButtonBorderColors()[1][5];
            c7 = TrendyUtils.currentTheme().getButtonBorderColors()[1][6];
        } else if (action.equals("FOCUS")) {
            c1 = TrendyUtils.currentTheme().getButtonBorderColors()[2][0];
            c2 = TrendyUtils.currentTheme().getButtonBorderColors()[2][1];
            c3 = TrendyUtils.currentTheme().getButtonBorderColors()[2][2];
            c4 = TrendyUtils.currentTheme().getButtonBorderColors()[2][3];
            c5 = TrendyUtils.currentTheme().getButtonBorderColors()[2][4];
            c6 = TrendyUtils.currentTheme().getButtonBorderColors()[2][5];
            c7 = TrendyUtils.currentTheme().getButtonBorderColors()[2][6];
        } else if (action.equals("DISABLE")) {
            c1 = TrendyUtils.currentTheme().getButtonBorderColors()[3][0];
            c2 = TrendyUtils.currentTheme().getButtonBorderColors()[3][1];
            c3 = TrendyUtils.currentTheme().getButtonBorderColors()[3][2];
            c4 = TrendyUtils.currentTheme().getButtonBorderColors()[3][3];
            c5 = TrendyUtils.currentTheme().getButtonBorderColors()[3][4];
            c6 = TrendyUtils.currentTheme().getButtonBorderColors()[3][5];
            c7 = TrendyUtils.currentTheme().getButtonBorderColors()[3][6];
        }
        g.setColor(c1);
        g.drawLine(5, 0, w - 7, 0);
        g.drawLine(0, 6, 0, h - 7);
        g.drawLine(w - 1, 6, w - 1, h - 7);
        g.setColor(c2);
        g.drawLine(6, h - 1, w - 7, h - 1);
        g.setColor(c5);
        g.drawLine(0, 5, 1, 5);
        g.drawLine(5, 1, 5, 0);
        g.setColor(c7);
        g.drawLine(1, 4, 1, 3);
        g.drawLine(4, 1, 3, 1);
        g.drawLine(3, 1, 1, 3);
        g.setColor(c4);
        g.drawLine(4, 0, 5, 1);
        g.drawLine(0, 4, 1, 5);
        g.drawLine(2, 3, 3, 2);
        g.setColor(c5);
        g.drawLine(w - 1, 5, w - 2, 5);
        g.drawLine(w - 6, 0, w - 6, 1);
        g.setColor(c7);
        g.drawLine(w - 2, 4, w - 2, 3);
        g.drawLine(w - 5, 1, w - 4, 1);
        g.drawLine(w - 4, 1, w - 2, 3);
        g.setColor(c4);
        g.drawLine(w - 5, 0, w - 6, 1);
        g.drawLine(w - 1, 4, w - 2, 5);
        g.drawLine(w - 4, 2, w - 3, 3);
        g.setColor(c3);
        g.drawLine(2, h - 4, 3, h - 3);
        g.drawLine(5, h - 2, 5, h - 1);
        g.setColor(c5);
        g.drawLine(0, h - 6, 1, h - 6);
        g.setColor(c6);
        g.drawLine(1, h - 5, 1, h - 4);
        g.drawLine(4, h - 2, 3, h - 2);
        g.drawLine(3, h - 2, 1, h - 4);
        g.setColor(c3);
        g.drawLine(w - 3, h - 4, w - 4, h - 3);
        g.drawLine(w - 6, h - 2, w - 6, h - 1);
        g.setColor(c5);
        g.drawLine(w - 1, h - 6, w - 2, h - 6);
        g.setColor(c6);
        g.drawLine(w - 2, h - 5, w - 2, h - 4);
        g.drawLine(w - 5, h - 2, w - 4, h - 2);
        g.drawLine(w - 4, h - 2, w - 2, h - 4);
        if (down) {
            g.setColor(new ColorUIResource(240, 240, 240));
        } else {
            g.setColor(new ColorUIResource(210, 210, 210));
        }
        g.drawLine(8, h, w - 9, h);
    }

    static void drawMenuItemBackground(Graphics g, JMenuItem menuItem) {
        Color oldColor = g.getColor();
        ButtonModel model = menuItem.getModel();
        int w = menuItem.getWidth();
        int h = menuItem.getHeight();
        if (model.isArmed() || model.isSelected() && menuItem instanceof JMenu) {
            Color c1 = UIManager.getColor("MenuItem.selectionBackground");
            g.setColor(c1);
            g.fillRect(0, 0, w, h);
            g.setColor(c1.brighter());
            g.drawLine(2, 0, w - 3, 0);
            g.drawLine(2, h - 1, w - 3, h - 1);
            g.drawLine(0, 2, 0, h - 3);
            g.drawLine(w - 1, 2, w - 1, h - 3);
            g.setColor(c1.brighter().brighter());
            g.drawLine(0, 1, 1, 0);
            g.drawLine(w - 1, 1, w - 2, 0);
            g.drawLine(0, h - 2, 1, h - 1);
            g.drawLine(w - 1, h - 2, w - 2, h - 1);
            g.setColor(c1.brighter().brighter().brighter());
            g.drawLine(0, 0, 0, 0);
            g.drawLine(0, h - 1, 0, h - 1);
            g.drawLine(w - 1, 0, w - 1, 0);
            g.drawLine(w - 1, h - 1, w - 1, h - 1);
        } else if (!(menuItem instanceof JMenu) || !((JMenu)menuItem).isTopLevelMenu()) {
            g.setColor(Color.white);
            g.fillRect(0, 0, w, h);
            Graphics2D g2 = (Graphics2D)g;
            g2.setPaint(new GradientPaint(w > 50 ? w - 50 : 0, 0.0f, new ColorUIResource(Color.white), w, 0.0f, new ColorUIResource(235, 242, 255)));
            g2.fillRect(w > 50 ? w - 50 : 0, 0, 50, h);
        }
        g.setColor(oldColor);
    }

    static boolean isToolbarButton(JComponent c) {
        return c.getParent() instanceof JToolBar;
    }

    static void drawToolbarButtonSkin(Graphics g, JComponent c) {
        int w = c.getWidth();
        int h = c.getHeight();
        AbstractButton b = (AbstractButton)c;
        if (c.getParent() instanceof JToolBar) {
            g.setColor(c.getParent().getBackground());
        }
        if (b.isOpaque()) {
            g.fillRect(0, 0, b.getWidth(), b.getHeight());
        }
        if (b.getModel().isSelected() || b.getModel().isPressed() && b.getModel().isArmed()) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setPaint(new GradientPaint(0.0f, 0.0f, TrendyUtils.currentTheme().getToolbarColors()[0], 0.0f, h, Color.white));
            g2.fillRect(1, 1, w - 2, h - 2);
            g.setColor(TrendyUtils.currentTheme().getToolbarButtonColors()[0]);
            g.drawLine(2, 0, w - 3, 0);
            g.drawLine(0, 2, 0, h - 3);
            g.setColor(TrendyUtils.currentTheme().getToolbarButtonColors()[1]);
            g.drawLine(w - 1, 2, w - 1, h - 3);
            g.drawLine(2, h - 1, w - 3, h - 1);
            g.setColor(TrendyUtils.currentTheme().getToolbarButtonColors()[2]);
            g.drawLine(0, 1, 1, 0);
            g.drawLine(w - 1, 1, w - 2, 0);
            g.setColor(TrendyUtils.currentTheme().getToolbarButtonColors()[3]);
            g.drawLine(1, h - 1, 0, h - 2);
            g.setColor(TrendyUtils.currentTheme().getToolbarButtonColors()[1]);
            g.drawLine(w - 1, h - 2, w - 2, h - 1);
            g.setColor(TrendyUtils.currentTheme().getToolbarButtonColors()[4]);
            g.drawLine(0, 0, 0, 0);
            g.drawLine(w - 1, 0, w - 1, 0);
        } else if (b.getModel().isRollover()) {
            g.setColor(TrendyUtils.currentTheme().getToolbarButtonColors()[0]);
            g.drawLine(2, 0, w - 3, 0);
            g.drawLine(2, h - 1, w - 3, h - 1);
            g.drawLine(0, 2, 0, h - 3);
            g.drawLine(w - 1, 2, w - 1, h - 3);
            g.drawLine(1, 1, 1, 1);
            g.drawLine(w - 2, 1, w - 2, 1);
            g.drawLine(1, h - 2, 1, h - 2);
            g.drawLine(w - 2, h - 2, w - 2, h - 2);
            g.setColor(TrendyUtils.currentTheme().getToolbarButtonColors()[8]);
            g.drawLine(0, 1, 1, 0);
            g.drawLine(w - 1, 1, w - 2, 0);
            g.drawLine(1, h - 1, 0, h - 2);
            g.drawLine(w - 1, h - 2, w - 2, h - 1);
            g.setColor(TrendyUtils.currentTheme().getToolbarButtonColors()[7]);
            g.drawLine(1, 2, 2, 1);
            g.drawLine(w - 2, 2, w - 3, 1);
            g.setColor(TrendyUtils.currentTheme().getToolbarButtonColors()[6]);
            g.drawLine(2, h - 2, 1, h - 3);
            g.drawLine(w - 2, h - 3, w - 3, h - 2);
        }
    }

    static boolean isLeftToRight(Component c) {
        return c.getComponentOrientation().isLeftToRight();
    }

    static void drawGradient(Graphics g, int x1, int y1, int x2, int y2, Color c1, Color c2) {
        int w = x2 - x1;
        int h = y2 - y1;
        if (w > 0) {
            BufferedImage bi = new BufferedImage(w, 1, 5);
            Graphics2D g2 = (Graphics2D)bi.getGraphics();
            g2.setPaint(new GradientPaint(0.0f, 0.0f, c1, w, 0.0f, c2));
            g2.fillRect(0, 0, w, 1);
            g.drawImage(bi, x1, 0, w, y2, 0, 0, x2, 1, null);
        } else if (h > 0) {
            // empty if block
        }
    }

    static class spinnerButton
    extends JButton {
        JButton c = this;
        private boolean up = false;
        Dimension d;

        public spinnerButton(String type) {
            if (type.equals("up")) {
                this.up = true;
            }
            this.setBorder(null);
            this.setContentAreaFilled(false);
        }

        private void paintDownButton(Graphics g) {
            int w = (int)this.getSize().getWidth();
            int h = (int)this.getSize().getHeight();
            boolean index = false;
            if (this.getModel().isEnabled()) {
                if (this.getModel().isPressed()) {
                    g.setColor(TrendyUtils.currentTheme().getSpinnerColors()[0]);
                    g.drawLine(1, 0, w - 1, 0);
                    g.fillRect(1, 1, w - 1, h - 3);
                    g.drawLine(1, h - 4, w - 1, h - 4);
                    g.drawLine(1, h - 3, w - 2, h - 3);
                    g.drawLine(1, h - 2, w - 3, h - 2);
                    g.drawLine(1, h - 1, w - 5, h - 1);
                    g.drawLine(1, 0, w - 1, 0);
                    g.drawLine(w - 1, 1, w - 1, h - 3);
                    g.drawLine(w - 2, 1, w - 2, h - 4);
                    g.drawLine(w - 3, 1, w - 3, h - 4);
                    g.setColor(TrendyUtils.currentTheme().getSpinnerColors()[1]);
                    g.drawLine(0, 0, 0, h);
                } else {
                    g.setColor(TrendyUtils.currentTheme().getSpinnerColors()[2]);
                    g.drawLine(1, 0, w - 1, 0);
                    g.fillRect(1, 1, w - 1, h - 3);
                    g.setColor(TrendyUtils.currentTheme().getSpinnerColors()[3]);
                    g.drawLine(1, h - 4, w - 1, h - 4);
                    g.setColor(TrendyUtils.currentTheme().getSpinnerColors()[4]);
                    g.drawLine(1, h - 3, w - 2, h - 3);
                    g.setColor(TrendyUtils.currentTheme().getSpinnerColors()[5]);
                    g.drawLine(1, h - 2, w - 3, h - 2);
                    g.setColor(TrendyUtils.currentTheme().getSpinnerColors()[6]);
                    g.drawLine(1, h - 1, w - 5, h - 1);
                    g.setColor(TrendyUtils.currentTheme().getSpinnerColors()[3]);
                    g.drawLine(1, 0, w - 1, 0);
                    g.setColor(TrendyUtils.currentTheme().getSpinnerColors()[7]);
                    g.drawLine(0, 0, 0, h);
                    g.setColor(TrendyUtils.currentTheme().getSpinnerColors()[4]);
                    g.drawLine(w - 1, 1, w - 1, h - 3);
                    g.setColor(TrendyUtils.currentTheme().getSpinnerColors()[8]);
                    g.drawLine(w - 2, 1, w - 2, h - 4);
                    g.setColor(TrendyUtils.currentTheme().getSpinnerColors()[3]);
                    g.drawLine(w - 3, 1, w - 3, h - 4);
                }
            } else {
                g.setColor(TrendyUtils.currentTheme().getSpinnerColors()[8]);
                g.drawLine(1, 0, w - 1, 0);
                g.fillRect(1, 1, w - 1, h - 3);
                g.drawLine(1, h - 4, w - 1, h - 4);
                g.drawLine(1, h - 3, w - 2, h - 3);
                g.drawLine(1, h - 2, w - 3, h - 2);
                g.drawLine(1, h - 1, w - 5, h - 1);
                g.drawLine(1, 0, w - 1, 0);
                g.drawLine(w - 1, 1, w - 1, h - 3);
                g.drawLine(w - 2, 1, w - 2, h - 4);
                g.drawLine(w - 3, 1, w - 3, h - 4);
                g.setColor(TrendyUtils.currentTheme().getSpinnerColors()[7]);
                g.drawLine(0, 0, 0, h);
            }
        }

        private void paintUpButton(Graphics g) {
            this.d = this.getSize();
            int h = (int)this.d.getHeight();
            int w = (int)this.d.getWidth();
            if (this.getModel().isEnabled()) {
                if (this.getModel().isPressed()) {
                    g.setColor(TrendyUtils.currentTheme().getSpinnerColors()[0]);
                    g.drawLine(1, 0, w - 5, 0);
                    g.drawLine(1, 1, w - 3, 1);
                    g.drawLine(1, 2, w - 2, 2);
                    g.fillRect(1, 3, w - 1, h - 3);
                    g.drawLine(1, h - 4, w - 1, h - 4);
                    g.drawLine(1, h - 3, w - 1, h - 3);
                    g.drawLine(1, h - 2, w - 1, h - 2);
                    g.drawLine(1, h - 1, w - 1, h - 1);
                    g.drawLine(1, h - 1, w - 1, h - 1);
                    g.drawLine(w - 1, 3, w - 1, h - 3);
                    g.drawLine(w - 2, 2, w - 2, h - 4);
                    g.drawLine(w - 3, 1, w - 3, h - 4);
                    g.setColor(TrendyUtils.currentTheme().getSpinnerColors()[1]);
                    g.drawLine(0, 0, 0, h);
                } else {
                    g.setColor(TrendyUtils.currentTheme().getSpinnerColors()[3]);
                    g.drawLine(1, 0, w - 5, 0);
                    g.setColor(TrendyUtils.currentTheme().getSpinnerColors()[2]);
                    g.drawLine(1, 1, w - 3, 1);
                    g.drawLine(1, 2, w - 2, 2);
                    g.fillRect(1, 3, w - 1, h - 3);
                    g.setColor(TrendyUtils.currentTheme().getSpinnerColors()[3]);
                    g.drawLine(1, h - 4, w - 1, h - 4);
                    g.setColor(TrendyUtils.currentTheme().getSpinnerColors()[4]);
                    g.drawLine(1, h - 3, w - 1, h - 3);
                    g.setColor(TrendyUtils.currentTheme().getSpinnerColors()[5]);
                    g.drawLine(1, h - 2, w - 1, h - 2);
                    g.setColor(TrendyUtils.currentTheme().getSpinnerColors()[6]);
                    g.drawLine(1, h - 1, w - 1, h - 1);
                    g.setColor(TrendyUtils.currentTheme().getSpinnerColors()[7]);
                    g.drawLine(1, h - 1, w - 1, h - 1);
                    g.drawLine(0, 0, 0, h);
                    g.setColor(TrendyUtils.currentTheme().getSpinnerColors()[4]);
                    g.drawLine(w - 1, 3, w - 1, h - 3);
                    g.setColor(TrendyUtils.currentTheme().getSpinnerColors()[8]);
                    g.drawLine(w - 2, 2, w - 2, h - 4);
                    g.setColor(TrendyUtils.currentTheme().getSpinnerColors()[3]);
                    g.drawLine(w - 3, 1, w - 3, h - 4);
                }
            } else {
                g.setColor(TrendyUtils.currentTheme().getSpinnerColors()[8]);
                g.drawLine(1, 0, w - 5, 0);
                g.drawLine(1, 1, w - 3, 1);
                g.drawLine(1, 2, w - 2, 2);
                g.fillRect(1, 3, w - 1, h - 3);
                g.drawLine(1, h - 4, w - 1, h - 4);
                g.drawLine(1, h - 3, w - 1, h - 3);
                g.drawLine(1, h - 2, w - 1, h - 2);
                g.drawLine(1, h - 1, w - 1, h - 1);
                g.drawLine(1, h - 1, w - 1, h - 1);
                g.drawLine(w - 1, 3, w - 1, h - 3);
                g.drawLine(w - 2, 2, w - 2, h - 4);
                g.drawLine(w - 3, 1, w - 3, h - 4);
                g.setColor(TrendyUtils.currentTheme().getSpinnerColors()[1]);
                g.drawLine(0, 0, 0, h);
            }
        }

        public void paintComponent(Graphics g) {
            if (this.up) {
                this.paintUpButton(g);
            } else {
                this.paintDownButton(g);
            }
            this.drawArrow(g);
        }

        protected void drawArrow(Graphics g) {
            this.d = this.getSize();
            if (this.getModel().isEnabled()) {
                g.setColor(TrendyUtils.currentTheme().getSpinnerColors()[9]);
            } else {
                g.setColor(TrendyUtils.currentTheme().getSpinnerColors()[10]);
            }
            int baseY = (int)(this.d.getHeight() / 2.0 - 2.0);
            if (!this.up) {
                ++baseY;
            }
            g.translate(5, baseY);
            if (this.up) {
                g.drawLine(2, 0, 3, 0);
                g.drawLine(1, 1, 4, 1);
                g.drawLine(0, 2, 1, 2);
                g.drawLine(4, 2, 5, 2);
            } else {
                g.drawLine(2, 2, 3, 2);
                g.drawLine(1, 1, 4, 1);
                g.drawLine(0, 0, 1, 0);
                g.drawLine(4, 0, 5, 0);
            }
            g.translate(-6, -baseY);
        }

        protected void paintBorder(Graphics g) {
        }

        public Dimension getPreferredSize() {
            return new Dimension(16, 6);
        }

        public Dimension getMinimumSize() {
            return new Dimension(16, 6);
        }

        public Dimension getMaximumSize() {
            return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }
    }
}

