/*
 * Decompiled with CFR 0.152.
 */
package com.Trendy.swing.plaf;

import com.Trendy.swing.plaf.TrendyUtils;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JToolBar;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToolBarUI;

public class TrendyToolBarUI
extends BasicToolBarUI {
    public static ComponentUI createUI(JComponent c) {
        return new TrendyToolBarUI();
    }

    protected void installDefaults() {
        super.installDefaults();
    }

    protected Border createRolloverBorder() {
        return new EmptyBorder(3, 3, 3, 3);
    }

    protected Border createNonRolloverBorder() {
        return new EmptyBorder(3, 3, 3, 3);
    }

    public Border createNonRolloverToggleBorder() {
        return new EmptyBorder(3, 3, 3, 3);
    }

    public void paint(Graphics g, JComponent c) {
        JToolBar b = (JToolBar)c;
        if (c.getParent() instanceof JFileChooser) {
            return;
        }
        super.paint(g, c);
    }

    public boolean isRolloverBorders() {
        return true;
    }

    protected MouseInputListener createDockingListener() {
        return new TrendyDockingListener(this.toolBar);
    }

    protected void setDragOffset(Point p) {
        if (!GraphicsEnvironment.isHeadless()) {
            if (this.dragWindow == null) {
                this.dragWindow = this.createDragWindow(this.toolBar);
            }
            this.dragWindow.setOffset(p);
        }
    }

    protected class TrendyDockingListener
    extends BasicToolBarUI.DockingListener {
        private boolean pressedInBumps;

        public TrendyDockingListener(JToolBar t) {
            super(TrendyToolBarUI.this, t);
            this.pressedInBumps = false;
        }

        public void mousePressed(MouseEvent e) {
            super.mousePressed(e);
            if (!this.toolBar.isEnabled()) {
                return;
            }
            this.pressedInBumps = false;
            Rectangle bumpRect = new Rectangle();
            if (this.toolBar.getOrientation() == 0) {
                int x = TrendyUtils.isLeftToRight(this.toolBar) ? 0 : this.toolBar.getSize().width - 14;
                bumpRect.setBounds(x, 0, 14, this.toolBar.getSize().height);
            } else {
                bumpRect.setBounds(0, 0, this.toolBar.getSize().width, 14);
            }
            if (bumpRect.contains(e.getPoint())) {
                this.pressedInBumps = true;
                Point dragOffset = e.getPoint();
                if (!TrendyUtils.isLeftToRight(this.toolBar)) {
                    dragOffset.x -= this.toolBar.getSize().width - this.toolBar.getPreferredSize().width;
                }
                TrendyToolBarUI.this.setDragOffset(dragOffset);
            }
        }

        public void mouseDragged(MouseEvent e) {
            if (this.pressedInBumps) {
                super.mouseDragged(e);
            }
        }
    }
}

