/*
 * Decompiled with CFR 0.152.
 */
package com.Trendy.swing.plaf;

import com.Trendy.swing.plaf.TrendyCashedPainter;
import com.Trendy.swing.plaf.TrendyConfiguration;
import com.Trendy.swing.plaf.TrendyToggleButtonListener;
import com.Trendy.swing.plaf.TrendyUtils;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicToggleButtonUI;
import javax.swing.text.View;

public class TrendyToggleButtonUI
extends BasicToggleButtonUI {
    private static final TrendyToggleButtonUI m_tbuttonUI = new TrendyToggleButtonUI();

    public static ComponentUI createUI(JComponent c) {
        return m_tbuttonUI;
    }

    protected void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        b.setRolloverEnabled(true);
        b.putClientProperty("TRENDY_ANTIALIASED_FONT_MINIMUM_SIZE", UIManager.get("ToggleButton.TRENDY_ANTIALIASED_FONT_MINIMUM_SIZE"));
    }

    protected void uninstallDefaults(AbstractButton b) {
        super.uninstallDefaults(b);
    }

    public void installUI(JComponent c) {
        super.installUI(c);
    }

    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
    }

    protected void paintText(Graphics g, AbstractButton c, Rectangle textRect, String text) {
        if (TrendyConfiguration.isFontAntialiased(c, g.getFont().getSize())) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            super.paintText(g, c, textRect, text);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
            g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_DEFAULT);
        } else {
            super.paintText(g, c, textRect, text);
        }
    }

    public void paint(Graphics g, JComponent c) {
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        boolean down = model.isArmed() && model.isPressed() || model.isSelected();
        Dimension size = b.getSize();
        FontMetrics fm = g.getFontMetrics();
        Insets i = c.getInsets();
        Rectangle viewRect = new Rectangle(size);
        viewRect.x += i.left;
        viewRect.y += i.top;
        viewRect.width -= i.right + viewRect.x;
        viewRect.height -= i.bottom + viewRect.y;
        Rectangle iconRect = new Rectangle();
        Rectangle textRect = new Rectangle();
        Font f = c.getFont();
        g.setFont(f);
        String text = SwingUtilities.layoutCompoundLabel(c, fm, b.getText(), b.getIcon(), b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, b.getText() == null ? 0 : b.getIconTextGap());
        g.setColor(b.getBackground());
        if (down) {
            this.paintButtonPressed(g, b);
        } else if (b.isContentAreaFilled()) {
            if (b.getParent() instanceof JToolBar) {
                TrendyUtils.drawToolbarButtonSkin(g, c);
            } else if (TrendyConfiguration.isRoundRectSmall(c, this.getPropertyPrefix())) {
                TrendyCashedPainter.drawButtonSquareSkin(c, g);
            } else {
                TrendyCashedPainter.drawButtonRoundSkin(c, g);
            }
        }
        if (b.getIcon() != null) {
            this.paintIcon(g, b, iconRect);
        }
        if (text != null && !text.equals("")) {
            View v = (View)c.getClientProperty("html");
            if (v != null) {
                v.paint(g, textRect);
            } else {
                this.paintText(g, b, textRect, text);
            }
        }
        if (b.isFocusPainted() && b.hasFocus()) {
            this.paintFocus(g, b, viewRect, textRect, iconRect);
        }
        TrendyCashedPainter.drawButtonBorder(c, g, this.getPropertyPrefix());
    }

    protected void paintFocus(Graphics g, AbstractButton b, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
        TrendyCashedPainter.drawButtonBorder(b, g, this.getPropertyPrefix());
    }

    protected void paintButtonPressed(Graphics g, AbstractButton b) {
        if (b.isContentAreaFilled()) {
            if (b.getParent() instanceof JToolBar) {
                TrendyUtils.drawToolbarButtonSkin(g, b);
            } else if (TrendyConfiguration.isRoundRectSmall(b, this.getPropertyPrefix())) {
                TrendyCashedPainter.drawButtonSquareSkin(b, g);
            } else {
                TrendyCashedPainter.drawButtonRoundSkin(b, g);
            }
        }
        this.setTextShiftOffset();
    }

    protected BasicButtonListener createButtonListener(AbstractButton b) {
        return new TrendyToggleButtonListener(b);
    }

    public Dimension getPreferredSize(JComponent c) {
        if (c.getParent() instanceof JToolBar) {
            return new Dimension((int)super.getPreferredSize(c).getWidth() + 6, (int)super.getPreferredSize(c).getHeight() + 6);
        }
        return new Dimension((int)super.getPreferredSize(c).getWidth() + 10, (int)super.getPreferredSize(c).getHeight() + 6);
    }
}

