/*
 * Decompiled with CFR 0.152.
 */
package com.Trendy.swing.plaf;

import com.Trendy.swing.plaf.TrendyClipboardActionsPopup;
import com.Trendy.swing.plaf.TrendyConfiguration;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTextPaneUI;

public class TrendyTextPaneUI
extends BasicTextPaneUI {
    private TrendyClipboardActionsPopup popup = null;
    private final TrendyTextPanePopupListener tfp = new TrendyTextPanePopupListener();

    public static ComponentUI createUI(JComponent c) {
        return new TrendyTextPaneUI();
    }

    protected void installDefaults() {
        super.installDefaults();
        this.getComponent().putClientProperty("TRENDY_ANTIALIASED_FONT_MINIMUM_SIZE", UIManager.get("TextPane.TRENDY_ANTIALIASED_FONT_MINIMUM_SIZE"));
        this.getComponent().putClientProperty("Text_Context_Menu", UIManager.get("TextPane.Text_Context_Menu"));
        if (TrendyConfiguration.isTextComponentOfferContextMenu(this.getComponent())) {
            this.getComponent().addMouseListener(this.tfp);
        }
    }

    protected void uninstallDefaults() {
        super.installDefaults();
        this.getComponent().removeMouseListener(this.tfp);
        this.popup = null;
    }

    public void update(Graphics g, JComponent c) {
        if (TrendyConfiguration.isFontAntialiased(c, g.getFont().getSize())) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            super.update(g, c);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
            g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_DEFAULT);
        } else {
            super.update(g, c);
        }
    }

    private void showPopup(Point p) {
        if (!this.getComponent().isEnabled()) {
            return;
        }
        if (!TrendyConfiguration.isTextComponentOfferContextMenu(this.getComponent())) {
            return;
        }
        if (this.popup == null) {
            this.popup = new TrendyClipboardActionsPopup(this.getComponent());
        }
        this.getComponent().requestFocus();
        this.popup.show(this.getComponent(), (int)p.getX(), (int)p.getY());
    }

    public class TrendyTextPanePopupListener
    implements MouseListener {
        public void mouseClicked(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            this.doForPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.doForPopup(e);
        }

        private void doForPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                TrendyTextPaneUI.this.showPopup(e.getPoint());
            }
        }
    }
}

