/*
 * Decompiled with CFR 0.152.
 */
package com.Trendy.swing.plaf;

import com.Trendy.swing.plaf.TrendyConfiguration;
import com.Trendy.swing.plaf.TrendyUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTableHeaderUI;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class TrendyTableHeaderUI
extends BasicTableHeaderUI {
    private TableCellRenderer originalRenderer;
    private tableHeaderRenderer mainRenderer;
    private int highlightedColumn = -1;
    private int pressedColumn = -1;

    public static ComponentUI createUI(JComponent h) {
        return new TrendyTableHeaderUI();
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        this.originalRenderer = this.header.getDefaultRenderer();
        if (this.originalRenderer instanceof UIResource) {
            this.mainRenderer = new tableHeaderRenderer();
            this.mainRenderer.setHorizontalAlignment(0);
            this.header.setDefaultRenderer(this.mainRenderer);
        }
    }

    public void uninstallUI(JComponent c) {
        if (this.header.getDefaultRenderer() instanceof tableHeaderRenderer) {
            this.header.setDefaultRenderer(this.originalRenderer);
            this.mainRenderer = null;
        }
        super.uninstallUI(c);
    }

    public void installDefaults() {
        super.installDefaults();
        this.header.putClientProperty("TRENDY_ANTIALIASED_FONT_MINIMUM_SIZE", UIManager.get("TableHeader.TRENDY_ANTIALIASED_FONT_MINIMUM_SIZE"));
    }

    private void updateRolloverColumn(Point p) {
        int col;
        if (this.header.getDraggedColumn() == null && this.header.contains(p) && (col = this.header.columnAtPoint(p)) != this.highlightedColumn) {
            this.highlightedColumn = col;
            this.header.repaint();
        }
    }

    protected MouseInputListener createMouseInputListener() {
        return new BasicTableHeaderUI.MouseInputHandler(){

            public void mouseMoved(MouseEvent e) {
                super.mouseMoved(e);
                TrendyTableHeaderUI.this.updateRolloverColumn(e.getPoint());
            }

            public void mouseEntered(MouseEvent e) {
                super.mouseEntered(e);
                TrendyTableHeaderUI.this.updateRolloverColumn(e.getPoint());
            }

            public void mouseExited(MouseEvent e) {
                super.mouseExited(e);
                TrendyTableHeaderUI.this.highlightedColumn = -1;
                TrendyTableHeaderUI.this.header.repaint();
            }

            public void mousePressed(MouseEvent e) {
                super.mousePressed(e);
                if (TrendyTableHeaderUI.this.header.contains(e.getPoint())) {
                    if (TrendyTableHeaderUI.this.header.getDraggedColumn() != null) {
                        TrendyTableHeaderUI.this.pressedColumn = TrendyTableHeaderUI.this.header.columnAtPoint(e.getPoint());
                    } else if (TrendyTableHeaderUI.this.header.getDraggedColumn() != null) {
                        TrendyTableHeaderUI.this.pressedColumn = TrendyTableHeaderUI.this.header.getColumnModel().getColumnIndex(TrendyTableHeaderUI.this.header.getDraggedColumn());
                    }
                }
                if (TrendyTableHeaderUI.this.header.getReorderingAllowed()) {
                    TrendyTableHeaderUI.this.highlightedColumn = -1;
                }
                TrendyTableHeaderUI.this.header.repaint();
            }

            public void mouseDragged(MouseEvent e) {
                super.mouseDragged(e);
                if (TrendyTableHeaderUI.this.header.contains(e.getPoint())) {
                    TrendyTableHeaderUI.this.pressedColumn = -1;
                }
                TrendyTableHeaderUI.this.updateRolloverColumn(e.getPoint());
            }

            public void mouseReleased(MouseEvent e) {
                super.mouseReleased(e);
                if (TrendyTableHeaderUI.this.header.contains(e.getPoint())) {
                    TrendyTableHeaderUI.this.pressedColumn = -1;
                }
                TrendyTableHeaderUI.this.updateRolloverColumn(e.getPoint());
                TrendyTableHeaderUI.this.header.repaint();
            }
        };
    }

    public Dimension getPreferredSize(JComponent c) {
        return new Dimension((int)super.getPreferredSize(c).getWidth(), Math.max((int)super.getPreferredSize(c).getHeight(), 20));
    }

    private class tableHeaderRenderer
    extends DefaultTableCellRenderer
    implements UIResource {
        boolean isSelected;
        boolean hasFocus;
        boolean rollOvered;
        boolean isPressed;
        int column;
        JTable table;

        private tableHeaderRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JTableHeader header;
            if (table != null && (header = table.getTableHeader()) != null) {
                this.setFont(header.getFont());
            }
            this.table = table;
            this.isSelected = isSelected;
            this.hasFocus = hasFocus;
            boolean bl = this.rollOvered = column == TrendyTableHeaderUI.this.highlightedColumn;
            this.isPressed = TrendyTableHeaderUI.this.header.getDraggedColumn() != null ? this.viewIndexForColumn(TrendyTableHeaderUI.this.header.getDraggedColumn()) == column || column == TrendyTableHeaderUI.this.pressedColumn : false;
            this.column = column;
            this.setText(value == null ? "" : value.toString());
            this.setBorder(null);
            return this;
        }

        public Insets getInsets() {
            return new Insets(2, 4, 2, 4);
        }

        private int viewIndexForColumn(TableColumn aColumn) {
            TableColumnModel cm = TrendyTableHeaderUI.this.header.getColumnModel();
            for (int column = 0; column < cm.getColumnCount(); ++column) {
                if (cm.getColumn(column) != aColumn) continue;
                return column;
            }
            return -1;
        }

        public void paint(Graphics g) {
            Graphics2D g2;
            int h = this.getHeight();
            int w = this.getWidth();
            if (this.isPressed) {
                g.setColor(TrendyUtils.currentTheme().getTableHeaderColors()[0]);
                g.drawLine(0, 0, w - 1, 0);
                g.setColor(TrendyUtils.currentTheme().getTableHeaderColors()[1]);
                g.drawLine(0, 1, w - 1, 1);
                g2 = (Graphics2D)g;
                g2.setPaint(new GradientPaint(0.0f, 2.0f, TrendyUtils.currentTheme().getTableHeaderColors()[2], 0.0f, h - 1, TrendyUtils.currentTheme().getTableHeaderColors()[3]));
                g2.fillRect(0, 2, w, h - 1);
                g.setColor(TrendyUtils.currentTheme().getTableHeaderColors()[0]);
                g.drawLine(0, h - 1, w - 1, h - 1);
            } else {
                if (this.rollOvered) {
                    g.setColor(TrendyUtils.currentTheme().getTableHeaderColors()[4]);
                    g.drawLine(0, 0, w - 1, 0);
                    g.setColor(TrendyUtils.currentTheme().getTableHeaderColors()[5]);
                    g.drawLine(0, h - 2, w - 1, h - 2);
                } else {
                    g.setColor(TrendyUtils.currentTheme().getTableHeaderColors()[6]);
                    g.drawLine(0, 0, w - 1, 0);
                    g.setColor(TrendyUtils.currentTheme().getTableHeaderColors()[7]);
                    g.drawLine(0, h - 2, w - 1, h - 2);
                }
                g2 = (Graphics2D)g;
                g2.setPaint(new GradientPaint(0.0f, 1.0f, TrendyUtils.currentTheme().getTableHeaderColors()[8], 0.0f, h - 5, TrendyUtils.currentTheme().getTableHeaderColors()[9]));
                g2.fillRect(0, 1, w, h - 5);
                g.setColor(TrendyUtils.currentTheme().getTableHeaderColors()[10]);
                g.drawLine(0, h - 5, w - 1, h - 5);
                g.setColor(TrendyUtils.currentTheme().getTableHeaderColors()[11]);
                g.drawLine(0, h - 4, w - 1, h - 4);
                g.setColor(TrendyUtils.currentTheme().getTableHeaderColors()[12]);
                g.drawLine(0, h - 3, w - 1, h - 3);
                g.setColor(TrendyUtils.currentTheme().getTableHeaderColors()[13]);
                g.drawLine(0, h - 1, w - 1, h - 1);
            }
            if (TrendyConfiguration.isFontAntialiased(TrendyTableHeaderUI.this.header, g.getFont().getSize())) {
                g2 = (Graphics2D)g;
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                super.paint(g2);
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
                g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_DEFAULT);
            } else {
                super.paint(g);
            }
        }
    }
}

