/*
 * Decompiled with CFR 0.152.
 */
package com.Trendy.swing.plaf;

import com.Trendy.swing.plaf.TrendyBorders;
import com.Trendy.swing.plaf.TrendyConfiguration;
import com.Trendy.swing.plaf.TrendyRoundRectPopupFactory;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JApplet;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JRootPane;
import javax.swing.JToolBar;
import javax.swing.Popup;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.ColorUIResource;

public final class TrendyRoundRectPopup
extends Popup {
    private static final Border POPUP_BORDER = TrendyBorders.getShadowedPopupMenuBorder();
    private static final Border TOPLEVEL_POPUP_BORDER = TrendyBorders.getShadowedTopLevelPopupBorder();
    private Dimension size;
    private static final Rectangle rectangle = new Rectangle();
    private static List used_popups;
    private BufferedImage tr;
    private BufferedImage tl;
    private BufferedImage br;
    private BufferedImage bl;
    private BufferedImage b;
    private BufferedImage r;
    private Component contents;
    private int x;
    private int y;
    private Popup popup;
    private Border originalBorder;
    private boolean originalOpaque;
    private Container heavyWeightContainer;
    private Robot robot;
    private Component owner;
    private static final Point point;
    private static Rectangle rect;
    private boolean oldOpaque;
    private static ColorUIResource bordercolor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Popup getInstance(Component owner, Component contents, int x, int y, Popup delegate) {
        Class<TrendyRoundRectPopup> clazz = TrendyRoundRectPopup.class;
        synchronized (TrendyRoundRectPopup.class) {
            if (used_popups == null) {
                used_popups = new ArrayList(7);
            }
            TrendyRoundRectPopup rrPopup = used_popups.size() > 0 ? (TrendyRoundRectPopup)used_popups.remove(0) : new TrendyRoundRectPopup();
            // ** MonitorExit[var6_5] (shouldn't be in output)
            rrPopup.initPopup(owner, contents, x, y, delegate);
            return rrPopup;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addPopupToList(TrendyRoundRectPopup popup) {
        Class<TrendyRoundRectPopup> clazz = TrendyRoundRectPopup.class;
        synchronized (TrendyRoundRectPopup.class) {
            if (used_popups.size() < 7) {
                used_popups.add(popup);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void hide() {
        this.popup.hide();
        ((JComponent)this.contents).putClientProperty(TrendyRoundRectPopupFactory.BOTTOM_LEFT_PIC, null);
        ((JComponent)this.contents).putClientProperty(TrendyRoundRectPopupFactory.BOTTOM_RIGHT_PIC, null);
        ((JComponent)this.contents).putClientProperty(TrendyRoundRectPopupFactory.TOP_LEFT_PIC, null);
        ((JComponent)this.contents).putClientProperty(TrendyRoundRectPopupFactory.TOP_RIGHT_PIC, null);
        ((JComponent)this.contents).putClientProperty(TrendyRoundRectPopupFactory.RIGHT_PIC, null);
        ((JComponent)this.contents).putClientProperty(TrendyRoundRectPopupFactory.BOTTOM_PIC, null);
        this.contents = null;
        this.popup = null;
        TrendyRoundRectPopup.addPopupToList(this);
    }

    public void show() {
        if (((JComponent)this.contents).getBorder() instanceof TrendyBorders.RoundRectTopLevelPopupBorder || ((JComponent)this.contents).getBorder() instanceof TrendyBorders.RoundRectPopupBorder) {
            this.updatePics();
        }
        this.popup.show();
    }

    private void initPopup(Component owner, Component contents, int x, int y, Popup popup) {
        this.owner = owner;
        this.contents = contents;
        this.popup = popup;
        this.x = x;
        this.y = y;
        if (TrendyConfiguration.isOSMac()) {
            ((JComponent)contents).setBorder(TrendyBorders.getPopupMenuBorder());
        } else if (((JComponent)contents).getBorder() instanceof TrendyBorders.TrendyPlaceholderBorder) {
            if (!(owner instanceof JMenu && ((JMenu)owner).isTopLevelMenu() || owner.getParent() != null && owner.getParent() instanceof JToolBar || owner != null && owner instanceof JComboBox)) {
                ((JComponent)contents).setBorder(TrendyBorders.getShadowedPopupMenuBorder());
            } else {
                ((JComponent)contents).setBorder(TrendyBorders.getShadowedTopLevelPopupBorder());
            }
        }
    }

    private void updatePics() {
        try {
            this.contents.requestFocus();
            this.robot = new Robot();
            this.size = this.contents.getPreferredSize();
            int w = this.size.width;
            int h = this.size.height;
            rectangle.setBounds(this.x, this.y, 5, 5);
            this.tl = this.robot.createScreenCapture(rectangle);
            rectangle.setBounds(this.x + w - 5, this.y, 5, 5);
            this.tr = this.robot.createScreenCapture(rectangle);
            rectangle.setBounds(this.x, this.y + h - 5, 5, 5);
            this.bl = this.robot.createScreenCapture(rectangle);
            rectangle.setBounds(this.x + w - 5, this.y + h - 5, 5, 5);
            this.br = this.robot.createScreenCapture(rectangle);
            rectangle.setBounds(this.x + w - 1, this.y, 1, h - 5);
            this.r = this.robot.createScreenCapture(rectangle);
            rectangle.setBounds(this.x + 5, this.y + h - 1, w - 10, 1);
            this.b = this.robot.createScreenCapture(rectangle);
            Component layeredPane = this.getLayeredPane();
            if (layeredPane == null) {
                return;
            }
            TrendyRoundRectPopup.point.x = this.x;
            TrendyRoundRectPopup.point.y = this.y;
            SwingUtilities.convertPointFromScreen(point, layeredPane);
            rect = new Rectangle(TrendyRoundRectPopup.point.x, TrendyRoundRectPopup.point.y, 5, 5);
            this.drawRemaining(rect, layeredPane, this.tl);
            rect = new Rectangle(TrendyRoundRectPopup.point.x + w - 5, TrendyRoundRectPopup.point.y, 5, 5);
            this.drawRemaining(rect, layeredPane, this.tr);
            rect = new Rectangle(TrendyRoundRectPopup.point.x, TrendyRoundRectPopup.point.y + h - 5, 5, 5);
            this.drawRemaining(rect, layeredPane, this.bl);
            rect = new Rectangle(TrendyRoundRectPopup.point.x + w - 5, TrendyRoundRectPopup.point.y + h - 5, 5, 5);
            this.drawRemaining(rect, layeredPane, this.br);
            rect = new Rectangle(TrendyRoundRectPopup.point.x + w - 1, TrendyRoundRectPopup.point.y, 1, h - 5);
            this.drawRemaining(rect, layeredPane, this.r);
            rect = new Rectangle(TrendyRoundRectPopup.point.x + 5, TrendyRoundRectPopup.point.y + h - 1, w - 10, 1);
            this.drawRemaining(rect, layeredPane, this.b);
            ((JComponent)this.contents).putClientProperty(TrendyRoundRectPopupFactory.BOTTOM_LEFT_PIC, this.bl);
            ((JComponent)this.contents).putClientProperty(TrendyRoundRectPopupFactory.BOTTOM_RIGHT_PIC, this.br);
            ((JComponent)this.contents).putClientProperty(TrendyRoundRectPopupFactory.TOP_LEFT_PIC, this.tl);
            ((JComponent)this.contents).putClientProperty(TrendyRoundRectPopupFactory.TOP_RIGHT_PIC, this.tr);
            ((JComponent)this.contents).putClientProperty(TrendyRoundRectPopupFactory.RIGHT_PIC, this.r);
            ((JComponent)this.contents).putClientProperty(TrendyRoundRectPopupFactory.BOTTOM_PIC, this.b);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void drawRemaining(Rectangle rectangle, Component lp, BufferedImage pic) {
        if (rectangle.x + rectangle.width > lp.getWidth()) {
            rectangle.width = lp.getWidth() - rectangle.x;
        }
        if (rectangle.y + rectangle.height > lp.getHeight()) {
            rectangle.height = lp.getHeight() - rectangle.y;
        }
        if (!rectangle.isEmpty()) {
            Graphics2D g = pic.createGraphics();
            ((Graphics)g).translate(-rectangle.x, -rectangle.y);
            g.setClip(rectangle);
            boolean doubleBuffered = lp.isDoubleBuffered();
            if (lp instanceof JComponent) {
                ((JComponent)lp).setDoubleBuffered(false);
                lp.paint(g);
                ((JComponent)lp).setDoubleBuffered(doubleBuffered);
            } else {
                lp.paint(g);
            }
            g.dispose();
        }
    }

    private Component getLayeredPane() {
        Container parent = null;
        if (this.owner != null) {
            parent = this.owner instanceof Container ? (Container)this.owner : this.owner.getParent();
        }
        for (Container p = parent; p != null; p = p.getParent()) {
            if (p instanceof JRootPane) {
                if (p.getParent() instanceof JInternalFrame) continue;
                parent = ((JRootPane)p).getLayeredPane();
                continue;
            }
            if (p instanceof Window) {
                if (parent != null) break;
                parent = p;
                break;
            }
            if (p instanceof JApplet) break;
        }
        return parent;
    }

    static {
        point = new Point();
        rect = new Rectangle();
        bordercolor = new ColorUIResource(165, 165, 175);
    }
}

