/*
 * Decompiled with CFR 0.152.
 */
package com.Trendy.swing.plaf;

import com.Trendy.swing.plaf.TrendyConfiguration;
import com.Trendy.swing.plaf.TrendyUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicRadioButtonUI;

public class TrendyRadioButtonUI
extends BasicRadioButtonUI {
    private static final TrendyRadioButtonUI trendyRadioButtonUI = new TrendyRadioButtonUI();
    protected Color focusColor;
    protected Color selectColor;
    protected Color disabledTextColor;
    private boolean defaults_initialized = false;
    static final BasicStroke dashed = new BasicStroke(1.0f, 0, 0, 6.0f, new float[]{2.0f}, 2.0f);

    protected Color getDisabledTextColor() {
        return this.disabledTextColor;
    }

    protected Color getFocusColor() {
        return this.focusColor;
    }

    protected Color getSelectColor() {
        return this.selectColor;
    }

    protected void paintText(Graphics g, AbstractButton c, Rectangle textRect, String text) {
        if (TrendyConfiguration.isFontAntialiased(c, g.getFont().getSize())) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            super.paintText(g, c, textRect, text);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
            g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_DEFAULT);
        } else {
            super.paintText(g, c, textRect, text);
        }
    }

    public void installDefaults(AbstractButton abstractbutton) {
        super.installDefaults(abstractbutton);
        if (!this.defaults_initialized) {
            this.icon = UIManager.getIcon(this.getPropertyPrefix() + "icon");
            this.defaults_initialized = true;
        }
        abstractbutton.setRolloverEnabled(true);
        abstractbutton.putClientProperty("TRENDY_ANTIALIASED_FONT_MINIMUM_SIZE", UIManager.get("RadioButton.TRENDY_ANTIALIASED_FONT_MINIMUM_SIZE"));
    }

    protected void uninstallDefaults(AbstractButton abstractbutton) {
        super.uninstallDefaults(abstractbutton);
        this.defaults_initialized = false;
    }

    public static ComponentUI createUI(JComponent jcomponent) {
        return trendyRadioButtonUI;
    }

    public Dimension getMinimumSize(JComponent c) {
        return new Dimension(30, 22);
    }

    protected void paintFocus(Graphics g, Rectangle textRect, Dimension d) {
        int x = 0;
        int y = 0;
        int w = 0;
        int h = 0;
        int arc = 14;
        x = (int)textRect.getX() - 2;
        y = (int)textRect.getY();
        w = textRect.width + 4;
        h = (int)textRect.getHeight();
        if (d.height < 20) {
            arc = 6;
        }
        g.setColor(TrendyUtils.currentTheme().getCommonFocusColor());
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2.setStroke(dashed);
        g2.draw(new RoundRectangle2D.Double(x, y, w, h, arc, arc));
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_DEFAULT);
    }
}

