/*
 * Decompiled with CFR 0.152.
 */
package com.Trendy.swing.plaf;

import com.Trendy.swing.plaf.TrendyCashedPainter;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicProgressBarUI;

public class TrendyProgressBarUI
extends BasicProgressBarUI {
    private Rectangle bouncingBox;

    public static ComponentUI createUI(JComponent x) {
        return new TrendyProgressBarUI();
    }

    protected void installDefaults() {
        super.installDefaults();
    }

    protected void paintDeterminate(Graphics g, JComponent c) {
        int height;
        int width;
        int y;
        int x;
        boolean vertical = this.progressBar.getOrientation() == 1;
        int w = c.getWidth();
        int h = c.getHeight();
        int amountFull = this.getAmountFull(this.progressBar.getInsets(), w, h);
        g.setColor((Color)UIManager.get("ProgressBar.background"));
        g.fillRect(1, 1, w - 2, h - 2);
        if (vertical) {
            x = 3;
            y = 4;
            width = w - 6;
            height = h - 9;
        } else {
            x = 4;
            y = 3;
            width = w - 9;
            height = h - 6;
        }
        int tedad = amountFull / 10;
        for (int i = 0; i < tedad; ++i) {
            if (vertical) {
                int newY = h - i * 10 - 12;
                TrendyCashedPainter.drawProgressBar(c, g, true, false, x, newY, width, height);
                continue;
            }
            int newX = x - 1 + i * 10;
            TrendyCashedPainter.drawProgressBar(c, g, false, false, newX, y, width, height);
        }
        this.drawString(g, vertical, w, h);
    }

    private void drawString(Graphics g, boolean vertical, int w, int h) {
        if (this.progressBar.isStringPainted()) {
            FontMetrics fontSizer = this.progressBar.getFontMetrics(this.progressBar.getFont());
            int stringWidth = fontSizer.stringWidth(this.progressBar.getString());
            int stringHeight = fontSizer.getHeight();
            if (!vertical) {
                g.setColor(new Color(220, 220, 220, 140));
                g.fillRoundRect((w - stringWidth) / 2 - 5, (h - stringHeight) / 2 - 2, stringWidth + 10, stringHeight + 3, 12, 6);
                g.setColor((Color)UIManager.get("ProgressBar.foreground"));
                g.drawString(this.progressBar.getString(), (w - stringWidth) / 2, (h + stringHeight) / 2 - 3);
            } else {
                g.setColor(new Color(220, 220, 220, 100));
                g.fillRoundRect((w - stringHeight) / 2 - 2, (h - stringWidth) / 2 - 5, stringHeight + 3, stringWidth + 10, 6, 12);
                AffineTransform rotate = AffineTransform.getRotateInstance(1.5707963267948966);
                g.setFont(this.progressBar.getFont().deriveFont(rotate));
                g.setColor((Color)UIManager.get("ProgressBar.foreground"));
                g.drawString(this.progressBar.getString(), (w - stringHeight) / 2 + 4, (h - stringWidth) / 2 + 2);
            }
        }
    }

    protected void paintIndeterminate(Graphics g, JComponent c) {
        this.bouncingBox = this.getBox(this.bouncingBox);
        boolean vertical = this.progressBar.getOrientation() == 1;
        int w = c.getWidth();
        int h = c.getHeight();
        if (this.bouncingBox != null) {
            TrendyCashedPainter.drawProgressBar(c, g, vertical, true, (int)this.bouncingBox.getX(), (int)this.bouncingBox.getY(), (int)this.bouncingBox.getWidth(), (int)this.bouncingBox.getHeight());
        }
        this.drawString(g, vertical, w, h);
    }
}

