/*
 * Decompiled with CFR 0.152.
 */
package com.Trendy.swing.plaf;

import com.Trendy.swing.plaf.Themes.TrendyTheme;
import com.Trendy.swing.plaf.TrendyCashedPainter;
import com.Trendy.swing.plaf.TrendyConfiguration;
import com.Trendy.swing.plaf.TrendyInternalFrameTitlePane;
import com.Trendy.swing.plaf.TrendyMenuBarUI;
import com.Trendy.swing.plaf.TrendyUtils;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicMenuUI;

public class TrendyMenuUI
extends BasicMenuUI {
    private MouseListener mouseRolloverListener;

    public static ComponentUI createUI(JComponent x) {
        return new TrendyMenuUI();
    }

    protected void installDefaults() {
        super.installDefaults();
        this.menuItem.putClientProperty("TRENDY_ANTIALIASED_FONT_MINIMUM_SIZE", UIManager.get("Menu.TRENDY_ANTIALIASED_FONT_MINIMUM_SIZE"));
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        this.menuItem.setRolloverEnabled(true);
    }

    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
    }

    protected void installListeners() {
        super.installListeners();
        this.mouseRolloverListener = new TrendyMenuMouseHandler();
        this.menuItem.addMouseListener(this.mouseRolloverListener);
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        if (this.mouseRolloverListener != null) {
            this.menuItem.removeMouseListener(this.mouseRolloverListener);
            this.mouseRolloverListener = null;
        }
    }

    protected void paintText(Graphics g, JMenuItem menuItem, Rectangle textRect, String text) {
        if (TrendyConfiguration.isFontAntialiased(menuItem, g.getFont().getSize())) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            super.paintText(g, menuItem, textRect, text);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
            g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_DEFAULT);
        } else {
            super.paintText(g, menuItem, textRect, text);
        }
    }

    protected void paintBackground(Graphics g, JMenuItem menuItem, Color bgColor) {
        JMenu menu = (JMenu)menuItem;
        ButtonModel buttonmodel = menu.getModel();
        this.selectionForeground = menu.isTopLevelMenu() ? TrendyTheme.getBlack() : TrendyTheme.getWhite();
        int w = menu.getWidth();
        int h = menu.getHeight();
        Color oldColor = g.getColor();
        if (menu.isContentAreaFilled() && menu.isOpaque()) {
            if (menu.isTopLevelMenu()) {
                if (buttonmodel.isSelected()) {
                    TrendyCashedPainter.drawMenuBackground(menuItem, g, 0, 0, w, h);
                } else if (buttonmodel.isRollover() && buttonmodel.isEnabled()) {
                    g.setColor(new ColorUIResource(252, 252, 252));
                    g.fillRect(1, 1, w - 2, h - 2);
                    g.setColor(TrendyUtils.currentTheme().getToolbarButtonColors()[0]);
                    g.drawLine(2, 0, w - 3, 0);
                    g.drawLine(2, h - 1, w - 3, h - 1);
                    g.drawLine(0, 2, 0, h - 3);
                    g.drawLine(w - 1, 2, w - 1, h - 3);
                    g.drawLine(1, 1, 1, 1);
                    g.drawLine(w - 2, 1, w - 2, 1);
                    g.drawLine(1, h - 2, 1, h - 2);
                    g.drawLine(w - 2, h - 2, w - 2, h - 2);
                    g.setColor(TrendyUtils.currentTheme().getToolbarButtonColors()[8]);
                    g.drawLine(0, 1, 1, 0);
                    g.drawLine(w - 1, 1, w - 2, 0);
                    g.drawLine(1, h - 1, 0, h - 2);
                    g.drawLine(w - 1, h - 2, w - 2, h - 1);
                    g.setColor(TrendyUtils.currentTheme().getToolbarButtonColors()[7]);
                    g.drawLine(1, 2, 2, 1);
                    g.drawLine(w - 2, 2, w - 3, 1);
                    g.setColor(TrendyUtils.currentTheme().getToolbarButtonColors()[6]);
                    g.drawLine(2, h - 2, 1, h - 3);
                    g.drawLine(w - 2, h - 3, w - 3, h - 2);
                    g.setColor(new ColorUIResource(252, 252, 252));
                    g.drawLine(0, 0, 0, 0);
                    g.drawLine(w - 1, 0, w - 1, 0);
                    g.setColor(new ColorUIResource(232, 232, 232));
                    g.drawLine(0, h - 1, 0, h - 1);
                    g.drawLine(w - 1, h - 1, w - 1, h - 1);
                } else if (menuItem.getParent() instanceof JMenuBar) {
                    ((TrendyMenuBarUI)((JMenuBar)menuItem.getParent()).getUI()).update(g, menuItem);
                }
            } else if (!menuItem.getModel().isSelected()) {
                TrendyCashedPainter.drawMenuItemFading(menuItem, g);
            } else {
                TrendyUtils.drawMenuItemBackground(g, menuItem);
            }
        }
        g.setColor(oldColor);
    }

    protected class TrendyMenuMouseHandler
    extends MouseAdapter {
        protected TrendyMenuMouseHandler() {
        }

        public void mouseEntered(MouseEvent me) {
            boolean res = true;
            try {
                if (TrendyMenuUI.this.menuItem.getParent().getParent() != null && ((JMenu)TrendyMenuUI.this.menuItem).getParent().getParent() instanceof TrendyInternalFrameTitlePane) {
                    res = false;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (res && ((AbstractButton)me.getSource()).isRolloverEnabled()) {
                ((AbstractButton)me.getSource()).getModel().setRollover(true);
                ((JComponent)me.getSource()).repaint();
            }
        }

        public void mouseExited(MouseEvent me) {
            boolean res = true;
            try {
                if (TrendyMenuUI.this.menuItem.getParent().getParent() != null && ((JMenu)TrendyMenuUI.this.menuItem).getParent().getParent() instanceof TrendyInternalFrameTitlePane) {
                    res = false;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (res && ((AbstractButton)me.getSource()).isRolloverEnabled()) {
                ((AbstractButton)me.getSource()).getModel().setRollover(false);
                ((JComponent)me.getSource()).repaint();
            }
        }
    }
}

