/*
 * Decompiled with CFR 0.152.
 */
package com.Trendy.swing.plaf;

import com.Trendy.swing.plaf.TrendyCashedPainter;
import com.Trendy.swing.plaf.TrendyConfiguration;
import com.Trendy.swing.plaf.TrendyUtils;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicMenuItemUI;

public class TrendyMenuItemUI
extends BasicMenuItemUI {
    public static ComponentUI createUI(JComponent c) {
        return new TrendyMenuItemUI();
    }

    protected void installDefaults() {
        super.installDefaults();
        this.menuItem.putClientProperty("TRENDY_ANTIALIASED_FONT_MINIMUM_SIZE", UIManager.get("MenuItem.TRENDY_ANTIALIASED_FONT_MINIMUM_SIZE"));
    }

    public void installUI(JComponent c) {
        super.installUI(c);
    }

    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
    }

    protected void paintText(Graphics g, JMenuItem menuItem, Rectangle textRect, String text) {
        if (TrendyConfiguration.isFontAntialiased(menuItem, g.getFont().getSize())) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            super.paintText(g, menuItem, textRect, text);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
            g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_DEFAULT);
        } else {
            super.paintText(g, menuItem, textRect, text);
        }
    }

    protected void paintBackground(Graphics g, JMenuItem m, Color c) {
        Color oldColor = g.getColor();
        if (!m.isArmed()) {
            TrendyCashedPainter.drawMenuItemFading(m, g);
        } else {
            TrendyUtils.drawMenuItemBackground(g, m);
        }
        g.setColor(oldColor);
    }
}

