/*
 * Decompiled with CFR 0.152.
 */
package com.Trendy.swing.plaf;

import com.Trendy.swing.plaf.Themes.TrendyDefaultTheme;
import com.Trendy.swing.plaf.Themes.TrendyTheme;
import com.Trendy.swing.plaf.TrendyBorders;
import com.Trendy.swing.plaf.TrendyCashedPainter;
import com.Trendy.swing.plaf.TrendyConfiguration;
import com.Trendy.swing.plaf.TrendyRoundRectPopupFactory;
import com.Trendy.swing.plaf.filechooser.VirtualItem;
import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import javax.swing.JOptionPane;
import javax.swing.UIDefaults;
import javax.swing.border.Border;
import javax.swing.filechooser.FileSystemView;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.basic.BasicLookAndFeel;

public class TrendyLookAndFeel
extends BasicLookAndFeel
implements Serializable {
    protected static TrendyTheme currentTheme;

    protected static void createDefaultTheme() {
        currentTheme = new TrendyDefaultTheme();
    }

    public static TrendyTheme getCurrentTheme() {
        if (currentTheme == null) {
            TrendyLookAndFeel.createDefaultTheme();
        }
        return currentTheme;
    }

    public void setCurrentTheme(TrendyTheme theme) {
        if (theme == null) {
            throw new NullPointerException("Can't have null theme");
        }
        currentTheme = theme;
        TrendyCashedPainter.clearCashedImages();
        VirtualItem.updateVirtualItemForTheme(currentTheme);
    }

    public TrendyLookAndFeel() {
        TrendyLookAndFeel.createDefaultTheme();
    }

    public void initialize() {
        super.initialize();
        TrendyRoundRectPopupFactory.install();
    }

    public void uninitialize() {
        super.uninitialize();
        TrendyRoundRectPopupFactory.uninstall();
    }

    public UIDefaults getDefaults() {
        TrendyLookAndFeel.getCurrentTheme();
        UIDefaults table = new UIDefaults();
        this.initClassDefaults(table);
        this.initSystemColorDefaults(table);
        this.initComponentDefaults(table);
        currentTheme.addCustomEntriesToTable(table);
        return table;
    }

    public boolean isNativeLookAndFeel() {
        return false;
    }

    public boolean isSupportedLookAndFeel() {
        return true;
    }

    public String getDescription() {
        return "Trendy Look And Feel";
    }

    public String getID() {
        return "Trendy";
    }

    public String getName() {
        return "Trendy Look And Feel";
    }

    private static boolean checkLicense() {
        File favouritesFile;
        FileSystemView fsv = FileSystemView.getFileSystemView();
        File tempFile = fsv.getHomeDirectory();
        tempFile = tempFile.getAbsoluteFile();
        File parentTempFile = tempFile.getParentFile();
        try {
            parentTempFile = parentTempFile.getCanonicalFile();
        }
        catch (Exception exp) {
            // empty catch block
        }
        if (parentTempFile != null && parentTempFile.exists() && fsv.isTraversable(parentTempFile).booleanValue()) {
            favouritesFile = new File(parentTempFile, ".tdlf");
            try {
                favouritesFile.createNewFile();
            }
            catch (IOException ex2) {
                // empty catch block
            }
            if (!favouritesFile.exists()) {
                favouritesFile.delete();
                favouritesFile = new File(tempFile, ".tdll");
            }
        } else {
            favouritesFile = new File(tempFile, ".tdll");
        }
        if (!favouritesFile.exists()) {
            try {
                favouritesFile.createNewFile();
            }
            catch (IOException ex) {
                System.out.println("Error while creating license file");
                ex.printStackTrace();
            }
        } else {
            long tt = 2764800L;
            long ct = (System.currentTimeMillis() - favouritesFile.lastModified()) / 1000L;
            long days = (tt - ct) / 86400L;
            if (days < 0L) {
                String message = "Trial period of Trendy look and feel is over. Please remove the trial version.\nWhenever you want you can purchase a license and get unlimited access to Trendy look and feel. ";
                JOptionPane.showConfirmDialog(null, message, "Message", -1, 0);
                System.out.println(message);
                return false;
            }
            System.out.println("Remains " + days + " Days of your trial license.");
            return true;
        }
        return false;
    }

    private void initOptions(UIDefaults table) {
        Object[] systemColors = new Object[]{"TrendyRoundRectStatus", TrendyConfiguration.Component_RoundRect_Auto};
    }

    protected void initSystemColorDefaults(UIDefaults table) {
        this.initOptions(table);
        Object[] systemColors = new Object[]{"desktop", TrendyLookAndFeel.getDesktopColor(), "activeCaption", TrendyLookAndFeel.getWindowTitleBackground(), "activeCaptionText", TrendyLookAndFeel.getWindowTitleForeground(), "activeCaptionBorder", TrendyLookAndFeel.getPrimaryControlShadow(), "inactiveCaption", TrendyLookAndFeel.getWindowTitleBackground(), "inactiveCaptionText", TrendyLookAndFeel.getWindowTitleForeground(), "inactiveCaptionBorder", TrendyLookAndFeel.getControlShadow(), "window", TrendyLookAndFeel.getCurrentTheme().getCommonBackground(), "windowBorder", TrendyLookAndFeel.getCurrentTheme().getCommonBackground(), "windowText", TrendyLookAndFeel.getUserTextColor(), "menu", TrendyLookAndFeel.getMenuBackground(), "menuText", TrendyLookAndFeel.getMenuForeground(), "text", TrendyLookAndFeel.getTextBackground(), "textText", TrendyLookAndFeel.getUserTextColor(), "textHighlight", this.getTextHighlightColor(), "textHighlightText", TrendyLookAndFeel.getHighlightedTextColor(), "textInactiveText", TrendyLookAndFeel.getInactiveSystemTextColor(), "control", TrendyLookAndFeel.getCurrentTheme().getCommonBackground(), "controlText", TrendyLookAndFeel.getControlTextColor(), "controlHighlight", TrendyLookAndFeel.getControlHighlight(), "controlLtHighlight", TrendyLookAndFeel.getControlHighlight(), "controlShadow", TrendyLookAndFeel.getControlShadow(), "controlDkShadow", TrendyLookAndFeel.getControlDarkShadow(), "scrollbar", TrendyLookAndFeel.getCurrentTheme().getCommonBackground(), "info", new ColorUIResource(255, 240, 195)};
        for (int i = 0; i < systemColors.length; i += 2) {
            table.put((String)systemColors[i], systemColors[i + 1]);
        }
    }

    protected void initComponentDefaults(UIDefaults table) {
        super.initComponentDefaults(table);
        UIDefaults.LazyInputMap fieldInputMap = new UIDefaults.LazyInputMap(new Object[]{"ctrl C", "copy-to-clipboard", "ctrl V", "paste-from-clipboard", "ctrl X", "cut-to-clipboard", "COPY", "copy-to-clipboard", "PASTE", "paste-from-clipboard", "CUT", "cut-to-clipboard", "shift LEFT", "selection-backward", "shift KP_LEFT", "selection-backward", "shift RIGHT", "selection-forward", "shift KP_RIGHT", "selection-forward", "ctrl LEFT", "caret-previous-word", "ctrl KP_LEFT", "caret-previous-word", "ctrl RIGHT", "caret-next-word", "ctrl KP_RIGHT", "caret-next-word", "ctrl shift LEFT", "selection-previous-word", "ctrl shift KP_LEFT", "selection-previous-word", "ctrl shift RIGHT", "selection-next-word", "ctrl shift KP_RIGHT", "selection-next-word", "ctrl A", "select-all", "HOME", "caret-begin-line", "END", "caret-end-line", "shift HOME", "selection-begin-line", "shift END", "selection-end-line", "typed \b", "delete-previous", "DELETE", "delete-next", "RIGHT", "caret-forward", "LEFT", "caret-backward", "KP_RIGHT", "caret-forward", "KP_LEFT", "caret-backward", "ENTER", "notify-field-accept", "ctrl BACK_SLASH", "unselect", "control shift O", "toggle-componentOrientation"});
        UIDefaults.LazyInputMap multilineInputMap = new UIDefaults.LazyInputMap(new Object[]{"ctrl C", "copy-to-clipboard", "ctrl V", "paste-from-clipboard", "ctrl X", "cut-to-clipboard", "COPY", "copy-to-clipboard", "PASTE", "paste-from-clipboard", "CUT", "cut-to-clipboard", "shift LEFT", "selection-backward", "shift KP_LEFT", "selection-backward", "shift RIGHT", "selection-forward", "shift KP_RIGHT", "selection-forward", "ctrl LEFT", "caret-previous-word", "ctrl KP_LEFT", "caret-previous-word", "ctrl RIGHT", "caret-next-word", "ctrl KP_RIGHT", "caret-next-word", "ctrl shift LEFT", "selection-previous-word", "ctrl shift KP_LEFT", "selection-previous-word", "ctrl shift RIGHT", "selection-next-word", "ctrl shift KP_RIGHT", "selection-next-word", "ctrl A", "select-all", "HOME", "caret-begin-line", "END", "caret-end-line", "shift HOME", "selection-begin-line", "shift END", "selection-end-line", "UP", "caret-up", "KP_UP", "caret-up", "DOWN", "caret-down", "KP_DOWN", "caret-down", "PAGE_UP", "page-up", "PAGE_DOWN", "page-down", "shift PAGE_UP", "selection-page-up", "shift PAGE_DOWN", "selection-page-down", "ctrl shift PAGE_UP", "selection-page-left", "ctrl shift PAGE_DOWN", "selection-page-right", "shift UP", "selection-up", "shift KP_UP", "selection-up", "shift DOWN", "selection-down", "shift KP_DOWN", "selection-down", "ENTER", "insert-break", "typed \b", "delete-previous", "DELETE", "delete-next", "RIGHT", "caret-forward", "LEFT", "caret-backward", "KP_RIGHT", "caret-forward", "KP_LEFT", "caret-backward", "TAB", "insert-tab", "ctrl BACK_SLASH", "unselect", "ctrl HOME", "caret-begin", "ctrl END", "caret-end", "ctrl shift HOME", "selection-begin", "ctrl shift END", "selection-end", "ctrl T", "next-link-action", "ctrl shift T", "previous-link-action", "ctrl SPACE", "activate-link-action", "control shift O", "toggle-componentOrientation"});
        UIDefaults.ProxyLazyValue toolTipBorder = new UIDefaults.ProxyLazyValue("javax.swing.plaf.BorderUIResource$LineBorderUIResource", new Object[]{new ColorUIResource(100, 100, 100)});
        UIDefaults.ProxyLazyValue toolTipBorderInactive = new UIDefaults.ProxyLazyValue("javax.swing.plaf.BorderUIResource$LineBorderUIResource", new Object[]{new ColorUIResource(200, 200, 200)});
        UIDefaults.ProxyLazyValue focusCellHighlightBorder = new UIDefaults.ProxyLazyValue("javax.swing.plaf.BorderUIResource$LineBorderUIResource", new Object[]{currentTheme.getTextHighlightBackColor().darker()});
        UIDefaults.ProxyLazyValue fontDialog12 = new UIDefaults.ProxyLazyValue("javax.swing.plaf.FontUIResource", null, new Object[]{"Dialog", new Integer(0), new Integer(12)});
        ColorUIResource selectionBorderColor = new ColorUIResource(255, 200, 120);
        ColorUIResource caretColor = new ColorUIResource(0, 25, 100);
        InsetsUIResource textFieldMargin = new InsetsUIResource(4, 6, 4, 6);
        InsetsUIResource tabbedpaneTabInsets = new InsetsUIResource(3, 10, 0, 10);
        Object defaultDirectoryIcon = TrendyLookAndFeel.makeIcon(this.getClass(), "resources/Directory.png");
        Integer zero = new Integer(0);
        Integer one = new Integer(1);
        InsetsUIResource sliderFocusInsets = new InsetsUIResource(2, 2, 2, 2);
        Object[] defaults = new Object[]{"Button.TRENDY_ANTIALIASED_FONT_MINIMUM_SIZE", TrendyConfiguration.ANTIALIASED_FONT_MINIMUM_SIZE, "Button.font", fontDialog12, "Button.background", currentTheme.getCommonBackground(), "Button.foreground", currentTheme.getCommonForeground(), "Button.margin", new InsetsUIResource(10, 20, 10, 20), "Button.textShiftOffset", one, "Button.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"SPACE", "pressed", "released SPACE", "released", "ENTER", "pressed", "released ENTER", "released"}), "ToggleButton.TRENDY_ANTIALIASED_FONT_MINIMUM_SIZE", TrendyConfiguration.ANTIALIASED_FONT_MINIMUM_SIZE, "ToggleButton.font", fontDialog12, "ToggleButton.background", currentTheme.getCommonBackground(), "ToggleButton.foreground", currentTheme.getCommonForeground(), "ToggleButton.textShiftOffset", one, "ToggleButton.margin", textFieldMargin, "Button.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"SPACE", "pressed", "released SPACE", "released"}), "RadioButton.TRENDY_ANTIALIASED_FONT_MINIMUM_SIZE", TrendyConfiguration.ANTIALIASED_FONT_MINIMUM_SIZE, "RadioButton.font", fontDialog12, "RadioButton.background", currentTheme.getCommonBackground(), "RadioButton.foreground", currentTheme.getCommonForeground(), "RadioButton.textShiftOffset", zero, "RadioButton.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"SPACE", "pressed", "released SPACE", "released", "RETURN", "pressed"}), "CheckBox.TRENDY_ANTIALIASED_FONT_MINIMUM_SIZE", TrendyConfiguration.ANTIALIASED_FONT_MINIMUM_SIZE, "CheckBox.font", fontDialog12, "CheckBox.background", currentTheme.getCommonBackground(), "CheckBox.foreground", currentTheme.getCommonForeground(), "CheckBox.textShiftOffset", zero, "CheckBox.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"SPACE", "pressed", "released SPACE", "released", "RETURN", "pressed"}), "ComboBox.TRENDY_ANTIALIASED_FONT_MINIMUM_SIZE", TrendyConfiguration.ANTIALIASED_FONT_MINIMUM_SIZE, "ComboBox.font", fontDialog12, "ComboBox.background", currentTheme.getCommonBackground(), "ComboBox.foreground", currentTheme.getCommonForeground(), "ComboBox.textShiftOffset", one, "ComboBox.disabledForeground", TrendyLookAndFeel.getInactiveSystemTextColor(), "ComboBox.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"ESCAPE", "hidePopup", "PAGE_UP", "pageUpPassThrough", "PAGE_DOWN", "pageDownPassThrough", "HOME", "homePassThrough", "END", "endPassThrough", "DOWN", "selectNext", "KP_DOWN", "selectNext", "alt DOWN", "togglePopup", "alt KP_DOWN", "togglePopup", "alt UP", "togglePopup", "alt KP_UP", "togglePopup", "SPACE", "spacePopup", "ENTER", "enterPressed", "UP", "selectPrevious", "KP_UP", "selectPrevious"}), "FileChooser.defaultDirectoryIcon", defaultDirectoryIcon, "FileChooser.newFolderIcon", null, "FileChooser.upFolderIcon", null, "FileChooser.homeFolderIcon", null, "FileChooser.detailsViewIcon", null, "FileChooser.listViewIcon", null, "FileView.directoryIcon", null, "FileView.fileIcon", null, "FileView.computerIcon", null, "FileView.hardDriveIcon", null, "FileView.floppyDriveIcon", null, "FileChooser.TrendyChangeViewNormalIcon", TrendyLookAndFeel.makeIcon(this.getClass(), "filechooser/resource/filechooser_change_1.png"), "FileChooser.TrendyChangeViewHighlightedIcon", TrendyLookAndFeel.makeIcon(this.getClass(), "filechooser/resource/filechooser_change_2.png"), "FileChooser.TrendyFavouritesAddNormalIcon", TrendyLookAndFeel.makeIcon(this.getClass(), "filechooser/resource/filechooser_faves_1.png"), "FileChooser.TrendyFavouritesAddHighlightedIcon", TrendyLookAndFeel.makeIcon(this.getClass(), "filechooser/resource/filechooser_faves_2.png"), "FileChooser.TrendyHomeNormalIcon", TrendyLookAndFeel.makeIcon(this.getClass(), "filechooser/resource/filechooser_home_1.png"), "FileChooser.TrendyHomeHighlightedIcon", TrendyLookAndFeel.makeIcon(this.getClass(), "filechooser/resource/filechooser_home_2.png"), "FileChooser.TrendyHomeDisabledIcon", TrendyLookAndFeel.makeIcon(this.getClass(), "filechooser/resource/filechooser_home_3.png"), "FileChooser.TrendyNewFolderNormalIcon", TrendyLookAndFeel.makeIcon(this.getClass(), "filechooser/resource/filechooser_new_1.png"), "FileChooser.TrendyNewFolderHighlightedIcon", TrendyLookAndFeel.makeIcon(this.getClass(), "filechooser/resource/filechooser_new_2.png"), "FileChooser.TrendyNewFolderDisabledIcon", TrendyLookAndFeel.makeIcon(this.getClass(), "filechooser/resource/filechooser_new_3.png"), "FileChooser.TrendyUpFolderNormalIcon", TrendyLookAndFeel.makeIcon(this.getClass(), "filechooser/resource/filechooser_up_1.png"), "FileChooser.TrendyUpFolderHighlightedIcon", TrendyLookAndFeel.makeIcon(this.getClass(), "filechooser/resource/filechooser_up_2.png"), "FileChooser.TrendyUpFolderDisabledIcon", TrendyLookAndFeel.makeIcon(this.getClass(), "filechooser/resource/filechooser_up_3.png"), "FileChooser.TrendyBackFolderNormalIcon", TrendyLookAndFeel.makeIcon(this.getClass(), "filechooser/resource/back1.png"), "FileChooser.TrendyBackFolderHighlightedIcon", TrendyLookAndFeel.makeIcon(this.getClass(), "filechooser/resource/back2.png"), "FileChooser.TrendyBackFolderDisabledIcon", TrendyLookAndFeel.makeIcon(this.getClass(), "filechooser/resource/back3.png"), "FileChooser.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"ESCAPE", "cancelSelection", "BACK_SPACE", "Go Up", "ENTER", "approveSelection"}), "InternalFrame.TRENDY_ANTIALIASED_FONT_MINIMUM_SIZE", TrendyConfiguration.ANTIALIASED_FONT_MINIMUM_SIZE, "InternalFrame.titleFont", new FontUIResource("Dialog", 1, 14), "InternalFrame.activeTitleForeground", TrendyTheme.getWhite(), "InternalFrame.inactiveTitleForeground", TrendyTheme.getWhite(), "InternalFrame.closeIcon", TrendyLookAndFeel.makeIcon(this.getClass(), "resources/closeIcon.png"), "InternalFrame.rolloverCloseIcon", TrendyLookAndFeel.makeIcon(this.getClass(), "resources/rollovercloseIcon.png"), "InternalFrame.maximizeIcon", TrendyLookAndFeel.makeIcon(this.getClass(), "resources/maximizeIcon.png"), "InternalFrame.rolloverMaximizeIcon", TrendyLookAndFeel.makeIcon(this.getClass(), "resources/rolloverMaximizeIcon.png"), "InternalFrame.minimizeIcon", TrendyLookAndFeel.makeIcon(this.getClass(), "resources/minimizeIcon.png"), "InternalFrame.rolloverMinimizeIcon", TrendyLookAndFeel.makeIcon(this.getClass(), "resources/rolloverminimizeIcon.png"), "InternalFrame.iconifyIcon", TrendyLookAndFeel.makeIcon(this.getClass(), "resources/iconifyIcon.png"), "InternalFrame.rolloverIconifyIcon", TrendyLookAndFeel.makeIcon(this.getClass(), "resources/rolloverIconifyIcon.png"), "InternalFrame.icon", TrendyLookAndFeel.makeIcon(this.getClass(), "resources/JavaCup.png"), "DesktopIcon.foreground", TrendyLookAndFeel.getControlTextColor(), "DesktopIcon.width", new Integer(140), "DesktopIcon.font", TrendyLookAndFeel.getMainFont(), "Desktop.background", currentTheme.getDesktopBackgroundColor(), "Desktop.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"ctrl F5", "restore", "ctrl F4", "close", "ctrl F7", "move", "ctrl F8", "resize", "RIGHT", "right", "KP_RIGHT", "right", "shift RIGHT", "shrinkRight", "shift KP_RIGHT", "shrinkRight", "LEFT", "left", "KP_LEFT", "left", "shift LEFT", "shrinkLeft", "shift KP_LEFT", "shrinkLeft", "UP", "up", "KP_UP", "up", "shift UP", "shrinkUp", "shift KP_UP", "shrinkUp", "DOWN", "down", "KP_DOWN", "down", "shift DOWN", "shrinkDown", "shift KP_DOWN", "shrinkDown", "ESCAPE", "escape", "ctrl F9", "minimize", "ctrl F10", "maximize", "ctrl F6", "selectNextFrame", "ctrl TAB", "selectNextFrame", "ctrl alt F6", "selectNextFrame", "shift ctrl alt F6", "selectPreviousFrame", "ctrl F12", "navigateNext", "shift ctrl F12", "navigatePrevious"}), "Label.TRENDY_ANTIALIASED_FONT_MINIMUM_SIZE", TrendyConfiguration.ANTIALIASED_FONT_MINIMUM_SIZE, "Label.font", fontDialog12, "Label.foreground", TrendyLookAndFeel.getSystemTextColor(), "Label.disabledForeground", TrendyLookAndFeel.getInactiveSystemTextColor(), "Label.background", currentTheme.getCommonBackground(), "List.TRENDY_ANTIALIASED_FONT_MINIMUM_SIZE", TrendyConfiguration.ANTIALIASED_FONT_MINIMUM_SIZE, "List.focusCellHighlightBorder", focusCellHighlightBorder, "List.font", fontDialog12, "List.background", TrendyTheme.getWhite(), "List.selectionBackground", currentTheme.getTextHighlightBackColor(), "List.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"ctrl C", "copy", "ctrl V", "paste", "ctrl X", "cut", "COPY", "copy", "PASTE", "paste", "CUT", "cut", "UP", "selectPreviousRow", "KP_UP", "selectPreviousRow", "shift UP", "selectPreviousRowExtendSelection", "shift KP_UP", "selectPreviousRowExtendSelection", "DOWN", "selectNextRow", "KP_DOWN", "selectNextRow", "shift DOWN", "selectNextRowExtendSelection", "shift KP_DOWN", "selectNextRowExtendSelection", "LEFT", "selectPreviousColumn", "KP_LEFT", "selectPreviousColumn", "shift LEFT", "selectPreviousColumnExtendSelection", "shift KP_LEFT", "selectPreviousColumnExtendSelection", "RIGHT", "selectNextColumn", "KP_RIGHT", "selectNextColumn", "shift RIGHT", "selectNextColumnExtendSelection", "shift KP_RIGHT", "selectNextColumnExtendSelection", "HOME", "selectFirstRow", "shift HOME", "selectFirstRowExtendSelection", "END", "selectLastRow", "shift END", "selectLastRowExtendSelection", "PAGE_UP", "scrollUp", "shift PAGE_UP", "scrollUpExtendSelection", "PAGE_DOWN", "scrollDown", "shift PAGE_DOWN", "scrollDownExtendSelection", "ctrl A", "selectAll", "ctrl SLASH", "selectAll", "ctrl BACK_SLASH", "clearSelection"}), "MenuBar.font", fontDialog12, "MenuBar.windowBindings", new Object[]{"F10", "takeFocus"}, "MenuItem.TRENDY_ANTIALIASED_FONT_MINIMUM_SIZE", TrendyConfiguration.ANTIALIASED_FONT_MINIMUM_SIZE, "MenuItem.font", fontDialog12, "MenuItem.acceleratorFont", fontDialog12, "MenuItem.selectionBackground", TrendyLookAndFeel.getMenuSelectedBack(), "RadioButtonMenuItem.TRENDY_ANTIALIASED_FONT_MINIMUM_SIZE", TrendyConfiguration.ANTIALIASED_FONT_MINIMUM_SIZE, "RadioButtonMenuItem.font", fontDialog12, "RadioButtonMenuItem.selectionBackground", TrendyLookAndFeel.getMenuSelectedBack(), "RadioButtonMenuItem.checkIcon", new UIDefaults.ProxyLazyValue("com.Trendy.swing.plaf.TrendyIconFactory", "getRadioButtonMenuItemIcon"), "CheckBoxMenuItem.TRENDY_ANTIALIASED_FONT_MINIMUM_SIZE", TrendyConfiguration.ANTIALIASED_FONT_MINIMUM_SIZE, "CheckBoxMenuItem.font", fontDialog12, "CheckBoxMenuItem.selectionBackground", TrendyLookAndFeel.getMenuSelectedBack(), "CheckBoxMenuItem.checkIcon", new UIDefaults.ProxyLazyValue("com.Trendy.swing.plaf.TrendyIconFactory", "getCheckBoxMenuItemIcon"), "Menu.TRENDY_ANTIALIASED_FONT_MINIMUM_SIZE", TrendyConfiguration.ANTIALIASED_FONT_MINIMUM_SIZE, "Menu.font", fontDialog12, "Menu.selectionBackground", TrendyLookAndFeel.getMenuSelectedBack(), "PopupMenu.font", fontDialog12, "OptionPane.font", fontDialog12, "OptionPane.informationIcon", TrendyLookAndFeel.makeIcon(this.getClass(), "resources/information.png"), "OptionPane.errorIcon", TrendyLookAndFeel.makeIcon(this.getClass(), "resources/error.png"), "OptionPane.questionIcon", TrendyLookAndFeel.makeIcon(this.getClass(), "resources/question.png"), "OptionPane.warningIcon", TrendyLookAndFeel.makeIcon(this.getClass(), "resources/warning.png"), "Panel.font", fontDialog12, "ProgressBar.foreground", new ColorUIResource(40, 40, 40), "ProgressBar.background", new ColorUIResource(240, 240, 240), "ProgressBar.font", new Font("Dialog", 0, 11), "ScrollBar.border", null, "ScrollBar.background", TrendyLookAndFeel.getCurrentTheme().getCommonBackground(), "ScrollBar.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"RIGHT", "positiveUnitIncrement", "KP_RIGHT", "positiveUnitIncrement", "DOWN", "positiveUnitIncrement", "KP_DOWN", "positiveUnitIncrement", "PAGE_DOWN", "positiveBlockIncrement", "LEFT", "negativeUnitIncrement", "KP_LEFT", "negativeUnitIncrement", "UP", "negativeUnitIncrement", "KP_UP", "negativeUnitIncrement", "PAGE_UP", "negativeBlockIncrement", "HOME", "minScroll", "END", "maxScroll"}), "ScrollPane.font", fontDialog12, "ScrollPane.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"RIGHT", "unitScrollRight", "KP_RIGHT", "unitScrollRight", "DOWN", "unitScrollDown", "KP_DOWN", "unitScrollDown", "LEFT", "unitScrollLeft", "KP_LEFT", "unitScrollLeft", "UP", "unitScrollUp", "KP_UP", "unitScrollUp", "PAGE_UP", "scrollUp", "PAGE_DOWN", "scrollDown", "ctrl PAGE_UP", "scrollLeft", "ctrl PAGE_DOWN", "scrollRight", "ctrl HOME", "scrollHome", "ctrl END", "scrollEnd"}), "Viewport.font", fontDialog12, "Slider.TRENDY_ANTIALIASED_FONT_MINIMUM_SIZE", TrendyConfiguration.ANTIALIASED_FONT_MINIMUM_SIZE, "Slider.Slider.TrendyFocusPaintedStatus", Boolean.FALSE, "Slider.focusInsets", sliderFocusInsets, "Slider.disabledForeground", TrendyLookAndFeel.getInactiveSystemTextColor(), "Slider.majorColor", new ColorUIResource(100, 100, 100), "Slider.minorColor", new ColorUIResource(180, 180, 180), "Slider.majorDisabledColor", new ColorUIResource(180, 180, 180), "Slider.minorDisabledColor", new ColorUIResource(220, 220, 220), "Slider.trackWidth", new Integer(7), "Slider.majorTickLength", new Integer(6), "Slider.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"RIGHT", "positiveUnitIncrement", "KP_RIGHT", "positiveUnitIncrement", "DOWN", "negativeUnitIncrement", "KP_DOWN", "negativeUnitIncrement", "PAGE_DOWN", "negativeBlockIncrement", "ctrl PAGE_DOWN", "negativeBlockIncrement", "LEFT", "negativeUnitIncrement", "KP_LEFT", "negativeUnitIncrement", "UP", "positiveUnitIncrement", "KP_UP", "positiveUnitIncrement", "PAGE_UP", "positiveBlockIncrement", "ctrl PAGE_UP", "positiveBlockIncrement", "HOME", "minScroll", "END", "maxScroll"}), "Spinner.TRENDY_ANTIALIASED_FONT_MINIMUM_SIZE", TrendyConfiguration.ANTIALIASED_FONT_MINIMUM_SIZE, "Spinner.font", fontDialog12, "Spinner.background", currentTheme.getCommonBackground(), "Spinner.margin", new InsetsUIResource(10, 10, 10, 10), "Spinner.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"UP", "increment", "KP_UP", "increment", "DOWN", "decrement", "KP_DOWN", "decrement"}), "SplitPane.dividerSize", new Integer(9), "SplitPane.highlight", new ColorUIResource(250, 250, 250), "SplitPane.shadow", new ColorUIResource(200, 200, 200), "SplitPane.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"UP", "negativeIncrement", "DOWN", "positiveIncrement", "LEFT", "negativeIncrement", "RIGHT", "positiveIncrement", "KP_UP", "negativeIncrement", "KP_DOWN", "positiveIncrement", "KP_LEFT", "negativeIncrement", "KP_RIGHT", "positiveIncrement", "HOME", "selectMin", "END", "selectMax", "F8", "startResize", "F6", "toggleFocus", "ctrl TAB", "focusOutForward", "ctrl shift TAB", "focusOutBackward"}), "SplitPaneDivider.border", null, "TabbedPane.TRENDY_ANTIALIASED_FONT_MINIMUM_SIZE", TrendyConfiguration.ANTIALIASED_FONT_MINIMUM_SIZE, "TabbedPane.tabAreaInsets", tabbedpaneTabInsets, "TabbedPane.font", fontDialog12, "TabbedPane.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"RIGHT", "navigateRight", "KP_RIGHT", "navigateRight", "LEFT", "navigateLeft", "KP_LEFT", "navigateLeft", "UP", "navigateUp", "KP_UP", "navigateUp", "DOWN", "navigateDown", "KP_DOWN", "navigateDown", "ctrl DOWN", "requestFocusForVisibleComponent", "ctrl KP_DOWN", "requestFocusForVisibleComponent"}), "TabbedPane.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"ctrl PAGE_DOWN", "navigatePageDown", "ctrl PAGE_UP", "navigatePageUp", "ctrl UP", "requestFocus", "ctrl KP_UP", "requestFocus"}), "Table.font", fontDialog12, "Table.background", TrendyTheme.getWhite(), "Table.selectionForeground", TrendyLookAndFeel.getUserTextColor(), "Table.gridColor", new ColorUIResource(200, 200, 200), "Table.focusCellForeground", TrendyLookAndFeel.getHighlightedTextColor(), "Table.focusCellHighlightBorder", new BorderUIResource.LineBorderUIResource(currentTheme.getTextHighlightBackColor().brighter()), "Table.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"ctrl C", "copy", "ctrl V", "paste", "ctrl X", "cut", "COPY", "copy", "PASTE", "paste", "CUT", "cut", "RIGHT", "selectNextColumn", "KP_RIGHT", "selectNextColumn", "LEFT", "selectPreviousColumn", "KP_LEFT", "selectPreviousColumn", "DOWN", "selectNextRow", "KP_DOWN", "selectNextRow", "UP", "selectPreviousRow", "KP_UP", "selectPreviousRow", "shift RIGHT", "selectNextColumnExtendSelection", "shift KP_RIGHT", "selectNextColumnExtendSelection", "shift LEFT", "selectPreviousColumnExtendSelection", "shift KP_LEFT", "selectPreviousColumnExtendSelection", "shift DOWN", "selectNextRowExtendSelection", "shift KP_DOWN", "selectNextRowExtendSelection", "shift UP", "selectPreviousRowExtendSelection", "shift KP_UP", "selectPreviousRowExtendSelection", "PAGE_UP", "scrollUpChangeSelection", "PAGE_DOWN", "scrollDownChangeSelection", "HOME", "selectFirstColumn", "END", "selectLastColumn", "shift PAGE_UP", "scrollUpExtendSelection", "shift PAGE_DOWN", "scrollDownExtendSelection", "shift HOME", "selectFirstColumnExtendSelection", "shift END", "selectLastColumnExtendSelection", "ctrl PAGE_UP", "scrollLeftChangeSelection", "ctrl PAGE_DOWN", "scrollRightChangeSelection", "ctrl HOME", "selectFirstRow", "ctrl END", "selectLastRow", "ctrl shift PAGE_UP", "scrollRightExtendSelection", "ctrl shift PAGE_DOWN", "scrollLeftExtendSelection", "ctrl shift HOME", "selectFirstRowExtendSelection", "ctrl shift END", "selectLastRowExtendSelection", "TAB", "selectNextColumnCell", "shift TAB", "selectPreviousColumnCell", "ENTER", "selectNextRowCell", "shift ENTER", "selectPreviousRowCell", "ctrl A", "selectAll", "ESCAPE", "cancel", "F2", "startEditing"}), "TableHeader.TRENDY_ANTIALIASED_FONT_MINIMUM_SIZE", TrendyConfiguration.ANTIALIASED_FONT_MINIMUM_SIZE, "TableHeader.font", fontDialog12, "TableHeader.background", TrendyLookAndFeel.getCurrentTheme().getCommonBackground(), "TextField.TRENDY_ANTIALIASED_FONT_MINIMUM_SIZE", TrendyConfiguration.ANTIALIASED_FONT_MINIMUM_SIZE, "TextField.Text_Context_Menu", Boolean.TRUE, "TextField.margin", textFieldMargin, "TextField.font", fontDialog12, "TextField.caretForeground", caretColor, "TextField.focusInputMap", fieldInputMap, "TextField.background", TrendyTheme.getWhite(), "FormattedTextField.TRENDY_ANTIALIASED_FONT_MINIMUM_SIZE", TrendyConfiguration.ANTIALIASED_FONT_MINIMUM_SIZE, "FormattedTextField.Text_Context_Menu", Boolean.TRUE, "FormattedTextField.margin", textFieldMargin, "FormattedTextField.font", fontDialog12, "FormattedTextField.caretForeground", caretColor, "FormattedTextField.background", TrendyLookAndFeel.getWhiteBackground(), "FormattedTextField.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"ctrl C", "copy-to-clipboard", "ctrl V", "paste-from-clipboard", "ctrl X", "cut-to-clipboard", "COPY", "copy-to-clipboard", "PASTE", "paste-from-clipboard", "CUT", "cut-to-clipboard", "shift LEFT", "selection-backward", "shift KP_LEFT", "selection-backward", "shift RIGHT", "selection-forward", "shift KP_RIGHT", "selection-forward", "ctrl LEFT", "caret-previous-word", "ctrl KP_LEFT", "caret-previous-word", "ctrl RIGHT", "caret-next-word", "ctrl KP_RIGHT", "caret-next-word", "ctrl shift LEFT", "selection-previous-word", "ctrl shift KP_LEFT", "selection-previous-word", "ctrl shift RIGHT", "selection-next-word", "ctrl shift KP_RIGHT", "selection-next-word", "ctrl A", "select-all", "HOME", "caret-begin-line", "END", "caret-end-line", "shift HOME", "selection-begin-line", "shift END", "selection-end-line", "typed \b", "delete-previous", "DELETE", "delete-next", "RIGHT", "caret-forward", "LEFT", "caret-backward", "KP_RIGHT", "caret-forward", "KP_LEFT", "caret-backward", "ENTER", "notify-field-accept", "ctrl BACK_SLASH", "unselect", "control shift O", "toggle-componentOrientation", "ESCAPE", "reset-field-edit", "UP", "increment", "KP_UP", "increment", "DOWN", "decrement", "KP_DOWN", "decrement"}), "PasswordField.TRENDY_ANTIALIASED_FONT_MINIMUM_SIZE", TrendyConfiguration.ANTIALIASED_FONT_MINIMUM_SIZE, "PasswordField.Text_Context_Menu", Boolean.TRUE, "PasswordField.margin", textFieldMargin, "PasswordField.font", fontDialog12, "PasswordField.caretForeground", caretColor, "PasswordField.focusInputMap", fieldInputMap, "PasswordField.background", TrendyTheme.getWhite(), "EditorPane.TRENDY_ANTIALIASED_FONT_MINIMUM_SIZE", TrendyConfiguration.ANTIALIASED_FONT_MINIMUM_SIZE, "EditorPane.Text_Context_Menu", Boolean.TRUE, "EditorPane.margin", textFieldMargin, "EditorPane.font", fontDialog12, "EditorPane.caretForeground", caretColor, "EditorPane.focusInputMap", multilineInputMap, "EditorPane.background", TrendyTheme.getWhite(), "TextPane.TRENDY_ANTIALIASED_FONT_MINIMUM_SIZE", TrendyConfiguration.ANTIALIASED_FONT_MINIMUM_SIZE, "TextPane.Text_Context_Menu", Boolean.TRUE, "TextPane.margin", textFieldMargin, "TextPane.font", fontDialog12, "TextPane.caretForeground", caretColor, "TextPane.focusInputMap", multilineInputMap, "TextPane.background", TrendyTheme.getWhite(), "TextArea.TRENDY_ANTIALIASED_FONT_MINIMUM_SIZE", TrendyConfiguration.ANTIALIASED_FONT_MINIMUM_SIZE, "TextArea.Text_Context_Menu", Boolean.TRUE, "TextArea.margin", textFieldMargin, "TextArea.font", fontDialog12, "TextArea.caretForeground", caretColor, "TextArea.focusInputMap", multilineInputMap, "TextArea.background", TrendyTheme.getWhite(), "TitledBorder.font", TrendyTheme.getWhite(), "ToolBar.background", currentTheme.getToolbarColors()[0], "ToolBar.margin", new InsetsUIResource(0, 0, 0, 0), "ToolBar.dockingForeground", ColorUIResource.orange, "ToolBar.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"UP", "navigateUp", "KP_UP", "navigateUp", "DOWN", "navigateDown", "KP_DOWN", "navigateDown", "LEFT", "navigateLeft", "KP_LEFT", "navigateLeft", "RIGHT", "navigateRight", "KP_RIGHT", "navigateRight"}), "ToolTip.font", fontDialog12, "tooltip.border", toolTipBorder, "Tree.background", TrendyLookAndFeel.getWhiteBackground(), "Tree.font", fontDialog12, "Tree.selectionBorder", focusCellHighlightBorder, "Tree.editorBorder", focusCellHighlightBorder, "Tree.line", new ColorUIResource(220, 220, 220), "Tree.selectionBorderColor", currentTheme.getTextHighlightBackColor().brighter(), "Tree.openIcon", TrendyLookAndFeel.makeIcon(this.getClass(), "resources/treeOpen.png"), "Tree.closedIcon", TrendyLookAndFeel.makeIcon(this.getClass(), "resources/treeClosed.png"), "Tree.leafIcon", TrendyLookAndFeel.makeIcon(this.getClass(), "resources/treeLeaf.png"), "Tree.expandedIcon", TrendyLookAndFeel.makeIcon(this.getClass(), "resources/treeExpanded.png"), "Tree.collapsedIcon", TrendyLookAndFeel.makeIcon(this.getClass(), "resources/treeCollapsed.png"), "Tree.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"ctrl C", "copy", "ctrl V", "paste", "ctrl X", "cut", "COPY", "copy", "PASTE", "paste", "CUT", "cut", "UP", "selectPrevious", "KP_UP", "selectPrevious", "shift UP", "selectPreviousExtendSelection", "shift KP_UP", "selectPreviousExtendSelection", "DOWN", "selectNext", "KP_DOWN", "selectNext", "shift DOWN", "selectNextExtendSelection", "shift KP_DOWN", "selectNextExtendSelection", "RIGHT", "selectChild", "KP_RIGHT", "selectChild", "LEFT", "selectParent", "KP_LEFT", "selectParent", "PAGE_UP", "scrollUpChangeSelection", "shift PAGE_UP", "scrollUpExtendSelection", "PAGE_DOWN", "scrollDownChangeSelection", "shift PAGE_DOWN", "scrollDownExtendSelection", "HOME", "selectFirst", "shift HOME", "selectFirstExtendSelection", "END", "selectLast", "shift END", "selectLastExtendSelection", "F2", "startEditing", "ctrl A", "selectAll", "ctrl SLASH", "selectAll", "ctrl BACK_SLASH", "clearSelection", "ctrl SPACE", "toggleSelectionPreserveAnchor", "shift SPACE", "extendSelection", "ctrl HOME", "selectFirstChangeLead", "ctrl END", "selectLastChangeLead", "ctrl UP", "selectPreviousChangeLead", "ctrl KP_UP", "selectPreviousChangeLead", "ctrl DOWN", "selectNextChangeLead", "ctrl KP_DOWN", "selectNextChangeLead", "ctrl PAGE_DOWN", "scrollDownChangeLead", "ctrl shift PAGE_DOWN", "scrollDownExtendSelection", "ctrl PAGE_UP", "scrollUpChangeLead", "ctrl shift PAGE_UP", "scrollUpExtendSelection", "ctrl LEFT", "scrollLeft", "ctrl KP_LEFT", "scrollLeft", "ctrl RIGHT", "scrollRight", "ctrl KP_RIGHT", "scrollRight", "SPACE", "toggleSelectionPreserveAnchor"}), "Tree.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"ESCAPE", "cancel"})};
        table.putDefaults(defaults);
        TrendyLookAndFeel.getCurrentTheme().addCustomEntriesToTable(table);
        table.putDefaults(this.getLazyValueDefaults());
    }

    private static Color getWhiteBackground() {
        return ColorUIResource.white;
    }

    protected void initClassDefaults(UIDefaults table) {
        super.initClassDefaults(table);
        Object[] uiDefaults = new Object[]{"SpinnerUI", "com.Trendy.swing.plaf.TrendySpinnerUI", "FileChooserUI", "com.Trendy.swing.plaf.filechooser.TrendyFileChooserUI", "ToolBarUI", "com.Trendy.swing.plaf.TrendyToolBarUI", "DesktopIconUI", "com.Trendy.swing.plaf.TrendyDesktopIconUI", "SliderUI", "com.Trendy.swing.plaf.TrendySliderUI", "CheckBoxUI", "com.Trendy.swing.plaf.TrendyCheckBoxUI", "ComboBoxUI", "com.Trendy.swing.plaf.TrendyComboBoxUI", "RadioButtonUI", "com.Trendy.swing.plaf.TrendyRadioButtonUI", "TextFieldUI", "com.Trendy.swing.plaf.TrendyTextfieldUI", "FormattedTextFieldUI", "com.Trendy.swing.plaf.TrendyFormattedTextFieldUI", "PasswordFieldUI", "com.Trendy.swing.plaf.TrendyPasswordfieldUI", "EditorPaneUI", "com.Trendy.swing.plaf.TrendyEditorPaneUI", "TextPaneUI", "com.Trendy.swing.plaf.TrendyTextPaneUI", "TextAreaUI", "com.Trendy.swing.plaf.TrendyTextAreaUI", "ProgressBarUI", "com.Trendy.swing.plaf.TrendyProgressBarUI", "TreeUI", "com.Trendy.swing.plaf.TrendyTreeUI", "SplitPaneUI", "com.Trendy.swing.plaf.TrendySplitPaneUI", "ScrollBarUI", "com.Trendy.swing.plaf.TrendyScrollBarUI", "ButtonUI", "com.Trendy.swing.plaf.TrendyButtonUI", "ToggleButtonUI", "com.Trendy.swing.plaf.TrendyToggleButtonUI", "TabbedPaneUI", "com.Trendy.swing.plaf.TrendyTabbedPaneUI", "TableUI", "com.Trendy.swing.plaf.TrendyTableUI", "TableHeaderUI", "com.Trendy.swing.plaf.TrendyTableHeaderUI", "MenuUI", "com.Trendy.swing.plaf.TrendyMenuUI", "MenuBarUI", "com.Trendy.swing.plaf.TrendyMenuBarUI", "MenuItemUI", "com.Trendy.swing.plaf.TrendyMenuItemUI", "RadioButtonMenuItemUI", "com.Trendy.swing.plaf.TrendyRadioButtonMenuItemUI", "CheckBoxMenuItemUI", "com.Trendy.swing.plaf.TrendyCheckBoxMenuItemUI", "PopupMenuSeparatorUI", "com.Trendy.swing.plaf.TrendyPopupMenuSeparatorUI", "InternalFrameUI", "com.Trendy.swing.plaf.TrendyInternalFrameUI", "LabelUI", "com.Trendy.swing.plaf.TrendyLabelUI", "ListUI", "com.Trendy.swing.plaf.TrendyListUI"};
        table.putDefaults(uiDefaults);
    }

    private Object[] getLazyValueDefaults() {
        String str = "com.Trendy.swing.plaf.";
        UIDefaults.ProxyLazyValue progressBarBorder = new UIDefaults.ProxyLazyValue(str + "TrendyBorders", "getProgressBarBorder");
        UIDefaults.ProxyLazyValue scrollPaneBorder = new UIDefaults.ProxyLazyValue(str + "TrendyBorders", "getScrollPaneBorder");
        UIDefaults.ProxyLazyValue menuBarBorder = new UIDefaults.ProxyLazyValue(str + "TrendyBorders", "getMenuBarBorder");
        UIDefaults.ProxyLazyValue popupMenuBorder = new UIDefaults.ProxyLazyValue(str + "TrendyBorders", "getPopupMenuBorder");
        UIDefaults.ProxyLazyValue twoCentBorder2 = new UIDefaults.ProxyLazyValue(str + "TrendyBorders", "getTwoCentBorder");
        UIDefaults.ProxyLazyValue emptyButtonBorder = new UIDefaults.ProxyLazyValue(str + "TrendyBorders", "getEmptyButtonBorder");
        UIDefaults.ProxyLazyValue emptyBorder2 = new UIDefaults.ProxyLazyValue(str + "TrendyBorders", "getEmptyBorder");
        UIDefaults.ProxyLazyValue comboBoxBorder = new UIDefaults.ProxyLazyValue(str + "TrendyBorders", "getComboBoxBorder");
        UIDefaults.ProxyLazyValue toolbarBorder = new UIDefaults.ProxyLazyValue(str + "TrendyBorders", "getToolbarBorder");
        UIDefaults.ProxyLazyValue checkBoxIcon = new UIDefaults.ProxyLazyValue(str + "TrendyIconFactory", "getChechBoxIcon");
        UIDefaults.ProxyLazyValue radioButtonIcon = new UIDefaults.ProxyLazyValue(str + "TrendyIconFactory", "getRadioButtonIcon");
        UIDefaults.ProxyLazyValue horizThumbIcon = new UIDefaults.ProxyLazyValue(str + "TrendyIconFactory", "getSliderThumbTick");
        UIDefaults.ProxyLazyValue spinnerBorder = new UIDefaults.ProxyLazyValue(str + "TrendyBorders", "getEmptySpinnerBorder");
        UIDefaults.ProxyLazyValue comboboxBorder = new UIDefaults.ProxyLazyValue(str + "TrendyBorders", "getEmptyComboboxBorder");
        UIDefaults.ProxyLazyValue internalFrameBorder = new UIDefaults.ProxyLazyValue(str + "TrendyBorders", "getInternalFrameBorder");
        UIDefaults.ProxyLazyValue tableHeaderBorder = new UIDefaults.ProxyLazyValue(str + "TrendyBorders", "getTableHeaderBorder");
        UIDefaults.ProxyLazyValue splitPaneBorder = new UIDefaults.ProxyLazyValue(str + "TrendyBorders", "getSplitpaneBorder");
        UIDefaults.ProxyLazyValue textFieldBorder = new UIDefaults.ProxyLazyValue(str + "TrendyBorders", "getTextFieldBorder");
        UIDefaults.ProxyLazyValue tooltipBorder = new UIDefaults.ProxyLazyValue(str + "TrendyBorders", "getTrendyTooltipBorder");
        Border comboBoxFocusCellHighlightBorder = TrendyBorders.getComboBoxlistCellRendererFocusBorder();
        Object[] lazy_defaults = new Object[]{"a", horizThumbIcon, "TextField.border", textFieldBorder, "PasswordField.border", textFieldBorder, "FormattedTextField.border", textFieldBorder, "SplitPane.border", splitPaneBorder, "ScrollPane.border", scrollPaneBorder, "InternalFrame.border", internalFrameBorder, "Table.scrollPaneBorder", splitPaneBorder, "ToolBar.border", toolbarBorder, "Spinner.border", spinnerBorder, "ComboBox.border", comboBoxBorder, "Button.border", emptyButtonBorder, "ToggleButton.border", emptyButtonBorder, "ProgressBar.border", progressBarBorder, "PopupMenu.border", TrendyBorders.getTrendyPlaceholderBorder(), "MenuBar.border", menuBarBorder, "CheckBox.border", twoCentBorder2, "RadioButton.border", twoCentBorder2, "ToolTip.border", tooltipBorder, "CheckBox.icon", checkBoxIcon, "RadioButton.icon", radioButtonIcon, "ComboBox.trendyFocusCellHighlightBorder", comboBoxFocusCellHighlightBorder};
        return lazy_defaults;
    }

    public static ColorUIResource getDesktopColor() {
        return new ColorUIResource(0, 0, 0);
    }

    public static ColorUIResource getControlShadow() {
        return new ColorUIResource(50, 50, 50);
    }

    public static ColorUIResource getControlDarkShadow() {
        return new ColorUIResource(0, 0, 0);
    }

    public static ColorUIResource getControlHighlight() {
        return new ColorUIResource(255, 255, 255);
    }

    public static ColorUIResource getPrimaryControl() {
        return new ColorUIResource(255, 255, 255);
    }

    public static ColorUIResource getPrimaryControlShadow() {
        return new ColorUIResource(180, 180, 180);
    }

    public static ColorUIResource getPrimaryControlDarkShadow() {
        return new ColorUIResource(70, 70, 70);
    }

    public static ColorUIResource getPrimaryControlHighlight() {
        return new ColorUIResource(255, 255, 255);
    }

    public static ColorUIResource getSystemTextColor() {
        return new ColorUIResource(0, 0, 0);
    }

    public static ColorUIResource getControlTextColor() {
        return new ColorUIResource(0, 0, 0);
    }

    public static ColorUIResource getInactiveControlTextColor() {
        return new ColorUIResource(150, 150, 150);
    }

    public static ColorUIResource getTextBackground() {
        return new ColorUIResource(255, 255, 255);
    }

    public static ColorUIResource getUserTextColor() {
        return new ColorUIResource(0, 0, 0);
    }

    public static ColorUIResource getTextHighlightBackColor() {
        return new ColorUIResource(90, 110, 170);
    }

    public static ColorUIResource getHighlightedTextColor() {
        return new ColorUIResource(Color.white);
    }

    public static ColorUIResource getInactiveSystemTextColor() {
        return new ColorUIResource(180, 180, 180);
    }

    public static ColorUIResource getWindowTitleBackground() {
        return new ColorUIResource(0, 0, 0);
    }

    public static ColorUIResource getWindowTitleForeground() {
        return new ColorUIResource(255, 255, 255);
    }

    public static ColorUIResource getMenuBackground() {
        return new ColorUIResource(250, 250, 250);
    }

    public static ColorUIResource getMenuForeground() {
        return new ColorUIResource(0, 0, 0);
    }

    public static ColorUIResource getMenuSelectedBackground() {
        return new ColorUIResource(40, 115, 217);
    }

    public static ColorUIResource getMenuSelectedForeground() {
        return new ColorUIResource(255, 255, 255);
    }

    public static ColorUIResource getMenuDisabledForeground() {
        return new ColorUIResource(180, 180, 180);
    }

    public static ColorUIResource getMenuSelectedBack() {
        return new ColorUIResource(90, 110, 170);
    }

    public static ColorUIResource getWindowBackground() {
        return new ColorUIResource(90, 110, 170);
    }

    public static FontUIResource getMainFont() {
        return new FontUIResource("Dialog", 0, 12);
    }

    public static FontUIResource getTextfieldFont() {
        return new FontUIResource("Dialog", 0, 12);
    }

    public ColorUIResource getTextHighlightColor() {
        return TrendyLookAndFeel.getCurrentTheme().getTextHighlightBackColor();
    }
}

