/*
 * Decompiled with CFR 0.152.
 */
package com.Trendy.swing.plaf;

import com.Trendy.swing.plaf.TrendyConfiguration;
import com.Trendy.swing.plaf.TrendyUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import javax.swing.Icon;
import javax.swing.JInternalFrame;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicInternalFrameTitlePane;

public class TrendyInternalFrameTitlePane
extends BasicInternalFrameTitlePane {
    protected Icon rolloverCloseIcon;
    protected Icon rolloverIconifyIcon;
    protected Icon rolloverMinimizeIcon;
    protected Icon rolloverMaximumIcon;

    protected void installDefaults() {
        super.installDefaults();
        this.rolloverCloseIcon = UIManager.getIcon("InternalFrame.rolloverCloseIcon");
        this.rolloverIconifyIcon = UIManager.getIcon("InternalFrame.rolloverIconifyIcon");
        this.rolloverMinimizeIcon = UIManager.getIcon("InternalFrame.rolloverMinimizeIcon");
        this.rolloverMaximumIcon = UIManager.getIcon("InternalFrame.rolloverMaximizeIcon");
        this.putClientProperty("TRENDY_ANTIALIASED_FONT_MINIMUM_SIZE", UIManager.get("InternalFrame.TRENDY_ANTIALIASED_FONT_MINIMUM_SIZE"));
    }

    public TrendyInternalFrameTitlePane(JInternalFrame f) {
        super(f);
    }

    public void uninstallListeners() {
        super.uninstallListeners();
    }

    public void paintComponent(Graphics g) {
        if (TrendyConfiguration.isFontAntialiased(this, g.getFont().getSize())) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            super.paintComponent(g2);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
            g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_DEFAULT);
        } else {
            super.paintComponent(g);
        }
    }

    protected void paintTitleBackground(Graphics g) {
        boolean antialiased = false;
        if (g instanceof Graphics2D && ((Graphics2D)g).getRenderingHint(RenderingHints.KEY_ANTIALIASING).equals(RenderingHints.VALUE_ANTIALIAS_ON)) {
            antialiased = true;
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_DEFAULT);
        }
        int x = this.getX();
        int y = this.getY();
        int w = this.getWidth();
        int h = this.getHeight();
        if (!this.frame.isSelected() && !this.frame.isIcon()) {
            g.setColor(TrendyUtils.currentTheme().getInternalFrameTitlePaneColors()[0][0]);
            g.drawLine(8, 0, w - 9, 0);
            g.setColor(TrendyUtils.currentTheme().getInternalFrameTitlePaneColors()[0][1]);
            g.drawLine(10, 0, w - 11, 0);
            g.setColor(TrendyUtils.currentTheme().getInternalFrameTitlePaneColors()[0][2]);
            g.drawLine(6, 1, w - 7, 1);
            g.setColor(TrendyUtils.currentTheme().getInternalFrameTitlePaneColors()[0][3]);
            g.drawLine(7, 1, w - 8, 1);
            g.setColor(TrendyUtils.currentTheme().getInternalFrameTitlePaneColors()[0][4]);
            g.drawLine(8, 1, w - 9, 1);
            g.setColor(TrendyUtils.currentTheme().getInternalFrameTitlePaneColors()[0][5]);
            g.drawLine(5, 2, w - 6, 2);
            g.drawLine(4, 3, w - 5, 3);
            g.drawLine(3, 4, w - 4, 4);
            g.setColor(TrendyUtils.currentTheme().getInternalFrameTitlePaneColors()[0][6]);
            g.drawLine(1, 5, w - 2, 5);
            g.setColor(TrendyUtils.currentTheme().getInternalFrameTitlePaneColors()[0][7]);
            g.drawLine(2, 5, w - 3, 5);
            g.setColor(TrendyUtils.currentTheme().getInternalFrameTitlePaneColors()[0][8]);
            g.drawLine(1, 6, w - 2, 6);
            g.setColor(TrendyUtils.currentTheme().getInternalFrameTitlePaneColors()[0][9]);
            g.drawLine(2, 6, w - 3, 6);
            g.fillRect(1, 7, w - 2, h - 1);
            g.setColor(TrendyUtils.currentTheme().getInternalFrameTitlePaneColors()[0][10]);
            g.drawLine(2, 4, 4, 2);
            g.drawLine(w - 3, 4, w - 5, 2);
            g.setColor(TrendyUtils.currentTheme().getInternalFrameTitlePaneColors()[0][11]);
            g.drawLine(0, 7, 0, 7);
            g.drawLine(w - 1, 7, w - 1, 7);
            g.setColor(TrendyUtils.currentTheme().getInternalFrameTitlePaneColors()[0][12]);
            g.drawLine(0, 8, 0, 8);
            g.drawLine(w - 1, 8, w - 1, 8);
            g.setColor(TrendyUtils.currentTheme().getInternalFrameTitlePaneColors()[0][13]);
            g.drawLine(0, 9, 0, h - 1);
            g.drawLine(w - 1, 9, w - 1, h - 1);
        } else {
            g.setColor(TrendyUtils.currentTheme().getInternalFrameTitlePaneColors()[1][0]);
            g.drawLine(8, 0, w - 9, 0);
            g.setColor(TrendyUtils.currentTheme().getInternalFrameTitlePaneColors()[1][1]);
            g.drawLine(10, 0, w - 11, 0);
            g.setColor(TrendyUtils.currentTheme().getInternalFrameTitlePaneColors()[1][2]);
            g.drawLine(6, 1, w - 7, 1);
            g.setColor(TrendyUtils.currentTheme().getInternalFrameTitlePaneColors()[1][3]);
            g.drawLine(7, 1, w - 8, 1);
            g.setColor(TrendyUtils.currentTheme().getInternalFrameTitlePaneColors()[1][4]);
            g.drawLine(8, 1, w - 9, 1);
            g.setColor(TrendyUtils.currentTheme().getInternalFrameTitlePaneColors()[1][5]);
            g.drawLine(5, 2, w - 6, 2);
            g.setColor(TrendyUtils.currentTheme().getInternalFrameTitlePaneColors()[1][6]);
            g.drawLine(4, 3, w - 5, 3);
            g.setColor(TrendyUtils.currentTheme().getInternalFrameTitlePaneColors()[1][7]);
            g.drawLine(3, 4, w - 4, 4);
            g.setColor(TrendyUtils.currentTheme().getInternalFrameTitlePaneColors()[1][8]);
            g.drawLine(1, 5, w - 2, 5);
            g.setColor(TrendyUtils.currentTheme().getInternalFrameTitlePaneColors()[1][9]);
            g.drawLine(2, 5, w - 3, 5);
            g.setColor(TrendyUtils.currentTheme().getInternalFrameTitlePaneColors()[1][10]);
            g.drawLine(1, 6, w - 2, 6);
            g.setColor(TrendyUtils.currentTheme().getInternalFrameTitlePaneColors()[1][11]);
            g.drawLine(2, 6, w - 3, 6);
            g.setColor(TrendyUtils.currentTheme().getInternalFrameTitlePaneColors()[1][12]);
            g.drawLine(1, 7, w - 2, 7);
            g.setColor(TrendyUtils.currentTheme().getInternalFrameTitlePaneColors()[1][13]);
            g.drawLine(1, 8, w - 2, 8);
            g.setColor(TrendyUtils.currentTheme().getInternalFrameTitlePaneColors()[1][14]);
            g.drawLine(1, 9, w - 2, 9);
            g.setColor(TrendyUtils.currentTheme().getInternalFrameTitlePaneColors()[1][15]);
            g.drawLine(1, 10, w - 2, 10);
            g.setColor(TrendyUtils.currentTheme().getInternalFrameTitlePaneColors()[1][16]);
            g.drawLine(1, 11, w - 2, 11);
            g.setColor(TrendyUtils.currentTheme().getInternalFrameTitlePaneColors()[1][17]);
            g.drawLine(1, 12, w - 2, 12);
            g.fillRect(1, 12, w - 2, h - 20);
            g.setColor(TrendyUtils.currentTheme().getInternalFrameTitlePaneColors()[1][18]);
            g.drawLine(1, h - 11, w - 2, h - 11);
            g.setColor(TrendyUtils.currentTheme().getInternalFrameTitlePaneColors()[1][19]);
            g.drawLine(1, h - 10, w - 2, h - 10);
            g.setColor(TrendyUtils.currentTheme().getInternalFrameTitlePaneColors()[1][20]);
            g.drawLine(1, h - 9, w - 2, h - 9);
            g.setColor(TrendyUtils.currentTheme().getInternalFrameTitlePaneColors()[1][21]);
            g.drawLine(1, h - 8, w - 2, h - 8);
            g.setColor(TrendyUtils.currentTheme().getInternalFrameTitlePaneColors()[1][22]);
            g.drawLine(1, h - 7, w - 2, h - 7);
            g.setColor(TrendyUtils.currentTheme().getInternalFrameTitlePaneColors()[1][23]);
            g.drawLine(1, h - 6, w - 2, h - 6);
            g.setColor(TrendyUtils.currentTheme().getInternalFrameTitlePaneColors()[1][24]);
            g.drawLine(1, h - 5, w - 2, h - 5);
            g.setColor(TrendyUtils.currentTheme().getInternalFrameTitlePaneColors()[1][25]);
            g.drawLine(1, h - 4, w - 2, h - 4);
            g.setColor(TrendyUtils.currentTheme().getInternalFrameTitlePaneColors()[1][26]);
            g.drawLine(1, h - 3, w - 2, h - 3);
            g.setColor(TrendyUtils.currentTheme().getInternalFrameTitlePaneColors()[1][27]);
            g.drawLine(1, h - 2, w - 2, h - 2);
            g.setColor(TrendyUtils.currentTheme().getInternalFrameTitlePaneColors()[1][28]);
            g.drawLine(1, h - 1, w - 2, h - 1);
            g.setColor(TrendyUtils.currentTheme().getInternalFrameTitlePaneColors()[1][29]);
            g.drawLine(2, 4, 4, 2);
            g.drawLine(w - 3, 4, w - 5, 2);
            g.setColor(TrendyUtils.currentTheme().getInternalFrameTitlePaneColors()[1][30]);
            g.drawLine(0, 7, 0, 7);
            g.drawLine(w - 1, 7, w - 1, 7);
            g.setColor(TrendyUtils.currentTheme().getInternalFrameTitlePaneColors()[1][31]);
            g.drawLine(0, 8, 0, 8);
            g.drawLine(w - 1, 8, w - 1, 8);
            g.setColor(TrendyUtils.currentTheme().getInternalFrameTitlePaneColors()[1][32]);
            g.drawLine(0, 9, 0, h - 1);
            g.drawLine(w - 1, 9, w - 1, h - 1);
        }
        if (antialiased) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        }
    }

    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        d.height = Math.max(25, d.height);
        return d;
    }

    public Dimension getMinimumSize() {
        Dimension d = super.getMinimumSize();
        d.height = Math.max(25, d.height);
        return d;
    }

    protected void createButtons() {
        super.createButtons();
        this.iconButton.setContentAreaFilled(false);
        this.maxButton.setContentAreaFilled(false);
        this.closeButton.setContentAreaFilled(false);
        this.iconButton.setRolloverEnabled(true);
        this.maxButton.setRolloverEnabled(true);
        this.closeButton.setRolloverEnabled(true);
        this.setButtonIcons();
    }

    protected void setButtonIcons() {
        super.setButtonIcons();
        if (this.frame.isIcon()) {
            this.iconButton.setIcon(this.minIcon);
            this.iconButton.setRolloverIcon(this.rolloverMinimizeIcon);
            this.maxButton.setIcon(this.maxIcon);
            this.maxButton.setRolloverIcon(this.rolloverMaximumIcon);
        } else if (this.frame.isMaximum()) {
            this.iconButton.setIcon(this.iconIcon);
            this.iconButton.setRolloverIcon(this.rolloverIconifyIcon);
            this.maxButton.setIcon(this.minIcon);
            this.maxButton.setRolloverIcon(this.rolloverMinimizeIcon);
        } else {
            this.iconButton.setIcon(this.iconIcon);
            this.iconButton.setRolloverIcon(this.rolloverIconifyIcon);
            this.maxButton.setIcon(this.maxIcon);
            this.maxButton.setRolloverIcon(this.rolloverMaximumIcon);
        }
        this.closeButton.setIcon(this.closeIcon);
        this.closeButton.setRolloverIcon(this.rolloverCloseIcon);
    }

    protected LayoutManager createLayout() {
        return new TrendyTitlePaneLayout();
    }

    public class TrendyTitlePaneLayout
    extends BasicInternalFrameTitlePane.TitlePaneLayout {
        public TrendyTitlePaneLayout() {
            super(TrendyInternalFrameTitlePane.this);
        }

        public void addLayoutComponent(String name, Component c) {
        }

        public void removeLayoutComponent(Component c) {
        }

        public Dimension preferredLayoutSize(Container c) {
            return this.minimumLayoutSize(c);
        }

        public void layoutContainer(Container c) {
            int x;
            boolean leftToRight = true;
            int w = TrendyInternalFrameTitlePane.this.getWidth();
            int h = TrendyInternalFrameTitlePane.this.getHeight();
            int buttonHeight = TrendyInternalFrameTitlePane.this.closeButton.getIcon().getIconHeight();
            Icon icon = TrendyInternalFrameTitlePane.this.frame.getFrameIcon();
            int iconHeight = 0;
            if (icon != null) {
                iconHeight = icon.getIconHeight();
            }
            int n = x = leftToRight ? 8 : w - 16 - 2 - 6;
            if (TrendyInternalFrameTitlePane.this.menuBar != null) {
                TrendyInternalFrameTitlePane.this.menuBar.setBounds(x, (h - iconHeight) / 2, 16, 16);
            }
            int n2 = x = leftToRight ? w - 16 - 2 - 6 : 8;
            if (TrendyInternalFrameTitlePane.this.frame.isClosable()) {
                TrendyInternalFrameTitlePane.this.closeButton.setBounds(x, (h - buttonHeight) / 2, 16, 14);
                x += leftToRight ? -18 : 18;
            }
            if (TrendyInternalFrameTitlePane.this.frame.isMaximizable()) {
                TrendyInternalFrameTitlePane.this.maxButton.setBounds(x, (h - buttonHeight) / 2, 16, 14);
                x += leftToRight ? -18 : 18;
            }
            if (TrendyInternalFrameTitlePane.this.frame.isIconifiable()) {
                TrendyInternalFrameTitlePane.this.iconButton.setBounds(x, (h - buttonHeight) / 2, 16, 14);
            }
        }
    }
}

