/*
 * Decompiled with CFR 0.152.
 */
package com.Trendy.swing.plaf;

import com.Trendy.swing.plaf.TrendyCashedPainter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.io.Serializable;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;

public class TrendyIconFactory {
    private static Icon listViewIcon;
    private static Icon sliderThumbTick;
    private static Icon sliderThumbFree;
    private static Icon radioButtonIcon;
    private static Icon checkBoxIcon;
    private static Icon checkBoxMenuItemIcon;
    private static Icon expandedTreeIcon;
    private static Icon radioButtonMenuItemIcon;
    private static final Dimension menuCheckIconSize;
    private static final Dimension listViewIconSize;

    public static Icon getListViewIcon() {
        if (listViewIcon == null) {
            listViewIcon = new ListViewIcon();
        }
        return listViewIcon;
    }

    public static Icon getSliderThumbTick() {
        if (sliderThumbTick == null) {
            sliderThumbTick = new SliderThumbTick();
        }
        return sliderThumbTick;
    }

    public static Icon getRadioButtonIcon() {
        if (radioButtonIcon == null) {
            radioButtonIcon = new RadioButtonIcon();
        }
        return radioButtonIcon;
    }

    public static Icon getCheckBoxMenuItemIcon() {
        if (checkBoxMenuItemIcon == null) {
            checkBoxMenuItemIcon = new CheckBoxMenuItemIcon();
        }
        return checkBoxMenuItemIcon;
    }

    public static Icon getChechBoxIcon() {
        if (checkBoxIcon == null) {
            checkBoxIcon = new CheckBoxIcon();
        }
        return checkBoxIcon;
    }

    public static Icon getRadioButtonMenuItemIcon() {
        if (radioButtonMenuItemIcon == null) {
            radioButtonMenuItemIcon = new RadioButtonMenuItemIcon();
        }
        return radioButtonMenuItemIcon;
    }

    static Icon getExpandedTreeIcon() {
        if (expandedTreeIcon == null) {
            expandedTreeIcon = new ExpandedTreeIcon();
        }
        return expandedTreeIcon;
    }

    static {
        menuCheckIconSize = new Dimension(10, 10);
        listViewIconSize = new Dimension(14, 10);
    }

    private static class SliderThumbTick
    implements Icon,
    Serializable {
        protected static final int SIZE = 9;
        protected static final int HALF_SIZE = 4;

        private SliderThumbTick() {
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.translate(x, y);
            g.setColor(new ColorUIResource(174, 196, 238));
            g.drawLine(9, 1, 14, 6);
            g.drawLine(6, 1, 1, 6);
            g.setColor(new ColorUIResource(224, 231, 246));
            g.drawLine(10, 1, 15, 6);
            g.drawLine(5, 1, 0, 6);
            g.setColor(new ColorUIResource(145, 180, 242));
            g.drawLine(1, 7, 1, 14);
            g.drawLine(14, 7, 14, 14);
            g.setColor(new ColorUIResource(180, 200, 235));
            g.drawLine(0, 7, 0, 13);
            g.drawLine(15, 7, 15, 13);
            g.setColor(new ColorUIResource(225, 232, 245));
            g.drawLine(0, 14, 1, 15);
            g.drawLine(14, 15, 15, 14);
            g.setColor(new ColorUIResource(220, 230, 250));
            g.drawLine(7, 0, 8, 0);
            g.setColor(new ColorUIResource(175, 195, 238));
            g.drawLine(7, 1, 8, 1);
            g.setColor(new ColorUIResource(254, 255, 255));
            g.drawLine(6, 2, 9, 2);
            g.setColor(new ColorUIResource(242, 247, 255));
            g.drawLine(5, 3, 10, 3);
            g.setColor(new ColorUIResource(228, 238, 255));
            g.drawLine(4, 4, 11, 4);
            g.setColor(new ColorUIResource(215, 230, 254));
            g.drawLine(3, 5, 12, 5);
            g.setColor(new ColorUIResource(200, 220, 254));
            g.drawLine(2, 6, 13, 6);
            g.setColor(new ColorUIResource(186, 212, 254));
            g.drawLine(2, 7, 13, 7);
            g.setColor(new ColorUIResource(172, 203, 253));
            g.drawLine(2, 8, 13, 8);
            g.setColor(new ColorUIResource(158, 195, 253));
            g.drawLine(2, 9, 13, 9);
            g.setColor(new ColorUIResource(148, 188, 253));
            g.drawLine(2, 10, 13, 10);
            g.setColor(new ColorUIResource(161, 196, 253));
            g.drawLine(2, 11, 13, 11);
            g.setColor(new ColorUIResource(174, 205, 254));
            g.drawLine(2, 12, 13, 12);
            g.setColor(new ColorUIResource(188, 213, 254));
            g.drawLine(2, 13, 13, 13);
            g.setColor(new ColorUIResource(208, 223, 249));
            g.drawLine(2, 14, 13, 14);
            g.setColor(new ColorUIResource(180, 200, 234));
            g.drawLine(2, 15, 13, 15);
            g.translate(-x, -y);
        }

        public int getIconWidth() {
            return 9;
        }

        public int getIconHeight() {
            return 9;
        }
    }

    private static class ExpandedTreeIcon
    implements Icon,
    Serializable {
        protected static final int SIZE = 9;
        protected static final int HALF_SIZE = 4;

        public void paintIcon(Component c, Graphics g, int x, int y) {
            Color backgroundColor = c.getBackground();
            g.setColor(backgroundColor == null ? Color.white : backgroundColor);
            g.fillRect(x, y, 8, 8);
            g.setColor(Color.red);
            g.drawRect(x, y, 8, 8);
            g.setColor(Color.black);
            g.drawLine(x + 2, y + 4, x + 6, y + 4);
        }

        public int getIconWidth() {
            return 9;
        }

        public int getIconHeight() {
            return 9;
        }

        private ExpandedTreeIcon() {
        }
    }

    private static class RadioButtonMenuItemIcon
    implements Icon,
    UIResource,
    Serializable {
        private RadioButtonMenuItemIcon() {
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            JMenuItem b = (JMenuItem)c;
            ButtonModel model = b.getModel();
            boolean isSelected = model.isSelected();
            boolean isEnabled = model.isEnabled();
            boolean isPressed = model.isPressed();
            boolean isArmed = model.isArmed();
            g.translate(x, y);
            if (isEnabled) {
                if (isPressed || isArmed) {
                    RadioButtonMenuItemIcon.drawCircles(g, new ColorUIResource(250, 250, 250), new ColorUIResource(162, 188, 241), new ColorUIResource(206, 220, 245));
                } else {
                    RadioButtonMenuItemIcon.drawCircles(g, new ColorUIResource(150, 150, 150), new ColorUIResource(230, 230, 230), new ColorUIResource(190, 190, 190));
                }
            } else {
                RadioButtonMenuItemIcon.drawCircles(g, new ColorUIResource(160, 160, 160), new ColorUIResource(210, 210, 210), new ColorUIResource(190, 190, 190));
            }
            if (isSelected) {
                Color c2;
                ColorUIResource c1;
                if (isEnabled) {
                    if (model.isArmed() || c instanceof JMenu && model.isSelected()) {
                        c1 = new ColorUIResource(162, 188, 241);
                        c2 = Color.white;
                    } else {
                        c1 = new ColorUIResource(200, 200, 200);
                        c2 = new ColorUIResource(120, 120, 120);
                    }
                } else {
                    c1 = new ColorUIResource(200, 200, 200);
                    c2 = new ColorUIResource(150, 150, 150);
                }
                g.setColor(c1);
                g.drawLine(5, 3, 5, 7);
                g.drawLine(3, 5, 7, 5);
                g.setColor(c2);
                g.fillRect(4, 4, 3, 3);
            }
            g.translate(-x, -y);
        }

        static void drawCircles(Graphics g, Color c1, Color c2, Color c3) {
            g.setColor(c1);
            g.drawLine(3, 1, 7, 1);
            g.drawLine(9, 3, 9, 7);
            g.drawLine(3, 9, 7, 9);
            g.drawLine(1, 3, 1, 7);
            g.drawLine(2, 2, 2, 2);
            g.drawLine(8, 2, 8, 2);
            g.drawLine(8, 8, 8, 8);
            g.drawLine(2, 8, 2, 8);
            g.setColor(c2);
            g.drawLine(1, 2, 2, 1);
            g.drawLine(4, 0, 6, 0);
            g.drawLine(8, 1, 9, 2);
            g.drawLine(10, 4, 10, 6);
            g.drawLine(9, 8, 8, 9);
            g.drawLine(4, 10, 6, 10);
            g.drawLine(1, 8, 2, 9);
            g.drawLine(0, 4, 0, 6);
            g.setColor(c3);
            g.drawLine(5, 1, 5, 1);
            g.drawLine(5, 9, 5, 9);
            g.drawLine(1, 5, 1, 5);
            g.drawLine(9, 5, 9, 5);
        }

        public int getIconWidth() {
            return menuCheckIconSize.width;
        }

        public int getIconHeight() {
            return menuCheckIconSize.height;
        }
    }

    private static class CheckBoxIcon
    implements Icon,
    UIResource,
    Serializable {
        private CheckBoxIcon() {
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.translate(x, y);
            TrendyCashedPainter.drawCheckBoxIcon(c, g);
            g.translate(-x, -y);
        }

        public int getIconWidth() {
            return 16;
        }

        public int getIconHeight() {
            return 16;
        }
    }

    private static class ListViewIcon
    implements Icon,
    UIResource,
    Serializable {
        private ListViewIcon() {
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.setColor(Color.red);
            g.fillRect(0, 0, 14, 10);
            g.setColor(new ColorUIResource(225, 235, 245));
            g.fillRect(0, 0, 5, 4);
            g.setColor(new ColorUIResource(160, 210, 250));
            g.fillRect(1, 0, 3, 4);
            g.fillRect(0, 1, 5, 2);
            g.setColor(new ColorUIResource(70, 170, 255));
            g.fillRect(1, 1, 3, 2);
            g.translate(8, 0);
            g.setColor(new ColorUIResource(225, 235, 245));
            g.fillRect(0, 0, 5, 4);
            g.setColor(new ColorUIResource(160, 210, 250));
            g.fillRect(1, 0, 3, 4);
            g.fillRect(0, 1, 5, 2);
            g.setColor(new ColorUIResource(70, 170, 255));
            g.fillRect(1, 1, 3, 2);
            g.translate(-8, 0);
            g.translate(0, 6);
            g.setColor(new ColorUIResource(225, 235, 245));
            g.fillRect(0, 0, 5, 4);
            g.setColor(new ColorUIResource(160, 210, 250));
            g.fillRect(1, 0, 3, 4);
            g.fillRect(0, 1, 5, 2);
            g.setColor(new ColorUIResource(70, 170, 255));
            g.fillRect(1, 1, 3, 2);
            g.translate(8, 0);
            g.setColor(new ColorUIResource(225, 235, 245));
            g.fillRect(0, 0, 5, 4);
            g.setColor(new ColorUIResource(160, 210, 250));
            g.fillRect(1, 0, 3, 4);
            g.fillRect(0, 1, 5, 2);
            g.setColor(new ColorUIResource(70, 170, 255));
            g.fillRect(1, 1, 3, 2);
            g.translate(-8, -6);
        }

        public int getIconWidth() {
            return listViewIconSize.width;
        }

        public int getIconHeight() {
            return listViewIconSize.height;
        }
    }

    private static class CheckBoxMenuItemIcon
    implements Icon,
    UIResource,
    Serializable {
        private CheckBoxMenuItemIcon() {
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            JMenuItem b = (JMenuItem)c;
            ButtonModel model = b.getModel();
            boolean isSelected = model.isSelected();
            boolean isEnabled = model.isEnabled();
            boolean isPressed = model.isPressed();
            boolean isArmed = model.isArmed();
            g.translate(x, y);
            if (isSelected) {
                if (isEnabled) {
                    if (model.isArmed() || c instanceof JMenu && model.isSelected()) {
                        g.setColor(new Color(255, 255, 255, 150));
                        g.drawLine(4, 6, 4, 9);
                        g.setColor(new Color(255, 255, 255, 120));
                        g.drawLine(9, 1, 9, 1);
                        g.setColor(new Color(255, 255, 255, 160));
                        g.drawLine(9, 3, 9, 3);
                        g.setColor(new Color(255, 255, 255, 200));
                        g.drawLine(9, 2, 5, 6);
                        g.setColor(new Color(255, 255, 255, 190));
                        g.drawLine(8, 4, 6, 6);
                        g.setColor(new Color(255, 255, 255, 205));
                        g.drawLine(7, 6, 6, 7);
                        g.setColor(new Color(255, 255, 255, 150));
                        g.drawLine(8, 5, 8, 5);
                        g.setColor(new Color(255, 255, 255, 255));
                        g.drawLine(2, 7, 5, 7);
                        g.setColor(new Color(255, 255, 255, 230));
                        g.drawLine(3, 8, 5, 8);
                        g.setColor(new Color(255, 255, 255, 200));
                        g.fillRect(1, 5, 2, 2);
                        g.setColor(new Color(255, 255, 255, 150));
                        g.fillRect(1, 4, 1, 1);
                        g.setColor(new Color(255, 255, 255, 245));
                        g.drawLine(2, 6, 2, 7);
                        g.setColor(new Color(255, 255, 255, 230));
                        g.drawLine(3, 6, 3, 6);
                    } else {
                        g.setColor(new ColorUIResource(176, 176, 176));
                        g.drawLine(4, 6, 4, 9);
                        g.setColor(new ColorUIResource(212, 212, 212));
                        g.drawLine(9, 1, 6, 4);
                        g.setColor(new ColorUIResource(200, 200, 200));
                        g.drawLine(9, 3, 9, 3);
                        g.setColor(new ColorUIResource(150, 150, 150));
                        g.drawLine(9, 2, 5, 6);
                        g.setColor(new ColorUIResource(130, 130, 130));
                        g.drawLine(8, 4, 6, 6);
                        g.setColor(new ColorUIResource(150, 150, 150));
                        g.drawLine(7, 6, 6, 7);
                        g.setColor(new ColorUIResource(195, 195, 195));
                        g.drawLine(8, 5, 8, 5);
                        g.setColor(new ColorUIResource(110, 110, 110));
                        g.drawLine(2, 7, 5, 7);
                        g.setColor(new ColorUIResource(145, 145, 145));
                        g.drawLine(3, 8, 5, 8);
                        g.setColor(new ColorUIResource(150, 150, 150));
                        g.fillRect(1, 5, 2, 2);
                        g.setColor(new ColorUIResource(180, 180, 180));
                        g.fillRect(1, 4, 1, 1);
                        g.setColor(new ColorUIResource(125, 125, 125));
                        g.drawLine(2, 6, 2, 7);
                        g.setColor(new ColorUIResource(150, 150, 150));
                        g.drawLine(3, 6, 3, 6);
                    }
                } else {
                    g.setColor(new ColorUIResource(216, 216, 216));
                    g.drawLine(4, 6, 4, 9);
                    g.setColor(new ColorUIResource(232, 232, 232));
                    g.drawLine(9, 1, 6, 4);
                    g.setColor(new ColorUIResource(210, 210, 210));
                    g.drawLine(9, 3, 9, 3);
                    g.setColor(new ColorUIResource(180, 180, 180));
                    g.drawLine(9, 2, 5, 6);
                    g.setColor(new ColorUIResource(170, 170, 170));
                    g.drawLine(8, 4, 6, 6);
                    g.setColor(new ColorUIResource(190, 190, 190));
                    g.drawLine(7, 6, 6, 7);
                    g.setColor(new ColorUIResource(220, 220, 220));
                    g.drawLine(8, 5, 8, 5);
                    g.setColor(new ColorUIResource(170, 170, 170));
                    g.drawLine(2, 7, 5, 7);
                    g.setColor(new ColorUIResource(185, 185, 185));
                    g.drawLine(3, 8, 5, 8);
                    g.setColor(new ColorUIResource(190, 190, 190));
                    g.fillRect(1, 5, 2, 2);
                    g.setColor(new ColorUIResource(220, 220, 220));
                    g.fillRect(1, 4, 1, 1);
                    g.setColor(new ColorUIResource(175, 175, 175));
                    g.drawLine(2, 6, 2, 7);
                    g.setColor(new ColorUIResource(190, 190, 190));
                    g.drawLine(3, 6, 3, 6);
                }
            }
            g.translate(-x, -y);
        }

        public int getIconWidth() {
            return menuCheckIconSize.width;
        }

        public int getIconHeight() {
            return menuCheckIconSize.height;
        }
    }

    private static class RadioButtonIcon
    implements Icon,
    UIResource,
    Serializable {
        private RadioButtonIcon() {
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.translate(x, y);
            TrendyCashedPainter.drawRadioButton(c, g);
            g.translate(-x, -y);
        }

        public int getIconWidth() {
            return 16;
        }

        public int getIconHeight() {
            return 16;
        }
    }
}

