/*
 * Decompiled with CFR 0.152.
 */
package com.Trendy.swing.plaf;

import com.Trendy.swing.plaf.TrendyLookAndFeel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.text.JTextComponent;

public final class TrendyConfiguration {
    public static final boolean IS_OS_MAC = TrendyConfiguration.isOSMac();
    public static final String Component_RoundRect_Status = "TrendyRoundRectStatus";
    public static final Integer Component_RoundRect_Square = new Integer(-1);
    public static final Integer Component_RoundRect_Round = new Integer(1);
    public static final Integer Component_RoundRect_Auto = new Integer(0);
    public static final String Button_Border_Thin = "Button.TrendyThinBorderStatus";
    public static final String Slider_Focus_Painted = "Slider.TrendyFocusPaintedStatus";
    public static final String ANTIALIASED_MINIMUM_FONT = "TRENDY_ANTIALIASED_FONT_MINIMUM_SIZE";
    public static final Integer ANTIALIASED_FONT_MINIMUM_SIZE = new Integer(-1);
    public static final String TEXT_COMPONENT_CONTEXT_MENU = "Text_Context_Menu";
    public static final String FILECHOOSER_FAVOURITES = "TRENDY_FILECHOOSER_FAVOURITES";
    public static final String FILECHOOSER_DIVIDER_LOCATION = "TrendyFileChooserDividerLocation";
    public static final String FILECHOOSER_ALLOW_BROWSING = "TRENDY_FILECHOOSER_ALLOW_BROWSING";
    public static final String FILECHOOSER_VIEW = "TRENDY_FILECHOOSER_VIEW";
    public static final String FILECHOOSER_VIEW_THUMBNAIL = "Thumbnail";
    public static final String FILECHOOSER_VIEW_ICON = "Icon";
    public static final String FILECHOOSER_VIEW_LIST = "List";
    public static final String FILECHOOSER_VIEW_DETAILS = "Details";

    public static boolean isOSMac() {
        try {
            return System.getProperty("os.name").toLowerCase().startsWith("mac");
        }
        catch (SecurityException e) {
            return true;
        }
    }

    public static boolean isTextComponentOfferContextMenu(JTextComponent c) {
        Object obj = c.getClientProperty(TEXT_COMPONENT_CONTEXT_MENU);
        return obj != null && obj instanceof Boolean && (Boolean)obj != false;
    }

    public static boolean isSliderFocusPainted(JComponent c) {
        Object obj = c.getClientProperty(Slider_Focus_Painted);
        return obj != null && obj instanceof Boolean && (Boolean)obj != false;
    }

    public static boolean isRoundRectSmall(JComponent c, String prefix) {
        Object obj = UIManager.get(prefix + Component_RoundRect_Status);
        if (obj != null && obj instanceof Integer) {
            int res = (Integer)obj;
            if (res == 1) {
                return false;
            }
            if (res == -1) {
                return true;
            }
        }
        if (c.getClientProperty(Component_RoundRect_Status) != null) {
            if (c.getClientProperty(Component_RoundRect_Status).equals(Component_RoundRect_Square)) {
                return true;
            }
            if (c.getClientProperty(Component_RoundRect_Status).equals(Component_RoundRect_Round)) {
                return false;
            }
        }
        int diff = 0;
        if (c instanceof JComboBox) {
            diff = 2;
        }
        if (c.getHeight() <= 22 && c.getWidth() <= 22) {
            return true;
        }
        return c.getHeight() <= 18 + diff && c.getWidth() >= 22 || c.getHeight() >= 22 && c.getWidth() <= 18 + diff;
    }

    public static boolean isThinBorder(JComponent c) {
        if (c.getClientProperty(Button_Border_Thin) != null) {
            return (Boolean)c.getClientProperty(Button_Border_Thin);
        }
        return false;
    }

    public static int getFavouritesDividerLocation(JFileChooser fc) {
        int dividerLocation = 100;
        try {
            dividerLocation = (Integer)fc.getClientProperty(FILECHOOSER_DIVIDER_LOCATION);
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        return dividerLocation;
    }

    public static boolean isFavouritesVisible(JFileChooser fc) {
        try {
            Object val = fc.getClientProperty(FILECHOOSER_FAVOURITES);
            if (val == null) {
                return false;
            }
            return (Boolean)val;
        }
        catch (Exception exp) {
            return false;
        }
    }

    public static boolean isFileChooserBrowsingAllowed(JFileChooser fc) {
        try {
            Object val = fc.getClientProperty(FILECHOOSER_ALLOW_BROWSING);
            if (val == null) {
                return true;
            }
            return (Boolean)val;
        }
        catch (Exception exp) {
            return true;
        }
    }

    public static boolean isFontAntialiased(JComponent c, int fontSize) {
        try {
            Object obj = c.getClientProperty(ANTIALIASED_MINIMUM_FONT);
            if (obj == null) {
                return false;
            }
            int ms = Integer.parseInt(obj.toString());
            if (ms == -1) {
                return false;
            }
            return ms <= fontSize;
        }
        catch (Exception exp) {
            return false;
        }
    }

    public static void updateCommonBackground(ColorUIResource c) {
        Object[] vals = new Object[]{"Button.background", c, "ToggleButton.background", c, "RadioButton.background", c, "CheckBox.background", c, "ComboBox.background", c, "Label.background", c, "Panel.background", c, "OptionPane.background", c, "ProgressBar.background", c, "Slider.background", c, "Spinner.background", c};
        TrendyLookAndFeel cfr_ignored_0 = (TrendyLookAndFeel)UIManager.getLookAndFeel();
        TrendyLookAndFeel.getCurrentTheme().setCommonBackground(c);
        TrendyConfiguration.updateLookAndFeel(vals);
    }

    public static void updateCommonBackground(ColorUIResource c, String[] components) {
        for (int i = 0; i < components.length; ++i) {
            String component = components[i];
            if (component.toLowerCase().equals("jbutton")) {
                TrendyConfiguration.updateLookAndFeel("Button.background", c);
                continue;
            }
            if (component.toLowerCase().equals("jtogglebutton")) {
                TrendyConfiguration.updateLookAndFeel("ToggleButton.background", c);
                continue;
            }
            if (component.toLowerCase().equals("jradiobutton")) {
                TrendyConfiguration.updateLookAndFeel("RadioButton.background", c);
                continue;
            }
            if (component.toLowerCase().equals("jcheckbox")) {
                TrendyConfiguration.updateLookAndFeel("CheckBox.background", c);
                continue;
            }
            if (component.toLowerCase().equals("jcombobox")) {
                TrendyConfiguration.updateLookAndFeel("ComboBox.background", c);
                continue;
            }
            if (component.toLowerCase().equals("jlabel")) {
                TrendyConfiguration.updateLookAndFeel("Label.background", c);
                continue;
            }
            if (component.toLowerCase().equals("jlist")) {
                TrendyConfiguration.updateLookAndFeel("List.background", c);
                continue;
            }
            if (component.toLowerCase().equals("jpanel")) {
                TrendyConfiguration.updateLookAndFeel("Panel.background", c);
                continue;
            }
            if (component.toLowerCase().equals("joptionpane")) {
                TrendyConfiguration.updateLookAndFeel("OptionPane.background", c);
                continue;
            }
            if (component.toLowerCase().equals("jprogressbar")) {
                TrendyConfiguration.updateLookAndFeel("ProgressBar.background", c);
                continue;
            }
            if (component.toLowerCase().equals("jslider")) {
                TrendyConfiguration.updateLookAndFeel("Slider.background", c);
                continue;
            }
            if (component.toLowerCase().equals("jspinner")) {
                TrendyConfiguration.updateLookAndFeel("Spinner.background", c);
                continue;
            }
            if (component.toLowerCase().equals("jtable")) {
                TrendyConfiguration.updateLookAndFeel("Table.background", c);
                continue;
            }
            if (component.toLowerCase().equals("jtextfield")) {
                TrendyConfiguration.updateLookAndFeel("textField.background", c);
                continue;
            }
            if (component.toLowerCase().equals("jformattedtextfield")) {
                TrendyConfiguration.updateLookAndFeel("FormattedTextField.background", c);
                continue;
            }
            if (component.toLowerCase().equals("jpasswordfield")) {
                TrendyConfiguration.updateLookAndFeel("PasswordField.background", c);
                continue;
            }
            if (component.toLowerCase().equals("jeditorpane")) {
                TrendyConfiguration.updateLookAndFeel("EditorPane.background", c);
                continue;
            }
            if (component.toLowerCase().equals("jtextpane")) {
                TrendyConfiguration.updateLookAndFeel("TextPane.background", c);
                continue;
            }
            if (component.toLowerCase().equals("jtextarea")) {
                TrendyConfiguration.updateLookAndFeel("TextArea.background", c);
                continue;
            }
            if (!component.toLowerCase().equals("jtree")) continue;
            TrendyConfiguration.updateLookAndFeel("Tree.background", c);
        }
    }

    public static void UpdateComponentsFont(FontUIResource font, String[] componentsArray) {
        for (int i = 0; i < componentsArray.length; ++i) {
            String component = componentsArray[i];
            if (component.toLowerCase().equals("jbutton")) {
                TrendyConfiguration.updateLookAndFeel("Button.font", font);
                continue;
            }
            if (component.toLowerCase().equals("jtogglebutton")) {
                TrendyConfiguration.updateLookAndFeel("ToggleButton.font", font);
                continue;
            }
            if (component.toLowerCase().equals("jradiobutton")) {
                TrendyConfiguration.updateLookAndFeel("RadioButton.font", font);
                continue;
            }
            if (component.toLowerCase().equals("jcheckbox")) {
                TrendyConfiguration.updateLookAndFeel("CheckBox.font", font);
                continue;
            }
            if (component.toLowerCase().equals("jcombobox")) {
                TrendyConfiguration.updateLookAndFeel("ComboBox.font", font);
                continue;
            }
            if (component.toLowerCase().equals("jinternalframe")) {
                TrendyConfiguration.updateLookAndFeel("InternalFrame.titleFont", font);
                continue;
            }
            if (component.toLowerCase().equals("jlabel")) {
                TrendyConfiguration.updateLookAndFeel("Label.font", font);
                continue;
            }
            if (component.toLowerCase().equals("jlist")) {
                TrendyConfiguration.updateLookAndFeel("List.font", font);
                continue;
            }
            if (component.toLowerCase().equals("jmenuitem")) {
                TrendyConfiguration.updateLookAndFeel("MenuItem.font", font);
                continue;
            }
            if (component.toLowerCase().equals("jradiobuttonmenuitem")) {
                TrendyConfiguration.updateLookAndFeel("RadioButtonMenuItem.font", font);
                continue;
            }
            if (component.toLowerCase().equals("jcheckboxmenuitem")) {
                TrendyConfiguration.updateLookAndFeel("CheckBoxMenuItem.font", font);
                continue;
            }
            if (component.toLowerCase().equals("jmenu")) {
                TrendyConfiguration.updateLookAndFeel("Menu.font", font);
                continue;
            }
            if (component.toLowerCase().equals("jslider")) {
                TrendyConfiguration.updateLookAndFeel("Slider.font", font);
                continue;
            }
            if (component.toLowerCase().equals("jtabbedpane")) {
                TrendyConfiguration.updateLookAndFeel("TabbedPane.font", font);
                continue;
            }
            if (component.toLowerCase().equals("jtable")) {
                TrendyConfiguration.updateLookAndFeel("Table.font", font);
                continue;
            }
            if (component.toLowerCase().equals("jtableheader")) {
                TrendyConfiguration.updateLookAndFeel("TableHeader.font", font);
                continue;
            }
            if (component.toLowerCase().equals("jtextfield")) {
                TrendyConfiguration.updateLookAndFeel("TextField.font", font);
                continue;
            }
            if (component.toLowerCase().equals("jformattedtextfield")) {
                TrendyConfiguration.updateLookAndFeel("FormattedTextField.font", font);
                continue;
            }
            if (component.toLowerCase().equals("jeditorpane")) {
                TrendyConfiguration.updateLookAndFeel("EditorPane.font", font);
                continue;
            }
            if (component.toLowerCase().equals("jtextpane")) {
                TrendyConfiguration.updateLookAndFeel("TextPane.font", font);
                continue;
            }
            if (component.toLowerCase().equals("jtextarea")) {
                TrendyConfiguration.updateLookAndFeel("TextArea.font", font);
                continue;
            }
            if (!component.toLowerCase().equals("jtree")) continue;
            TrendyConfiguration.updateLookAndFeel("Tree.font", font);
        }
    }

    public static void setGlobal_ANTIALIASED_MINIMUM_FONT(Integer fs) {
        Object[] vals = new Object[]{"Button.TRENDY_ANTIALIASED_FONT_MINIMUM_SIZE", fs, "ToggleButton.TRENDY_ANTIALIASED_FONT_MINIMUM_SIZE", fs, "RadioButton.TRENDY_ANTIALIASED_FONT_MINIMUM_SIZE", fs, "CheckBox.TRENDY_ANTIALIASED_FONT_MINIMUM_SIZE", fs, "ComboBox.TRENDY_ANTIALIASED_FONT_MINIMUM_SIZE", fs, "InternalFrame.TRENDY_ANTIALIASED_FONT_MINIMUM_SIZE", fs, "Label.TRENDY_ANTIALIASED_FONT_MINIMUM_SIZE", fs, "List.TRENDY_ANTIALIASED_FONT_MINIMUM_SIZE", fs, "MenuItem.TRENDY_ANTIALIASED_FONT_MINIMUM_SIZE", fs, "RadioButtonMenuItem.TRENDY_ANTIALIASED_FONT_MINIMUM_SIZE", fs, "CheckBoxMenuItem.TRENDY_ANTIALIASED_FONT_MINIMUM_SIZE", fs, "Menu.TRENDY_ANTIALIASED_FONT_MINIMUM_SIZE", fs, "Slider.TRENDY_ANTIALIASED_FONT_MINIMUM_SIZE", fs, "TabbedPane.TRENDY_ANTIALIASED_FONT_MINIMUM_SIZE", fs, "TableHeader.TRENDY_ANTIALIASED_FONT_MINIMUM_SIZE", fs, "TextField.TRENDY_ANTIALIASED_FONT_MINIMUM_SIZE", fs, "FormattedTextField.TRENDY_ANTIALIASED_FONT_MINIMUM_SIZE", fs, "PasswordField.TRENDY_ANTIALIASED_FONT_MINIMUM_SIZE", fs, "EditorPane.TRENDY_ANTIALIASED_FONT_MINIMUM_SIZE", fs, "TextPane.TRENDY_ANTIALIASED_FONT_MINIMUM_SIZE", fs, "TextArea.TRENDY_ANTIALIASED_FONT_MINIMUM_SIZE", fs};
        TrendyConfiguration.updateLookAndFeel(vals);
    }

    public static void setANTIALIASED_MINIMUM_FONT(Integer fs, String[] components) {
        for (int i = 0; i < components.length; ++i) {
            String component = components[i];
            if (component.toLowerCase().equals("jbutton")) {
                TrendyConfiguration.updateLookAndFeel("Button.TRENDY_ANTIALIASED_FONT_MINIMUM_SIZE", fs);
                continue;
            }
            if (component.toLowerCase().equals("jtogglebutton")) {
                TrendyConfiguration.updateLookAndFeel("ToggleButton.TRENDY_ANTIALIASED_FONT_MINIMUM_SIZE", fs);
                continue;
            }
            if (component.toLowerCase().equals("jradiobutton")) {
                TrendyConfiguration.updateLookAndFeel("RadioButton.TRENDY_ANTIALIASED_FONT_MINIMUM_SIZE", fs);
                continue;
            }
            if (component.toLowerCase().equals("jcheckbox")) {
                TrendyConfiguration.updateLookAndFeel("CheckBox.TRENDY_ANTIALIASED_FONT_MINIMUM_SIZE", fs);
                continue;
            }
            if (component.toLowerCase().equals("jcombobox")) {
                TrendyConfiguration.updateLookAndFeel("ComboBox.TRENDY_ANTIALIASED_FONT_MINIMUM_SIZE", fs);
                continue;
            }
            if (component.toLowerCase().equals("jinternalframe")) {
                TrendyConfiguration.updateLookAndFeel("InternalFrame.TRENDY_ANTIALIASED_FONT_MINIMUM_SIZE", fs);
                continue;
            }
            if (component.toLowerCase().equals("jlabel")) {
                TrendyConfiguration.updateLookAndFeel("Label.TRENDY_ANTIALIASED_FONT_MINIMUM_SIZE", fs);
                continue;
            }
            if (component.toLowerCase().equals("jlist")) {
                TrendyConfiguration.updateLookAndFeel("List.TRENDY_ANTIALIASED_FONT_MINIMUM_SIZE", fs);
                continue;
            }
            if (component.toLowerCase().equals("jmenuitem")) {
                TrendyConfiguration.updateLookAndFeel("MenuItem.TRENDY_ANTIALIASED_FONT_MINIMUM_SIZE", fs);
                continue;
            }
            if (component.toLowerCase().equals("jradiobuttonmenuitem")) {
                TrendyConfiguration.updateLookAndFeel("RadioButtonMenuItem.TRENDY_ANTIALIASED_FONT_MINIMUM_SIZE", fs);
                continue;
            }
            if (component.toLowerCase().equals("jcheckboxmenuitem")) {
                TrendyConfiguration.updateLookAndFeel("CheckBoxMenuItem.TRENDY_ANTIALIASED_FONT_MINIMUM_SIZE", fs);
                continue;
            }
            if (component.toLowerCase().equals("jmenu")) {
                TrendyConfiguration.updateLookAndFeel("Menu.TRENDY_ANTIALIASED_FONT_MINIMUM_SIZE", fs);
                continue;
            }
            if (component.toLowerCase().equals("jslider")) {
                TrendyConfiguration.updateLookAndFeel("Slider.TRENDY_ANTIALIASED_FONT_MINIMUM_SIZE", fs);
                continue;
            }
            if (component.toLowerCase().equals("jtabbedpane")) {
                TrendyConfiguration.updateLookAndFeel("TabbedPane.TRENDY_ANTIALIASED_FONT_MINIMUM_SIZE", fs);
                continue;
            }
            if (component.toLowerCase().equals("jtableheader")) {
                TrendyConfiguration.updateLookAndFeel("TabbedPane.TRENDY_ANTIALIASED_FONT_MINIMUM_SIZE", fs);
                continue;
            }
            if (component.toLowerCase().equals("jtextfield")) {
                TrendyConfiguration.updateLookAndFeel("TextField.TRENDY_ANTIALIASED_FONT_MINIMUM_SIZE", fs);
                continue;
            }
            if (component.toLowerCase().equals("jformattedtextfield")) {
                TrendyConfiguration.updateLookAndFeel("FormattedTextField.TRENDY_ANTIALIASED_FONT_MINIMUM_SIZE", fs);
                continue;
            }
            if (component.toLowerCase().equals("jpasswordfield")) {
                TrendyConfiguration.updateLookAndFeel("PasswordField.TRENDY_ANTIALIASED_FONT_MINIMUM_SIZE", fs);
                continue;
            }
            if (component.toLowerCase().equals("jeditorpane")) {
                TrendyConfiguration.updateLookAndFeel("EditorPane.TRENDY_ANTIALIASED_FONT_MINIMUM_SIZE", fs);
                continue;
            }
            if (component.toLowerCase().equals("jtextpane")) {
                TrendyConfiguration.updateLookAndFeel("TextPane.TRENDY_ANTIALIASED_FONT_MINIMUM_SIZE", fs);
                continue;
            }
            if (!component.toLowerCase().equals("jtextarea")) continue;
            TrendyConfiguration.updateLookAndFeel("TextArea.TRENDY_ANTIALIASED_FONT_MINIMUM_SIZE", fs);
        }
    }

    private static void updateLookAndFeel(Object key, Object val) {
        UIManager.getLookAndFeelDefaults().put(key, val);
    }

    private static void updateLookAndFeel(Object[] vals) {
        UIManager.getLookAndFeelDefaults().putDefaults(vals);
    }
}

