/*
 * Decompiled with CFR 0.152.
 */
package com.Trendy.swing.plaf;

import com.Trendy.swing.plaf.TrendyBorders;
import com.Trendy.swing.plaf.TrendyCashedPainter;
import com.Trendy.swing.plaf.TrendyComboboxEditor;
import com.Trendy.swing.plaf.TrendyConfiguration;
import com.Trendy.swing.plaf.TrendyListCellRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;

public class TrendyComboBoxUI
extends BasicComboBoxUI {
    private String TrendyPropertyPrefix = "ComboBox.";
    ComboBoxMouseListener comboBoxListener = new ComboBoxMouseListener();
    TrendyComboBoxPropertyListener comboBoxpropertychangelistener = new TrendyComboBoxPropertyListener();
    private boolean isDown = false;

    public static ComponentUI createUI(JComponent c) {
        return new TrendyComboBoxUI();
    }

    protected void installComponents() {
        this.arrowButton = this.createArrowButton();
        if (this.arrowButton != null) {
            this.comboBox.add(this.arrowButton);
        }
        if (this.comboBox.isEditable()) {
            this.addEditor();
        }
        this.comboBox.add(this.currentValuePane);
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        this.listBox.setCellRenderer(new TrendyListCellRenderer());
    }

    protected void installListeners() {
        super.installListeners();
        this.comboBox.addMouseListener(this.comboBoxListener);
        this.comboBox.addPropertyChangeListener(this.comboBoxpropertychangelistener);
    }

    protected void uninstallListeners() {
        this.comboBox.removeMouseListener(this.comboBoxListener);
        this.comboBox.removePropertyChangeListener(this.comboBoxpropertychangelistener);
        super.uninstallListeners();
    }

    public void installDefaults() {
        super.installDefaults();
        this.comboBox.putClientProperty("TRENDY_ANTIALIASED_FONT_MINIMUM_SIZE", UIManager.get("ComboBox.TRENDY_ANTIALIASED_FONT_MINIMUM_SIZE"));
    }

    public void paint(Graphics g, JComponent c) {
        ((TrendyComboboxEditor)this.comboBox.getEditor()).updateAntialiasedSetting(this.comboBox.getClientProperty("TRENDY_ANTIALIASED_FONT_MINIMUM_SIZE"));
        this.hasFocus = this.comboBox.hasFocus();
        if (TrendyConfiguration.isRoundRectSmall(c, this.TrendyPropertyPrefix) || c.getParent() instanceof JTable) {
            TrendyCashedPainter.drawComboBoxSquareSkin(c, g, this.isDown);
            TrendyCashedPainter.drawComboBoxBorder(c, g, this.isDown, false);
        } else {
            TrendyCashedPainter.drawComboBoxRoundSkin(c, g, this.isDown);
            TrendyCashedPainter.drawComboBoxBorder(c, g, this.isDown, true);
        }
        if (!this.comboBox.isEditable()) {
            Rectangle r = this.rectangleForCurrentValue();
            this.paintCurrentValue(g, r, this.hasFocus);
        }
    }

    public void paintCurrentValue(Graphics g, Rectangle bounds, boolean hasFocus) {
        Component c;
        ListCellRenderer<Object> renderer = this.comboBox.getRenderer();
        if (hasFocus && !this.isPopupVisible(this.comboBox)) {
            c = renderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, true, false);
        } else {
            c = renderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, false, false);
            c.setBackground(UIManager.getColor("ComboBox.background"));
        }
        c.setFont(this.comboBox.getFont());
        if (this.comboBox.isEnabled()) {
            c.setForeground(this.comboBox.getForeground());
            c.setBackground(this.comboBox.getBackground());
        } else {
            c.setForeground(UIManager.getColor("ComboBox.disabledForeground"));
            c.setBackground(UIManager.getColor("ComboBox.disabledBackground"));
        }
        boolean shouldValidate = false;
        if (c instanceof JPanel) {
            shouldValidate = true;
        }
        c.setBackground(new Color(255, 255, 255, 0));
        if (TrendyConfiguration.isFontAntialiased(this.comboBox, g.getFont().getSize())) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            this.currentValuePane.paintComponent(g2, c, this.comboBox, bounds.x, bounds.y, bounds.width, bounds.height, shouldValidate);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
            g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_DEFAULT);
        } else {
            this.currentValuePane.paintComponent(g, c, this.comboBox, bounds.x, bounds.y, bounds.width, bounds.height, shouldValidate);
        }
    }

    protected JButton createArrowButton() {
        return null;
    }

    protected ComboBoxEditor createEditor() {
        return new TrendyComboboxEditor.UIResource();
    }

    protected ComboPopup createPopup() {
        return new TrendyComboPopup(this.comboBox);
    }

    private JComboBox getComboBox() {
        return this.comboBox;
    }

    protected void synchronizeEditorStatus(boolean enabled) {
        if (this.comboBox.getEditor() instanceof TrendyComboboxEditor) {
            ((TrendyComboboxEditor)this.comboBox.getEditor()).setEnable(enabled);
        }
    }

    private void updateComponentsAntialiasedStatus() {
        if (this.comboBox.getEditor() instanceof TrendyComboboxEditor) {
            ((TrendyComboboxEditor)this.comboBox.getEditor()).putClientProperty("TRENDY_ANTIALIASED_FONT_MINIMUM_SIZE", this.comboBox.getClientProperty("TRENDY_ANTIALIASED_FONT_MINIMUM_SIZE"));
            this.listBox.putClientProperty("TRENDY_ANTIALIASED_FONT_MINIMUM_SIZE", this.comboBox.getClientProperty("TRENDY_ANTIALIASED_FONT_MINIMUM_SIZE"));
        }
    }

    protected Rectangle rectangleForCurrentValue() {
        int width = this.comboBox.getWidth();
        int height = this.comboBox.getHeight();
        return new Rectangle(5, 3, width - 25, height - 6);
    }

    public class TrendyComboPopup
    extends BasicComboPopup {
        public TrendyComboPopup(JComboBox cBox) {
            super(cBox);
        }

        protected void configureScroller() {
            this.scroller.setFocusable(false);
            this.scroller.getVerticalScrollBar().setFocusable(false);
            this.scroller.setBorder(null);
            this.scroller.setOpaque(false);
        }

        protected void configurePopup() {
            this.setLayout(new BoxLayout(this, 1));
            this.setBorderPainted(true);
            this.setBorder(TrendyBorders.getShadowedTopLevelPopupBorder());
            this.setOpaque(false);
            this.add(this.scroller);
            this.setDoubleBuffered(true);
            this.setFocusable(false);
        }

        protected JList createList() {
            return new JList(this.comboBox.getModel()){

                public void processMouseEvent(MouseEvent e) {
                    if (e.isControlDown()) {
                        e = new MouseEvent((Component)e.getSource(), e.getID(), e.getWhen(), e.getModifiers() ^ 2, e.getX(), e.getY(), e.getClickCount(), e.isPopupTrigger());
                    }
                    super.processMouseEvent(e);
                }
            };
        }

        protected void configureList() {
            super.configureList();
            this.list.setBackground(Color.white);
            this.list.putClientProperty("TRENDY_ANTIALIASED_FONT_MINIMUM_SIZE", UIManager.get("ComboBox.TRENDY_ANTIALIASED_FONT_MINIMUM_SIZE"));
        }

        public void delegateFocus(MouseEvent e) {
            super.delegateFocus(e);
        }

        public void show() {
            this.setListSelection(this.comboBox.getSelectedIndex());
            Point location = this.getPopupLocation();
            this.show(this.comboBox, location.x + 3, location.y - 2);
        }

        private void setListSelection(int selectedIndex) {
            if (selectedIndex == -1) {
                this.list.clearSelection();
            } else {
                this.list.setSelectedIndex(selectedIndex);
                this.list.ensureIndexIsVisible(selectedIndex);
            }
        }

        private Point getPopupLocation() {
            Dimension popupSize = new Dimension((int)this.comboBox.getSize().getWidth() - 6, (int)this.comboBox.getSize().getHeight());
            Insets insets = this.getInsets();
            popupSize.setSize(popupSize.width - (insets.right + insets.left), this.getPopupHeightForRowCount(this.comboBox.getMaximumRowCount()));
            Rectangle popupBounds = this.computePopupBounds(0, this.comboBox.getBounds().height, popupSize.width, popupSize.height);
            Dimension scrollSize = popupBounds.getSize();
            Point popupLocation = popupBounds.getLocation();
            this.scroller.setMaximumSize(scrollSize);
            this.scroller.setPreferredSize(scrollSize);
            this.scroller.setMinimumSize(scrollSize);
            this.list.revalidate();
            return popupLocation;
        }

        public void hide() {
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            MenuElement[] selection = manager.getSelectedPath();
            for (int i = 0; i < selection.length; ++i) {
                if (selection[i] != this) continue;
                manager.clearSelectedPath();
                break;
            }
            TrendyComboBoxUI.this.isDown = false;
            this.comboBox.repaint();
        }
    }

    class ComboBoxMouseListener
    extends MouseAdapter {
        ComboBoxMouseListener() {
        }

        public void mousePressed(MouseEvent e) {
            TrendyComboBoxUI.this.isDown = true;
            super.mousePressed(e);
            TrendyComboBoxUI.this.getComboBox().repaint();
        }

        public void mouseClicked(MouseEvent e) {
            super.mouseClicked(e);
            TrendyComboBoxUI.this.getComboBox().repaint();
        }

        public void mouseEntered(MouseEvent e) {
            super.mouseEntered(e);
            TrendyComboBoxUI.this.getComboBox().repaint();
        }

        public void mouseExited(MouseEvent e) {
            TrendyComboBoxUI.this.isDown = false;
            super.mouseExited(e);
            TrendyComboBoxUI.this.getComboBox().repaint();
        }

        public void mouseReleased(MouseEvent e) {
            TrendyComboBoxUI.this.isDown = false;
            super.mouseReleased(e);
            TrendyComboBoxUI.this.getComboBox().repaint();
        }
    }

    class ComboBoxFocusListener
    implements FocusListener {
        ComboBoxFocusListener() {
        }

        public void focusGained(FocusEvent e) {
            TrendyComboBoxUI.this.isDown = false;
            TrendyComboBoxUI.this.getComboBox().repaint();
        }

        public void focusLost(FocusEvent e) {
            TrendyComboBoxUI.this.isDown = false;
            TrendyComboBoxUI.this.getComboBox().repaint();
        }
    }

    class TrendyComboBoxPropertyListener
    implements PropertyChangeListener {
        TrendyComboBoxPropertyListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("enabled")) {
                TrendyComboBoxUI.this.synchronizeEditorStatus((Boolean)evt.getNewValue());
            } else if (evt.getPropertyName().equals("TRENDY_ANTIALIASED_FONT_MINIMUM_SIZE")) {
                TrendyComboBoxUI.this.updateComponentsAntialiasedStatus();
            }
        }
    }
}

