/*
 * Decompiled with CFR 0.152.
 */
package com.Trendy.swing.plaf;

import com.Trendy.swing.plaf.Themes.TrendyTheme;
import com.Trendy.swing.plaf.TrendyAbstractCachedPainter;
import com.Trendy.swing.plaf.TrendyConfiguration;
import com.Trendy.swing.plaf.TrendyUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.JToolBar;
import javax.swing.plaf.ColorUIResource;

public class TrendyCashedPainter {
    public static void clearMenuCache() {
        MenuItemFadingPainter.INSTANCE.clearCache();
        MenuSeparatorPainter.INSTANCE.clearCache();
        MenuBarBackgroundPainter.INSTANCE.clearCache();
        MenuBackgroundPainter.INSTANCE.clearCache();
    }

    public static void clearCashedImages() {
        ButtonRoundSkinPainter.INSTANCE.clearCache();
        ButtonSquareSkinPainter.INSTANCE.clearCache();
        ButtonBorderPainter.INSTANCE.clearCache();
        ComboBoxRoundSkinPainter.INSTANCE.clearCache();
        ComboBoxSquareSkinPainter.INSTANCE.clearCache();
        MenuItemFadingPainter.INSTANCE.clearCache();
        MenuSeparatorPainter.INSTANCE.clearCache();
        CheckboxPainter.INSTANCE.clearCache();
        RadioButtonPainter.INSTANCE.clearCache();
        InDeterminateProgressBarPainter.INSTANCE.clearCache();
        DeterminateProgressBarPainter.INSTANCE.clearCache();
        MenuBarBackgroundPainter.INSTANCE.clearCache();
        MenuBackgroundPainter.INSTANCE.clearCache();
    }

    private static TrendyTheme currentTheme() {
        return TrendyUtils.currentTheme();
    }

    public static boolean drawMenuBackground(Component c, Graphics g, int x, int y, int w, int h) {
        if (h < 0 || w < 0) {
            return true;
        }
        MenuBackgroundPainter.INSTANCE.paint(c, g, x, y, w, h);
        return true;
    }

    public static boolean drawMenuBarBackground(Component c, Graphics g, int x, int y, int w, int h) {
        if (h < 0 || w < 0) {
            return true;
        }
        MenuBarBackgroundPainter.INSTANCE.paint(c, g, x, y, w, h);
        return true;
    }

    public static boolean drawProgressBar(Component c, Graphics g, boolean vertical, boolean indeterminate, int x, int y, int w, int h) {
        if (h < 0 || w < 0) {
            return true;
        }
        if (!indeterminate) {
            DeterminateProgressBarPainter.INSTANCE.paint(c, g, x, y, w, h, new Object[]{new Boolean(vertical)});
        } else {
            InDeterminateProgressBarPainter.INSTANCE.paint(c, g, x, y, w, h, new Object[]{new Boolean(vertical)});
        }
        return true;
    }

    public static boolean drawRadioButton(Component c, Graphics g) {
        JRadioButton radioButton = (JRadioButton)c;
        ButtonModel bm = radioButton.getModel();
        int w = c.getWidth();
        int h = c.getHeight();
        if (h < 0 || w < 0) {
            return true;
        }
        RadioButtonPainter.INSTANCE.paint(c, g, c.getX(), c.getY(), w, h, new Object[]{new Boolean(bm.isSelected()), new Boolean(bm.isEnabled()), new Boolean(bm.isPressed() || bm.isSelected()), new Boolean(bm.isArmed()), new Boolean(bm.isRollover() && radioButton.isRolloverEnabled())});
        return true;
    }

    public static boolean drawMenuSeparator(Component c, Graphics g) {
        int w = c.getWidth();
        int h = c.getHeight();
        if (h < 0 || w < 0) {
            return true;
        }
        MenuSeparatorPainter.INSTANCE.paint(c, g, c.getX(), c.getY(), w, h);
        return true;
    }

    public static boolean drawCheckBoxIcon(Component c, Graphics g) {
        JCheckBox checkbox = (JCheckBox)c;
        ButtonModel bm = checkbox.getModel();
        int w = c.getWidth();
        int h = c.getHeight();
        if (h < 0 || w < 0) {
            return true;
        }
        CheckboxPainter.INSTANCE.paint(c, g, c.getX(), c.getY(), w, h, new Object[]{new Boolean(bm.isSelected()), new Boolean(bm.isEnabled()), new Boolean(bm.isPressed()), new Boolean(bm.isArmed()), new Boolean(bm.isRollover() && checkbox.isRolloverEnabled())});
        return true;
    }

    public static boolean drawMenuItemFading(Component c, Graphics g) {
        int w = c.getWidth();
        int h = c.getHeight();
        if (h < 0 || w < 0) {
            return true;
        }
        g.setColor(TrendyUtils.currentTheme().getMenuItemBackground());
        g.fillRect(0, 0, c.getWidth(), c.getHeight());
        if (!TrendyUtils.currentTheme().getMenuItemFadingColor().equals(TrendyUtils.currentTheme().getMenuItemBackground())) {
            MenuItemFadingPainter.INSTANCE.paint(c, g, c.getX(), c.getY(), w, h);
        }
        return true;
    }

    public static boolean drawComboBoxSquareSkin(Component c, Graphics g, boolean down) {
        int w = c.getWidth();
        int h = c.getHeight();
        if (w <= 0 || h <= 0) {
            return true;
        }
        JComboBox comboBox = (JComboBox)c;
        ComboBoxSquareSkinPainter.INSTANCE.paint(c, g, 0, 0, w, h, new Object[]{new Boolean(down), new Boolean(comboBox.isEnabled())});
        return true;
    }

    public static boolean drawComboBoxRoundSkin(Component c, Graphics g, boolean down) {
        int w = c.getWidth();
        int h = c.getHeight();
        if (w <= 0 || h <= 0) {
            return true;
        }
        JComboBox comboBox = (JComboBox)c;
        ComboBoxRoundSkinPainter.INSTANCE.paint(c, g, 0, 0, w, h, new Object[]{new Boolean(down), new Boolean(comboBox.isEnabled())});
        return true;
    }

    public static boolean drawComboBoxBorder(Component c, Graphics g, boolean down, boolean round) {
        int w = c.getWidth();
        int h = c.getHeight();
        if (w <= 0 || h <= 0) {
            return true;
        }
        JComboBox comboBox = (JComboBox)c;
        String type = "";
        type = comboBox.isEnabled() ? (comboBox.hasFocus() ? "ROLLOVER" : "NORMAL") : "DISABLE";
        ButtonBorderPainter.INSTANCE.paint(c, g, 0, 0, w, h, new Object[]{new Boolean(down), new Boolean(round), type});
        return true;
    }

    public static boolean drawButtonBorder(Component c, Graphics g, String prefix) {
        int w = c.getWidth();
        int h = c.getHeight();
        if (w <= 0 || h <= 0) {
            return true;
        }
        AbstractButton b = (AbstractButton)c;
        ButtonModel bm = ((AbstractButton)c).getModel();
        boolean down = false;
        boolean draw = false;
        boolean roundBorder = false;
        String type = "";
        if (b.isContentAreaFilled() && !(b.getParent() instanceof JToolBar)) {
            draw = true;
            boolean bl = down = bm.isArmed() && bm.isPressed() || bm.isSelected();
            if (!TrendyConfiguration.isRoundRectSmall(b, prefix)) {
                roundBorder = true;
            }
            type = bm.isEnabled() ? (bm.isRollover() && b.isRolloverEnabled() ? "ROLLOVER" : (b.hasFocus() && b.isFocusPainted() ? "FOCUS" : "NORMAL")) : "DISABLE";
        }
        if (draw) {
            ButtonBorderPainter.INSTANCE.paint(c, g, 0, 0, w, h, new Object[]{new Boolean(down), new Boolean(roundBorder), type});
        }
        return true;
    }

    public static boolean drawButtonSquareSkin(Component c, Graphics g) {
        int w = c.getWidth();
        int h = c.getHeight();
        if (w <= 0 || h <= 0) {
            return true;
        }
        ButtonModel bm = ((AbstractButton)c).getModel();
        ButtonSquareSkinPainter.INSTANCE.paint(c, g, 0, 0, w, h, new Object[]{new Boolean(bm.isEnabled()), new Boolean(bm.isPressed()), new Boolean(bm.isSelected())});
        return true;
    }

    public static boolean drawButtonRoundSkin(Component c, Graphics g) {
        int w = c.getWidth();
        int h = c.getHeight();
        if (w <= 0 || h <= 0) {
            return true;
        }
        ButtonModel bm = ((AbstractButton)c).getModel();
        ButtonRoundSkinPainter.INSTANCE.paint(c, g, 0, 0, w, h, new Object[]{new Boolean(bm.isEnabled()), new Boolean(bm.isPressed()), new Boolean(bm.isSelected())});
        return true;
    }

    private static class SamplePainter
    extends TrendyAbstractCachedPainter {
        public static final ButtonSquareSkinPainter INSTANCE = new ButtonSquareSkinPainter(7);
        int w;
        int h;

        SamplePainter(int count) {
            super(count);
        }

        public synchronized void paint(Component c, Graphics g, int x, int y, int w, int h) {
            this.w = w;
            this.h = h;
            this.paint(c, g, x, y, w, h, new Object[0]);
        }

        protected void paintToImage(Component c, Graphics g, int w, int h, Object[] args) {
        }

        protected void paintImage(Component c, Graphics g, int x, int y, int imageW, int imageH, Image image, Object[] args) {
            g.translate(x, y);
            g.drawImage(image, 0, 0, null);
            g.translate(-x, -y);
        }
    }

    private static class ButtonRoundSkinPainter
    extends TrendyAbstractCachedPainter {
        public static final ButtonRoundSkinPainter INSTANCE = new ButtonRoundSkinPainter(15);
        int w;
        int h;

        ButtonRoundSkinPainter(int count) {
            super(count);
        }

        public synchronized void paint(Component c, Graphics g, int x, int y, int w, int h) {
            this.w = w;
            this.h = h;
            this.paint(c, g, x, y, w, h, new Object[0]);
        }

        protected void paintToImage(Component c, Graphics g, int w, int h, Object[] args) {
            --h;
            ButtonModel buttonModel = ((AbstractButton)c).getModel();
            if (buttonModel.isEnabled()) {
                if (buttonModel.isArmed() && buttonModel.isPressed() || buttonModel.isSelected()) {
                    g.setColor(TrendyUtils.currentTheme().getButtonSkinColors()[0]);
                    g.drawLine(5, 1, w - 6, 1);
                    g.setColor(TrendyUtils.currentTheme().getButtonSkinColors()[1]);
                    g.drawLine(4, 2, w - 5, 2);
                    g.setColor(TrendyUtils.currentTheme().getButtonSkinColors()[2]);
                    g.drawLine(3, 3, w - 4, 3);
                    g.drawLine(2, 4, w - 3, 4);
                    g.drawLine(2, 5, w - 3, 5);
                    Graphics2D g2 = (Graphics2D)g;
                    g2.setPaint(new GradientPaint(0.0f, 0.0f, TrendyUtils.currentTheme().getButtonSkinColors()[3], 0.0f, h, TrendyUtils.currentTheme().getButtonSkinColors()[4]));
                    g.fillRect(1, 6, w - 2, h - 12);
                    g.setColor(TrendyUtils.currentTheme().getButtonSkinColors()[5]);
                    g.drawLine(2, h - 6, w - 3, h - 6);
                    g.drawLine(2, h - 5, w - 3, h - 5);
                    g.setColor(TrendyUtils.currentTheme().getButtonSkinColors()[6]);
                    g.drawLine(3, h - 4, w - 4, h - 4);
                    g.setColor(TrendyUtils.currentTheme().getButtonSkinColors()[7]);
                    g.drawLine(4, h - 3, w - 5, h - 3);
                    g.setColor(TrendyUtils.currentTheme().getButtonSkinColors()[8]);
                    g.drawLine(5, h - 2, w - 6, h - 2);
                } else {
                    g.setColor(Color.white);
                    g.drawLine(5, 1, w - 6, 1);
                    g.drawLine(4, 2, w - 5, 2);
                    g.setColor(TrendyUtils.currentTheme().getButtonSkinColors()[9]);
                    g.drawLine(3, 3, w - 4, 3);
                    g.setColor(TrendyUtils.currentTheme().getButtonSkinColors()[4]);
                    g.drawLine(2, 4, w - 3, 4);
                    g.setColor(TrendyUtils.currentTheme().getButtonSkinColors()[1]);
                    g.drawLine(2, 5, w - 3, 5);
                    g.setColor(TrendyUtils.currentTheme().getButtonSkinColors()[10]);
                    g.drawLine(1, 6, w - 2, 6);
                    g.setColor(TrendyUtils.currentTheme().getButtonSkinColors()[2]);
                    g.drawLine(1, 7, w - 2, 7);
                    g.setColor(TrendyUtils.currentTheme().getButtonSkinColors()[18]);
                    g.drawLine(1, 8, w - 2, 8);
                    g.setColor(TrendyUtils.currentTheme().getButtonSkinColors()[3]);
                    g.fillRect(1, 9, w - 2, h - 16);
                    g.setColor(TrendyUtils.currentTheme().getButtonSkinColors()[11]);
                    g.drawLine(1, h - 7, w - 2, h - 7);
                    g.setColor(TrendyUtils.currentTheme().getButtonSkinColors()[12]);
                    g.drawLine(2, h - 6, w - 3, h - 6);
                    g.setColor(TrendyUtils.currentTheme().getButtonSkinColors()[13]);
                    g.drawLine(2, h - 5, w - 3, h - 5);
                    g.setColor(TrendyUtils.currentTheme().getButtonSkinColors()[14]);
                    g.drawLine(3, h - 4, w - 4, h - 4);
                    g.setColor(TrendyUtils.currentTheme().getButtonSkinColors()[15]);
                    g.drawLine(4, h - 3, w - 5, h - 3);
                    g.setColor(TrendyUtils.currentTheme().getButtonSkinColors()[16]);
                    g.drawLine(5, h - 2, w - 6, h - 2);
                }
            } else {
                if (buttonModel.isSelected()) {
                    g.setColor(TrendyUtils.currentTheme().getButtonSkinColors()[11]);
                } else {
                    g.setColor(TrendyUtils.currentTheme().getButtonSkinColors()[17]);
                }
                g.drawLine(5, 1, w - 6, 1);
                g.drawLine(4, 2, w - 5, 2);
                g.drawLine(3, 3, w - 4, 3);
                g.drawLine(2, 4, w - 3, 4);
                g.drawLine(2, 5, w - 3, 5);
                g.drawLine(1, 6, w - 2, 6);
                g.drawLine(1, 7, w - 2, 7);
                g.fillRect(1, 8, w - 2, h - 14);
                g.drawLine(2, h - 6, w - 3, h - 6);
                g.drawLine(2, h - 5, w - 3, h - 5);
                g.drawLine(3, h - 4, w - 4, h - 4);
                g.drawLine(4, h - 3, w - 5, h - 3);
                g.drawLine(5, h - 2, w - 6, h - 2);
            }
        }

        protected void paintImage(Component c, Graphics g, int x, int y, int imageW, int imageH, Image image, Object[] args) {
            g.translate(x, y);
            g.drawImage(image, 0, 0, null);
            g.translate(-x, -y);
        }
    }

    private static class ButtonSquareSkinPainter
    extends TrendyAbstractCachedPainter {
        public static final ButtonSquareSkinPainter INSTANCE = new ButtonSquareSkinPainter(15);
        int w;
        int h;

        ButtonSquareSkinPainter(int count) {
            super(count);
        }

        public synchronized void paint(Component c, Graphics g, int x, int y, int w, int h) {
            this.w = w;
            this.h = h;
            this.paint(c, g, x, y, w, h, new Object[0]);
        }

        protected void paintToImage(Component c, Graphics g, int w, int h, Object[] args) {
            ButtonModel buttonModel = ((AbstractButton)c).getModel();
            if (buttonModel.isEnabled()) {
                if (buttonModel.isArmed() && buttonModel.isPressed() || buttonModel.isSelected()) {
                    g.setColor(TrendyCashedPainter.currentTheme().getButtonSkinColors()[0]);
                    g.drawLine(2, 1, w - 3, 1);
                    g.setColor(TrendyCashedPainter.currentTheme().getButtonSkinColors()[1]);
                    g.drawLine(1, 2, w - 2, 2);
                    g.setColor(TrendyCashedPainter.currentTheme().getButtonSkinColors()[2]);
                    g.drawLine(1, 3, w - 2, 3);
                    g.drawLine(1, 4, w - 2, 4);
                    g.drawLine(1, 5, w - 2, 5);
                    Graphics2D g2 = (Graphics2D)g;
                    g2.setPaint(new GradientPaint(0.0f, 0.0f, TrendyCashedPainter.currentTheme().getButtonSkinColors()[3], 0.0f, h, TrendyCashedPainter.currentTheme().getButtonSkinColors()[4]));
                    g.fillRect(1, 6, w - 2, h - 11);
                    g.setColor(TrendyCashedPainter.currentTheme().getButtonSkinColors()[5]);
                    g.drawLine(1, h - 5, w - 2, h - 5);
                    g.drawLine(1, h - 4, w - 2, h - 4);
                    g.setColor(TrendyCashedPainter.currentTheme().getButtonSkinColors()[6]);
                    g.drawLine(1, h - 3, w - 2, h - 3);
                    g.setColor(TrendyCashedPainter.currentTheme().getButtonSkinColors()[7]);
                    g.drawLine(1, h - 2, w - 2, h - 2);
                    g.setColor(TrendyCashedPainter.currentTheme().getButtonSkinColors()[8]);
                    g.drawLine(2, h - 1, w - 3, h - 1);
                } else {
                    g.setColor(Color.white);
                    g.drawLine(2, 1, w - 3, 1);
                    g.drawLine(1, 2, w - 2, 2);
                    g.setColor(TrendyCashedPainter.currentTheme().getButtonSkinColors()[9]);
                    g.drawLine(1, 3, w - 2, 3);
                    g.setColor(TrendyCashedPainter.currentTheme().getButtonSkinColors()[4]);
                    g.drawLine(1, 4, w - 2, 4);
                    g.setColor(TrendyCashedPainter.currentTheme().getButtonSkinColors()[1]);
                    g.drawLine(1, 5, w - 2, 5);
                    g.setColor(TrendyCashedPainter.currentTheme().getButtonSkinColors()[10]);
                    g.drawLine(1, 6, w - 2, 6);
                    g.setColor(TrendyCashedPainter.currentTheme().getButtonSkinColors()[2]);
                    g.drawLine(1, 7, w - 2, 7);
                    g.setColor(TrendyCashedPainter.currentTheme().getButtonSkinColors()[18]);
                    g.drawLine(1, 8, w - 2, 8);
                    g.setColor(TrendyCashedPainter.currentTheme().getButtonSkinColors()[3]);
                    g.fillRect(1, 9, w - 2, h - 15);
                    g.setColor(TrendyCashedPainter.currentTheme().getButtonSkinColors()[11]);
                    g.drawLine(1, h - 6, w - 2, h - 6);
                    g.setColor(TrendyCashedPainter.currentTheme().getButtonSkinColors()[12]);
                    g.drawLine(1, h - 5, w - 2, h - 5);
                    g.setColor(TrendyCashedPainter.currentTheme().getButtonSkinColors()[13]);
                    g.drawLine(1, h - 4, w - 2, h - 4);
                    g.setColor(TrendyCashedPainter.currentTheme().getButtonSkinColors()[14]);
                    g.drawLine(1, h - 3, w - 2, h - 3);
                    g.setColor(TrendyCashedPainter.currentTheme().getButtonSkinColors()[15]);
                    g.drawLine(1, h - 2, w - 2, h - 2);
                    g.setColor(TrendyCashedPainter.currentTheme().getButtonSkinColors()[16]);
                    g.drawLine(2, h - 1, w - 3, h - 1);
                }
            } else {
                if (buttonModel.isSelected()) {
                    g.setColor(TrendyCashedPainter.currentTheme().getButtonSkinColors()[11]);
                } else {
                    g.setColor(TrendyCashedPainter.currentTheme().getButtonSkinColors()[17]);
                }
                g.drawLine(2, 1, w - 3, 1);
                g.drawLine(1, 2, w - 2, 2);
                g.drawLine(1, 3, w - 2, 3);
                g.drawLine(1, 4, w - 2, 4);
                g.drawLine(1, 5, w - 2, 5);
                g.drawLine(1, 6, w - 2, 6);
                g.drawLine(1, 7, w - 2, 7);
                g.fillRect(1, 8, w - 2, h - 14);
                g.drawLine(1, h - 6, w - 2, h - 6);
                g.drawLine(1, h - 5, w - 2, h - 5);
                g.drawLine(1, h - 4, w - 2, h - 4);
                g.drawLine(1, h - 3, w - 2, h - 3);
                g.drawLine(1, h - 2, w - 2, h - 2);
                g.drawLine(2, h - 1, w - 3, h - 1);
            }
        }

        protected void paintImage(Component c, Graphics g, int x, int y, int imageW, int imageH, Image image, Object[] args) {
            g.translate(x, y);
            g.drawImage(image, 0, 0, null);
            g.translate(-x, -y);
        }
    }

    private static class ButtonBorderPainter
    extends TrendyAbstractCachedPainter {
        public static final ButtonBorderPainter INSTANCE = new ButtonBorderPainter(15);
        int w;
        int h;

        ButtonBorderPainter(int count) {
            super(count);
        }

        public synchronized void paint(Component c, Graphics g, int x, int y, int w, int h) {
            this.w = w;
            this.h = h;
            this.paint(c, g, x, y, w, h, new Object[0]);
        }

        protected void paintToImage(Component c, Graphics g, int w, int h, Object[] args) {
            boolean thinBorder = TrendyConfiguration.isThinBorder((JComponent)c);
            boolean down = new Boolean(args[0].toString());
            boolean roundBorder = new Boolean(args[1].toString());
            String type = args[2].toString();
            if (roundBorder) {
                ColorUIResource c1 = new ColorUIResource(0);
                ColorUIResource c2 = new ColorUIResource(0);
                ColorUIResource c3 = new ColorUIResource(0);
                ColorUIResource c4 = new ColorUIResource(0);
                ColorUIResource c5 = new ColorUIResource(0);
                ColorUIResource c6 = new ColorUIResource(0);
                ColorUIResource c7 = new ColorUIResource(0);
                ColorUIResource c11 = new ColorUIResource(0);
                ColorUIResource c12 = new ColorUIResource(0);
                if (type.equals("NORMAL")) {
                    c1 = TrendyCashedPainter.currentTheme().getButtonBorderColors()[0][0];
                    c2 = TrendyCashedPainter.currentTheme().getButtonBorderColors()[0][1];
                    c3 = TrendyCashedPainter.currentTheme().getButtonBorderColors()[0][2];
                    c4 = TrendyCashedPainter.currentTheme().getButtonBorderColors()[0][3];
                    c5 = TrendyCashedPainter.currentTheme().getButtonBorderColors()[0][4];
                    c6 = TrendyCashedPainter.currentTheme().getButtonBorderColors()[0][5];
                    c7 = TrendyCashedPainter.currentTheme().getButtonBorderColors()[0][6];
                    c11 = TrendyCashedPainter.currentTheme().getButtonBorderColors()[0][9];
                    c12 = TrendyCashedPainter.currentTheme().getButtonBorderColors()[0][10];
                } else if (type.equals("ROLLOVER")) {
                    c1 = TrendyCashedPainter.currentTheme().getButtonBorderColors()[1][0];
                    c2 = TrendyCashedPainter.currentTheme().getButtonBorderColors()[1][1];
                    c3 = TrendyCashedPainter.currentTheme().getButtonBorderColors()[1][2];
                    c4 = TrendyCashedPainter.currentTheme().getButtonBorderColors()[1][3];
                    c5 = TrendyCashedPainter.currentTheme().getButtonBorderColors()[1][4];
                    c6 = TrendyCashedPainter.currentTheme().getButtonBorderColors()[1][5];
                    c7 = TrendyCashedPainter.currentTheme().getButtonBorderColors()[1][6];
                    c11 = TrendyCashedPainter.currentTheme().getButtonBorderColors()[1][9];
                    c12 = TrendyCashedPainter.currentTheme().getButtonBorderColors()[1][10];
                } else if (type.equals("FOCUS")) {
                    c1 = TrendyCashedPainter.currentTheme().getButtonBorderColors()[2][0];
                    c2 = TrendyCashedPainter.currentTheme().getButtonBorderColors()[2][1];
                    c3 = TrendyCashedPainter.currentTheme().getButtonBorderColors()[2][2];
                    c4 = TrendyCashedPainter.currentTheme().getButtonBorderColors()[2][3];
                    c5 = TrendyCashedPainter.currentTheme().getButtonBorderColors()[2][4];
                    c6 = TrendyCashedPainter.currentTheme().getButtonBorderColors()[2][5];
                    c7 = TrendyCashedPainter.currentTheme().getButtonBorderColors()[2][6];
                    c11 = TrendyCashedPainter.currentTheme().getButtonBorderColors()[2][9];
                    c12 = TrendyCashedPainter.currentTheme().getButtonBorderColors()[2][10];
                } else if (type.equals("DISABLE")) {
                    c1 = TrendyCashedPainter.currentTheme().getButtonBorderColors()[3][0];
                    c2 = TrendyCashedPainter.currentTheme().getButtonBorderColors()[3][1];
                    c3 = TrendyCashedPainter.currentTheme().getButtonBorderColors()[3][2];
                    c4 = TrendyCashedPainter.currentTheme().getButtonBorderColors()[3][3];
                    c5 = TrendyCashedPainter.currentTheme().getButtonBorderColors()[3][4];
                    c6 = TrendyCashedPainter.currentTheme().getButtonBorderColors()[3][5];
                    c7 = TrendyCashedPainter.currentTheme().getButtonBorderColors()[3][6];
                    c11 = TrendyCashedPainter.currentTheme().getButtonBorderColors()[3][9];
                    c12 = TrendyCashedPainter.currentTheme().getButtonBorderColors()[3][10];
                }
                if (!thinBorder) {
                    g.setColor(c11);
                    g.drawLine(7, 0, w - 8, 0);
                    g.drawLine(1, 4, 4, 1);
                    g.drawLine(w - 5, 1, w - 2, 4);
                    g.drawLine(0, 7, 0, h - 9);
                    g.drawLine(w - 1, 7, w - 1, h - 9);
                    g.drawLine(1, h - 6, 1, h - 5);
                    g.drawLine(2, h - 4, 3, h - 3);
                    g.drawLine(4, h - 2, 5, h - 2);
                    g.drawLine(w - 2, h - 6, w - 2, h - 5);
                    g.drawLine(w - 3, h - 4, w - 4, h - 3);
                    g.drawLine(w - 5, h - 2, w - 6, h - 2);
                    g.setColor(c12);
                    g.drawLine(5, 0, 6, 0);
                    g.drawLine(w - 6, 0, w - 7, 0);
                    g.drawLine(0, 5, 0, 6);
                    g.drawLine(0, h - 7, 0, h - 8);
                    g.drawLine(w - 1, 5, w - 1, 6);
                    g.drawLine(w - 1, h - 7, w - 1, h - 8);
                    g.translate(1, 1);
                    w -= 2;
                    h -= 2;
                } else {
                    --h;
                }
                g.setColor(c1);
                g.drawLine(5, 0, w - 7, 0);
                g.drawLine(0, 6, 0, h - 7);
                g.drawLine(w - 1, 6, w - 1, h - 7);
                g.setColor(c2);
                g.drawLine(6, h - 1, w - 7, h - 1);
                g.setColor(c5);
                g.drawLine(0, 5, 1, 5);
                g.drawLine(5, 1, 5, 0);
                g.setColor(c7);
                g.drawLine(1, 4, 1, 3);
                g.drawLine(4, 1, 3, 1);
                g.drawLine(3, 1, 1, 3);
                g.setColor(c4);
                g.drawLine(4, 0, 5, 1);
                g.drawLine(0, 4, 1, 5);
                g.drawLine(2, 3, 3, 2);
                g.setColor(c5);
                g.drawLine(w - 1, 5, w - 2, 5);
                g.drawLine(w - 6, 0, w - 6, 1);
                g.setColor(c7);
                g.drawLine(w - 2, 4, w - 2, 3);
                g.drawLine(w - 5, 1, w - 4, 1);
                g.drawLine(w - 4, 1, w - 2, 3);
                g.setColor(c4);
                g.drawLine(w - 5, 0, w - 6, 1);
                g.drawLine(w - 1, 4, w - 2, 5);
                g.drawLine(w - 4, 2, w - 3, 3);
                g.setColor(c3);
                g.drawLine(2, h - 4, 3, h - 3);
                g.drawLine(5, h - 2, 5, h - 1);
                g.setColor(c5);
                g.drawLine(0, h - 6, 1, h - 6);
                g.setColor(c6);
                g.drawLine(1, h - 5, 1, h - 4);
                g.drawLine(4, h - 2, 3, h - 2);
                g.drawLine(3, h - 2, 1, h - 4);
                g.setColor(c3);
                g.drawLine(w - 3, h - 4, w - 4, h - 3);
                g.drawLine(w - 6, h - 2, w - 6, h - 1);
                g.setColor(c5);
                g.drawLine(w - 1, h - 6, w - 2, h - 6);
                g.setColor(c6);
                g.drawLine(w - 2, h - 5, w - 2, h - 4);
                g.drawLine(w - 5, h - 2, w - 4, h - 2);
                g.drawLine(w - 4, h - 2, w - 2, h - 4);
                g.setColor(c4);
                g.drawLine(7, h, w - 8, h);
            } else {
                ColorUIResource c1 = new ColorUIResource(0);
                ColorUIResource c2 = new ColorUIResource(0);
                ColorUIResource c11 = new ColorUIResource(0);
                ColorUIResource c12 = new ColorUIResource(0);
                if (type.equals("NORMAL")) {
                    c1 = TrendyCashedPainter.currentTheme().getButtonBorderColors()[0][8];
                    c2 = TrendyCashedPainter.currentTheme().getButtonBorderColors()[0][7];
                    c11 = TrendyCashedPainter.currentTheme().getButtonBorderColors()[0][9];
                    c12 = TrendyCashedPainter.currentTheme().getButtonBorderColors()[0][10];
                } else if (type.equals("ROLLOVER")) {
                    c1 = TrendyCashedPainter.currentTheme().getButtonBorderColors()[1][8];
                    c2 = TrendyCashedPainter.currentTheme().getButtonBorderColors()[1][7];
                    c11 = TrendyCashedPainter.currentTheme().getButtonBorderColors()[1][9];
                    c12 = TrendyCashedPainter.currentTheme().getButtonBorderColors()[1][10];
                } else if (type.equals("FOCUS")) {
                    c1 = TrendyCashedPainter.currentTheme().getButtonBorderColors()[2][8];
                    c2 = TrendyCashedPainter.currentTheme().getButtonBorderColors()[2][7];
                    c11 = TrendyCashedPainter.currentTheme().getButtonBorderColors()[2][9];
                    c12 = TrendyCashedPainter.currentTheme().getButtonBorderColors()[2][10];
                } else if (type.equals("DISABLE")) {
                    c1 = TrendyCashedPainter.currentTheme().getButtonBorderColors()[3][8];
                    c2 = TrendyCashedPainter.currentTheme().getButtonBorderColors()[3][7];
                    c11 = TrendyCashedPainter.currentTheme().getButtonBorderColors()[3][9];
                    c12 = TrendyCashedPainter.currentTheme().getButtonBorderColors()[3][10];
                }
                if (!thinBorder) {
                    g.setColor(c11);
                    g.drawLine(0, 3, 0, h - 4);
                    g.drawLine(w - 1, 3, w - 1, h - 4);
                    g.drawLine(3, 0, w - 4, 0);
                    g.drawLine(3, h - 1, w - 4, h - 1);
                    g.setColor(c12);
                    g.drawLine(0, 2, 2, 0);
                    g.drawLine(w - 1, 2, w - 3, 0);
                    g.drawLine(0, h - 3, 2, h - 1);
                    g.drawLine(w - 1, h - 3, w - 3, h - 1);
                    g.translate(1, 1);
                    w -= 2;
                    h -= 2;
                }
                g.setColor(c1);
                g.drawLine(2, 0, w - 3, 0);
                g.drawLine(0, 2, 0, h - 3);
                g.drawLine(w - 1, 2, w - 1, h - 3);
                g.drawLine(2, h - 1, w - 3, h - 1);
                g.drawLine(1, 1, 1, 1);
                g.drawLine(w - 2, 1, w - 2, 1);
                g.drawLine(1, h - 2, 1, h - 2);
                g.drawLine(w - 2, h - 2, w - 2, h - 2);
                g.setColor(c2);
                g.drawLine(1, 0, 0, 1);
                g.drawLine(w - 2, 0, w - 1, 1);
                g.drawLine(w - 2, h - 1, w - 1, h - 2);
                g.drawLine(1, h - 1, 0, h - 2);
            }
        }

        protected void paintImage(Component c, Graphics g, int x, int y, int imageW, int imageH, Image image, Object[] args) {
            g.translate(x, y);
            g.drawImage(image, 0, 0, null);
            g.translate(-x, -y);
        }
    }

    private static class ComboBoxRoundSkinPainter
    extends TrendyAbstractCachedPainter {
        public static final ComboBoxRoundSkinPainter INSTANCE = new ComboBoxRoundSkinPainter(15);
        int w;
        int h;

        ComboBoxRoundSkinPainter(int count) {
            super(count);
        }

        public synchronized void paint(Component c, Graphics g, int x, int y, int w, int h) {
            this.w = w;
            this.h = h;
            this.paint(c, g, x, y, w, h, new Object[0]);
        }

        protected void paintToImage(Component c, Graphics g, int w, int h, Object[] args) {
            --h;
            boolean down = (Boolean)args[0];
            boolean enable = (Boolean)args[1];
            if (enable) {
                if (down) {
                    g.setColor(TrendyCashedPainter.currentTheme().getButtonSkinColors()[0]);
                    g.drawLine(5, 1, w - 6, 1);
                    g.setColor(TrendyCashedPainter.currentTheme().getButtonSkinColors()[1]);
                    g.drawLine(4, 2, w - 5, 2);
                    g.setColor(TrendyCashedPainter.currentTheme().getButtonSkinColors()[2]);
                    g.drawLine(3, 3, w - 4, 3);
                    g.drawLine(2, 4, w - 3, 4);
                    g.drawLine(2, 5, w - 3, 5);
                    Graphics2D g2 = (Graphics2D)g;
                    g2.setPaint(new GradientPaint(0.0f, 0.0f, TrendyCashedPainter.currentTheme().getButtonSkinColors()[3], 0.0f, h, TrendyCashedPainter.currentTheme().getButtonSkinColors()[4]));
                    g.fillRect(1, 6, w - 2, h - 12);
                    g.setColor(TrendyCashedPainter.currentTheme().getButtonSkinColors()[5]);
                    g.drawLine(2, h - 6, w - 3, h - 6);
                    g.drawLine(2, h - 5, w - 3, h - 5);
                    g.setColor(TrendyCashedPainter.currentTheme().getButtonSkinColors()[6]);
                    g.drawLine(3, h - 4, w - 4, h - 4);
                    g.setColor(TrendyCashedPainter.currentTheme().getButtonSkinColors()[7]);
                    g.drawLine(4, h - 3, w - 5, h - 3);
                    g.setColor(TrendyCashedPainter.currentTheme().getButtonSkinColors()[8]);
                    g.drawLine(5, h - 2, w - 6, h - 2);
                } else {
                    g.setColor(Color.white);
                    g.drawLine(5, 1, w - 6, 1);
                    g.drawLine(4, 2, w - 5, 2);
                    g.setColor(TrendyCashedPainter.currentTheme().getButtonSkinColors()[9]);
                    g.drawLine(3, 3, w - 4, 3);
                    g.setColor(TrendyCashedPainter.currentTheme().getButtonSkinColors()[4]);
                    g.drawLine(2, 4, w - 3, 4);
                    g.setColor(TrendyCashedPainter.currentTheme().getButtonSkinColors()[1]);
                    g.drawLine(2, 5, w - 3, 5);
                    g.setColor(TrendyCashedPainter.currentTheme().getButtonSkinColors()[10]);
                    g.drawLine(1, 6, w - 2, 6);
                    g.setColor(TrendyCashedPainter.currentTheme().getButtonSkinColors()[2]);
                    g.drawLine(1, 7, w - 2, 7);
                    g.setColor(TrendyCashedPainter.currentTheme().getButtonSkinColors()[18]);
                    g.drawLine(1, 8, w - 2, 8);
                    g.setColor(TrendyCashedPainter.currentTheme().getButtonSkinColors()[3]);
                    g.fillRect(1, 9, w - 2, h - 16);
                    g.setColor(TrendyCashedPainter.currentTheme().getButtonSkinColors()[11]);
                    g.drawLine(1, h - 7, w - 2, h - 7);
                    g.setColor(TrendyCashedPainter.currentTheme().getButtonSkinColors()[12]);
                    g.drawLine(2, h - 6, w - 3, h - 6);
                    g.setColor(TrendyCashedPainter.currentTheme().getButtonSkinColors()[13]);
                    g.drawLine(2, h - 5, w - 3, h - 5);
                    g.setColor(TrendyCashedPainter.currentTheme().getButtonSkinColors()[14]);
                    g.drawLine(3, h - 4, w - 4, h - 4);
                    g.setColor(TrendyCashedPainter.currentTheme().getButtonSkinColors()[15]);
                    g.drawLine(4, h - 3, w - 5, h - 3);
                    g.setColor(TrendyCashedPainter.currentTheme().getButtonSkinColors()[16]);
                    g.drawLine(5, h - 2, w - 6, h - 2);
                }
            } else {
                g.setColor(TrendyCashedPainter.currentTheme().getButtonSkinColors()[17]);
                g.drawLine(5, 1, w - 6, 1);
                g.drawLine(4, 2, w - 5, 2);
                g.drawLine(3, 3, w - 4, 3);
                g.drawLine(2, 4, w - 3, 4);
                g.drawLine(2, 5, w - 3, 5);
                g.drawLine(1, 6, w - 2, 6);
                g.drawLine(1, 7, w - 2, 7);
                g.fillRect(1, 8, w - 2, h - 15);
                g.drawLine(2, h - 7, w - 3, h - 7);
                g.drawLine(2, h - 6, w - 3, h - 6);
                g.drawLine(2, h - 5, w - 3, h - 5);
                g.drawLine(3, h - 4, w - 4, h - 4);
                g.drawLine(4, h - 3, w - 5, h - 3);
                g.drawLine(5, h - 2, w - 6, h - 2);
            }
            if (!c.isEnabled()) {
                g.setColor(new ColorUIResource(240, 240, 240));
                g.drawLine(8, h, w - 9, h);
            }
            int ny = c.getSize().height / 2 - 2;
            int nx = c.getWidth() - 15;
            if (down && enable) {
                ++nx;
                ++ny;
            }
            g.translate(nx, ny);
            if (enable) {
                g.setColor(new ColorUIResource(195, 195, 195));
                g.drawLine(0, 0, 8, 0);
                g.drawLine(1, 2, 4, 5);
                g.drawLine(7, 2, 4, 5);
                g.setColor(new ColorUIResource(100, 100, 100));
                g.drawLine(1, 1, 7, 1);
                g.drawLine(2, 2, 6, 2);
                g.drawLine(3, 3, 5, 3);
                g.drawLine(4, 4, 4, 4);
            } else {
                g.setColor(new ColorUIResource(220, 220, 220));
                g.drawLine(0, 0, 8, 0);
                g.drawLine(1, 2, 4, 5);
                g.drawLine(7, 2, 4, 5);
                g.setColor(new ColorUIResource(190, 190, 190));
                g.drawLine(1, 1, 7, 1);
                g.drawLine(2, 2, 6, 2);
                g.drawLine(3, 3, 5, 3);
                g.drawLine(4, 4, 4, 4);
            }
            g.translate(-nx, -ny);
        }

        protected void paintImage(Component c, Graphics g, int x, int y, int imageW, int imageH, Image image, Object[] args) {
            g.translate(x, y);
            g.drawImage(image, 0, 0, null);
            g.translate(-x, -y);
        }
    }

    private static class ComboBoxSquareSkinPainter
    extends TrendyAbstractCachedPainter {
        public static final ComboBoxSquareSkinPainter INSTANCE = new ComboBoxSquareSkinPainter(15);
        int w;
        int h;

        ComboBoxSquareSkinPainter(int count) {
            super(count);
        }

        public synchronized void paint(Component c, Graphics g, int x, int y, int w, int h) {
            this.w = w;
            this.h = h;
            this.paint(c, g, x, y, w, h, new Object[0]);
        }

        protected void paintToImage(Component c, Graphics g, int w, int h, Object[] args) {
            --h;
            boolean down = (Boolean)args[0];
            boolean enable = (Boolean)args[1];
            if (enable) {
                if (down) {
                    g.setColor(TrendyCashedPainter.currentTheme().getButtonSkinColors()[0]);
                    g.drawLine(2, 1, w - 3, 1);
                    g.setColor(TrendyCashedPainter.currentTheme().getButtonSkinColors()[1]);
                    g.drawLine(1, 2, w - 2, 2);
                    g.setColor(TrendyCashedPainter.currentTheme().getButtonSkinColors()[2]);
                    g.drawLine(1, 3, w - 2, 3);
                    g.drawLine(1, 4, w - 2, 4);
                    g.drawLine(1, 5, w - 2, 5);
                    Graphics2D g2 = (Graphics2D)g;
                    g2.setPaint(new GradientPaint(0.0f, 0.0f, TrendyCashedPainter.currentTheme().getButtonSkinColors()[3], 0.0f, h, TrendyCashedPainter.currentTheme().getButtonSkinColors()[4]));
                    g.fillRect(1, 6, w - 2, h - 11);
                    g.setColor(TrendyCashedPainter.currentTheme().getButtonSkinColors()[5]);
                    g.drawLine(1, h - 5, w - 2, h - 5);
                    g.drawLine(1, h - 4, w - 2, h - 4);
                    g.setColor(TrendyCashedPainter.currentTheme().getButtonSkinColors()[6]);
                    g.drawLine(1, h - 3, w - 2, h - 3);
                    g.setColor(TrendyCashedPainter.currentTheme().getButtonSkinColors()[7]);
                    g.drawLine(1, h - 2, w - 2, h - 2);
                    g.setColor(TrendyCashedPainter.currentTheme().getButtonSkinColors()[8]);
                    g.drawLine(2, h - 1, w - 3, h - 1);
                } else {
                    g.setColor(Color.white);
                    g.drawLine(2, 1, w - 3, 1);
                    g.drawLine(1, 2, w - 2, 2);
                    g.setColor(TrendyCashedPainter.currentTheme().getButtonSkinColors()[9]);
                    g.drawLine(1, 3, w - 2, 3);
                    g.setColor(TrendyCashedPainter.currentTheme().getButtonSkinColors()[4]);
                    g.drawLine(1, 4, w - 2, 4);
                    g.setColor(TrendyCashedPainter.currentTheme().getButtonSkinColors()[1]);
                    g.drawLine(1, 5, w - 2, 5);
                    g.setColor(TrendyCashedPainter.currentTheme().getButtonSkinColors()[10]);
                    g.drawLine(1, 6, w - 2, 6);
                    g.setColor(TrendyCashedPainter.currentTheme().getButtonSkinColors()[2]);
                    g.drawLine(1, 7, w - 2, 7);
                    g.setColor(TrendyCashedPainter.currentTheme().getButtonSkinColors()[18]);
                    g.drawLine(1, 8, w - 2, 8);
                    g.setColor(TrendyCashedPainter.currentTheme().getButtonSkinColors()[3]);
                    g.fillRect(1, 9, w - 2, h - 15);
                    g.setColor(TrendyCashedPainter.currentTheme().getButtonSkinColors()[11]);
                    g.drawLine(1, h - 6, w - 2, h - 6);
                    g.setColor(TrendyCashedPainter.currentTheme().getButtonSkinColors()[12]);
                    g.drawLine(1, h - 5, w - 2, h - 5);
                    g.setColor(TrendyCashedPainter.currentTheme().getButtonSkinColors()[13]);
                    g.drawLine(1, h - 4, w - 2, h - 4);
                    g.setColor(TrendyCashedPainter.currentTheme().getButtonSkinColors()[14]);
                    g.drawLine(1, h - 3, w - 2, h - 3);
                    g.setColor(TrendyCashedPainter.currentTheme().getButtonSkinColors()[15]);
                    g.drawLine(1, h - 2, w - 2, h - 2);
                    g.setColor(TrendyCashedPainter.currentTheme().getButtonSkinColors()[16]);
                    g.drawLine(2, h - 1, w - 3, h - 1);
                }
            } else {
                g.setColor(TrendyCashedPainter.currentTheme().getButtonSkinColors()[17]);
                g.drawLine(2, 1, w - 3, 1);
                g.drawLine(1, 2, w - 2, 2);
                g.drawLine(1, 3, w - 2, 3);
                g.drawLine(1, 4, w - 2, 4);
                g.drawLine(1, 5, w - 2, 5);
                g.drawLine(1, 6, w - 2, 6);
                g.drawLine(1, 7, w - 2, 7);
                g.fillRect(1, 8, w - 2, h - 14);
                g.drawLine(1, h - 6, w - 2, h - 6);
                g.drawLine(1, h - 5, w - 2, h - 5);
                g.drawLine(1, h - 4, w - 2, h - 4);
                g.drawLine(1, h - 3, w - 2, h - 3);
                g.drawLine(1, h - 2, w - 2, h - 2);
                g.drawLine(2, h - 1, w - 3, h - 1);
            }
            int ny = c.getSize().height / 2 - 3;
            int nx = c.getWidth() - 15;
            if (down && enable) {
                ++nx;
                ++ny;
            }
            g.translate(nx, ny);
            if (enable) {
                g.setColor(new ColorUIResource(195, 195, 195));
                g.drawLine(0, 0, 8, 0);
                g.drawLine(1, 2, 4, 5);
                g.drawLine(7, 2, 4, 5);
                g.setColor(new ColorUIResource(100, 100, 100));
                g.drawLine(1, 1, 7, 1);
                g.drawLine(2, 2, 6, 2);
                g.drawLine(3, 3, 5, 3);
                g.drawLine(4, 4, 4, 4);
            } else {
                g.setColor(new ColorUIResource(220, 220, 220));
                g.drawLine(0, 0, 8, 0);
                g.drawLine(1, 2, 4, 5);
                g.drawLine(7, 2, 4, 5);
                g.setColor(new ColorUIResource(190, 190, 190));
                g.drawLine(1, 1, 7, 1);
                g.drawLine(2, 2, 6, 2);
                g.drawLine(3, 3, 5, 3);
                g.drawLine(4, 4, 4, 4);
            }
            g.translate(-nx, -ny);
        }

        protected void paintImage(Component c, Graphics g, int x, int y, int imageW, int imageH, Image image, Object[] args) {
            g.translate(x, y);
            g.drawImage(image, 0, 0, null);
            g.translate(-x, -y);
        }
    }

    private static class MenuItemFadingPainter
    extends TrendyAbstractCachedPainter {
        public static final MenuItemFadingPainter INSTANCE = new MenuItemFadingPainter(7);
        int w;
        int h;

        MenuItemFadingPainter(int count) {
            super(count);
        }

        public synchronized void paint(Component c, Graphics g, int x, int y, int w, int h) {
            this.w = w;
            this.h = h;
            this.paint(c, g, x, y, 50, h, new Object[0]);
        }

        protected void paintToImage(Component c, Graphics g, int w, int h, Object[] args) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setPaint(new GradientPaint(0.0f, 0.0f, new ColorUIResource(TrendyCashedPainter.currentTheme().getMenuItemBackground()), 50.0f, 0.0f, TrendyCashedPainter.currentTheme().getMenuItemFadingColor()));
            g2.fillRect(0, 0, 50, h);
        }

        protected void paintImage(Component c, Graphics g, int x, int y, int imageW, int imageH, Image image, Object[] args) {
            g.drawImage(image, this.w >= 50 ? this.w - 50 : 0, 0, null);
        }

        protected Image createImage(Component c, int w, int h, GraphicsConfiguration config) {
            if (config == null) {
                return new BufferedImage(50, h, 5);
            }
            return config.createCompatibleVolatileImage(50, h);
        }
    }

    private static class CheckboxPainter
    extends TrendyAbstractCachedPainter {
        public static final CheckboxPainter INSTANCE = new CheckboxPainter(7);
        int w;
        int h;

        CheckboxPainter(int count) {
            super(count);
        }

        public synchronized void paint(Component c, Graphics g, int x, int y, int w, int h) {
            this.w = w;
            this.h = h;
            this.paint(c, g, x, y, w, h, new Object[0]);
        }

        protected void paintToImage(Component c, Graphics g, int w, int h, Object[] args) {
            boolean isSelected = (Boolean)args[0];
            boolean isEnabled = (Boolean)args[1];
            boolean isPressed = (Boolean)args[2];
            boolean isArmed = (Boolean)args[3];
            boolean isRollover = (Boolean)args[4];
            ColorUIResource c1 = new ColorUIResource(0);
            ColorUIResource c2 = new ColorUIResource(0);
            ColorUIResource c3 = new ColorUIResource(0);
            if (!isEnabled) {
                c1 = TrendyUtils.currentTheme().getCheckBoxButtonColors()[2][0];
                c2 = TrendyUtils.currentTheme().getCheckBoxButtonColors()[2][1];
                c3 = TrendyUtils.currentTheme().getCheckBoxButtonColors()[2][2];
            } else if (isRollover) {
                c1 = TrendyUtils.currentTheme().getCheckBoxButtonColors()[1][0];
                c2 = TrendyUtils.currentTheme().getCheckBoxButtonColors()[1][1];
                c3 = TrendyUtils.currentTheme().getCheckBoxButtonColors()[1][2];
            } else {
                c1 = TrendyUtils.currentTheme().getCheckBoxButtonColors()[0][0];
                c2 = TrendyUtils.currentTheme().getCheckBoxButtonColors()[0][1];
                c3 = TrendyUtils.currentTheme().getCheckBoxButtonColors()[0][2];
            }
            g.setColor(c3);
            g.drawRect(1, 1, 13, 13);
            g.setColor(c2);
            g.drawLine(1, 1, 1, 1);
            g.drawLine(14, 1, 14, 1);
            g.drawLine(1, 14, 1, 14);
            g.drawLine(14, 14, 14, 14);
            g.setColor(c1);
            g.drawLine(0, 2, 0, 13);
            g.drawLine(2, 0, 13, 0);
            g.drawLine(15, 2, 15, 13);
            g.drawLine(2, 15, 13, 15);
            if (!isEnabled) {
                g.setColor(TrendyUtils.currentTheme().getCheckBoxButtonColors()[2][3]);
                g.fillRect(2, 2, 12, 12);
            } else if (isPressed || isSelected) {
                g.setColor(TrendyUtils.currentTheme().getCheckBoxButtonColors()[1][3]);
                g.fillRect(2, 2, 12, 12);
            } else {
                g.setColor(TrendyUtils.currentTheme().getCheckBoxButtonColors()[0][3]);
                g.drawLine(2, 2, 13, 2);
                g.setColor(TrendyUtils.currentTheme().getCheckBoxButtonColors()[0][3]);
                g.drawLine(2, 3, 13, 3);
                g.setColor(TrendyUtils.currentTheme().getCheckBoxButtonColors()[0][3]);
                g.drawLine(2, 4, 13, 4);
                g.setColor(TrendyUtils.currentTheme().getCheckBoxButtonColors()[0][3]);
                g.drawLine(2, 5, 13, 5);
                g.setColor(TrendyUtils.currentTheme().getCheckBoxButtonColors()[0][4]);
                g.drawLine(2, 6, 13, 6);
                g.setColor(TrendyUtils.currentTheme().getCheckBoxButtonColors()[0][5]);
                g.drawLine(2, 7, 13, 7);
                g.setColor(TrendyUtils.currentTheme().getCheckBoxButtonColors()[0][6]);
                g.drawLine(2, 8, 13, 8);
                g.setColor(TrendyUtils.currentTheme().getCheckBoxButtonColors()[0][7]);
                g.drawLine(2, 9, 13, 9);
                g.setColor(TrendyUtils.currentTheme().getCheckBoxButtonColors()[0][8]);
                g.drawLine(2, 10, 13, 10);
                g.setColor(TrendyUtils.currentTheme().getCheckBoxButtonColors()[0][8]);
                g.drawLine(2, 11, 13, 11);
                g.setColor(TrendyUtils.currentTheme().getCheckBoxButtonColors()[0][5]);
                g.drawLine(2, 12, 13, 12);
                g.setColor(TrendyUtils.currentTheme().getCheckBoxButtonColors()[0][4]);
                g.drawLine(2, 13, 13, 13);
            }
            if (isSelected) {
                g.translate(2, 3);
                if (isEnabled) {
                    g.setColor(TrendyUtils.currentTheme().getCheckBoxButtonColors()[3][0]);
                    g.drawLine(4, 6, 4, 9);
                    g.setColor(TrendyUtils.currentTheme().getCheckBoxButtonColors()[3][1]);
                    g.drawLine(9, 1, 9, 1);
                    g.setColor(TrendyUtils.currentTheme().getCheckBoxButtonColors()[3][2]);
                    g.drawLine(9, 3, 9, 3);
                    g.setColor(TrendyUtils.currentTheme().getCheckBoxButtonColors()[3][3]);
                    g.drawLine(9, 2, 5, 6);
                    g.drawLine(3, 6, 3, 6);
                    g.setColor(TrendyUtils.currentTheme().getCheckBoxButtonColors()[3][4]);
                    g.drawLine(8, 4, 6, 6);
                    g.setColor(TrendyUtils.currentTheme().getCheckBoxButtonColors()[3][5]);
                    g.drawLine(7, 6, 6, 7);
                    g.setColor(TrendyUtils.currentTheme().getCheckBoxButtonColors()[3][6]);
                    g.drawLine(8, 5, 8, 5);
                    g.setColor(TrendyUtils.currentTheme().getCheckBoxButtonColors()[3][7]);
                    g.drawLine(2, 7, 5, 7);
                    g.drawLine(3, 8, 5, 8);
                    g.setColor(TrendyUtils.currentTheme().getCheckBoxButtonColors()[3][8]);
                    g.fillRect(1, 5, 2, 2);
                    g.setColor(TrendyUtils.currentTheme().getCheckBoxButtonColors()[3][9]);
                    g.fillRect(1, 4, 1, 1);
                    g.setColor(TrendyUtils.currentTheme().getCheckBoxButtonColors()[3][10]);
                    g.drawLine(2, 6, 2, 7);
                } else {
                    g.setColor(TrendyUtils.currentTheme().getCheckBoxButtonColors()[2][4]);
                    g.drawLine(4, 6, 4, 9);
                    g.drawLine(9, 1, 9, 1);
                    g.drawLine(9, 3, 9, 3);
                    g.drawLine(9, 2, 5, 6);
                    g.drawLine(8, 4, 6, 6);
                    g.drawLine(7, 6, 6, 7);
                    g.drawLine(8, 5, 8, 5);
                    g.drawLine(2, 7, 5, 7);
                    g.drawLine(3, 8, 5, 8);
                    g.fillRect(1, 5, 2, 2);
                    g.fillRect(1, 4, 1, 1);
                    g.drawLine(2, 6, 2, 7);
                    g.drawLine(3, 6, 3, 6);
                }
                g.translate(-2, -3);
            }
        }

        protected void paintImage(Component c, Graphics g, int x, int y, int imageW, int imageH, Image image, Object[] args) {
            g.drawImage(image, 0, 0, null);
        }
    }

    private static class MenuSeparatorPainter
    extends TrendyAbstractCachedPainter {
        public static final MenuSeparatorPainter INSTANCE = new MenuSeparatorPainter(7);
        int w;
        int h;

        MenuSeparatorPainter(int count) {
            super(count);
        }

        public synchronized void paint(Component c, Graphics g, int x, int y, int w, int h) {
            this.w = w;
            this.h = h;
            this.paint(c, g, x, y, w, h, new Object[0]);
        }

        protected void paintToImage(Component c, Graphics g, int w, int h, Object[] args) {
            g.setColor(TrendyUtils.currentTheme().getMenuItemBackground());
            g.fillRect(0, 0, w, h);
            Graphics2D g2 = (Graphics2D)g;
            g2.setPaint(new GradientPaint(w > 50 ? w - 50 : 0, 0.0f, TrendyUtils.currentTheme().getMenuItemBackground(), w, 0.0f, TrendyUtils.currentTheme().getMenuItemFadingColor()));
            g2.fillRect(w > 50 ? w - 50 : 0, 0, w, h);
            ColorUIResource c1 = new ColorUIResource(140, 140, 140);
            g.setColor(c1);
            g.drawLine(0, 1, w, 1);
            g2.setPaint(new GradientPaint(w - 20, 0.0f, c1, w, 0.0f, TrendyUtils.currentTheme().getMenuItemFadingColor()));
            g2.fillRect(w - 20, 1, 20, 1);
            g2.setPaint(new GradientPaint(0.0f, 0.0f, TrendyUtils.currentTheme().getMenuItemBackground(), 20.0f, 0.0f, c1));
            g2.fillRect(0, 1, 20, 1);
        }

        protected void paintImage(Component c, Graphics g, int x, int y, int imageW, int imageH, Image image, Object[] args) {
            g.drawImage(image, 0, 0, null);
        }

        protected Image createImage(Component c, int w, int h, GraphicsConfiguration config) {
            if (config == null) {
                return new BufferedImage(w, h, 5);
            }
            return config.createCompatibleVolatileImage(w, h);
        }
    }

    private static class RadioButtonPainter
    extends TrendyAbstractCachedPainter {
        public static final RadioButtonPainter INSTANCE = new RadioButtonPainter(7);
        int w;
        int h;

        RadioButtonPainter(int count) {
            super(count);
        }

        public synchronized void paint(Component c, Graphics g, int x, int y, int w, int h) {
            this.w = w;
            this.h = h;
            this.paint(c, g, x, y, w, h, new Object[0]);
        }

        protected void paintToImage(Component c, Graphics g, int w, int h, Object[] args) {
            boolean isSelected = (Boolean)args[0];
            boolean isEnabled = (Boolean)args[1];
            boolean isPressed = (Boolean)args[2];
            boolean isArmed = (Boolean)args[3];
            boolean isRollover = (Boolean)args[4];
            ColorUIResource c1 = new ColorUIResource(0);
            ColorUIResource c2 = new ColorUIResource(0);
            ColorUIResource c3 = new ColorUIResource(0);
            ColorUIResource c4 = new ColorUIResource(0);
            ColorUIResource c5 = new ColorUIResource(0);
            if (isEnabled) {
                if (isRollover) {
                    c1 = TrendyUtils.currentTheme().getRadioButtonColors()[1][0];
                    c2 = TrendyUtils.currentTheme().getRadioButtonColors()[1][1];
                    c3 = TrendyUtils.currentTheme().getRadioButtonColors()[1][2];
                    c4 = TrendyUtils.currentTheme().getRadioButtonColors()[1][3];
                    c5 = TrendyUtils.currentTheme().getRadioButtonColors()[1][4];
                } else {
                    c1 = TrendyUtils.currentTheme().getRadioButtonColors()[0][0];
                    c2 = TrendyUtils.currentTheme().getRadioButtonColors()[0][1];
                    c3 = TrendyUtils.currentTheme().getRadioButtonColors()[0][2];
                    c4 = TrendyUtils.currentTheme().getRadioButtonColors()[0][3];
                    c5 = TrendyUtils.currentTheme().getRadioButtonColors()[0][4];
                }
            } else {
                c1 = TrendyUtils.currentTheme().getRadioButtonColors()[0][0];
                c2 = TrendyUtils.currentTheme().getRadioButtonColors()[0][1];
                c3 = TrendyUtils.currentTheme().getRadioButtonColors()[0][2];
                c4 = TrendyUtils.currentTheme().getRadioButtonColors()[0][3];
                c5 = TrendyUtils.currentTheme().getRadioButtonColors()[0][4];
            }
            g.setColor(c1);
            g.drawLine(4, 0, 11, 0);
            g.drawLine(4, 15, 11, 15);
            g.drawLine(0, 4, 0, 11);
            g.drawLine(15, 4, 15, 11);
            g.setColor(c2);
            g.drawLine(5, 0, 6, 1);
            g.drawLine(10, 0, 9, 1);
            g.drawLine(5, 15, 6, 14);
            g.drawLine(10, 15, 9, 14);
            g.drawLine(0, 5, 1, 6);
            g.drawLine(0, 10, 1, 9);
            g.drawLine(15, 5, 14, 6);
            g.drawLine(15, 10, 14, 9);
            g.drawLine(1, 3, 3, 1);
            g.drawLine(1, 12, 3, 14);
            g.drawLine(12, 1, 14, 3);
            g.drawLine(12, 14, 14, 12);
            g.setColor(c3);
            g.drawLine(6, 0, 5, 1);
            g.drawLine(9, 0, 10, 1);
            g.drawLine(6, 15, 5, 14);
            g.drawLine(9, 15, 10, 14);
            g.drawLine(0, 6, 1, 5);
            g.drawLine(0, 9, 1, 10);
            g.drawLine(15, 6, 14, 5);
            g.drawLine(15, 9, 14, 10);
            g.setColor(c4);
            g.drawLine(7, 0, 8, 0);
            g.drawLine(7, 15, 8, 15);
            g.drawLine(0, 7, 0, 8);
            g.drawLine(15, 7, 15, 8);
            g.drawLine(1, 4, 4, 1);
            g.drawLine(1, 11, 4, 14);
            g.drawLine(11, 1, 14, 4);
            g.drawLine(11, 14, 14, 11);
            g.setColor(c5);
            g.drawLine(7, 1, 8, 1);
            g.drawLine(7, 14, 8, 14);
            g.drawLine(1, 7, 1, 8);
            g.drawLine(14, 7, 14, 8);
            g.drawLine(2, 4, 4, 2);
            g.drawLine(11, 2, 13, 4);
            g.drawLine(2, 11, 4, 13);
            g.drawLine(11, 13, 13, 11);
            if (isEnabled) {
                if (isSelected || isPressed) {
                    g.setColor(TrendyUtils.currentTheme().getRadioButtonColors()[2][0]);
                    g.drawLine(5, 2, 10, 2);
                    g.drawLine(4, 3, 11, 3);
                    g.drawLine(3, 4, 12, 4);
                    g.drawLine(2, 5, 13, 5);
                    g.drawLine(2, 6, 13, 6);
                    g.drawLine(2, 7, 13, 7);
                    g.drawLine(2, 8, 13, 8);
                    g.drawLine(2, 9, 13, 9);
                    g.drawLine(2, 10, 13, 10);
                    g.drawLine(3, 11, 12, 11);
                    g.drawLine(4, 12, 11, 12);
                    g.drawLine(5, 13, 10, 13);
                } else {
                    g.setColor(TrendyUtils.currentTheme().getRadioButtonColors()[2][1]);
                    g.drawLine(5, 2, 10, 2);
                    g.setColor(TrendyUtils.currentTheme().getRadioButtonColors()[2][2]);
                    g.drawLine(4, 3, 11, 3);
                    g.setColor(TrendyUtils.currentTheme().getRadioButtonColors()[2][3]);
                    g.drawLine(3, 4, 12, 4);
                    g.setColor(TrendyUtils.currentTheme().getRadioButtonColors()[2][4]);
                    g.drawLine(2, 5, 13, 5);
                    g.setColor(TrendyUtils.currentTheme().getRadioButtonColors()[2][5]);
                    g.drawLine(2, 6, 13, 6);
                    g.setColor(TrendyUtils.currentTheme().getRadioButtonColors()[2][6]);
                    g.drawLine(2, 7, 13, 7);
                    g.setColor(TrendyUtils.currentTheme().getRadioButtonColors()[2][7]);
                    g.drawLine(2, 8, 13, 8);
                    g.setColor(TrendyUtils.currentTheme().getRadioButtonColors()[2][8]);
                    g.drawLine(2, 9, 13, 9);
                    g.setColor(TrendyUtils.currentTheme().getRadioButtonColors()[2][9]);
                    g.drawLine(2, 10, 13, 10);
                    g.setColor(TrendyUtils.currentTheme().getRadioButtonColors()[2][8]);
                    g.drawLine(3, 11, 12, 11);
                    g.setColor(TrendyUtils.currentTheme().getRadioButtonColors()[2][4]);
                    g.drawLine(4, 12, 11, 12);
                    g.setColor(TrendyUtils.currentTheme().getRadioButtonColors()[2][1]);
                    g.drawLine(5, 13, 10, 13);
                }
            } else {
                g.setColor(TrendyUtils.currentTheme().getRadioButtonColors()[2][8]);
                g.drawLine(5, 2, 10, 2);
                g.drawLine(4, 3, 11, 3);
                g.drawLine(3, 4, 12, 4);
                g.drawLine(2, 5, 13, 5);
                g.drawLine(2, 6, 13, 6);
                g.drawLine(2, 7, 13, 7);
                g.drawLine(2, 8, 13, 8);
                g.drawLine(2, 9, 13, 9);
                g.drawLine(2, 10, 13, 10);
                g.drawLine(3, 11, 12, 11);
                g.drawLine(4, 12, 11, 12);
                g.drawLine(5, 13, 10, 13);
            }
            g.translate(3, 3);
            if (isSelected) {
                if (isEnabled) {
                    g.setColor(TrendyUtils.currentTheme().getRadioButtonColors()[3][0]);
                    g.drawLine(1, 3, 3, 1);
                    g.setColor(TrendyUtils.currentTheme().getRadioButtonColors()[3][1]);
                    g.drawLine(1, 4, 4, 1);
                    g.setColor(TrendyUtils.currentTheme().getRadioButtonColors()[3][2]);
                    g.drawLine(1, 5, 5, 1);
                    g.setColor(TrendyUtils.currentTheme().getRadioButtonColors()[3][3]);
                    g.drawLine(1, 6, 6, 1);
                    g.setColor(TrendyUtils.currentTheme().getRadioButtonColors()[3][4]);
                    g.drawLine(2, 6, 6, 2);
                    g.setColor(TrendyUtils.currentTheme().getRadioButtonColors()[3][5]);
                    g.drawLine(2, 7, 7, 2);
                    g.setColor(TrendyUtils.currentTheme().getRadioButtonColors()[3][6]);
                    g.drawLine(3, 7, 7, 3);
                    g.drawLine(3, 8, 8, 3);
                    g.drawLine(4, 8, 8, 4);
                    g.drawLine(5, 8, 8, 5);
                    g.drawLine(6, 8, 8, 6);
                } else {
                    g.setColor(TrendyUtils.currentTheme().getRadioButtonColors()[3][7]);
                    g.drawLine(1, 3, 3, 1);
                    g.drawLine(1, 4, 4, 1);
                    g.drawLine(1, 5, 5, 1);
                    g.drawLine(1, 6, 6, 1);
                    g.drawLine(2, 6, 6, 2);
                    g.drawLine(2, 7, 7, 2);
                    g.drawLine(3, 7, 7, 3);
                    g.drawLine(3, 8, 8, 3);
                    g.drawLine(4, 8, 8, 4);
                    g.drawLine(5, 8, 8, 5);
                    g.drawLine(6, 8, 8, 6);
                }
            }
            g.translate(-3, -3);
        }

        protected void paintImage(Component c, Graphics g, int x, int y, int imageW, int imageH, Image image, Object[] args) {
            g.drawImage(image, 0, 0, null);
        }
    }

    private static class InDeterminateProgressBarPainter
    extends TrendyAbstractCachedPainter {
        public static final InDeterminateProgressBarPainter INSTANCE = new InDeterminateProgressBarPainter(7);
        int w;
        int h;

        InDeterminateProgressBarPainter(int count) {
            super(count);
        }

        public synchronized void paint(Component c, Graphics g, int x, int y, int w, int h) {
            this.w = w;
            this.h = h;
            this.paint(c, g, x, y, w, h, new Object[0]);
        }

        protected void paintToImage(Component c, Graphics g, int w, int h, Object[] args) {
            boolean vertical = (Boolean)args[0];
            int x = 0;
            int y = 0;
            if (vertical) {
                g.setColor(TrendyUtils.currentTheme().getProgressBarColors()[1][0]);
                g.drawLine(x, y + 1, x, y + h - 2);
                g.setColor(TrendyUtils.currentTheme().getProgressBarColors()[1][1]);
                g.drawLine(x + 1, y + 1, x + 1, y + h - 2);
                g.setColor(TrendyUtils.currentTheme().getProgressBarColors()[1][2]);
                g.drawLine(x + 1, y, x + 1, y + h - 1);
                g.setColor(TrendyUtils.currentTheme().getProgressBarColors()[1][3]);
                g.drawLine(x + 2, y, x + 2, y + h - 1);
                g.setColor(TrendyUtils.currentTheme().getProgressBarColors()[1][4]);
                g.drawLine(x + 2, y + 1, x + 2, y + h - 2);
                if (w > 0) {
                    g.setColor(TrendyUtils.currentTheme().getProgressBarColors()[1][5]);
                    g.drawLine(x + 3, y, x + w - 4, y);
                    g.setColor(TrendyUtils.currentTheme().getProgressBarColors()[1][6]);
                    g.fillRect(x + 3, y + 1, w - 6, h - 2);
                    g.setColor(TrendyUtils.currentTheme().getProgressBarColors()[1][7]);
                    g.drawLine(x + 3, y + h - 1, x + w - 4, y + h - 1);
                }
                g.setColor(TrendyUtils.currentTheme().getProgressBarColors()[1][8]);
                g.drawLine(x + w - 3, y, x + w - 3, y + h - 1);
                g.setColor(TrendyUtils.currentTheme().getProgressBarColors()[1][9]);
                g.drawLine(x + w - 3, y + 1, x + w - 3, y + h - 2);
                g.setColor(TrendyUtils.currentTheme().getProgressBarColors()[1][10]);
                g.drawLine(x + w - 2, y, x + w - 2, y + h - 1);
                g.setColor(TrendyUtils.currentTheme().getProgressBarColors()[1][11]);
                g.drawLine(x + w - 2, y + 1, x + w - 2, y + h - 2);
                g.setColor(TrendyUtils.currentTheme().getProgressBarColors()[1][12]);
                g.drawLine(x + w - 1, y + 1, x + w - 1, y + h - 2);
            } else {
                g.setColor(TrendyUtils.currentTheme().getProgressBarColors()[1][0]);
                g.drawLine(x + 1, y, x + w - 2, y);
                g.setColor(TrendyUtils.currentTheme().getProgressBarColors()[1][2]);
                g.drawLine(x, y + 1, x + w - 1, y + 1);
                g.setColor(TrendyUtils.currentTheme().getProgressBarColors()[1][1]);
                g.drawLine(x + 1, y + 1, x + w - 2, y + 1);
                g.setColor(TrendyUtils.currentTheme().getProgressBarColors()[1][3]);
                g.drawLine(x, y + 2, x + w - 1, y + 2);
                g.setColor(TrendyUtils.currentTheme().getProgressBarColors()[1][4]);
                g.drawLine(x + 1, y + 2, x + w - 2, y + 2);
                if (h > 0) {
                    g.setColor(TrendyUtils.currentTheme().getProgressBarColors()[1][7]);
                    g.drawLine(x, y + 3, x, y + h - 4);
                    g.setColor(TrendyUtils.currentTheme().getProgressBarColors()[1][6]);
                    g.fillRect(x + 1, y + 3, w - 2, h - 6);
                    g.setColor(TrendyUtils.currentTheme().getProgressBarColors()[1][5]);
                    g.drawLine(x + w - 1, y + 3, x + w - 1, y + h - 4);
                }
                g.setColor(TrendyUtils.currentTheme().getProgressBarColors()[1][8]);
                g.drawLine(x, y + h - 3, x + w - 1, y + h - 3);
                g.setColor(TrendyUtils.currentTheme().getProgressBarColors()[1][9]);
                g.drawLine(x + 1, y + h - 3, x + w - 2, y + h - 3);
                g.setColor(TrendyUtils.currentTheme().getProgressBarColors()[1][10]);
                g.drawLine(x, y + h - 2, x + w - 1, y + h - 2);
                g.setColor(TrendyUtils.currentTheme().getProgressBarColors()[1][11]);
                g.drawLine(x + 1, y + h - 2, x + w - 2, y + h - 2);
                g.setColor(TrendyUtils.currentTheme().getProgressBarColors()[1][12]);
                g.drawLine(x + 1, y + h - 1, x + w - 2, y + h - 1);
            }
        }

        protected void paintImage(Component c, Graphics g, int x, int y, int imageW, int imageH, Image image, Object[] args) {
            g.translate(x, y);
            g.drawImage(image, 0, 0, null);
            g.translate(-x, -y);
        }
    }

    private static class DeterminateProgressBarPainter
    extends TrendyAbstractCachedPainter {
        public static final DeterminateProgressBarPainter INSTANCE = new DeterminateProgressBarPainter(7);
        int w;
        int h;

        DeterminateProgressBarPainter(int count) {
            super(count);
        }

        public synchronized void paint(Component c, Graphics g, int x, int y, int w, int h) {
            this.w = w;
            this.h = h;
            this.paint(c, g, x, y, w, h, new Object[0]);
        }

        protected void paintToImage(Component c, Graphics g, int w, int h, Object[] args) {
            boolean vertical = (Boolean)args[0];
            int x = 0;
            int y = 0;
            if (vertical) {
                g.setColor(TrendyUtils.currentTheme().getProgressBarColors()[0][0]);
                g.drawLine(x, y + 1, x, y + 7);
                g.setColor(TrendyUtils.currentTheme().getProgressBarColors()[0][1]);
                g.drawLine(x + 1, y + 1, x + 1, y + 7);
                g.setColor(TrendyUtils.currentTheme().getProgressBarColors()[0][2]);
                g.drawLine(x + 1, y, x + 1, y + 8);
                g.setColor(TrendyUtils.currentTheme().getProgressBarColors()[0][3]);
                g.drawLine(x + 2, y, x + 2, y + 8);
                g.setColor(TrendyUtils.currentTheme().getProgressBarColors()[0][4]);
                g.drawLine(x + 2, y + 1, x + 2, y + 7);
                if (w > 0) {
                    g.setColor(TrendyUtils.currentTheme().getProgressBarColors()[0][5]);
                    g.drawLine(x + 3, y, x + w - 4, y);
                    g.setColor(TrendyUtils.currentTheme().getProgressBarColors()[0][6]);
                    g.fillRect(x + 3, y + 1, w - 6, 7);
                    g.setColor(TrendyUtils.currentTheme().getProgressBarColors()[0][7]);
                    g.drawLine(x + 3, y + 8, x + w - 4, y + 8);
                }
                g.setColor(TrendyUtils.currentTheme().getProgressBarColors()[0][8]);
                g.drawLine(x + w - 3, y, x + w - 3, y + 8);
                g.setColor(TrendyUtils.currentTheme().getProgressBarColors()[0][9]);
                g.drawLine(x + w - 3, y + 1, x + w - 3, y + 7);
                g.setColor(TrendyUtils.currentTheme().getProgressBarColors()[0][10]);
                g.drawLine(x + w - 2, y, x + w - 2, y + 8);
                g.setColor(TrendyUtils.currentTheme().getProgressBarColors()[0][11]);
                g.drawLine(x + w - 2, y + 1, x + w - 2, y + 7);
                g.setColor(TrendyUtils.currentTheme().getProgressBarColors()[0][12]);
                g.drawLine(x + w - 1, y + 1, x + w - 1, y + 7);
            } else {
                g.setColor(TrendyUtils.currentTheme().getProgressBarColors()[0][0]);
                g.drawLine(x + 1, y, x + 7, y);
                g.setColor(TrendyUtils.currentTheme().getProgressBarColors()[0][2]);
                g.drawLine(x, y + 1, x + 8, y + 1);
                g.setColor(TrendyUtils.currentTheme().getProgressBarColors()[0][1]);
                g.drawLine(x + 1, y + 1, x + 7, y + 1);
                g.setColor(TrendyUtils.currentTheme().getProgressBarColors()[0][2]);
                g.drawLine(x, y + 2, x + 8, y + 2);
                g.setColor(TrendyUtils.currentTheme().getProgressBarColors()[0][3]);
                g.drawLine(x + 1, y + 2, x + 7, y + 2);
                if (h > 0) {
                    g.setColor(TrendyUtils.currentTheme().getProgressBarColors()[0][7]);
                    g.drawLine(x, y + 3, x, y + h - 4);
                    g.setColor(TrendyUtils.currentTheme().getProgressBarColors()[0][6]);
                    g.fillRect(x + 1, y + 3, 7, h - 6);
                    g.setColor(TrendyUtils.currentTheme().getProgressBarColors()[0][5]);
                    g.drawLine(x + 8, y + 3, x + 8, y + h - 4);
                }
                g.setColor(TrendyUtils.currentTheme().getProgressBarColors()[0][8]);
                g.drawLine(x, y + h - 3, x + 8, y + h - 3);
                g.setColor(TrendyUtils.currentTheme().getProgressBarColors()[0][9]);
                g.drawLine(x + 1, y + h - 3, x + 7, y + h - 3);
                g.setColor(TrendyUtils.currentTheme().getProgressBarColors()[0][10]);
                g.drawLine(x, y + h - 2, x + 8, y + h - 2);
                g.setColor(TrendyUtils.currentTheme().getProgressBarColors()[0][11]);
                g.drawLine(x + 1, y + h - 2, x + 7, y + h - 2);
                g.setColor(TrendyUtils.currentTheme().getProgressBarColors()[0][12]);
                g.drawLine(x + 1, y + h - 1, x + 7, y + h - 1);
            }
        }

        protected void paintImage(Component c, Graphics g, int x, int y, int imageW, int imageH, Image image, Object[] args) {
            g.translate(x, y);
            g.drawImage(image, 0, 0, null);
            g.translate(-x, -y);
        }
    }

    private static class MenuBarBackgroundPainter
    extends TrendyAbstractCachedPainter {
        public static final MenuBarBackgroundPainter INSTANCE = new MenuBarBackgroundPainter(15);
        int w;
        int h;

        MenuBarBackgroundPainter(int count) {
            super(count);
        }

        public synchronized void paint(Component c, Graphics g, int x, int y, int w, int h) {
            this.w = w;
            this.h = h;
            this.paint(c, g, x, y, w, h, new Object[0]);
        }

        protected void paintToImage(Component c, Graphics g, int w, int h, Object[] args) {
            g.setColor(new ColorUIResource(252, 252, 252));
            g.fillRect(0, 0, w, 3);
            Graphics2D g2 = (Graphics2D)g;
            g2.setPaint(new GradientPaint(0.0f, 3.0f, new ColorUIResource(252, 252, 252), 0.0f, h - 3, new ColorUIResource(232, 232, 232)));
            g2.fillRect(0, 3, w, h - 3);
        }

        protected void paintImage(Component c, Graphics g, int x, int y, int imageW, int imageH, Image image, Object[] args) {
            g.translate(x, y);
            g.drawImage(image, 0, 0, null);
            g.translate(-x, -y);
        }

        protected Image createImage(Component c, int w, int h, GraphicsConfiguration config) {
            if (config == null) {
                return new BufferedImage(w, h, 6);
            }
            return config.createCompatibleVolatileImage(w, h);
        }
    }

    private static class MenuBackgroundPainter
    extends TrendyAbstractCachedPainter {
        public static final MenuBackgroundPainter INSTANCE = new MenuBackgroundPainter(7);
        int w;
        int h;

        MenuBackgroundPainter(int count) {
            super(count);
        }

        public synchronized void paint(Component c, Graphics g, int x, int y, int w, int h) {
            this.w = w;
            this.h = h;
            this.paint(c, g, x, y, w, h, new Object[0]);
        }

        protected void paintToImage(Component c, Graphics g, int w, int h, Object[] args) {
            g.setColor(TrendyTheme.getWhite());
            g.drawLine(0, 0, w - 1, 0);
            g.setColor(new ColorUIResource(140, 140, 140));
            g.drawLine(3, 1, w - 4, 1);
            g.drawLine(0, 4, 0, h - 1);
            g.drawLine(w - 1, 4, w - 1, h - 1);
            g.setColor(new ColorUIResource(170, 170, 170));
            g.drawLine(0, 3, 2, 1);
            g.drawLine(w - 1, 3, w - 3, 1);
            g.setColor(new ColorUIResource(220, 220, 220));
            g.drawLine(0, 1, 1, 2);
            g.drawLine(w - 1, 1, w - 2, 2);
            Graphics2D g2 = (Graphics2D)g;
            g2.setPaint(new GradientPaint(1.0f, 2.0f, new ColorUIResource(233, 233, 233), 1.0f, h, TrendyTheme.getWhite()));
            g2.fillRect(1, 2, w - 2, h);
            g.setColor(new ColorUIResource(190, 190, 190));
            g.drawLine(0, 2, 1, 1);
            g.drawLine(1, 2, 1, 2);
            g.drawLine(w - 1, 2, w - 2, 1);
            g.drawLine(w - 2, 2, w - 2, 2);
        }

        protected void paintImage(Component c, Graphics g, int x, int y, int imageW, int imageH, Image image, Object[] args) {
            g.translate(x, y);
            g.drawImage(image, 0, 0, null);
            g.translate(-x, -y);
        }

        protected Image createImage(Component c, int w, int h, GraphicsConfiguration config) {
            if (config == null) {
                return new BufferedImage(w, h, 6);
            }
            return config.createCompatibleVolatileImage(w, h);
        }
    }
}

