/*
 * Decompiled with CFR 0.152.
 */
package com.Trendy.swing.plaf;

import com.Trendy.swing.plaf.TrendyButtonListener;
import com.Trendy.swing.plaf.TrendyCashedPainter;
import com.Trendy.swing.plaf.TrendyConfiguration;
import com.Trendy.swing.plaf.TrendyUtils;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicButtonUI;

public class TrendyButtonUI
extends BasicButtonUI {
    private static final TrendyButtonUI m_buttonUI = new TrendyButtonUI();

    public static ComponentUI createUI(JComponent c) {
        return m_buttonUI;
    }

    protected void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        b.setRolloverEnabled(true);
        b.putClientProperty("TRENDY_ANTIALIASED_FONT_MINIMUM_SIZE", UIManager.get("Button.TRENDY_ANTIALIASED_FONT_MINIMUM_SIZE"));
    }

    protected void uninstallDefaults(AbstractButton b) {
        super.uninstallDefaults(b);
    }

    public void installUI(JComponent c) {
        super.installUI(c);
    }

    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
    }

    protected BasicButtonListener createButtonListener(AbstractButton b) {
        return new TrendyButtonListener(b);
    }

    protected void paintText(Graphics g, AbstractButton c, Rectangle textRect, String text) {
        if (TrendyConfiguration.isFontAntialiased(c, g.getFont().getSize())) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            super.paintText(g, c, textRect, text);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
            g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_DEFAULT);
        } else {
            super.paintText(g, c, textRect, text);
        }
    }

    public void paint(Graphics g, JComponent c) {
        AbstractButton b = (AbstractButton)c;
        if (b.isContentAreaFilled()) {
            if (b.getParent() instanceof JToolBar) {
                TrendyUtils.drawToolbarButtonSkin(g, c);
            } else if (TrendyConfiguration.isRoundRectSmall(c, this.getPropertyPrefix())) {
                TrendyCashedPainter.drawButtonSquareSkin(c, g);
            } else {
                TrendyCashedPainter.drawButtonRoundSkin(c, g);
            }
        }
        TrendyCashedPainter.drawButtonBorder(c, g, this.getPropertyPrefix());
        super.paint(g, c);
    }

    public Dimension getPreferredSize(JComponent c) {
        if (c.getParent() instanceof JToolBar) {
            return new Dimension((int)super.getPreferredSize(c).getWidth() + 6, (int)super.getPreferredSize(c).getHeight() + 6);
        }
        return new Dimension((int)super.getPreferredSize(c).getWidth() + 10, (int)super.getPreferredSize(c).getHeight() + 6);
    }

    protected void paintFocus(Graphics g, AbstractButton b, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
        TrendyCashedPainter.drawButtonBorder(b, g, this.getPropertyPrefix());
    }

    protected void paintButtonPressed(Graphics g, AbstractButton b) {
        this.setTextShiftOffset();
    }
}

