/*
 * Decompiled with CFR 0.152.
 */
package com.Trendy.swing.plaf;

import com.Trendy.swing.plaf.Themes.TrendyTheme;
import com.Trendy.swing.plaf.TrendyBumps;
import com.Trendy.swing.plaf.TrendyListCellRenderer;
import com.Trendy.swing.plaf.TrendyLookAndFeel;
import com.Trendy.swing.plaf.TrendyRoundRectPopupFactory;
import com.Trendy.swing.plaf.TrendyUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;

public class TrendyBorders {
    private static Border trendyTooltipBorder;
    private static Border trendyPlaceholderBorder;
    private static Border shadowedTopLevelPopupBorder;
    private static Border shadowedPopupMenuBorder;
    private static Border menuBorder;
    private static Border tableHeaderBorder;
    private static Border splitpaneBorder;
    private static Border internalFrameBorder;
    private static Border ComboPopupBorder;
    private static Border roundButtonBorder;
    private static Border comboBoxBorder;
    private static Border toolbarBorder;
    private static Border progressBarBorder;
    private static Border menuBarBorder;
    private static Border emptyBorder;
    private static Border emptyButtonBorder;
    private static Border curveBorder;
    private static Border popupMenuBorder;
    private static Border textFieldBorder;
    private static Border twoCentBorder;
    private static Border comboBoxEditorBorder;
    private static Border scrollPaneBorder;
    private static Border emptyspinnerBorder;
    private static Border emptyComboboxBorder;
    private static Border comboBoxlistCellRendererFocusBorder;
    private static Image popupTopRight;
    private static Image popupTopLeft;
    private static Image popupBottomLeft;
    private static Image popupBottomRight;

    public static Border getTrendyTooltipBorder() {
        if (trendyTooltipBorder == null) {
            trendyTooltipBorder = new TrendyToolTipBorder();
        }
        return trendyTooltipBorder;
    }

    public static Border getTrendyPlaceholderBorder() {
        if (trendyPlaceholderBorder == null) {
            trendyPlaceholderBorder = new TrendyPlaceholderBorder();
        }
        return trendyPlaceholderBorder;
    }

    public static Border getShadowedTopLevelPopupBorder() {
        if (shadowedTopLevelPopupBorder == null) {
            shadowedTopLevelPopupBorder = new RoundRectTopLevelPopupBorder();
        }
        return shadowedTopLevelPopupBorder;
    }

    public static Border getShadowedPopupMenuBorder() {
        if (shadowedPopupMenuBorder == null) {
            shadowedPopupMenuBorder = new RoundRectPopupBorder();
        }
        return shadowedPopupMenuBorder;
    }

    public static Border getMenuBorder() {
        if (menuBorder == null) {
            menuBorder = new MenuBorder();
        }
        return menuBorder;
    }

    public static Border getTableHeaderBorder() {
        if (tableHeaderBorder == null) {
            tableHeaderBorder = new TableHeaderBorder();
        }
        return tableHeaderBorder;
    }

    public static Border getSplitpaneBorder() {
        if (splitpaneBorder == null) {
            splitpaneBorder = new SplitpaneBorder();
        }
        return splitpaneBorder;
    }

    public static Border getInternalFrameBorder() {
        if (internalFrameBorder == null) {
            internalFrameBorder = new InternalFrameBorder();
        }
        return internalFrameBorder;
    }

    public static Border getComboPopupBorder() {
        if (ComboPopupBorder == null) {
            ComboPopupBorder = new comboPopupBorder();
        }
        return ComboPopupBorder;
    }

    public static Border getRoundButtonBorder() {
        if (roundButtonBorder == null) {
            roundButtonBorder = new roundButtonBorder();
        }
        return roundButtonBorder;
    }

    public static Border getComboBoxBorder() {
        if (comboBoxBorder == null) {
            comboBoxBorder = new ComboBoxBorder();
        }
        return comboBoxBorder;
    }

    public static Border getToolbarBorder() {
        if (toolbarBorder == null) {
            toolbarBorder = new ToolbarBorder();
        }
        return toolbarBorder;
    }

    public static Border getProgressBarBorder() {
        if (progressBarBorder == null) {
            progressBarBorder = new ProgressBarBorder();
        }
        return progressBarBorder;
    }

    public static Border getMenuBarBorder() {
        if (menuBarBorder == null) {
            menuBarBorder = new MenuBarBorder();
        }
        return menuBarBorder;
    }

    public static Border getEmptyBorder() {
        if (emptyBorder == null) {
            emptyBorder = new emptyBorder();
        }
        return emptyBorder;
    }

    public static Border getEmptyButtonBorder() {
        if (emptyButtonBorder == null) {
            emptyButtonBorder = new EmptyButtonBorder();
        }
        return emptyButtonBorder;
    }

    public static Border getCurveBorder() {
        if (curveBorder == null) {
            curveBorder = new CurveBorder();
        }
        return curveBorder;
    }

    public static Border getPopupMenuBorder() {
        if (popupMenuBorder == null) {
            popupMenuBorder = new PopupMenuBorder();
        }
        return popupMenuBorder;
    }

    public static Border getTextFieldBorder() {
        if (textFieldBorder == null) {
            textFieldBorder = new TextFieldBorder();
        }
        return textFieldBorder;
    }

    public static Border getTwoCentBorder() {
        if (twoCentBorder == null) {
            twoCentBorder = new twoCentBorder();
        }
        return twoCentBorder;
    }

    public static Border getComboBoxEditorBorder() {
        if (comboBoxEditorBorder == null) {
            comboBoxEditorBorder = new ComboBoxEditorBorder();
        }
        return comboBoxEditorBorder;
    }

    public static Border getScrollPaneBorder() {
        if (scrollPaneBorder == null) {
            scrollPaneBorder = new ScrollPaneBorder();
        }
        return scrollPaneBorder;
    }

    public static Border getEmptySpinnerBorder() {
        if (emptyspinnerBorder == null) {
            emptyspinnerBorder = new emptySpinnerBorder();
        }
        return emptyspinnerBorder;
    }

    public static Border getEmptyComboboxBorder() {
        if (emptyComboboxBorder == null) {
            emptyComboboxBorder = new EmptyComboboxBorder();
        }
        return emptyComboboxBorder;
    }

    public static Border getComboBoxlistCellRendererFocusBorder() {
        if (comboBoxlistCellRendererFocusBorder == null) {
            comboBoxlistCellRendererFocusBorder = new TrendyComboBoxlistCellRendererFocusBorder();
        }
        return comboBoxlistCellRendererFocusBorder;
    }

    static {
        popupTopRight = new ImageIcon(RoundRectPopupBorder.class.getResource("resources/popupShadowTopRight.png")).getImage();
        popupTopLeft = new ImageIcon(RoundRectPopupBorder.class.getResource("resources/popupShadowTopLeft.png")).getImage();
        popupBottomLeft = new ImageIcon(RoundRectPopupBorder.class.getResource("resources/popupShadowBottomLeft.png")).getImage();
        popupBottomRight = new ImageIcon(RoundRectPopupBorder.class.getResource("resources/popupShadowBottomRight.png")).getImage();
    }

    public static class TrendyComboBoxlistCellRendererFocusBorder
    extends AbstractBorder
    implements UIResource {
        private Color selectionBackground = TrendyUtils.currentTheme().getTextHighlightBackColor();

        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            if (c instanceof TrendyListCellRenderer) {
                this.selectionBackground = ((TrendyListCellRenderer)c).getParentList().getSelectionBackground();
            }
            g.translate(x, y);
            g.drawLine(0, 0, 0, 0);
            g.drawLine(w - 1, 0, w - 1, 0);
            g.drawLine(0, h - 1, 0, h - 1);
            g.drawLine(w - 1, h - 1, w - 1, h - 1);
            g.setColor(this.selectionBackground.brighter());
            g.drawLine(1, 0, 2, 0);
            g.drawLine(w - 2, 0, w - 3, 0);
            g.drawLine(1, h - 1, 2, h - 1);
            g.drawLine(w - 2, h - 1, w - 3, h - 1);
            g.drawLine(0, 1, 0, 2);
            g.drawLine(0, h - 2, 0, h - 3);
            g.drawLine(w - 1, 1, w - 1, 2);
            g.drawLine(w - 1, h - 2, w - 1, h - 3);
            g.translate(-x, -y);
        }

        public Insets getBorderInsets(Component c) {
            return new Insets(1, 1, 1, 1);
        }

        public Insets getBorderInsets(Component c, Insets insets) {
            insets.left = 1;
            insets.top = 1;
            insets.right = 1;
            insets.bottom = 1;
            return insets;
        }
    }

    public static class TrendyPlaceholderBorder
    extends AbstractBorder
    implements UIResource {
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
        }

        public Insets getBorderInsets(Component c) {
            return new Insets(2, 2, 3, 3);
        }

        public Insets getBorderInsets(Component c, Insets insets) {
            insets.left = 2;
            insets.top = 2;
            insets.right = 3;
            insets.bottom = 3;
            return insets;
        }
    }

    public static class RoundRectTopLevelPopupBorder
    extends AbstractBorder
    implements UIResource {
        private Image bl;
        private Image br;
        private Image r;
        private Image b;

        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            JComponent popup = (JComponent)c;
            g.translate(x, y);
            try {
                this.bl = (Image)popup.getClientProperty(TrendyRoundRectPopupFactory.BOTTOM_LEFT_PIC);
                if (this.bl != null) {
                    g.drawImage(this.bl, 0, h - 5, c);
                }
                this.br = (Image)popup.getClientProperty(TrendyRoundRectPopupFactory.BOTTOM_RIGHT_PIC);
                if (this.br != null) {
                    g.drawImage(this.br, w - 5, h - 5, c);
                }
                this.r = (Image)popup.getClientProperty(TrendyRoundRectPopupFactory.RIGHT_PIC);
                if (this.r != null) {
                    g.drawImage(this.r, w - 1, 0, c);
                }
                this.b = (Image)popup.getClientProperty(TrendyRoundRectPopupFactory.BOTTOM_PIC);
                if (this.b != null) {
                    g.drawImage(this.b, 5, h - 1, c);
                }
            }
            catch (Exception exp) {
                // empty catch block
            }
            g.drawImage(popupBottomLeft, 0, h - 5, popup);
            g.drawImage(popupBottomRight, w - 5, h - 5, popup);
            ColorUIResource c1 = new ColorUIResource(150, 150, 150);
            Color c4 = new Color(160, 160, 160, 100);
            ColorUIResource c2 = new ColorUIResource(135, 135, 135);
            g.setColor(UIManager.getColor("MenuItem.background"));
            g.drawLine(1, 0, w - 4, 0);
            g.drawLine(1, 1, w - 4, 1);
            g.drawLine(1, 0, 1, h - 7);
            g.drawLine(5, h - 3, w - 6, h - 3);
            g.setColor(UIManager.getColor("MenuItem.trendyFadingColor"));
            g.drawLine(w - 3, 2, w - 3, h - 5);
            g.setColor(c1);
            g.drawLine(0, 0, 0, h - 6);
            g.setColor(c4);
            g.drawLine(5, h - 1, w - 6, h - 1);
            g.drawLine(w - 1, 2, w - 1, h - 6);
            g.setColor(c2);
            g.drawLine(w - 2, 0, w - 2, h - 6);
            g.drawLine(5, h - 2, w - 6, h - 2);
            g.translate(-x, -y);
        }

        public Insets getBorderInsets(Component c) {
            return new Insets(2, 2, 3, 3);
        }

        public Insets getBorderInsets(Component c, Insets insets) {
            insets.left = 2;
            insets.top = 2;
            insets.bottom = 3;
            insets.right = 3;
            return insets;
        }
    }

    public static class RoundRectPopupBorder
    extends AbstractBorder
    implements UIResource {
        Image tr;
        Image tl;
        Image br;
        Image bl;
        Image r;
        Image b;

        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            JComponent popup = (JComponent)c;
            g.translate(x, y);
            try {
                this.tl = (Image)popup.getClientProperty(TrendyRoundRectPopupFactory.TOP_LEFT_PIC);
                if (this.tl != null) {
                    g.drawImage(this.tl, 0, 0, c);
                }
                this.tr = (Image)popup.getClientProperty(TrendyRoundRectPopupFactory.TOP_RIGHT_PIC);
                if (this.tr != null) {
                    g.drawImage(this.tr, w - 5, 0, c);
                }
                this.bl = (Image)popup.getClientProperty(TrendyRoundRectPopupFactory.BOTTOM_LEFT_PIC);
                if (this.bl != null) {
                    g.drawImage(this.bl, 0, h - 5, c);
                }
                this.br = (Image)popup.getClientProperty(TrendyRoundRectPopupFactory.BOTTOM_RIGHT_PIC);
                if (this.br != null) {
                    g.drawImage(this.br, w - 5, h - 5, c);
                }
                this.r = (Image)popup.getClientProperty(TrendyRoundRectPopupFactory.RIGHT_PIC);
                if (this.r != null) {
                    g.drawImage(this.r, w - 1, 0, c);
                }
                this.b = (Image)popup.getClientProperty(TrendyRoundRectPopupFactory.BOTTOM_PIC);
                if (this.b != null) {
                    g.drawImage(this.b, 5, h - 1, c);
                }
            }
            catch (Exception exp) {
                // empty catch block
            }
            g.drawImage(popupTopLeft, 0, 0, popup);
            g.drawImage(popupTopRight, w - 5, 0, popup);
            g.drawImage(popupBottomLeft, 0, h - 5, popup);
            g.drawImage(popupBottomRight, w - 5, h - 5, popup);
            ColorUIResource c1 = new ColorUIResource(150, 150, 150);
            Color c4 = new Color(160, 160, 160, 100);
            ColorUIResource c2 = new ColorUIResource(135, 135, 135);
            Color c3 = new Color(220, 220, 220);
            g.setColor(c1);
            g.drawLine(5, 0, w - 6, 0);
            g.drawLine(0, 5, 0, h - 6);
            g.setColor(c4);
            g.drawLine(5, h - 1, w - 6, h - 1);
            g.drawLine(w - 1, 5, w - 1, h - 6);
            g.setColor(c2);
            g.drawLine(w - 2, 5, w - 2, h - 6);
            g.drawLine(5, h - 2, w - 6, h - 2);
            g.translate(-x, -y);
        }

        public Insets getBorderInsets(Component c) {
            return new Insets(2, 2, 3, 3);
        }

        public Insets getBorderInsets(Component c, Insets insets) {
            insets.left = 2;
            insets.top = 2;
            insets.bottom = 3;
            insets.right = 3;
            return insets;
        }
    }

    public static class roundButtonBorder
    extends AbstractBorder
    implements UIResource {
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            g.translate(x, y);
            JComponent jc = (JComponent)c;
            Color backColor = jc.getBackground();
            boolean isOpaque = jc.isOpaque();
            boolean isRollover = false;
            boolean isFocused = false;
            if (jc instanceof JButton) {
                isRollover = ((JButton)jc).getModel().isRollover();
                isFocused = ((JButton)jc).hasFocus();
            } else if (jc instanceof JComboBox) {
                isFocused = ((JComboBox)jc).hasFocus();
            }
            ColorUIResource c1 = new ColorUIResource(0);
            ColorUIResource c2 = new ColorUIResource(0);
            ColorUIResource c3 = new ColorUIResource(0);
            ColorUIResource c4 = new ColorUIResource(0);
            ColorUIResource c5 = new ColorUIResource(0);
            ColorUIResource c6 = new ColorUIResource(0);
            if (isFocused) {
                c1 = new ColorUIResource(105, 150, 225);
                c2 = new ColorUIResource(92, 120, 166);
                c3 = new ColorUIResource(130, 165, 220);
                c4 = new ColorUIResource(210, 220, 240);
                c5 = new ColorUIResource(163, 190, 230);
                c6 = new ColorUIResource(120, 150, 205);
            } else if (isRollover) {
                c1 = new ColorUIResource(105, 190, 105);
                c2 = new ColorUIResource(85, 140, 85);
                c3 = new ColorUIResource(105, 165, 105);
                c4 = new ColorUIResource(160, 210, 160);
                c5 = new ColorUIResource(145, 200, 145);
                c6 = new ColorUIResource(140, 190, 140);
            } else {
                c1 = new ColorUIResource(140, 140, 140);
                c2 = new ColorUIResource(130, 130, 130);
                c3 = new ColorUIResource(170, 170, 170);
                c4 = new ColorUIResource(210, 210, 210);
                c5 = new ColorUIResource(165, 165, 165);
                c6 = new ColorUIResource(155, 155, 155);
            }
            g.setColor(c1);
            g.drawLine(5, 0, w - 7, 0);
            g.drawLine(0, 6, 0, h - 7);
            g.drawLine(w - 1, 6, w - 1, h - 7);
            g.setColor(c2);
            g.drawLine(6, h - 1, w - 7, h - 1);
            g.setColor(c5);
            g.drawLine(0, 5, 1, 5);
            g.drawLine(5, 1, 5, 0);
            g.setColor(c1);
            g.drawLine(1, 4, 1, 3);
            g.drawLine(4, 1, 3, 1);
            g.drawLine(3, 1, 1, 3);
            g.setColor(c4);
            g.drawLine(4, 0, 5, 1);
            g.drawLine(0, 4, 1, 5);
            g.drawLine(2, 3, 3, 2);
            g.setColor(c5);
            g.drawLine(w - 1, 5, w - 2, 5);
            g.drawLine(w - 6, 0, w - 6, 1);
            g.setColor(c1);
            g.drawLine(w - 2, 4, w - 2, 3);
            g.drawLine(w - 5, 1, w - 4, 1);
            g.drawLine(w - 4, 1, w - 2, 3);
            g.setColor(c4);
            g.drawLine(w - 5, 0, w - 6, 1);
            g.drawLine(w - 1, 4, w - 2, 5);
            g.drawLine(w - 4, 2, w - 3, 3);
            g.setColor(c3);
            g.drawLine(2, h - 4, 3, h - 3);
            g.drawLine(5, h - 2, 5, h - 1);
            g.setColor(c5);
            g.drawLine(0, h - 6, 1, h - 6);
            g.setColor(c6);
            g.drawLine(1, h - 5, 1, h - 4);
            g.drawLine(4, h - 2, 3, h - 2);
            g.drawLine(3, h - 2, 1, h - 4);
            g.setColor(c3);
            g.drawLine(w - 3, h - 4, w - 4, h - 3);
            g.drawLine(w - 6, h - 2, w - 6, h - 1);
            g.setColor(c5);
            g.drawLine(w - 1, h - 6, w - 2, h - 6);
            g.setColor(c6);
            g.drawLine(w - 2, h - 5, w - 2, h - 4);
            g.drawLine(w - 5, h - 2, w - 4, h - 2);
            g.drawLine(w - 4, h - 2, w - 2, h - 4);
            g.translate(-x, -y);
        }

        public Insets getBorderInsets(Component c) {
            return new Insets(2, 2, 2, 2);
        }

        public Insets getBorderInsets(Component c, Insets insets) {
            insets.right = 2;
            insets.left = 2;
            insets.top = 2;
            insets.bottom = 5;
            return insets;
        }
    }

    public static class ComboBoxEditorBordertemp
    extends AbstractBorder
    implements UIResource {
        static final Insets inset = new Insets(2, 4, 2, 4);

        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            g.translate(x, y);
            g.setColor(new ColorUIResource(155, 155, 155));
            g.drawLine(x + 3, y, x + w - 4, y);
            g.drawLine(x + 3, y + h - 1, x + w - 4, y + h - 1);
            g.drawLine(x, y + 3, x, y + h - 4);
            g.drawLine(x + w - 1, y + 3, x + w - 1, y + h - 4);
            g.setColor(new ColorUIResource(170, 170, 170));
            g.drawLine(0, 2, 2, 0);
            g.drawLine(w - 3, 0, w - 1, 2);
            g.drawLine(0, h - 3, 2, h - 1);
            g.drawLine(w - 3, h - 1, w - 1, h - 3);
            g.setColor(new ColorUIResource(185, 185, 185));
            g.drawLine(0, 1, 1, 0);
            g.drawLine(w - 2, 0, w - 1, 1);
            g.drawLine(0, h - 2, 1, h - 1);
            g.drawLine(w - 2, h - 1, w - 1, h - 2);
            g.setColor(new ColorUIResource(215, 215, 215));
            g.drawLine(1, 2, 2, 1);
            g.drawLine(w - 3, 1, w - 2, 2);
            g.drawLine(1, h - 3, 2, h - 2);
            g.drawLine(w - 3, h - 2, w - 2, h - 3);
            g.setColor(new ColorUIResource(215, 215, 215));
            g.drawLine(0, h - 1, 0, h - 1);
            g.drawLine(w - 1, h - 1, w - 1, h - 1);
            g.translate(-x, -y);
        }

        public Insets getBorderInsets(Component c) {
            return inset;
        }

        public Insets getBorderInsets(Component c, Insets insets) {
            insets.top = ComboBoxEditorBordertemp.inset.top;
            insets.bottom = ComboBoxEditorBordertemp.inset.bottom;
            insets.right = ComboBoxEditorBordertemp.inset.right;
            insets.left = ComboBoxEditorBordertemp.inset.left;
            return insets;
        }
    }

    private static class InternalFrameBorder
    extends AbstractBorder
    implements UIResource {
        private InternalFrameBorder() {
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            g.setColor(TrendyUtils.currentTheme().getBorderColors()[0][1]);
            g.drawLine(1, 23, 1, h - 2);
            g.drawLine(w - 2, 23, w - 2, h - 2);
            g.drawLine(1, h - 2, w - 2, h - 2);
            g.setColor(TrendyUtils.currentTheme().getBorderColors()[0][0]);
            g.drawLine(0, 23, 0, h - 1);
            g.drawLine(2, 23, 2, h - 3);
            g.drawLine(w - 1, 23, w - 1, h - 1);
            g.drawLine(w - 3, 23, w - 3, h - 3);
            g.drawLine(0, h - 1, w - 1, h - 1);
        }

        public Insets getBorderInsets(Component c) {
            return this.getBorderInsets(c, new Insets(0, 3, 2, 3));
        }

        public Insets getBorderInsets(Component c, Insets insets) {
            insets.top = 0;
            insets.left = 3;
            insets.right = 3;
            insets.bottom = 2;
            return insets;
        }

        public boolean isBorderOpaque() {
            return true;
        }
    }

    public static class ToolbarBorder
    extends AbstractBorder
    implements UIResource,
    SwingConstants {
        protected TrendyBumps bumps = new TrendyBumps(10, 10, TrendyLookAndFeel.getPrimaryControlHighlight(), TrendyLookAndFeel.getPrimaryControlDarkShadow());

        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            g.translate(x, y);
            if (((JToolBar)c).isFloatable()) {
                if (((JToolBar)c).getOrientation() == 0) {
                    this.bumps.setBumpArea(8, c.getSize().height - 10);
                    if (TrendyUtils.isLeftToRight(c)) {
                        this.bumps.paintIcon(c, g, 4, 5);
                    } else {
                        this.bumps.paintIcon(c, g, c.getBounds().width - 12, 5);
                    }
                } else {
                    this.bumps.setBumpArea(c.getSize().width - 10, 8);
                    this.bumps.paintIcon(c, g, 5, 4);
                }
            }
            if (((JToolBar)c).getOrientation() == 0) {
                g.setColor(new ColorUIResource(152, 152, 152));
                g.drawLine(0, 0, w - 1, 0);
                g.setColor(new ColorUIResource(252, 252, 252));
                g.drawLine(0, 1, w - 1, 1);
                g.setColor(new ColorUIResource(249, 249, 249));
                g.drawLine(0, 2, w - 1, 2);
                g.setColor(new ColorUIResource(245, 245, 245));
                g.drawLine(0, 3, w - 1, 3);
                g.setColor(new ColorUIResource(205, 205, 205));
                g.drawLine(0, h - 2, w - 1, h - 2);
                g.setColor(new ColorUIResource(180, 180, 180));
                g.drawLine(0, h - 1, w - 1, h - 1);
            } else {
                g.setColor(new ColorUIResource(152, 152, 152));
                g.drawLine(0, 0, 0, h - 1);
                g.setColor(new ColorUIResource(252, 252, 252));
                g.drawLine(1, 0, 1, h - 1);
                g.setColor(new ColorUIResource(249, 249, 249));
                g.drawLine(2, 0, 2, h - 1);
                g.setColor(new ColorUIResource(245, 245, 245));
                g.drawLine(3, 0, 3, h - 1);
                g.setColor(new ColorUIResource(205, 205, 205));
                g.drawLine(w - 3, 0, w - 3, h - 1);
                g.setColor(new ColorUIResource(180, 180, 180));
                g.drawLine(w - 2, 0, w - 2, h - 1);
                g.setColor(new ColorUIResource(145, 145, 145));
                g.drawLine(w - 1, 0, w - 1, h - 1);
            }
            g.translate(-x, -y);
        }

        public Insets getBorderInsets(Component c) {
            return this.getBorderInsets(c, new Insets(4, 0, 3, 0));
        }

        public Insets getBorderInsets(Component c, Insets newInsets) {
            Insets margin;
            newInsets.right = 4;
            newInsets.bottom = 4;
            newInsets.left = 4;
            newInsets.top = 4;
            if (((JToolBar)c).isFloatable()) {
                if (((JToolBar)c).getOrientation() == 0) {
                    newInsets.top = 4;
                    if (c.getComponentOrientation().isLeftToRight()) {
                        newInsets.left = 16;
                    } else {
                        newInsets.right = 16;
                    }
                } else {
                    newInsets.left = 4;
                    newInsets.top = 16;
                }
            }
            if ((margin = ((JToolBar)c).getMargin()) != null) {
                newInsets.left += margin.left;
                newInsets.top += margin.top;
                newInsets.right += margin.right;
                newInsets.bottom += margin.bottom;
            }
            return newInsets;
        }
    }

    public static class PopupMenuBorder
    extends AbstractBorder
    implements UIResource {
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            g.translate(x, y);
            g.setColor(new ColorUIResource(165, 165, 175));
            g.drawLine(0, 0, 0, h - 1);
            g.drawLine(0, h - 1, w - 1, h - 1);
            g.drawLine(0, 0, w - 1, 0);
            g.drawLine(w - 1, 0, w - 1, h - 1);
            g.setColor(new ColorUIResource(245, 245, 245));
            g.drawLine(1, 1, 1, h - 2);
            g.drawLine(1, h - 2, w - 2, h - 2);
            g.drawLine(1, 1, w - 2, 1);
            g.drawLine(w - 2, 1, w - 2, h - 2);
            g.translate(-x, -y);
        }

        public Insets getBorderInsets(Component c) {
            return new Insets(2, 2, 2, 2);
        }

        public Insets getBorderInsets(Component c, Insets insets) {
            insets.top = 2;
            insets.right = 2;
            insets.bottom = 2;
            insets.left = 2;
            return insets;
        }
    }

    public static class twoCentBorder
    extends AbstractBorder
    implements UIResource {
        public Insets getBorderInsets(Component c) {
            return new Insets(3, 4, 3, 4);
        }

        public Insets getBorderInsets(Component c, Insets insets) {
            insets.bottom = 3;
            insets.top = 3;
            insets.left = 4;
            insets.right = 4;
            return insets;
        }
    }

    public static class emptyBorder
    extends AbstractBorder
    implements UIResource {
        public Insets getBorderInsets(Component c) {
            return new Insets(2, 5, 2, 5);
        }

        public Insets getBorderInsets(Component c, Insets insets) {
            insets.top = 1;
            insets.bottom = 1;
            insets.left = 5;
            insets.right = 1;
            return insets;
        }
    }

    public static class emptySpinnerBorder
    extends AbstractBorder
    implements UIResource {
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            g.translate(x, y);
            g.setColor(TrendyTheme.getWhite());
            g.drawLine(1, 6, 1, h - 7);
            g.drawLine(2, 4, 2, h - 5);
            g.drawLine(3, 3, 3, h - 4);
            g.drawLine(4, 2, 4, h - 3);
            g.drawLine(5, 2, 5, h - 3);
            g.setColor(TrendyUtils.currentTheme().getSpinnerColors()[8]);
            g.drawLine(w - 2, 6, w - 2, h - 7);
            g.translate(-x, -y);
        }

        public Insets getBorderInsets(Component c) {
            return new Insets(1, 6, 1, 2);
        }

        public Insets getBorderInsets(Component c, Insets insets) {
            insets.top = 1;
            insets.bottom = 1;
            insets.left = 6;
            insets.right = 2;
            return insets;
        }
    }

    public static class EmptyComboboxBorder
    extends AbstractBorder
    implements UIResource {
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            g.translate(x, y);
            g.setColor(TrendyTheme.getWhite());
            g.drawLine(1, 6, 1, h - 7);
            g.drawLine(2, 4, 2, h - 5);
            g.drawLine(3, 3, 3, h - 4);
            g.drawLine(4, 2, 4, h - 3);
            g.translate(-x, -y);
        }

        public Insets getBorderInsets(Component c) {
            return new Insets(3, 5, 3, 1);
        }

        public Insets getBorderInsets(Component c, Insets insets) {
            insets.top = 3;
            insets.bottom = 3;
            insets.left = 5;
            insets.right = 1;
            return insets;
        }
    }

    public static class EmptyButtonBorder
    extends AbstractBorder
    implements UIResource {
        static final Insets bbi = new Insets(1, 5, 2, 5);
        static final Insets tbbi = new Insets(5, 5, 5, 5);

        public Insets getBorderInsets(Component c) {
            if (TrendyUtils.isToolbarButton((JComponent)c)) {
                return tbbi;
            }
            return bbi;
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
        }

        public Insets getBorderInsets(Component c, Insets insets) {
            if (TrendyUtils.isToolbarButton((JComponent)c)) {
                insets.bottom = 0;
                insets.right = 0;
                insets.left = 0;
                insets.top = 0;
                return tbbi;
            }
            insets.top = EmptyButtonBorder.bbi.top;
            insets.left = EmptyButtonBorder.bbi.left;
            insets.right = EmptyButtonBorder.bbi.right;
            insets.bottom = EmptyButtonBorder.bbi.bottom;
            return bbi;
        }
    }

    public static class ComboBoxBorder
    extends AbstractBorder
    implements UIResource {
        static final Insets bbi = new Insets(3, 7, 4, 5);

        public Insets getBorderInsets(Component c) {
            return bbi;
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
        }

        public Insets getBorderInsets(Component c, Insets insets) {
            insets.top = ComboBoxBorder.bbi.top;
            insets.left = ComboBoxBorder.bbi.left;
            insets.right = ComboBoxBorder.bbi.right;
            insets.bottom = ComboBoxBorder.bbi.bottom;
            return bbi;
        }
    }

    public static class ComboBoxPopupBorder
    extends AbstractBorder
    implements UIResource {
        static final Insets bbi = new Insets(3, 7, 4, 5);

        public Insets getBorderInsets(Component c) {
            return bbi;
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
        }

        public Insets getBorderInsets(Component c, Insets insets) {
            insets.top = ComboBoxPopupBorder.bbi.top;
            insets.left = ComboBoxPopupBorder.bbi.left;
            insets.right = ComboBoxPopupBorder.bbi.right;
            insets.bottom = ComboBoxPopupBorder.bbi.bottom;
            return bbi;
        }
    }

    public static class ProgressBarBorder
    extends AbstractBorder
    implements UIResource {
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            g.translate(x, y);
            g.setColor(new ColorUIResource(252, 252, 252));
            g.drawLine(4, 1, w - 5, 1);
            g.drawLine(2, 2, w - 3, 2);
            g.drawLine(4, h - 2, w - 5, h - 2);
            g.drawLine(2, h - 3, w - 3, h - 3);
            g.drawLine(1, 2, 1, h - 3);
            g.drawLine(2, 2, 2, h - 3);
            g.drawLine(w - 2, 2, w - 2, h - 3);
            g.drawLine(w - 3, 2, w - 3, h - 3);
            g.setColor(new ColorUIResource(140, 140, 150));
            g.drawLine(3, 0, w - 4, 0);
            g.drawLine(3, h - 1, w - 4, h - 1);
            g.drawLine(0, 2, 0, h - 3);
            g.drawLine(w - 1, 2, w - 1, h - 3);
            g.drawLine(1, 1, 2, 1);
            g.drawLine(0, 2, 1, 2);
            g.drawLine(1, h - 2, 2, h - 2);
            g.drawLine(0, h - 3, 1, h - 3);
            g.drawLine(w - 2, 1, w - 3, 1);
            g.drawLine(w - 1, 2, w - 2, 2);
            g.drawLine(w - 2, h - 2, w - 3, h - 2);
            g.drawLine(w - 1, h - 3, w - 2, h - 3);
            g.setColor(new ColorUIResource(235, 235, 235));
            g.drawLine(2, 0, 3, 1);
            g.drawLine(0, 2, 1, 3);
            g.drawLine(2, h - 1, 3, h - 2);
            g.drawLine(0, h - 3, 1, h - 4);
            g.drawLine(w - 3, 0, w - 4, 1);
            g.drawLine(w - 1, 2, w - 2, 3);
            g.drawLine(w - 3, h - 1, w - 4, h - 2);
            g.drawLine(w - 1, h - 3, w - 2, h - 4);
            g.translate(-x, -y);
        }

        public Insets getBorderInsets(Component c) {
            return new Insets(3, 3, 3, 3);
        }

        public Insets getBorderInsets(Component c, Insets insets) {
            insets.right = 3;
            insets.bottom = 3;
            insets.left = 3;
            insets.top = 3;
            return insets;
        }
    }

    public static class MenuBarBorder
    extends AbstractBorder
    implements UIResource {
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            g.translate(x, y);
            g.setColor(new ColorUIResource(220, 220, 220));
            g.drawLine(0, 0, w, 0);
            g.drawLine(0, h - 1, w, h - 1);
            g.setColor(new ColorUIResource(200, 200, 200));
            g.drawLine(0, 1, w, 1);
            g.drawLine(0, h - 2, w, h - 2);
            g.translate(-x, -y);
        }

        public Insets getBorderInsets(Component c) {
            return new Insets(2, 5, 2, 0);
        }

        public Insets getBorderInsets(Component c, Insets insets) {
            insets.top = 2;
            insets.bottom = 2;
            insets.left = 5;
            insets.right = 0;
            return insets;
        }
    }

    public static class TrendyToolTipBorder
    extends AbstractBorder
    implements UIResource {
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            g.translate(x, y);
            g.setColor(UIManager.getColor("ToolTip.borderColor"));
            g.drawLine(0, 0, w - 1, 0);
            g.drawLine(0, h - 1, w - 1, h - 1);
            g.drawLine(0, 0, 0, h - 1);
            g.drawLine(w - 1, 0, w - 1, h - 1);
            g.translate(-x, -y);
        }

        public Insets getBorderInsets(Component c) {
            return new Insets(1, 1, 1, 1);
        }

        public Insets getBorderInsets(Component c, Insets insets) {
            insets.left = 1;
            insets.top = 1;
            insets.bottom = 1;
            insets.right = 1;
            return insets;
        }
    }

    public static class MenuBorder
    extends AbstractBorder
    implements UIResource {
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            g.translate(x, y);
            g.setColor(new ColorUIResource(175, 215, 255));
            g.drawLine(0, 0, w - 3, 0);
            g.drawLine(0, 0, 0, h - 3);
            g.drawLine(w - 2, 0, w - 2, h);
            g.drawLine(0, h - 2, w, h - 2);
            g.setColor(new ColorUIResource(200, 225, 250));
            g.drawLine(w - 3, 0, w - 3, h);
            g.setColor(new ColorUIResource(160, 200, 255));
            g.drawLine(w - 1, 0, w - 1, h);
            g.drawLine(0, h - 1, w, h - 1);
            g.setColor(new ColorUIResource(190, 220, 255));
            g.translate(-x, -y);
        }

        public Insets getBorderInsets(Component c) {
            return new Insets(3, 3, 4, 5);
        }

        public Insets getBorderInsets(Component c, Insets insets) {
            insets.left = 3;
            insets.top = 3;
            insets.bottom = 4;
            insets.right = 5;
            return insets;
        }
    }

    public static class comboPopupBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets inset = new Insets(1, 1, 1, 1);

        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            g.translate(x, y);
            g.setColor(new ColorUIResource(170, 170, 170));
            g.drawLine(w - 1, 0, w - 1, 0);
            g.drawLine(0, 0, 0, h - 1);
            g.drawLine(w - 1, 0, w - 1, h - 1);
            g.drawLine(0, h - 1, w - 1, h - 1);
            g.translate(-x, -y);
        }

        public Insets getBorderInsets(Component c) {
            return inset;
        }

        public Insets getBorderInsets(Component c, Insets insets) {
            insets.top = comboPopupBorder.inset.top;
            insets.left = comboPopupBorder.inset.left;
            insets.bottom = comboPopupBorder.inset.bottom;
            insets.right = comboPopupBorder.inset.right;
            return insets;
        }
    }

    public static class ComboBoxEditorBorder
    extends AbstractBorder
    implements UIResource {
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            g.translate(x, y);
            g.setColor((Color)UIManager.get("control"));
            g.drawRect(0, 0, w - 1, h - 1);
            g.setColor((Color)UIManager.get("TextField.background"));
            g.drawRect(3, 3, w - 7, h - 7);
            g.setColor(TrendyTheme.getWhite());
            g.drawLine(3, 2, w - 4, 2);
            g.drawLine(3, h - 3, w - 4, h - 3);
            g.drawLine(2, 3, 2, h - 4);
            g.drawLine(w - 3, 3, w - 3, h - 4);
            if (c.isEnabled()) {
                g.setColor(TrendyUtils.currentTheme().getButtonSkinColors()[14]);
                g.drawLine(0, h - 3, 2, h - 1);
                g.drawLine(0, h - 2, 1, h - 1);
                g.drawLine(0, h - 1, 0, h - 1);
                g.drawLine(w - 3, h - 1, w - 1, h - 3);
                g.drawLine(w - 2, h - 1, w - 1, h - 2);
                g.drawLine(w - 1, h - 1, w - 1, h - 1);
                g.setColor(TrendyUtils.currentTheme().getButtonSkinColors()[0]);
                g.drawLine(0, 2, 2, 0);
                g.drawLine(0, 1, 1, 0);
                g.drawLine(0, 0, 0, 0);
                g.drawLine(w - 3, 0, w - 1, 2);
                g.drawLine(w - 2, 0, w - 1, 1);
                g.drawLine(w - 1, 0, w - 1, 0);
            } else {
                g.setColor(TrendyUtils.currentTheme().getButtonSkinColors()[17]);
                g.drawLine(0, h - 3, 2, h - 1);
                g.drawLine(0, h - 2, 1, h - 1);
                g.drawLine(0, h - 1, 0, h - 1);
                g.drawLine(w - 3, h - 1, w - 1, h - 3);
                g.drawLine(w - 2, h - 1, w - 1, h - 2);
                g.drawLine(w - 1, h - 1, w - 1, h - 1);
                g.drawLine(0, 2, 2, 0);
                g.drawLine(0, 1, 1, 0);
                g.drawLine(0, 0, 0, 0);
                g.drawLine(w - 3, 0, w - 1, 2);
                g.drawLine(w - 2, 0, w - 1, 1);
                g.drawLine(w - 1, 0, w - 1, 0);
            }
            ColorUIResource c1 = new ColorUIResource(0);
            ColorUIResource c2 = new ColorUIResource(0);
            ColorUIResource c3 = new ColorUIResource(0);
            ColorUIResource c4 = new ColorUIResource(0);
            if (c.isEnabled()) {
                if (c.hasFocus()) {
                    c1 = TrendyUtils.currentTheme().getTextFieldBorderColors()[0][0];
                    c2 = TrendyUtils.currentTheme().getTextFieldBorderColors()[0][1];
                    c3 = TrendyUtils.currentTheme().getTextFieldBorderColors()[0][2];
                    c4 = TrendyUtils.currentTheme().getTextFieldBorderColors()[0][3];
                } else {
                    c1 = TrendyUtils.currentTheme().getTextFieldBorderColors()[1][0];
                    c2 = TrendyUtils.currentTheme().getTextFieldBorderColors()[1][1];
                    c3 = TrendyUtils.currentTheme().getTextFieldBorderColors()[1][2];
                    c4 = TrendyUtils.currentTheme().getTextFieldBorderColors()[1][3];
                }
            } else {
                c1 = TrendyUtils.currentTheme().getTextFieldBorderColors()[2][0];
                c2 = TrendyUtils.currentTheme().getTextFieldBorderColors()[2][1];
                c3 = TrendyUtils.currentTheme().getTextFieldBorderColors()[2][2];
                c4 = TrendyUtils.currentTheme().getTextFieldBorderColors()[2][3];
            }
            g.setColor(c1);
            g.drawLine(3, 1, w - 4, 1);
            g.drawLine(3, h - 2, w - 4, h - 2);
            g.drawLine(1, 3, 1, h - 4);
            g.drawLine(w - 2, 3, w - 2, h - 4);
            g.drawLine(2, 2, 2, 2);
            g.drawLine(2, h - 3, 2, h - 3);
            g.drawLine(w - 3, 2, w - 3, 2);
            g.drawLine(w - 3, h - 3, w - 3, h - 3);
            g.setColor(c2);
            g.drawLine(3, 0, 3, 0);
            g.drawLine(0, 3, 0, 3);
            g.drawLine(w - 4, 0, w - 4, 0);
            g.drawLine(w - 1, 3, w - 1, 3);
            g.drawLine(3, h - 1, 3, h - 1);
            g.drawLine(0, h - 4, 0, h - 4);
            g.drawLine(w - 4, h - 1, w - 4, h - 1);
            g.drawLine(w - 1, h - 4, w - 1, h - 4);
            g.setColor(c3);
            g.drawLine(4, 0, w - 5, 0);
            g.drawLine(4, h - 1, w - 5, h - 1);
            g.drawLine(0, 4, 0, h - 5);
            g.drawLine(w - 1, 4, w - 1, h - 5);
            g.setColor(c4);
            g.drawLine(1, 2, 2, 1);
            g.drawLine(1, h - 3, 2, h - 2);
            g.drawLine(w - 2, 2, w - 3, 1);
            g.drawLine(w - 2, h - 3, w - 3, h - 2);
            g.translate(-x, -y);
        }

        public Insets getBorderInsets(Component c) {
            return new Insets(2, 4, 2, 4);
        }

        public Insets getBorderInsets(Component c, Insets insets) {
            insets.left = 4;
            insets.right = 4;
            insets.bottom = 2;
            insets.top = 2;
            return insets;
        }
    }

    public static class TextFieldBorder
    extends AbstractBorder
    implements UIResource {
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            g.translate(x, y);
            if (c.isOpaque()) {
                g.setColor(TrendyUtils.currentTheme().getCommonBackground());
                g.drawRect(0, 0, w - 1, h - 1);
            }
            g.setColor(c.getBackground());
            g.drawRect(3, 3, w - 7, h - 7);
            g.drawLine(3, 2, w - 4, 2);
            g.drawLine(3, h - 3, w - 4, h - 3);
            g.drawLine(2, 3, 2, h - 4);
            g.drawLine(w - 3, 3, w - 3, h - 4);
            ColorUIResource c1 = new ColorUIResource(0);
            ColorUIResource c2 = new ColorUIResource(0);
            ColorUIResource c3 = new ColorUIResource(0);
            ColorUIResource c4 = new ColorUIResource(0);
            if (c.isEnabled()) {
                if (c.hasFocus()) {
                    c1 = TrendyUtils.currentTheme().getTextFieldBorderColors()[0][0];
                    c2 = TrendyUtils.currentTheme().getTextFieldBorderColors()[0][1];
                    c3 = TrendyUtils.currentTheme().getTextFieldBorderColors()[0][2];
                    c4 = TrendyUtils.currentTheme().getTextFieldBorderColors()[0][3];
                } else {
                    c1 = TrendyUtils.currentTheme().getTextFieldBorderColors()[1][0];
                    c2 = TrendyUtils.currentTheme().getTextFieldBorderColors()[1][1];
                    c3 = TrendyUtils.currentTheme().getTextFieldBorderColors()[1][2];
                    c4 = TrendyUtils.currentTheme().getTextFieldBorderColors()[1][3];
                }
            } else {
                c1 = TrendyUtils.currentTheme().getTextFieldBorderColors()[2][0];
                c2 = TrendyUtils.currentTheme().getTextFieldBorderColors()[2][1];
                c3 = TrendyUtils.currentTheme().getTextFieldBorderColors()[2][2];
                c4 = TrendyUtils.currentTheme().getTextFieldBorderColors()[2][3];
            }
            g.setColor(c1);
            g.drawLine(3, 1, w - 4, 1);
            g.drawLine(3, h - 2, w - 4, h - 2);
            g.drawLine(1, 3, 1, h - 4);
            g.drawLine(w - 2, 3, w - 2, h - 4);
            g.drawLine(2, 2, 2, 2);
            g.drawLine(2, h - 3, 2, h - 3);
            g.drawLine(w - 3, 2, w - 3, 2);
            g.drawLine(w - 3, h - 3, w - 3, h - 3);
            g.setColor(c2);
            g.drawLine(3, 0, 3, 0);
            g.drawLine(0, 3, 0, 3);
            g.drawLine(w - 4, 0, w - 4, 0);
            g.drawLine(w - 1, 3, w - 1, 3);
            g.drawLine(3, h - 1, 3, h - 1);
            g.drawLine(0, h - 4, 0, h - 4);
            g.drawLine(w - 4, h - 1, w - 4, h - 1);
            g.drawLine(w - 1, h - 4, w - 1, h - 4);
            g.drawLine(1, 1, 1, 1);
            g.drawLine(1, h - 2, 1, h - 2);
            g.drawLine(w - 2, 1, w - 2, 1);
            g.drawLine(w - 2, h - 2, w - 2, h - 2);
            g.setColor(c3);
            g.drawLine(4, 0, w - 5, 0);
            g.drawLine(4, h - 1, w - 5, h - 1);
            g.drawLine(0, 4, 0, h - 5);
            g.drawLine(w - 1, 4, w - 1, h - 5);
            g.setColor(c4);
            g.drawLine(1, 2, 2, 1);
            g.drawLine(1, h - 3, 2, h - 2);
            g.drawLine(w - 2, 2, w - 3, 1);
            g.drawLine(w - 2, h - 3, w - 3, h - 2);
            g.translate(-x, -y);
        }

        public Insets getBorderInsets(Component c) {
            return new Insets(3, 4, 3, 4);
        }

        public Insets getBorderInsets(Component c, Insets insets) {
            insets.left = 4;
            insets.right = 4;
            insets.bottom = 3;
            insets.top = 3;
            return insets;
        }
    }

    public static class CurveBorder
    extends AbstractBorder
    implements UIResource {
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            g.translate(x, y);
            int a = 100;
            g.setColor(new Color(225, 225, 225, a));
            g.drawLine(4, 0, w - 5, 0);
            g.setColor(new ColorUIResource(188, 188, 188));
            g.drawRoundRect(1, 1, w - 3, h - 3, 6, 6);
            g.setColor(new Color(210, 210, 210, a));
            g.drawLine(4, 2, w - 5, 2);
            g.setColor(new Color(220, 220, 220, a));
            g.drawLine(4, 2, w - 5, 2);
            g.setColor(new Color(210, 210, 210, a));
            g.drawLine(1, 2, 2, 1);
            g.setColor(new Color(211, 211, 211, a));
            g.drawLine(2, 3, 3, 2);
            g.setColor(new Color(233, 233, 233, a));
            g.drawLine(0, 4, 0, h - 5);
            g.setColor(new Color(220, 220, 220, a));
            g.drawLine(0, 5, 0, h - 6);
            g.setColor(new Color(220, 220, 220, a));
            g.drawLine(2, 4, 2, h - 4);
            g.setColor(new Color(210, 210, 210, a));
            g.drawLine(1, h - 3, 2, h - 2);
            g.setColor(new Color(220, 220, 220, a));
            g.drawLine(3, h - 1, w - 5, h - 1);
            g.setColor(new Color(215, 215, 215, a));
            g.drawLine(w - 4, h - 1, w - 2, h - 3);
            g.setColor(new Color(233, 233, 233, a));
            g.drawLine(w - 1, 4, w - 1, h - 5);
            g.setColor(new Color(220, 220, 220, a));
            g.drawLine(w - 1, 5, w - 1, h - 6);
            g.setColor(new ColorUIResource(224, 224, 224));
            g.drawLine(w - 3, 3, w - 3, h - 4);
            g.setColor(new Color(204, 204, 204, a));
            g.drawLine(w - 4, 2, w - 3, 3);
            g.setColor(new Color(210, 210, 210, a));
            g.drawLine(w - 3, 1, w - 2, 2);
            g.translate(-x, -y);
        }

        public Insets getBorderInsets(Component c) {
            return new Insets(3, 3, 2, 3);
        }

        public Insets getBorderInsets(Component c, Insets insets) {
            insets.left = 3;
            insets.right = 3;
            insets.top = 3;
            insets.bottom = 2;
            return insets;
        }
    }

    public static class ScrollPaneBorder
    extends AbstractBorder
    implements UIResource {
        static final Insets inset = new Insets(1, 1, 1, 1);

        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            g.translate(x, y);
            g.setColor(new ColorUIResource(150, 150, 150));
            g.drawLine(0, 0, w - 1, 0);
            g.drawLine(0, 0, 0, h - 1);
            g.setColor(new ColorUIResource(180, 180, 180));
            g.drawLine(w - 1, 1, w - 1, h - 1);
            g.drawLine(1, h - 1, w - 1, h - 1);
            g.translate(-x, -y);
        }

        public Insets getBorderInsets(Component c) {
            return inset;
        }

        public Insets getBorderInsets(Component c, Insets insets) {
            insets.top = ScrollPaneBorder.inset.top;
            insets.left = ScrollPaneBorder.inset.left;
            insets.bottom = ScrollPaneBorder.inset.bottom;
            insets.right = ScrollPaneBorder.inset.right;
            return insets;
        }
    }

    public static class SplitpaneBorder
    extends AbstractBorder
    implements UIResource {
        static final Insets inset = new Insets(1, 1, 1, 1);

        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            g.translate(x, y);
            g.setColor(new ColorUIResource(90, 90, 90));
            g.drawLine(0, 0, w - 1, 0);
            g.drawLine(0, 0, 0, h - 1);
            g.setColor(new ColorUIResource(255, 255, 255));
            g.drawLine(w - 1, 1, w - 1, h - 1);
            g.drawLine(1, h - 1, w - 1, h - 1);
            g.translate(-x, -y);
        }

        public Insets getBorderInsets(Component c) {
            return inset;
        }

        public Insets getBorderInsets(Component c, Insets insets) {
            insets.top = SplitpaneBorder.inset.top;
            insets.left = SplitpaneBorder.inset.left;
            insets.bottom = SplitpaneBorder.inset.bottom;
            insets.right = SplitpaneBorder.inset.right;
            return insets;
        }
    }

    public static class TableHeaderBorder
    extends AbstractBorder {
        protected Insets editorBorderInsets = new Insets(0, 0, 1, 0);

        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            g.translate(x, y);
            g.setColor(Color.lightGray);
            g.drawLine(0, h - 1, w - 1, h - 1);
            g.translate(-x, -y);
        }

        public Insets getBorderInsets(Component c) {
            return this.editorBorderInsets;
        }
    }
}

