/*
 * Decompiled with CFR 0.152.
 */
package com.Trendy.swing.plaf;

import java.awt.event.ActionEvent;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;

public final class TrendyActions {
    public static final String clearAllCharsAction = "Clear All";
    public static final String selectAllAction = "Select All";
    public static final String deleteCharsAction = "Delete";

    public static class clearAction
    extends TextAction {
        public clearAction() {
            super(TrendyActions.clearAllCharsAction);
        }

        public void actionPerformed(ActionEvent e) {
            JTextComponent target = this.getTextComponent(e);
            boolean beep = true;
            if (target != null && target.isEditable()) {
                try {
                    Document doc = target.getDocument();
                    int ss = 0;
                    int se = doc.getLength();
                    if (ss != se) {
                        doc.remove(ss, se - ss);
                        beep = false;
                    }
                }
                catch (BadLocationException bl) {
                    // empty catch block
                }
            }
            if (beep) {
                UIManager.getLookAndFeel().provideErrorFeedback(target);
            }
        }
    }

    public static class deleteCharsAction
    extends TextAction {
        public deleteCharsAction() {
            super(TrendyActions.deleteCharsAction);
        }

        public void actionPerformed(ActionEvent e) {
            JTextComponent target = this.getTextComponent(e);
            boolean beep = true;
            if (target != null && target.isEditable()) {
                try {
                    Document doc = target.getDocument();
                    int ss = target.getSelectionStart();
                    int se = target.getSelectionEnd();
                    if (ss != se) {
                        doc.remove(ss, se - ss);
                        beep = false;
                    }
                }
                catch (BadLocationException bl) {
                    // empty catch block
                }
            }
            if (beep) {
                UIManager.getLookAndFeel().provideErrorFeedback(target);
            }
        }
    }

    public static class SelectAllAction
    extends TextAction {
        public SelectAllAction() {
            super(TrendyActions.selectAllAction);
        }

        public void actionPerformed(ActionEvent e) {
            JTextComponent target = this.getTextComponent(e);
            if (target != null) {
                Document doc = target.getDocument();
                target.setCaretPosition(0);
                target.moveCaretPosition(doc.getLength());
            }
        }
    }
}

